/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface BackupRestoreConstants {
    public static final String BACKUP_SYSTEM_TABLE_NAME_KEY = "hbase.backup.system.table.name";
    public static final String BACKUP_SYSTEM_TABLE_NAME_DEFAULT = "backup:system";
    public static final String BACKUP_SYSTEM_TTL_KEY = "hbase.backup.system.ttl";
    public static final int BACKUP_SYSTEM_TTL_DEFAULT = Integer.MAX_VALUE;
    public static final String BACKUP_ENABLE_KEY = "hbase.backup.enable";
    public static final boolean BACKUP_ENABLE_DEFAULT = false;
    public static final String BACKUP_MAX_ATTEMPTS_KEY = "hbase.backup.attempts.max";
    public static final int DEFAULT_BACKUP_MAX_ATTEMPTS = 10;
    public static final String BACKUP_ATTEMPTS_PAUSE_MS_KEY = "hbase.backup.attempts.pause.ms";
    public static final int DEFAULT_BACKUP_ATTEMPTS_PAUSE_MS = 10000;
    public static final String OPTION_OVERWRITE = "o";
    public static final String OPTION_OVERWRITE_DESC = "Overwrite data if any of the restore target tables exists";
    public static final String OPTION_CHECK = "c";
    public static final String OPTION_CHECK_DESC = "Check restore sequence and dependencies only (does not execute the command)";
    public static final String OPTION_SET = "s";
    public static final String OPTION_SET_DESC = "Backup set name";
    public static final String OPTION_SET_RESTORE_DESC = "Backup set to restore, mutually exclusive with -t (table list)";
    public static final String OPTION_SET_BACKUP_DESC = "Backup set to backup, mutually exclusive with -t (table list)";
    public static final String OPTION_DEBUG = "d";
    public static final String OPTION_DEBUG_DESC = "Enable debug loggings";
    public static final String OPTION_TABLE = "t";
    public static final String OPTION_TABLE_DESC = "Table name. If specified, only backup images, which contain this table will be listed.";
    public static final String OPTION_LIST = "l";
    public static final String OPTION_TABLE_LIST_DESC = "Table name list, comma-separated.";
    public static final String OPTION_BACKUP_LIST_DESC = "Backup ids list, comma-separated.";
    public static final String OPTION_BANDWIDTH = "b";
    public static final String OPTION_BANDWIDTH_DESC = "Bandwidth per task (MapReduce task) in MB/s";
    public static final String OPTION_WORKERS = "w";
    public static final String OPTION_WORKERS_DESC = "Number of parallel MapReduce tasks to execute";
    public static final String OPTION_IGNORECHECKSUM = "i";
    public static final String OPTION_IGNORECHECKSUM_DESC = "Ignore checksum verify between source snapshot and exported snapshot. Especially when the source and target file system types are different, we should use -i option to skip checksum-checks.";
    public static final String OPTION_RECORD_NUMBER = "n";
    public static final String OPTION_RECORD_NUMBER_DESC = "Number of records of backup history. Default: 10";
    public static final String OPTION_PATH = "p";
    public static final String OPTION_PATH_DESC = "Backup destination root directory path";
    public static final String OPTION_KEEP = "k";
    public static final String OPTION_KEEP_DESC = "Specifies maximum age of backup (in days) to keep during bulk delete";
    public static final String OPTION_TABLE_MAPPING = "m";
    public static final String OPTION_TABLE_MAPPING_DESC = "A comma separated list of target tables. If specified, each table in <tables> must have a mapping";
    public static final String OPTION_YARN_QUEUE_NAME = "q";
    public static final String OPTION_YARN_QUEUE_NAME_DESC = "Yarn queue name to run backup create command on";
    public static final String OPTION_YARN_QUEUE_NAME_RESTORE_DESC = "Yarn queue name to run backup restore command on";
    public static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";
    public static final String BACKUP_CONFIG_STRING = "hbase.backup.enable=true\nhbase.master.logcleaner.plugins=YOUR_PLUGINS,org.apache.hadoop.hbase.backup.master.BackupLogCleaner\nhbase.procedure.master.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.master.LogRollMasterProcedureManager\nhbase.procedure.regionserver.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.regionserver.LogRollRegionServerProcedureManager\nhbase.coprocessor.region.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.BackupObserver\nand restart the cluster\nFor more information please see http://hbase.apache.org/book.html#backuprestore\n";
    public static final String ENABLE_BACKUP = "Backup is not enabled. To enable backup, in hbase-site.xml, set:\n hbase.backup.enable=true\nhbase.master.logcleaner.plugins=YOUR_PLUGINS,org.apache.hadoop.hbase.backup.master.BackupLogCleaner\nhbase.procedure.master.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.master.LogRollMasterProcedureManager\nhbase.procedure.regionserver.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.regionserver.LogRollRegionServerProcedureManager\nhbase.coprocessor.region.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.BackupObserver\nand restart the cluster\nFor more information please see http://hbase.apache.org/book.html#backuprestore\n";
    public static final String VERIFY_BACKUP = "To enable backup, in hbase-site.xml, set:\n hbase.backup.enable=true\nhbase.master.logcleaner.plugins=YOUR_PLUGINS,org.apache.hadoop.hbase.backup.master.BackupLogCleaner\nhbase.procedure.master.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.master.LogRollMasterProcedureManager\nhbase.procedure.regionserver.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.regionserver.LogRollRegionServerProcedureManager\nhbase.coprocessor.region.classes=YOUR_CLASSES,org.apache.hadoop.hbase.backup.BackupObserver\nand restart the cluster\nFor more information please see http://hbase.apache.org/book.html#backuprestore\n";
    public static final String TABLENAME_DELIMITER_IN_COMMAND = ",";
    public static final String CONF_STAGING_ROOT = "snapshot.export.staging.root";
    public static final String BACKUPID_PREFIX = "backup_";

    public static enum BackupCommand {
        CREATE,
        CANCEL,
        DELETE,
        DESCRIBE,
        HISTORY,
        STATUS,
        CONVERT,
        MERGE,
        STOP,
        SHOW,
        HELP,
        PROGRESS,
        SET,
        SET_ADD,
        SET_REMOVE,
        SET_DELETE,
        SET_DESCRIBE,
        SET_LIST,
        REPAIR;

    }
}

