/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupTableInfo;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.BackupProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BackupInfo
implements Comparable<BackupInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(BackupInfo.class);
    private static final int MAX_FAILED_MESSAGE_LENGTH = 1024;
    private String backupId;
    private BackupType type;
    private String backupRootDir;
    private BackupState state;
    private BackupPhase phase = BackupPhase.REQUEST;
    private String failedMsg;
    private Map<TableName, BackupTableInfo> backupTableInfoMap = new HashMap<TableName, BackupTableInfo>();
    private long startTs;
    private long completeTs;
    private long totalBytesCopied;
    private String hlogTargetDir = null;
    private List<String> incrBackupFileList;
    private Map<TableName, Map<String, Long>> tableSetTimestampMap;
    private Map<TableName, Map<String, Long>> incrTimestampMap;
    private int progress;
    private int workers = -1;
    private long bandwidth = -1L;
    private boolean noChecksumVerify;

    public BackupInfo() {
    }

    public BackupInfo(String backupId, BackupType type, TableName[] tables, String targetRootDir) {
        this();
        this.backupId = backupId;
        this.type = type;
        this.backupRootDir = targetRootDir;
        this.addTables(tables);
        if (type == BackupType.INCREMENTAL) {
            this.setHLogTargetDir(BackupUtils.getLogBackupDir(targetRootDir, backupId));
        }
        this.startTs = 0L;
        this.completeTs = 0L;
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setNoChecksumVerify(boolean noChecksumVerify) {
        this.noChecksumVerify = noChecksumVerify;
    }

    public boolean getNoChecksumVerify() {
        return this.noChecksumVerify;
    }

    public void setBackupTableInfoMap(Map<TableName, BackupTableInfo> backupTableInfoMap) {
        this.backupTableInfoMap = backupTableInfoMap;
    }

    public Map<TableName, Map<String, Long>> getTableSetTimestampMap() {
        return this.tableSetTimestampMap;
    }

    public void setTableSetTimestampMap(Map<TableName, Map<String, Long>> tableSetTimestampMap) {
        this.tableSetTimestampMap = tableSetTimestampMap;
    }

    public void setType(BackupType type) {
        this.type = type;
    }

    public void setBackupRootDir(String targetRootDir) {
        this.backupRootDir = targetRootDir;
    }

    public void setTotalBytesCopied(long totalBytesCopied) {
        this.totalBytesCopied = totalBytesCopied;
    }

    public void setProgress(int p) {
        this.progress = p;
    }

    public int getProgress() {
        return this.progress;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    public BackupTableInfo getBackupTableInfo(TableName table) {
        return this.backupTableInfoMap.get(table);
    }

    public String getFailedMsg() {
        return this.failedMsg;
    }

    public void setFailedMsg(String failedMsg) {
        if (failedMsg.length() > 1024) {
            failedMsg = failedMsg.substring(0, 1024);
        }
        this.failedMsg = failedMsg;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public long getCompleteTs() {
        return this.completeTs;
    }

    public void setCompleteTs(long endTs) {
        this.completeTs = endTs;
    }

    public long getTotalBytesCopied() {
        return this.totalBytesCopied;
    }

    public BackupState getState() {
        return this.state;
    }

    public void setState(BackupState flag) {
        this.state = flag;
    }

    public BackupPhase getPhase() {
        return this.phase;
    }

    public void setPhase(BackupPhase phase) {
        this.phase = phase;
    }

    public BackupType getType() {
        return this.type;
    }

    public void setSnapshotName(TableName table, String snapshotName) {
        this.backupTableInfoMap.get(table).setSnapshotName(snapshotName);
    }

    public String getSnapshotName(TableName table) {
        return this.backupTableInfoMap.get(table).getSnapshotName();
    }

    public List<String> getSnapshotNames() {
        ArrayList<String> snapshotNames = new ArrayList<String>();
        for (BackupTableInfo backupStatus : this.backupTableInfoMap.values()) {
            snapshotNames.add(backupStatus.getSnapshotName());
        }
        return snapshotNames;
    }

    public Set<TableName> getTables() {
        return this.backupTableInfoMap.keySet();
    }

    public List<TableName> getTableNames() {
        return new ArrayList<TableName>(this.backupTableInfoMap.keySet());
    }

    public void addTables(TableName[] tables) {
        for (TableName table : tables) {
            BackupTableInfo backupStatus = new BackupTableInfo(table, this.backupRootDir, this.backupId);
            this.backupTableInfoMap.put(table, backupStatus);
        }
    }

    public void setTables(List<TableName> tables) {
        this.backupTableInfoMap.clear();
        for (TableName table : tables) {
            BackupTableInfo backupStatus = new BackupTableInfo(table, this.backupRootDir, this.backupId);
            this.backupTableInfoMap.put(table, backupStatus);
        }
    }

    public String getBackupRootDir() {
        return this.backupRootDir;
    }

    public String getTableBackupDir(TableName tableName) {
        return BackupUtils.getTableBackupDir(this.backupRootDir, this.backupId, tableName);
    }

    public void setHLogTargetDir(String hlogTagetDir) {
        this.hlogTargetDir = hlogTagetDir;
    }

    public String getHLogTargetDir() {
        return this.hlogTargetDir;
    }

    public List<String> getIncrBackupFileList() {
        return this.incrBackupFileList;
    }

    public void setIncrBackupFileList(List<String> incrBackupFileList) {
        this.incrBackupFileList = incrBackupFileList;
    }

    public void setIncrTimestampMap(Map<TableName, Map<String, Long>> prevTableSetTimestampMap) {
        this.incrTimestampMap = prevTableSetTimestampMap;
    }

    public Map<TableName, Map<String, Long>> getIncrTimestampMap() {
        return this.incrTimestampMap;
    }

    public TableName getTableBySnapshot(String snapshotName) {
        for (Map.Entry<TableName, BackupTableInfo> entry : this.backupTableInfoMap.entrySet()) {
            if (!snapshotName.equals(entry.getValue().getSnapshotName())) continue;
            return entry.getKey();
        }
        return null;
    }

    public BackupProtos.BackupInfo toProtosBackupInfo() {
        BackupProtos.BackupInfo.Builder builder = BackupProtos.BackupInfo.newBuilder();
        builder.setBackupId(this.getBackupId());
        this.setBackupTableInfoMap(builder);
        this.setTableSetTimestampMap(builder);
        builder.setCompleteTs(this.getCompleteTs());
        if (this.getFailedMsg() != null) {
            builder.setFailedMessage(this.getFailedMsg());
        }
        if (this.getState() != null) {
            builder.setBackupState(BackupProtos.BackupInfo.BackupState.valueOf((String)this.getState().name()));
        }
        if (this.getPhase() != null) {
            builder.setBackupPhase(BackupProtos.BackupInfo.BackupPhase.valueOf((String)this.getPhase().name()));
        }
        builder.setProgress(this.getProgress());
        builder.setStartTs(this.getStartTs());
        builder.setBackupRootDir(this.getBackupRootDir());
        builder.setBackupType(BackupProtos.BackupType.valueOf((String)this.getType().name()));
        builder.setWorkersNumber(this.workers);
        builder.setBandwidth(this.bandwidth);
        return builder.build();
    }

    public int hashCode() {
        int hash;
        int n = hash = 33 * this.type.hashCode() + this.backupId != null ? this.backupId.hashCode() : 0;
        if (this.backupRootDir != null) {
            hash = 33 * hash + this.backupRootDir.hashCode();
        }
        hash = 33 * hash + this.state.hashCode();
        hash = 33 * hash + this.phase.hashCode();
        hash = 33 * hash + (int)(this.startTs ^ this.startTs >>> 32);
        hash = 33 * hash + (int)(this.completeTs ^ this.completeTs >>> 32);
        hash = 33 * hash + (int)(this.totalBytesCopied ^ this.totalBytesCopied >>> 32);
        if (this.hlogTargetDir != null) {
            hash = 33 * hash + this.hlogTargetDir.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BackupInfo) {
            BackupInfo other = (BackupInfo)obj;
            try {
                return Bytes.equals((byte[])this.toByteArray(), (byte[])other.toByteArray());
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return this.backupId;
    }

    public byte[] toByteArray() throws IOException {
        return this.toProtosBackupInfo().toByteArray();
    }

    private void setBackupTableInfoMap(BackupProtos.BackupInfo.Builder builder) {
        for (Map.Entry<TableName, BackupTableInfo> entry : this.backupTableInfoMap.entrySet()) {
            builder.addBackupTableInfo(entry.getValue().toProto());
        }
    }

    private void setTableSetTimestampMap(BackupProtos.BackupInfo.Builder builder) {
        if (this.getTableSetTimestampMap() != null) {
            for (Map.Entry<TableName, Map<String, Long>> entry : this.getTableSetTimestampMap().entrySet()) {
                builder.putTableSetTimestamp(entry.getKey().getNameAsString(), BackupProtos.BackupInfo.RSTimestampMap.newBuilder().putAllRsTimestamp(entry.getValue()).build());
            }
        }
    }

    public static BackupInfo fromByteArray(byte[] data) throws IOException {
        return BackupInfo.fromProto(BackupProtos.BackupInfo.parseFrom((byte[])data));
    }

    public static BackupInfo fromStream(InputStream stream) throws IOException {
        return BackupInfo.fromProto(BackupProtos.BackupInfo.parseDelimitedFrom((InputStream)stream));
    }

    public static BackupInfo fromProto(BackupProtos.BackupInfo proto) {
        BackupInfo context = new BackupInfo();
        context.setBackupId(proto.getBackupId());
        context.setBackupTableInfoMap(BackupInfo.toMap(proto.getBackupTableInfoList()));
        context.setTableSetTimestampMap(BackupInfo.getTableSetTimestampMap(proto.getTableSetTimestampMap()));
        context.setCompleteTs(proto.getCompleteTs());
        if (proto.hasFailedMessage()) {
            context.setFailedMsg(proto.getFailedMessage());
        }
        if (proto.hasBackupState()) {
            context.setState(BackupState.valueOf(proto.getBackupState().name()));
        }
        context.setHLogTargetDir(BackupUtils.getLogBackupDir(proto.getBackupRootDir(), proto.getBackupId()));
        if (proto.hasBackupPhase()) {
            context.setPhase(BackupPhase.valueOf(proto.getBackupPhase().name()));
        }
        if (proto.hasProgress()) {
            context.setProgress(proto.getProgress());
        }
        context.setStartTs(proto.getStartTs());
        context.setBackupRootDir(proto.getBackupRootDir());
        context.setType(BackupType.valueOf((String)proto.getBackupType().name()));
        context.setWorkers(proto.getWorkersNumber());
        context.setBandwidth(proto.getBandwidth());
        return context;
    }

    private static Map<TableName, BackupTableInfo> toMap(List<BackupProtos.BackupTableInfo> list) {
        HashMap<TableName, BackupTableInfo> map = new HashMap<TableName, BackupTableInfo>();
        for (BackupProtos.BackupTableInfo tbs : list) {
            map.put(ProtobufUtil.toTableName((HBaseProtos.TableName)tbs.getTableName()), BackupTableInfo.convert(tbs));
        }
        return map;
    }

    private static Map<TableName, Map<String, Long>> getTableSetTimestampMap(Map<String, BackupProtos.BackupInfo.RSTimestampMap> map) {
        HashMap<TableName, Map<String, Long>> tableSetTimestampMap = new HashMap<TableName, Map<String, Long>>();
        for (Map.Entry<String, BackupProtos.BackupInfo.RSTimestampMap> entry : map.entrySet()) {
            tableSetTimestampMap.put(TableName.valueOf((String)entry.getKey()), entry.getValue().getRsTimestampMap());
        }
        return tableSetTimestampMap;
    }

    public String getShortDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ID=" + this.backupId).append(",");
        sb.append("Type=" + this.getType()).append(",");
        sb.append("Tables=" + this.getTableListAsString()).append(",");
        sb.append("State=" + (Object)((Object)this.getState())).append(",");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.getStartTs());
        Date date = cal.getTime();
        sb.append("Start time=" + date).append(",");
        if (this.state == BackupState.FAILED) {
            sb.append("Failed message=" + this.getFailedMsg()).append(",");
        } else if (this.state == BackupState.RUNNING) {
            sb.append("Phase=" + (Object)((Object)this.getPhase())).append(",");
        } else if (this.state == BackupState.COMPLETE) {
            cal = Calendar.getInstance();
            cal.setTimeInMillis(this.getCompleteTs());
            date = cal.getTime();
            sb.append("End time=" + date).append(",");
        }
        sb.append("Progress=" + this.getProgress() + "%");
        sb.append("}");
        return sb.toString();
    }

    public String getStatusAndProgressAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.getBackupId()).append(" state: ").append((Object)this.getState()).append(" progress: ").append(this.getProgress());
        return sb.toString();
    }

    public String getTableListAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(StringUtils.join(this.backupTableInfoMap.keySet(), (String)","));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(BackupInfo o) {
        Long thisTS = Long.valueOf(this.getBackupId().substring(this.getBackupId().lastIndexOf("_") + 1));
        Long otherTS = Long.valueOf(o.getBackupId().substring(o.getBackupId().lastIndexOf("_") + 1));
        return thisTS.compareTo(otherTS);
    }

    public static enum BackupPhase {
        REQUEST,
        SNAPSHOT,
        PREPARE_INCREMENTAL,
        SNAPSHOTCOPY,
        INCREMENTAL_COPY,
        STORE_MANIFEST;

    }

    public static enum BackupState {
        RUNNING,
        COMPLETE,
        FAILED,
        ANY;

    }

    public static interface Filter {
        public boolean apply(BackupInfo var1);
    }
}

