/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class BackupHFileCleaner
extends BaseHFileCleanerDelegate
implements Abortable {
    private static final Logger LOG = LoggerFactory.getLogger(BackupHFileCleaner.class);
    private boolean stopped = false;
    private boolean aborted;
    private Configuration conf;
    private Connection connection;
    private long prevReadFromBackupTbl = 0L;
    private long secondPrevReadFromBackupTbl = 0L;
    private boolean checkForFullyBackedUpTables = true;
    private List<TableName> fullyBackedUpTables = null;

    private Set<String> getFilenameFromBulkLoad(Map<byte[], List<Path>>[] maps) {
        HashSet<String> filenames = new HashSet<String>();
        for (Map<byte[], List<Path>> map : maps) {
            if (map == null) continue;
            for (List<Path> paths : map.values()) {
                for (Path p : paths) {
                    filenames.add(p.getName());
                }
            }
        }
        return filenames;
    }

    private Set<String> loadHFileRefs(List<TableName> tableList) throws IOException {
        if (this.connection == null) {
            this.connection = ConnectionFactory.createConnection((Configuration)this.conf);
        }
        try (BackupSystemTable tbl = new BackupSystemTable(this.connection);){
            Map<byte[], List<Path>>[] res = tbl.readBulkLoadedFiles(null, tableList);
            this.secondPrevReadFromBackupTbl = this.prevReadFromBackupTbl;
            this.prevReadFromBackupTbl = EnvironmentEdgeManager.currentTime();
            Set<String> set = this.getFilenameFromBulkLoad(res);
            return set;
        }
    }

    @InterfaceAudience.Private
    void setCheckForFullyBackedUpTables(boolean b) {
        this.checkForFullyBackedUpTables = b;
    }

    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        Set<String> hfileRefs;
        if (this.conf == null) {
            return files;
        }
        if (this.checkForFullyBackedUpTables) {
            if (this.connection == null) {
                return files;
            }
            try (BackupSystemTable tbl = new BackupSystemTable(this.connection);){
                this.fullyBackedUpTables = tbl.getTablesForBackupType(BackupType.FULL);
            }
            catch (IOException ioe) {
                LOG.error("Failed to get tables which have been fully backed up, skipping checking", (Throwable)ioe);
                return Collections.emptyList();
            }
            Collections.sort(this.fullyBackedUpTables);
        }
        try {
            hfileRefs = this.loadHFileRefs(this.fullyBackedUpTables);
        }
        catch (IOException ioe) {
            LOG.error("Failed to read hfile references, skipping checking deletable files", (Throwable)ioe);
            return Collections.emptyList();
        }
        Iterable deletables = Iterables.filter(files, file -> {
            if (file.getModificationTime() > this.secondPrevReadFromBackupTbl) {
                return false;
            }
            String hfile = file.getPath().getName();
            boolean foundHFileRef = hfileRefs.contains(hfile);
            return !foundHFileRef;
        });
        return deletables;
    }

    public boolean isFileDeletable(FileStatus fStat) {
        return true;
    }

    public void setConf(Configuration config) {
        this.conf = config;
        this.connection = null;
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)this.conf);
        }
        catch (IOException ioe) {
            LOG.error("Couldn't establish connection", (Throwable)ioe);
        }
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException ioe) {
                LOG.debug("Got " + ioe + " when closing connection");
            }
        }
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void abort(String why, Throwable e) {
        LOG.warn("Aborting ReplicationHFileCleaner because " + why, e);
        this.aborted = true;
        this.stop(why);
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

