/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.protobuf.generated.CellMessage;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="Cell")
@XmlAccessorType(value=XmlAccessType.FIELD)
@InterfaceAudience.Private
public class CellModel
implements ProtobufMessageHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="column")
    @XmlAttribute
    private byte[] column;
    @JsonProperty(value="timestamp")
    @XmlAttribute
    private long timestamp = Long.MAX_VALUE;
    @JsonProperty(value="$")
    @XmlValue
    private byte[] value;

    public CellModel() {
    }

    public CellModel(byte[] column, byte[] value) {
        this(column, Long.MAX_VALUE, value);
    }

    public CellModel(byte[] column, byte[] qualifier, byte[] value) {
        this(column, qualifier, Long.MAX_VALUE, value);
    }

    public CellModel(Cell cell) {
        this(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), CellUtil.cloneValue((Cell)cell));
    }

    public CellModel(byte[] column, long timestamp, byte[] value) {
        this.column = column;
        this.timestamp = timestamp;
        this.value = value;
    }

    public CellModel(byte[] column, byte[] qualifier, long timestamp, byte[] value) {
        this.column = CellUtil.makeColumn((byte[])column, (byte[])qualifier);
        this.timestamp = timestamp;
        this.value = value;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public void setColumn(byte[] column) {
        this.column = column;
    }

    public boolean hasUserTimestamp() {
        return this.timestamp != Long.MAX_VALUE;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public byte[] createProtobufOutput() {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        builder.setColumn(ByteStringer.wrap((byte[])this.getColumn()));
        builder.setData(ByteStringer.wrap((byte[])this.getValue()));
        if (this.hasUserTimestamp()) {
            builder.setTimestamp(this.getTimestamp());
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        CellMessage.Cell.Builder builder = CellMessage.Cell.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])message);
        this.setColumn(builder.getColumn().toByteArray());
        this.setValue(builder.getData().toByteArray());
        if (builder.hasTimestamp()) {
            this.setTimestamp(builder.getTimestamp());
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CellModel cellModel = (CellModel)obj;
        return new EqualsBuilder().append(this.column, cellModel.column).append(this.timestamp, cellModel.timestamp).append(this.value, cellModel.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.column).append(this.timestamp).append(this.value).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("column", this.column).append("timestamp", this.timestamp).append("value", this.value).toString();
    }
}

