/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.OptionalLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StripeStoreEngine;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestStripeStoreEngine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStripeStoreEngine.class);

    @Test
    public void testCreateBasedOnConfig() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", TestStoreEngine.class.getName());
        TestStoreEngine se = TestStripeStoreEngine.createEngine(conf);
        Assert.assertTrue((boolean)(se.getCompactionPolicy() instanceof StripeCompactionPolicy));
    }

    @Test
    public void testCompactionContextForceSelect() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int targetCount = 2;
        conf.setInt("hbase.store.stripe.initialStripeCount", targetCount);
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 2);
        conf.set("hbase.hstore.engine.class", TestStoreEngine.class.getName());
        TestStoreEngine se = TestStripeStoreEngine.createEngine(conf);
        StripeCompactor mockCompactor = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        se.setCompactorOverride(mockCompactor);
        Mockito.when((Object)mockCompactor.compact((CompactionRequestImpl)Matchers.any(), Matchers.anyInt(), Matchers.anyLong(), (byte[])Matchers.any(), (byte[])Matchers.any(), (byte[])Matchers.any(), (byte[])Matchers.any(), (ThroughputController)Matchers.any(), (User)Matchers.any())).thenReturn(new ArrayList());
        HStoreFile sf = TestStripeStoreEngine.createFile();
        ArrayList<HStoreFile> compactUs = TestStripeStoreEngine.al(sf, TestStripeStoreEngine.createFile(), TestStripeStoreEngine.createFile());
        se.getStoreFileManager().loadFiles(compactUs);
        CompactionContext compaction = se.createCompaction();
        compaction.select(TestStripeStoreEngine.al(new HStoreFile[0]), false, false, false);
        Assert.assertEquals((long)3L, (long)compaction.getRequest().getFiles().size());
        compactUs.remove(sf);
        CompactionRequestImpl req = new CompactionRequestImpl(compactUs);
        compaction.forceSelect(req);
        Assert.assertEquals((long)2L, (long)compaction.getRequest().getFiles().size());
        Assert.assertFalse((boolean)compaction.getRequest().getFiles().contains(sf));
        compaction.compact((ThroughputController)NoLimitThroughputController.INSTANCE, null);
        ((StripeCompactor)Mockito.verify((Object)mockCompactor, (VerificationMode)Mockito.times((int)1))).compact(compaction.getRequest(), targetCount, 0L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, null, null, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
    }

    private static HStoreFile createFile() throws Exception {
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        Mockito.when((Object)sf.getMetadataValue((byte[])Matchers.any())).thenReturn((Object)StripeStoreFileManager.INVALID_KEY);
        Mockito.when((Object)sf.getReader()).thenReturn(Mockito.mock(StoreFileReader.class));
        Mockito.when((Object)sf.getPath()).thenReturn((Object)new Path("moo"));
        Mockito.when((Object)sf.getBulkLoadTimestamp()).thenReturn((Object)OptionalLong.empty());
        return sf;
    }

    private static TestStoreEngine createEngine(Configuration conf) throws Exception {
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        HStore store = (HStore)Mockito.mock(HStore.class);
        store.conf = conf;
        Mockito.when((Object)store.getRegionInfo()).thenReturn((Object)RegionInfoBuilder.FIRST_META_REGIONINFO);
        Mockito.when((Object)store.getHRegion()).thenReturn((Object)region);
        CellComparatorImpl kvComparator = (CellComparatorImpl)Mockito.mock(CellComparatorImpl.class);
        return (TestStoreEngine)StoreEngine.create((HStore)store, (Configuration)conf, (CellComparator)kvComparator);
    }

    private static ArrayList<HStoreFile> al(HStoreFile ... sfs) {
        return new ArrayList<HStoreFile>(Arrays.asList(sfs));
    }

    public static class TestStoreEngine
    extends StripeStoreEngine {
        public void setCompactorOverride(StripeCompactor compactorOverride) {
            this.compactor = compactorOverride;
        }
    }
}

