/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.CompactSplit;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapperImpl;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StatefulStoreMockMaker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestCompaction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompaction.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected Configuration conf = UTIL.getConfiguration();
    private HRegion r = null;
    private HTableDescriptor htd = null;
    private static final byte[] COLUMN_FAMILY = HBaseTestingUtility.fam1;
    private final byte[] STARTROW = Bytes.toBytes((String)HBaseTestingUtility.START_KEY);
    private static final byte[] COLUMN_FAMILY_TEXT = COLUMN_FAMILY;
    private int compactionThreshold;
    private byte[] secondRowBytes;
    private byte[] thirdRowBytes;
    private static final long MAX_FILES_TO_COMPACT = 10L;
    private final byte[] FAMILY = Bytes.toBytes((String)"cf");

    public TestCompaction() {
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 100);
        this.conf.set("hbase.regionserver.throughput.controller", NoLimitThroughputController.class.getName());
        this.compactionThreshold = this.conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] = (byte)(this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] + 2);
    }

    @Before
    public void setUp() throws Exception {
        this.htd = UTIL.createTableDescriptor(this.name.getMethodName());
        if (this.name.getMethodName().equals("testCompactionSeqId")) {
            UTIL.getConfiguration().set("hbase.hstore.compaction.kv.max", "10");
            UTIL.getConfiguration().set("hbase.hstore.defaultengine.compactor.class", DummyCompactor.class.getName());
            HColumnDescriptor hcd = new HColumnDescriptor(this.FAMILY);
            hcd.setMaxVersions(65536);
            this.htd.addFamily(hcd);
        }
        this.r = UTIL.createLocalHRegion((TableDescriptor)this.htd, null, null);
    }

    @After
    public void tearDown() throws Exception {
        WAL wal = this.r.getWAL();
        this.r.close();
        wal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptCompactionBySize() throws Exception {
        Assert.assertEquals((long)0L, (long)this.count());
        this.conf.setInt("hbase.hstore.close.check.interval", 10000);
        try {
            int jmax = (int)Math.ceil(15.0 / (double)this.compactionThreshold);
            byte[] pad = new byte[1000];
            for (int i = 0; i < this.compactionThreshold; ++i) {
                RegionAsTable loader = new RegionAsTable((Region)this.r);
                Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                p.setDurability(Durability.SKIP_WAL);
                for (int j = 0; j < jmax; ++j) {
                    p.addColumn(COLUMN_FAMILY, Bytes.toBytes((int)j), pad);
                }
                HTestConst.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY));
                loader.put(p);
                this.r.flush(true);
            }
            HRegion spyR = (HRegion)Mockito.spy((Object)this.r);
            ((HRegion)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ((TestCompaction)TestCompaction.this).r.writestate.writesEnabled = false;
                    return invocation.callRealMethod();
                }
            }).when((Object)spyR)).doRegionCompactionPrep();
            spyR.compactStores();
            HStore s = this.r.getStore(COLUMN_FAMILY);
            Assert.assertEquals((long)this.compactionThreshold, (long)s.getStorefilesCount());
            Assert.assertTrue((s.getStorefilesSize() > 15000L ? 1 : 0) != 0);
            FileStatus[] ls = this.r.getFilesystem().listStatus(this.r.getRegionFileSystem().getTempDir());
            Assert.assertEquals((long)1L, (long)ls.length);
            Path storeTempDir = new Path(this.r.getRegionFileSystem().getTempDir(), Bytes.toString((byte[])COLUMN_FAMILY));
            Assert.assertTrue((boolean)this.r.getFilesystem().exists(storeTempDir));
            ls = this.r.getFilesystem().listStatus(storeTempDir);
            Assert.assertEquals((long)0L, (long)ls.length);
            this.r.writestate.writesEnabled = true;
        }
        catch (Throwable throwable) {
            this.r.writestate.writesEnabled = true;
            this.conf.setInt("hbase.hstore.close.check.interval", 10000000);
            for (int i = 0; i < this.compactionThreshold; ++i) {
                Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
                delete.addFamily(famAndQf[0]);
                this.r.delete(delete);
            }
            this.r.flush(true);
            int ttl = 1000;
            for (HStore store : this.r.stores.values()) {
                ScanInfo old = store.getScanInfo();
                ScanInfo si = old.customize(old.getMaxVersions(), 1000L, old.getKeepDeletedCells());
                store.setScanInfo(si);
            }
            Thread.sleep(1000L);
            this.r.compact(true);
            Assert.assertEquals((long)0L, (long)this.count());
            throw throwable;
        }
        this.conf.setInt("hbase.hstore.close.check.interval", 10000000);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
            byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
            delete.addFamily(famAndQf[0]);
            this.r.delete(delete);
        }
        this.r.flush(true);
        int ttl = 1000;
        for (HStore store : this.r.stores.values()) {
            ScanInfo old = store.getScanInfo();
            ScanInfo si = old.customize(old.getMaxVersions(), 1000L, old.getKeepDeletedCells());
            store.setScanInfo(si);
        }
        Thread.sleep(1000L);
        this.r.compact(true);
        Assert.assertEquals((long)0L, (long)this.count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptCompactionByTime() throws Exception {
        Assert.assertEquals((long)0L, (long)this.count());
        this.conf.setLong("hbase.hstore.close.check.time.interval", 1L);
        try {
            int jmax = (int)Math.ceil(15.0 / (double)this.compactionThreshold);
            byte[] pad = new byte[1000];
            for (int i = 0; i < this.compactionThreshold; ++i) {
                RegionAsTable loader = new RegionAsTable((Region)this.r);
                Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                p.setDurability(Durability.SKIP_WAL);
                for (int j = 0; j < jmax; ++j) {
                    p.addColumn(COLUMN_FAMILY, Bytes.toBytes((int)j), pad);
                }
                HTestConst.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY));
                loader.put(p);
                this.r.flush(true);
            }
            HRegion spyR = (HRegion)Mockito.spy((Object)this.r);
            ((HRegion)Mockito.doAnswer((Answer)new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ((TestCompaction)TestCompaction.this).r.writestate.writesEnabled = false;
                    return invocation.callRealMethod();
                }
            }).when((Object)spyR)).doRegionCompactionPrep();
            spyR.compactStores();
            HStore s = this.r.getStore(COLUMN_FAMILY);
            Assert.assertEquals((long)this.compactionThreshold, (long)s.getStorefilesCount());
            Assert.assertTrue((s.getStorefilesSize() > 15000L ? 1 : 0) != 0);
            FileStatus[] ls = this.r.getFilesystem().listStatus(this.r.getRegionFileSystem().getTempDir());
            Assert.assertEquals((long)1L, (long)ls.length);
            Path storeTempDir = new Path(this.r.getRegionFileSystem().getTempDir(), Bytes.toString((byte[])COLUMN_FAMILY));
            Assert.assertTrue((boolean)this.r.getFilesystem().exists(storeTempDir));
            ls = this.r.getFilesystem().listStatus(storeTempDir);
            Assert.assertEquals((long)0L, (long)ls.length);
            this.r.writestate.writesEnabled = true;
        }
        catch (Throwable throwable) {
            this.r.writestate.writesEnabled = true;
            this.conf.setLong("hbase.hstore.close.check.time.interval", 10000L);
            for (int i = 0; i < this.compactionThreshold; ++i) {
                Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
                delete.addFamily(famAndQf[0]);
                this.r.delete(delete);
            }
            this.r.flush(true);
            int ttl = 1000;
            for (HStore store : this.r.stores.values()) {
                ScanInfo old = store.getScanInfo();
                ScanInfo si = old.customize(old.getMaxVersions(), 1000L, old.getKeepDeletedCells());
                store.setScanInfo(si);
            }
            Thread.sleep(1000L);
            this.r.compact(true);
            Assert.assertEquals((long)0L, (long)this.count());
            throw throwable;
        }
        this.conf.setLong("hbase.hstore.close.check.time.interval", 10000L);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
            byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
            delete.addFamily(famAndQf[0]);
            this.r.delete(delete);
        }
        this.r.flush(true);
        int ttl = 1000;
        for (HStore store : this.r.stores.values()) {
            ScanInfo old = store.getScanInfo();
            ScanInfo si = old.customize(old.getMaxVersions(), 1000L, old.getKeepDeletedCells());
            store.setScanInfo(si);
        }
        Thread.sleep(1000L);
        this.r.compact(true);
        Assert.assertEquals((long)0L, (long)this.count());
    }

    private int count() throws IOException {
        int count = 0;
        for (HStoreFile f : ((HStore)this.r.stores.get(COLUMN_FAMILY_TEXT)).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            if (!scanner.seekTo()) continue;
            do {
                ++count;
            } while (scanner.next());
        }
        return count;
    }

    private void createStoreFile(HRegion region) throws IOException {
        this.createStoreFile(region, Bytes.toString((byte[])COLUMN_FAMILY));
    }

    private void createStoreFile(HRegion region, String family) throws IOException {
        RegionAsTable loader = new RegionAsTable((Region)region);
        HTestConst.addContent(loader, family);
        region.flush(true);
    }

    @Test
    public void testCompactionWithCorruptResult() throws Exception {
        int nfiles = 10;
        for (int i = 0; i < nfiles; ++i) {
            this.createStoreFile(this.r);
        }
        HStore store = this.r.getStore(COLUMN_FAMILY);
        Collection storeFiles = store.getStorefiles();
        DefaultCompactor tool = (DefaultCompactor)store.storeEngine.getCompactor();
        CompactionRequestImpl request = new CompactionRequestImpl(storeFiles);
        tool.compact(request, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        FileSystem fs = store.getFileSystem();
        Path tmpPath = store.getRegionFileSystem().createTempName();
        try (FSDataOutputStream stream = fs.create(tmpPath, null, true, 512, (short)3, 1024L, null);){
            stream.writeChars("CORRUPT FILE!!!!");
        }
        Assert.assertThrows(IOException.class, () -> store.doCompaction(null, null, null, EnvironmentEdgeManager.currentTime(), Collections.singletonList(tmpPath)));
        Assert.assertTrue((boolean)fs.exists(tmpPath));
    }

    @Test
    public void testTrackingCompactionRequest() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplit thread = new CompactSplit(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        HStore store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        CountDownLatch latch = new CountDownLatch(1);
        Tracker tracker = new Tracker(latch);
        thread.requestCompaction(this.r, store, "test custom comapction", 1, (CompactionLifeCycleTracker)tracker, null);
        latch.await();
        thread.interruptIfNecessary();
    }

    @Test
    public void testCompactionFailure() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplit thread = new CompactSplit(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        HStore store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        for (int i = 0; i < 15; ++i) {
            this.createStoreFile(this.r);
        }
        HRegion mockRegion = (HRegion)Mockito.spy((Object)this.r);
        Mockito.when((Object)mockRegion.checkSplit()).thenThrow(new Throwable[]{new RuntimeException("Thrown intentionally by test!")});
        try (MetricsRegionWrapperImpl metricsWrapper = new MetricsRegionWrapperImpl(this.r);){
            long preCompletedCount = metricsWrapper.getNumCompactionsCompleted();
            long preFailedCount = metricsWrapper.getNumCompactionsFailed();
            CountDownLatch latch = new CountDownLatch(1);
            Tracker tracker = new Tracker(latch);
            thread.requestCompaction(mockRegion, store, "test custom comapction", 1, (CompactionLifeCycleTracker)tracker, null);
            latch.await(120L, TimeUnit.SECONDS);
            long postCompletedCount = metricsWrapper.getNumCompactionsCompleted();
            long postFailedCount = metricsWrapper.getNumCompactionsFailed();
            Assert.assertTrue((String)("Completed count should have increased (pre=" + preCompletedCount + ", post=" + postCompletedCount + ")"), (postCompletedCount > preCompletedCount ? 1 : 0) != 0);
            Assert.assertTrue((String)("Failed count should have increased (pre=" + preFailedCount + ", post=" + postFailedCount + ")"), (postFailedCount > preFailedCount ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStopStartCompaction() throws IOException {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplit thread = new CompactSplit(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        HStore store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        for (int i = 0; i < 15; ++i) {
            this.createStoreFile(this.r);
        }
        thread.switchCompaction(false);
        thread.requestCompaction(this.r, store, "test", 1, CompactionLifeCycleTracker.DUMMY, null);
        Assert.assertFalse((boolean)thread.isCompactionsEnabled());
        int longCompactions = thread.getLongCompactions().getActiveCount();
        int shortCompactions = thread.getShortCompactions().getActiveCount();
        Assert.assertEquals((String)("longCompactions=" + longCompactions + ",shortCompactions=" + shortCompactions), (long)0L, (long)(longCompactions + shortCompactions));
        thread.switchCompaction(true);
        Assert.assertTrue((boolean)thread.isCompactionsEnabled());
        Assert.assertEquals((long)0L, (long)(thread.getLongCompactions().getCompletedTaskCount() + thread.getShortCompactions().getCompletedTaskCount()));
        thread.requestCompaction(this.r, store, "test", 1, CompactionLifeCycleTracker.DUMMY, null);
        Waiter.waitFor((Configuration)UTIL.getConfiguration(), (long)5000L, () -> thread.getLongCompactions().getCompletedTaskCount() + thread.getShortCompactions().getCompletedTaskCount() == 1L);
        Assert.assertEquals((long)0L, (long)(thread.getLongCompactions().getActiveCount() + thread.getShortCompactions().getActiveCount()));
    }

    @Test
    public void testInterruptingRunningCompactions() throws Exception {
        this.conf.set("hbase.regionserver.throughput.controller", WaitThroughPutController.class.getName());
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplit thread = new CompactSplit(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        HStore store = this.r.getStore(COLUMN_FAMILY);
        int jmax = (int)Math.ceil(15.0 / (double)this.compactionThreshold);
        byte[] pad = new byte[1000];
        for (int i = 0; i < this.compactionThreshold; ++i) {
            RegionAsTable loader = new RegionAsTable((Region)this.r);
            Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
            p.setDurability(Durability.SKIP_WAL);
            for (int j = 0; j < jmax; ++j) {
                p.addColumn(COLUMN_FAMILY, Bytes.toBytes((int)j), pad);
            }
            HTestConst.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY));
            loader.put(p);
            this.r.flush(true);
        }
        HStore s = this.r.getStore(COLUMN_FAMILY);
        int initialFiles = s.getStorefilesCount();
        thread.requestCompaction(this.r, store, "test custom comapction", 1, CompactionLifeCycleTracker.DUMMY, null);
        Thread.sleep(3000L);
        thread.switchCompaction(false);
        Assert.assertEquals((long)initialFiles, (long)s.getStorefilesCount());
        thread.switchCompaction(true);
    }

    @Test
    public void testMultipleCustomCompactionRequests() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplit thread = new CompactSplit(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        int numStores = this.r.getStores().size();
        CountDownLatch latch = new CountDownLatch(numStores);
        Tracker tracker = new Tracker(latch);
        for (HStore store : this.r.getStores()) {
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            thread.requestCompaction(this.r, store, "test mulitple custom comapctions", 1, (CompactionLifeCycleTracker)tracker, null);
        }
        latch.await();
        thread.interruptIfNecessary();
    }

    @Test
    public void testCompactionQueuePriorities() throws Exception {
        int i;
        Configuration conf = HBaseConfiguration.create();
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockServer.getChoreService()).thenReturn((Object)new ChoreService("test"));
        CompactSplit cst = new CompactSplit(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)cst);
        cst.shutdownLongCompactions();
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)r.compact((CompactionContext)ArgumentMatchers.any(), (HStore)ArgumentMatchers.any(), (ThroughputController)ArgumentMatchers.any(), (User)ArgumentMatchers.any())).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                ((CompactionContext)invocation.getArgument(0)).compact((ThroughputController)invocation.getArgument(2), null);
                return true;
            }
        });
        ArrayList<Integer> results = new ArrayList<Integer>();
        StoreMockMaker sm = new StoreMockMaker(results);
        StoreMockMaker sm2 = new StoreMockMaker(results);
        HStore store = sm.createStoreMock("store1");
        HStore store2 = sm2.createStoreMock("store2");
        BlockingStoreMockMaker blocker = new BlockingStoreMockMaker();
        cst.requestSystemCompaction(r, blocker.createStoreMock(1, "b-pri1"), "b-pri1");
        BlockingStoreMockMaker.BlockingCompactionContext currentBlock = blocker.waitForBlocking();
        for (i = 0; i < 4; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store, "s1-pri3");
        for (i = 0; i < 3; ++i) {
            sm2.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store2, "s2-pri4");
        for (i = 0; i < 2; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store, "s1-pri1");
        cst.requestSystemCompaction(r, blocker.createStoreMock(2, "b-pri2"), "b-pri2");
        currentBlock.unblock();
        currentBlock = blocker.waitForBlocking();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)results.get(0).intValue());
        for (i = 0; i < 2; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, blocker.createStoreMock(7, "b-pri7"), "b-pri7");
        currentBlock.unblock();
        currentBlock = blocker.waitForBlocking();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(1).intValue());
        Assert.assertEquals((long)2L, (long)results.get(2).intValue());
        currentBlock.unblock();
        cst.interruptIfNecessary();
    }

    @Test
    public void testCompactionSeqId() throws Exception {
        Put put;
        int i;
        byte[] ROW = Bytes.toBytes((String)"row");
        byte[] QUALIFIER = Bytes.toBytes((String)"qualifier");
        long timestamp = 10000L;
        for (i = 0; i < 10; ++i) {
            put = new Put(ROW);
            put.addColumn(this.FAMILY, QUALIFIER, timestamp + (long)i, Bytes.toBytes((String)("v" + i)));
            this.r.put(put);
        }
        this.r.flush(true);
        for (i = 18; i > 8; --i) {
            put = new Put(ROW);
            put.addColumn(this.FAMILY, QUALIFIER, timestamp + (long)i, Bytes.toBytes((String)("v" + i)));
            this.r.put(put);
        }
        this.r.flush(true);
        this.r.compact(true);
    }

    private static HStoreFile createFile() throws Exception {
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        Mockito.when((Object)sf.getPath()).thenReturn((Object)new Path("file"));
        StoreFileReader r = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        Mockito.when((Object)r.length()).thenReturn((Object)10L);
        Mockito.when((Object)sf.getReader()).thenReturn((Object)r);
        return sf;
    }

    public static class WaitThroughPutController
    extends NoLimitThroughputController {
        public long control(String compactionName, long size) throws InterruptedException {
            Thread.sleep(6000000L);
            return 6000000L;
        }
    }

    public static class Tracker
    implements CompactionLifeCycleTracker {
        private final CountDownLatch done;

        public Tracker(CountDownLatch done) {
            this.done = done;
        }

        public void afterExecution(Store store) {
            this.done.countDown();
        }
    }

    public static class DummyCompactor
    extends DefaultCompactor {
        public DummyCompactor(Configuration conf, HStore store) {
            super(conf, store);
            this.keepSeqIdPeriod = 0;
        }
    }

    public class BlockingStoreMockMaker
    extends StatefulStoreMockMaker {
        BlockingCompactionContext blocked = null;

        @Override
        public Optional<CompactionContext> selectCompaction() {
            this.blocked = new BlockingCompactionContext();
            try {
                this.blocked.select(null, false, false, false);
            }
            catch (IOException ex) {
                Assert.fail((String)"Shouldn't happen");
            }
            return Optional.of(this.blocked);
        }

        @Override
        public void cancelCompaction(Object object) {
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        public BlockingCompactionContext waitForBlocking() {
            while (this.blocked == null || !this.blocked.isInCompact) {
                Threads.sleepWithoutInterrupt((long)50L);
            }
            BlockingCompactionContext ctx = this.blocked;
            this.blocked = null;
            return ctx;
        }

        @Override
        public HStore createStoreMock(String name) throws Exception {
            return this.createStoreMock(Integer.MIN_VALUE, name);
        }

        public HStore createStoreMock(int priority, String name) throws Exception {
            HStore s = super.createStoreMock(name);
            Mockito.when((Object)s.getCompactPriority()).thenReturn((Object)priority);
            return s;
        }

        public class BlockingCompactionContext
        extends CompactionContext {
            public volatile boolean isInCompact = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unblock() {
                BlockingCompactionContext blockingCompactionContext = this;
                synchronized (blockingCompactionContext) {
                    ((Object)((Object)this)).notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<Path> compact(ThroughputController throughputController, User user) throws IOException {
                try {
                    this.isInCompact = true;
                    BlockingCompactionContext blockingCompactionContext = this;
                    synchronized (blockingCompactionContext) {
                        ((Object)((Object)this)).wait();
                    }
                }
                catch (InterruptedException e) {
                    Assume.assumeNoException((Throwable)e);
                }
                return new ArrayList<Path>();
            }

            public List<HStoreFile> preSelect(List<HStoreFile> filesCompacting) {
                return new ArrayList<HStoreFile>();
            }

            public boolean select(List<HStoreFile> f, boolean i, boolean m, boolean e) throws IOException {
                this.request = new CompactionRequestImpl(new ArrayList());
                return true;
            }
        }
    }

    class StoreMockMaker
    extends StatefulStoreMockMaker {
        public ArrayList<HStoreFile> compacting = new ArrayList();
        public ArrayList<HStoreFile> notCompacting = new ArrayList();
        private final ArrayList<Integer> results;

        public StoreMockMaker(ArrayList<Integer> results) {
            this.results = results;
        }

        @Override
        public synchronized Optional<CompactionContext> selectCompaction() {
            TestCompactionContext ctx = new TestCompactionContext(new ArrayList<HStoreFile>(this.notCompacting));
            this.compacting.addAll(this.notCompacting);
            this.notCompacting.clear();
            try {
                ctx.select(null, false, false, false);
            }
            catch (IOException ex) {
                Assert.fail((String)"Shouldn't happen");
            }
            return Optional.of(ctx);
        }

        @Override
        public synchronized void cancelCompaction(Object object) {
            TestCompactionContext ctx = (TestCompactionContext)((Object)object);
            this.compacting.removeAll(ctx.selectedFiles);
            this.notCompacting.addAll(ctx.selectedFiles);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void finishCompaction(List<HStoreFile> sfs) {
            if (sfs.isEmpty()) {
                return;
            }
            ArrayList<Integer> arrayList = this.results;
            synchronized (arrayList) {
                this.results.add(sfs.size());
            }
            this.compacting.removeAll(sfs);
        }

        @Override
        public int getPriority() {
            return 7 - this.compacting.size() - this.notCompacting.size();
        }

        public class TestCompactionContext
        extends CompactionContext {
            private List<HStoreFile> selectedFiles;

            public TestCompactionContext(List<HStoreFile> selectedFiles) {
                this.selectedFiles = selectedFiles;
            }

            public List<HStoreFile> preSelect(List<HStoreFile> filesCompacting) {
                return new ArrayList<HStoreFile>();
            }

            public boolean select(List<HStoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
                this.request = new CompactionRequestImpl(this.selectedFiles);
                this.request.setPriority(StoreMockMaker.this.getPriority());
                return true;
            }

            public List<Path> compact(ThroughputController throughputController, User user) throws IOException {
                StoreMockMaker.this.finishCompaction(this.selectedFiles);
                return new ArrayList<Path>();
            }
        }
    }
}

