/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRaceBetweenSCPAndDTP {
    private static final Logger LOG = LoggerFactory.getLogger(TestRaceBetweenSCPAndDTP.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRaceBetweenSCPAndDTP.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"Race");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static CountDownLatch ARRIVE_GET_REGIONS_ON_TABLE;
    private static CountDownLatch RESUME_GET_REGIONS_ON_SERVER;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.startMiniCluster(2);
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        ServerName sn = am.getRegionStates().getRegionState(region).getServerName();
        LOG.info("ServerName={}, region={}", (Object)sn, (Object)region);
        ARRIVE_GET_REGIONS_ON_TABLE = new CountDownLatch(1);
        RESUME_GET_REGIONS_ON_SERVER = new CountDownLatch(1);
        CountDownLatch cdl = ARRIVE_GET_REGIONS_ON_TABLE;
        UTIL.getAdmin().disableTableAsync(NAME);
        cdl.await();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        UTIL.getMiniHBaseCluster().stopRegionServer(sn);
        long pid = -1L;
        do {
            Threads.sleep((long)1L);
        } while ((pid = this.getSCPPID(procExec)) != -1L);
        long scppid = pid;
        UTIL.waitFor(60000L, () -> procExec.isFinished(scppid));
        RESUME_GET_REGIONS_ON_SERVER.countDown();
        long dtpProcId = procExec.getProcedures().stream().filter(p -> p instanceof DisableTableProcedure).map(p -> (DisableTableProcedure)p).findAny().get().getProcId();
        UTIL.waitFor(60000L, () -> procExec.isFinished(dtpProcId));
    }

    private long getSCPPID(ProcedureExecutor<?> e) {
        Optional<ServerCrashProcedure> optional = e.getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).map(p -> (ServerCrashProcedure)p).findAny();
        return optional.isPresent() ? optional.get().getProcId() : -1L;
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException, KeeperException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master, MasterRegion masterRegion) {
            return new AssignmentManagerForTest(master, masterRegion);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master, MasterRegion masterRegion) {
            super(master, masterRegion);
        }

        public TransitRegionStateProcedure[] createUnassignProceduresForDisabling(TableName tableName) {
            if (ARRIVE_GET_REGIONS_ON_TABLE != null) {
                ARRIVE_GET_REGIONS_ON_TABLE.countDown();
                ARRIVE_GET_REGIONS_ON_TABLE = null;
                try {
                    RESUME_GET_REGIONS_ON_SERVER.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            TransitRegionStateProcedure[] procs = super.createUnassignProceduresForDisabling(tableName);
            return procs;
        }
    }
}

