/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.xbill.DNS;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DClass;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Generator;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.RelativeNameException;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.SOARecord;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.TTL;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.TextParseException;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Tokenizer;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Type;

public class Master {
    private Name origin;
    private File file;
    private Record last = null;
    private long defaultTTL;
    private Master included = null;
    private Tokenizer st;
    private int currentType;
    private int currentDClass;
    private long currentTTL;
    private boolean needSOATTL;
    private Generator generator;
    private List generators;
    private boolean noExpandGenerate;

    Master(File file, Name origin, long initialTTL) throws IOException {
        if (origin != null && !origin.isAbsolute()) {
            throw new RelativeNameException(origin);
        }
        this.file = file;
        this.st = new Tokenizer(file);
        this.origin = origin;
        this.defaultTTL = initialTTL;
    }

    public Master(String filename, Name origin, long ttl) throws IOException {
        this(new File(filename), origin, ttl);
    }

    public Master(String filename, Name origin) throws IOException {
        this(new File(filename), origin, -1L);
    }

    public Master(String filename) throws IOException {
        this(new File(filename), null, -1L);
    }

    public Master(InputStream in, Name origin, long ttl) {
        if (origin != null && !origin.isAbsolute()) {
            throw new RelativeNameException(origin);
        }
        this.st = new Tokenizer(in);
        this.origin = origin;
        this.defaultTTL = ttl;
    }

    public Master(InputStream in, Name origin) {
        this(in, origin, -1L);
    }

    public Master(InputStream in) {
        this(in, null, -1L);
    }

    private Name parseName(String s2, Name origin) throws TextParseException {
        try {
            return Name.fromString(s2, origin);
        }
        catch (TextParseException e) {
            throw this.st.exception(e.getMessage());
        }
    }

    private void parseTTLClassAndType() throws IOException {
        String s2;
        boolean seen_class;
        block10: {
            seen_class = false;
            seen_class = false;
            s2 = this.st.getString();
            this.currentDClass = DClass.value(s2);
            if (this.currentDClass >= 0) {
                s2 = this.st.getString();
                seen_class = true;
            }
            this.currentTTL = -1L;
            try {
                this.currentTTL = TTL.parseTTL(s2);
                s2 = this.st.getString();
            }
            catch (NumberFormatException e) {
                if (this.defaultTTL >= 0L) {
                    this.currentTTL = this.defaultTTL;
                }
                if (this.last == null) break block10;
                this.currentTTL = this.last.getTTL();
            }
        }
        if (!seen_class) {
            this.currentDClass = DClass.value(s2);
            if (this.currentDClass >= 0) {
                s2 = this.st.getString();
            } else {
                this.currentDClass = 1;
            }
        }
        if ((this.currentType = Type.value(s2)) < 0) {
            throw this.st.exception("Invalid type '" + s2 + "'");
        }
        if (this.currentTTL < 0L) {
            if (this.currentType != 6) {
                throw this.st.exception("missing TTL");
            }
            this.needSOATTL = true;
            this.currentTTL = 0L;
        }
    }

    private long parseUInt32(String s2) {
        if (!Character.isDigit(s2.charAt(0))) {
            return -1L;
        }
        try {
            long l = Long.parseLong(s2);
            if (l < 0L || l > 0xFFFFFFFFL) {
                return -1L;
            }
            return l;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private void startGenerate() throws IOException {
        String s2 = this.st.getIdentifier();
        int n = s2.indexOf("-");
        if (n < 0) {
            throw this.st.exception("Invalid $GENERATE range specifier: " + s2);
        }
        String startstr = s2.substring(0, n);
        String endstr = s2.substring(n + 1);
        String stepstr = null;
        n = endstr.indexOf("/");
        if (n >= 0) {
            stepstr = endstr.substring(n + 1);
            endstr = endstr.substring(0, n);
        }
        long start = this.parseUInt32(startstr);
        long end = this.parseUInt32(endstr);
        long step = stepstr != null ? this.parseUInt32(stepstr) : 1L;
        if (start < 0L || end < 0L || start > end || step <= 0L) {
            throw this.st.exception("Invalid $GENERATE range specifier: " + s2);
        }
        String nameSpec = this.st.getIdentifier();
        this.parseTTLClassAndType();
        if (!Generator.supportedType(this.currentType)) {
            throw this.st.exception("$GENERATE does not support " + Type.string(this.currentType) + " records");
        }
        String rdataSpec = this.st.getIdentifier();
        this.st.getEOL();
        this.st.unget();
        this.generator = new Generator(start, end, step, nameSpec, this.currentType, this.currentDClass, this.currentTTL, rdataSpec, this.origin);
        if (this.generators == null) {
            this.generators = new ArrayList(1);
        }
        this.generators.add(this.generator);
    }

    private void endGenerate() throws IOException {
        this.st.getEOL();
        this.generator = null;
    }

    private Record nextGenerated() throws IOException {
        try {
            return this.generator.nextRecord();
        }
        catch (Tokenizer.TokenizerException e) {
            throw this.st.exception("Parsing $GENERATE: " + e.getBaseMessage());
        }
        catch (TextParseException e) {
            throw this.st.exception("Parsing $GENERATE: " + e.getMessage());
        }
    }

    public Record _nextRecord() throws IOException {
        Name name;
        block18: {
            String s2;
            Tokenizer.Token token;
            block19: {
                block20: {
                    Record rec;
                    if (this.included != null) {
                        rec = this.included.nextRecord();
                        if (rec != null) {
                            return rec;
                        }
                        this.included = null;
                    }
                    if (this.generator != null) {
                        rec = this.nextGenerated();
                        if (rec != null) {
                            return rec;
                        }
                        this.endGenerate();
                    }
                    while (true) {
                        token = this.st.get(true, false);
                        if (token.type == 2) {
                            Tokenizer.Token next = this.st.get();
                            if (next.type == 1) continue;
                            if (next.type == 0) {
                                return null;
                            }
                            this.st.unget();
                            if (this.last == null) {
                                throw this.st.exception("no owner");
                            }
                            name = this.last.getName();
                            break block18;
                        }
                        if (token.type == 1) continue;
                        if (token.type == 0) {
                            return null;
                        }
                        if (token.value.charAt(0) != '$') break block19;
                        s2 = token.value;
                        if (s2.equalsIgnoreCase("$ORIGIN")) {
                            this.origin = this.st.getName(Name.root);
                            this.st.getEOL();
                            continue;
                        }
                        if (s2.equalsIgnoreCase("$TTL")) {
                            this.defaultTTL = this.st.getTTL();
                            this.st.getEOL();
                            continue;
                        }
                        if (s2.equalsIgnoreCase("$INCLUDE")) {
                            File newfile;
                            String filename = this.st.getString();
                            if (this.file != null) {
                                String parent = this.file.getParent();
                                newfile = new File(parent, filename);
                            } else {
                                newfile = new File(filename);
                            }
                            Name incorigin = this.origin;
                            token = this.st.get();
                            if (token.isString()) {
                                incorigin = this.parseName(token.value, Name.root);
                                this.st.getEOL();
                            }
                            this.included = new Master(newfile, incorigin, this.defaultTTL);
                            return this.nextRecord();
                        }
                        if (!s2.equalsIgnoreCase("$GENERATE")) break block20;
                        if (this.generator != null) {
                            throw new IllegalStateException("cannot nest $GENERATE");
                        }
                        this.startGenerate();
                        if (!this.noExpandGenerate) break;
                        this.endGenerate();
                    }
                    return this.nextGenerated();
                }
                throw this.st.exception("Invalid directive: " + s2);
            }
            s2 = token.value;
            name = this.parseName(s2, this.origin);
            if (this.last != null && name.equals(this.last.getName())) {
                name = this.last.getName();
            }
        }
        this.parseTTLClassAndType();
        this.last = Record.fromString(name, this.currentType, this.currentDClass, this.currentTTL, this.st, this.origin);
        if (this.needSOATTL) {
            long ttl = ((SOARecord)this.last).getMinimum();
            this.last.setTTL(ttl);
            this.defaultTTL = ttl;
            this.needSOATTL = false;
        }
        return this.last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record nextRecord() throws IOException {
        Record rec = null;
        try {
            rec = this._nextRecord();
        }
        finally {
            if (rec == null) {
                this.st.close();
            }
        }
        return rec;
    }

    public void expandGenerate(boolean wantExpand) {
        this.noExpandGenerate = !wantExpand;
    }

    public Iterator generators() {
        if (this.generators != null) {
            return Collections.unmodifiableList(this.generators).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected void finalize() {
        if (this.st != null) {
            this.st.close();
        }
    }
}

