/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.keytab;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.keytab.KeytabEntry;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.keytab.KeytabInputStream;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.keytab.KeytabOutputStream;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.keytab.KrbKeytab;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public final class Keytab
implements KrbKeytab {
    public static final int V501 = 1281;
    public static final int V502 = 1282;
    private int version = 1282;
    private Map<PrincipalName, List<KeytabEntry>> principalEntries = new HashMap<PrincipalName, List<KeytabEntry>>();

    public static Keytab loadKeytab(File keytabFile) throws IOException {
        Keytab keytab = new Keytab();
        keytab.load(keytabFile);
        return keytab;
    }

    public static Keytab loadKeytab(InputStream inputStream) throws IOException {
        Keytab keytab = new Keytab();
        keytab.load(inputStream);
        return keytab;
    }

    @Override
    public List<PrincipalName> getPrincipals() {
        return new ArrayList<PrincipalName>(this.principalEntries.keySet());
    }

    @Override
    public void addKeytabEntries(List<KeytabEntry> entries) {
        for (KeytabEntry entry : entries) {
            this.addEntry(entry);
        }
    }

    @Override
    public void removeKeytabEntries(PrincipalName principal) {
        this.principalEntries.remove(principal);
    }

    @Override
    public void removeKeytabEntries(PrincipalName principal, int kvno) {
        List<KeytabEntry> entries = this.getKeytabEntries(principal);
        for (KeytabEntry entry : entries) {
            if (entry.getKvno() != kvno) continue;
            this.removeKeytabEntry(entry);
        }
    }

    @Override
    public void removeKeytabEntry(KeytabEntry entry) {
        PrincipalName principal = entry.getPrincipal();
        List<KeytabEntry> entries = this.principalEntries.get(principal);
        if (entries != null) {
            Iterator<KeytabEntry> iter = entries.iterator();
            while (iter.hasNext()) {
                KeytabEntry tmp = iter.next();
                if (!entry.equals(tmp)) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public List<KeytabEntry> getKeytabEntries(PrincipalName principal) {
        ArrayList<KeytabEntry> results = new ArrayList<KeytabEntry>();
        List<KeytabEntry> internal = this.principalEntries.get(principal);
        if (internal == null) {
            return results;
        }
        for (KeytabEntry entry : internal) {
            results.add(entry);
        }
        return results;
    }

    @Override
    public EncryptionKey getKey(PrincipalName principal, EncryptionType keyType) {
        List<KeytabEntry> entries = this.getKeytabEntries(principal);
        for (KeytabEntry ke : entries) {
            if (ke.getKey().getKeyType() != keyType) continue;
            return ke.getKey();
        }
        return null;
    }

    @Override
    public void load(File keytabFile) throws IOException {
        if (!keytabFile.exists() || !keytabFile.canRead()) {
            throw new IllegalArgumentException("Invalid keytab file: " + keytabFile.getAbsolutePath());
        }
        try (InputStream is = Files.newInputStream(keytabFile.toPath(), new OpenOption[0]);){
            this.load(is);
        }
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid and null input stream");
        }
        KeytabInputStream kis = new KeytabInputStream(inputStream);
        this.doLoad(kis);
    }

    private void doLoad(KeytabInputStream kis) throws IOException {
        this.version = this.readVersion(kis);
        List<KeytabEntry> entries = this.readEntries(kis);
        this.addKeytabEntries(entries);
    }

    @Override
    public void addEntry(KeytabEntry entry) {
        PrincipalName principal = entry.getPrincipal();
        List<KeytabEntry> entries = this.principalEntries.get(principal);
        if (entries == null) {
            entries = new ArrayList<KeytabEntry>();
            this.principalEntries.put(principal, entries);
        }
        entries.add(entry);
    }

    private int readVersion(KeytabInputStream kis) throws IOException {
        return kis.readShort();
    }

    private List<KeytabEntry> readEntries(KeytabInputStream kis) throws IOException {
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        int bytesLeft = kis.available();
        while (bytesLeft > 0) {
            int entrySize = kis.readInt();
            if (kis.available() < entrySize) {
                throw new IOException("Bad input stream with less data than expected: " + entrySize);
            }
            KeytabEntry entry = this.readEntry(kis, entrySize);
            entries.add(entry);
            int bytesReadForEntry = bytesLeft - kis.available();
            if (bytesReadForEntry != entrySize) {
                kis.skipBytes(entrySize - bytesReadForEntry);
            }
            bytesLeft = kis.available();
        }
        return entries;
    }

    private KeytabEntry readEntry(KeytabInputStream kis, int entrySize) throws IOException {
        KeytabEntry entry = new KeytabEntry();
        entry.load(kis, this.version, entrySize);
        return entry;
    }

    @Override
    public void store(File keytabFile) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(keytabFile.toPath(), new OpenOption[0]);){
            this.store(outputStream);
        }
    }

    @Override
    public void store(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Invalid and null output stream");
        }
        KeytabOutputStream kos = new KeytabOutputStream(outputStream);
        this.writeVersion(kos);
        this.writeEntries(kos);
    }

    private void writeVersion(KeytabOutputStream kos) throws IOException {
        byte[] bytes = new byte[]{5, this.version == 1282 ? (byte)2 : 1};
        kos.write(bytes);
    }

    private void writeEntries(KeytabOutputStream kos) throws IOException {
        for (Map.Entry<PrincipalName, List<KeytabEntry>> entryList : this.principalEntries.entrySet()) {
            for (KeytabEntry entry : entryList.getValue()) {
                entry.store(kos);
            }
        }
    }
}

