/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.ccache;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbOutputStream;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddress;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TicketFlags;

public class CredCacheOutputStream
extends KrbOutputStream {
    public CredCacheOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void writePrincipal(PrincipalName principal, int version) throws IOException {
        List<String> nameComponents = principal.getNameStrings();
        if (version != 1281) {
            this.writeInt(principal.getNameType().getValue());
        }
        int numComponents = nameComponents.size();
        if (version == 1281) {
            ++numComponents;
        }
        this.writeInt(numComponents);
        this.writeRealm(principal.getRealm());
        for (String nameCom : nameComponents) {
            this.writeCountedString(nameCom);
        }
    }

    @Override
    public void writeKey(EncryptionKey key, int version) throws IOException {
        this.writeShort(key.getKeyType().getValue());
        if (version == 1283) {
            this.writeShort(key.getKeyType().getValue());
        }
        this.writeCountedOctets(key.getKeyData());
    }

    public void writeTimes(KerberosTime[] times) throws IOException {
        for (int i = 0; i < times.length; ++i) {
            this.writeTime(times[i]);
        }
    }

    public void writeAddresses(HostAddresses addrs) throws IOException {
        if (addrs == null) {
            this.writeInt(0);
        } else {
            List addresses = addrs.getElements();
            this.writeInt(addresses.size());
            for (HostAddress addr : addresses) {
                this.writeAddress(addr);
            }
        }
    }

    public void writeAddress(HostAddress address) throws IOException {
        this.write(address.getAddrType().getValue());
        this.write(address.getAddress().length);
        this.write(address.getAddress(), 0, address.getAddress().length);
    }

    public void writeAuthzData(AuthorizationData authData) throws IOException {
        if (authData == null) {
            this.writeInt(0);
        } else {
            for (AuthorizationDataEntry entry : authData.getElements()) {
                this.write(entry.getAuthzType().getValue());
                this.write(entry.getAuthzData().length);
                this.write(entry.getAuthzData());
            }
        }
    }

    public void writeTicket(Ticket t) throws IOException {
        if (t == null) {
            this.writeInt(0);
        } else {
            byte[] bytes = t.encode();
            this.writeInt(bytes.length);
            this.write(bytes);
        }
    }

    public void writeIsSkey(boolean isEncInSKey) throws IOException {
        this.writeByte(isEncInSKey ? 1 : 0);
    }

    public void writeTicketFlags(TicketFlags ticketFlags) throws IOException {
        this.writeInt(ticketFlags.getFlags());
    }
}

