/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin;

import org.apache.hadoop.hbase.shaded.org.apache.kerby.KOption;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.KOptionInfo;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.KOptionType;

public enum KadminOption implements KOption
{
    NONE(null),
    EXPIRE(new KOptionInfo("-expire", "expire time", KOptionType.DATE)),
    DISABLED(new KOptionInfo("-disabled", "disabled", KOptionType.BOOL)),
    LOCKED(new KOptionInfo("-locked", "locked", KOptionType.BOOL)),
    FORCE(new KOptionInfo("-force", "force", KOptionType.NOV)),
    KVNO(new KOptionInfo("-kvno", "initial key version number", KOptionType.INT)),
    SIZE(new KOptionInfo("-size", "principal's numbers", KOptionType.STR)),
    PW(new KOptionInfo("-pw", "password", KOptionType.STR)),
    RANDKEY(new KOptionInfo("-randkey", "random key", KOptionType.NOV)),
    KEEPOLD(new KOptionInfo("-keepold", "keep old passowrd", KOptionType.NOV)),
    KEYSALTLIST(new KOptionInfo("-e", "key saltlist", KOptionType.STR)),
    K(new KOptionInfo("-k", "keytab file path", KOptionType.STR)),
    KEYTAB(new KOptionInfo("-keytab", "keytab file path", KOptionType.STR)),
    CCACHE(new KOptionInfo("-c", "credentials cache", KOptionType.FILE));

    private final KOptionInfo optionInfo;

    private KadminOption(KOptionInfo optionInfo) {
        this.optionInfo = optionInfo;
    }

    @Override
    public KOptionInfo getOptionInfo() {
        return this.optionInfo;
    }

    public static KadminOption fromName(String name) {
        if (name != null) {
            for (KadminOption ko : KadminOption.values()) {
                if (ko.optionInfo == null || !ko.optionInfo.getName().equals(name)) continue;
                return ko;
            }
        }
        return NONE;
    }

    public static KadminOption fromOptionName(String optionName) {
        if (optionName != null) {
            for (KadminOption ko : KadminOption.values()) {
                if (ko.optionInfo == null || !ko.optionInfo.getName().equals(optionName)) continue;
                return ko;
            }
        }
        return NONE;
    }
}

