/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.ConfigLoader;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.IniConfigLoader;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.JsonConfigLoader;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.MapConfigLoader;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.PropertiesConfigLoader;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.PropertiesFileConfigLoader;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.config.XmlConfigLoader;

public final class Resource {
    private String name;
    private Object resource;
    private Format format;

    public static Resource createXmlResource(File xmlFile) throws IOException {
        return new Resource(xmlFile.getName(), xmlFile, Format.XML_FILE);
    }

    public static Resource createIniResource(File iniFile) throws IOException {
        return new Resource(iniFile.getName(), iniFile, Format.INI_FILE);
    }

    public static Resource createJsonResource(File jsonFile) throws IOException {
        return new Resource(jsonFile.getName(), jsonFile, Format.JSON_FILE);
    }

    public static Resource createXmlResource(URL xmlUrl) throws IOException {
        return new Resource(xmlUrl, Format.XML_FILE);
    }

    public static Resource createIniResource(URL iniUrl) throws IOException {
        return new Resource(iniUrl, Format.INI_FILE);
    }

    public static Resource createJsonResource(URL jsonUrl) throws IOException {
        return new Resource(jsonUrl, Format.JSON_FILE);
    }

    public static Resource createMapResource(Map<String, Object> mapConfig) {
        return new Resource("mapConfig", mapConfig, Format.MAP);
    }

    public static Resource createPropertiesFileResource(File propFile) throws IOException {
        return new Resource(propFile.getName(), propFile, Format.PROPERTIES_FILE);
    }

    public static Resource createPropertiesResource(Properties propertiesConfig) {
        return new Resource("propConfig", propertiesConfig, Format.PROPERTIES);
    }

    private Resource(String name, File resourceFile, Format format) throws IOException {
        this.name = name;
        this.resource = Files.newInputStream(resourceFile.toPath(), new OpenOption[0]);
        this.format = format;
    }

    private Resource(URL resourceUrl, Format format) throws IOException {
        this(resourceUrl.toString(), resourceUrl.openStream(), format);
    }

    private Resource(String name, Object resourceStream, Format format) {
        this.name = name;
        this.resource = resourceStream;
        this.format = format;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object getResource() {
        return this.resource;
    }

    public Format getFormat() {
        return this.format;
    }

    public static enum Format {
        XML_FILE(XmlConfigLoader.class),
        INI_FILE(IniConfigLoader.class),
        JSON_FILE(JsonConfigLoader.class),
        PROPERTIES_FILE(PropertiesFileConfigLoader.class),
        MAP(MapConfigLoader.class),
        PROPERTIES(PropertiesConfigLoader.class);

        private Class<? extends ConfigLoader> loaderClass;

        private Format(Class<? extends ConfigLoader> loaderClass) {
            this.loaderClass = loaderClass;
        }

        public Class<? extends ConfigLoader> getLoaderClass() {
            return this.loaderClass;
        }
    }
}

