/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Binder;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1Dumper;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.EnumType;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.TaggingOption;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.UniversalTag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.AbstractAsn1Type;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Any;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Choice;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Collection;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Integer;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1ObjectIdentifier;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Simple;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1String;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Type;

public abstract class Asn1CollectionType
extends AbstractAsn1Type<Asn1CollectionType>
implements Asn1Dumpable {
    private final Asn1FieldInfo[] fieldInfos;
    private final Asn1Type[] fields;

    public Asn1CollectionType(UniversalTag universalTag, Asn1FieldInfo[] fieldInfos) {
        super(universalTag);
        this.setValue(this);
        this.fieldInfos = fieldInfos;
        this.fields = new Asn1Type[fieldInfos.length];
        this.usePrimitive(false);
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        int allLen = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            int fieldLen;
            Asn1Encodeable field = (Asn1Encodeable)this.fields[i];
            if (field == null) continue;
            if (this.fieldInfos[i].isTagged()) {
                TaggingOption taggingOption = this.fieldInfos[i].getTaggingOption();
                fieldLen = field.taggedEncodingLength(taggingOption);
            } else {
                fieldLen = field.encodingLength();
            }
            allLen += fieldLen;
        }
        return allLen;
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        for (int i = 0; i < this.fields.length; ++i) {
            Asn1Type field = this.fields[i];
            if (field == null) continue;
            if (this.fieldInfos[i].isTagged()) {
                TaggingOption taggingOption = this.fieldInfos[i].getTaggingOption();
                field.taggedEncode(buffer, taggingOption);
                continue;
            }
            field.encode(buffer);
        }
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        this.useDefinitiveLength(parseResult.isDefinitiveLength());
        Asn1Container container = (Asn1Container)parseResult;
        List<Asn1ParseResult> parseResults = container.getChildren();
        int lastPos = -1;
        int foundPos = -1;
        for (Asn1ParseResult parseItem : parseResults) {
            if (parseItem.isEOC()) continue;
            foundPos = this.match(lastPos, parseItem);
            if (foundPos == -1) {
                throw new IOException("Unexpected item: " + parseItem.simpleInfo());
            }
            lastPos = foundPos;
            this.attemptBinding(parseItem, foundPos);
        }
    }

    private void attemptBinding(Asn1ParseResult parseItem, int foundPos) throws IOException {
        Asn1FieldInfo fieldInfo = this.fieldInfos[foundPos];
        this.checkAndInitField(foundPos);
        Asn1Type fieldValue = this.fields[foundPos];
        if (fieldValue instanceof Asn1Any) {
            Asn1Any any = (Asn1Any)fieldValue;
            any.setDecodeInfo(fieldInfo);
            Asn1Binder.bind(parseItem, any);
        } else if (parseItem.isContextSpecific()) {
            Asn1Binder.bindWithTagging(parseItem, fieldValue, fieldInfo.getTaggingOption());
        } else {
            Asn1Binder.bind(parseItem, fieldValue);
        }
    }

    private int match(int lastPos, Asn1ParseResult parseItem) {
        int foundPos = -1;
        for (int i = lastPos + 1; i < this.fieldInfos.length; ++i) {
            Asn1Choice aChoice;
            Asn1Type fieldValue = this.fields[i];
            Asn1FieldInfo fieldInfo = this.fieldInfos[i];
            if (fieldInfo.isTagged()) {
                if (!parseItem.isContextSpecific() || fieldInfo.getTagNo() != parseItem.tagNo()) continue;
                foundPos = i;
                break;
            }
            if (fieldValue != null) {
                if (fieldValue.tag().equals(parseItem.tag())) {
                    foundPos = i;
                    break;
                }
                if (fieldValue instanceof Asn1Choice) {
                    aChoice = (Asn1Choice)fieldValue;
                    if (!aChoice.matchAndSetValue(parseItem.tag())) continue;
                    foundPos = i;
                    break;
                }
                if (!(fieldValue instanceof Asn1Any)) continue;
                foundPos = i;
                break;
            }
            if (fieldInfo.getFieldTag().equals(parseItem.tag())) {
                foundPos = i;
                break;
            }
            if (Asn1Choice.class.isAssignableFrom(fieldInfo.getType())) {
                this.fields[i] = fieldInfo.createFieldValue();
                aChoice = (Asn1Choice)this.fields[i];
                if (!aChoice.matchAndSetValue(parseItem.tag())) continue;
                foundPos = i;
                break;
            }
            if (!Asn1Any.class.isAssignableFrom(fieldInfo.getType())) continue;
            foundPos = i;
            break;
        }
        return foundPos;
    }

    private void checkAndInitField(int index) {
        if (this.fields[index] == null) {
            this.fields[index] = this.fieldInfos[index].createFieldValue();
        }
    }

    protected abstract Asn1Collection createCollection();

    protected <T extends Asn1Type> T getFieldAs(EnumType index, Class<T> t) {
        Asn1Type value = this.fields[index.getValue()];
        if (value == null) {
            return null;
        }
        return (T)value;
    }

    protected void setFieldAs(EnumType index, Asn1Type value) {
        this.resetBodyLength();
        if (value instanceof Asn1Encodeable) {
            ((Asn1Encodeable)value).outerEncodeable = this;
        }
        this.fields[index.getValue()] = value;
    }

    protected String getFieldAsString(EnumType index) {
        Asn1Type value = this.fields[index.getValue()];
        if (value == null) {
            return null;
        }
        if (value instanceof Asn1String) {
            return (String)((Asn1String)value).getValue();
        }
        throw new RuntimeException("The targeted field type isn't of string");
    }

    protected byte[] getFieldAsOctets(EnumType index) {
        Asn1OctetString value = this.getFieldAs(index, Asn1OctetString.class);
        if (value != null) {
            return (byte[])value.getValue();
        }
        return null;
    }

    protected void setFieldAsOctets(EnumType index, byte[] bytes) {
        Asn1OctetString value = new Asn1OctetString(bytes);
        this.setFieldAs(index, value);
    }

    protected Integer getFieldAsInteger(EnumType index) {
        Asn1Integer value = this.getFieldAs(index, Asn1Integer.class);
        if (value != null && value.getValue() != null) {
            return ((BigInteger)value.getValue()).intValue();
        }
        return null;
    }

    protected void setFieldAsInt(EnumType index, int value) {
        this.setFieldAs(index, new Asn1Integer((Integer)value));
    }

    protected void setFieldAsInt(EnumType index, BigInteger value) {
        this.setFieldAs(index, new Asn1Integer(value));
    }

    protected void setFieldAsObjId(EnumType index, String value) {
        this.setFieldAs(index, new Asn1ObjectIdentifier(value));
    }

    protected String getFieldAsObjId(EnumType index) {
        Asn1ObjectIdentifier objId = this.getFieldAs(index, Asn1ObjectIdentifier.class);
        if (objId != null) {
            return (String)objId.getValue();
        }
        return null;
    }

    protected <T extends Asn1Type> T getFieldAsAny(EnumType index, Class<T> t) {
        Asn1Type value = this.fields[index.getValue()];
        if (value != null && value instanceof Asn1Any) {
            Asn1Any any = (Asn1Any)value;
            return any.getValueAs(t);
        }
        return null;
    }

    protected void setFieldAsAny(EnumType index, Asn1Type value) {
        if (value != null) {
            Asn1Any any = new Asn1Any(value);
            any.setDecodeInfo(this.fieldInfos[index.getValue()]);
            this.setFieldAs(index, any);
        }
    }

    protected void setAnyFieldValueType(EnumType index, Class<? extends Asn1Type> valueType) {
        if (valueType != null) {
            this.checkAndInitField(index.getValue());
            Asn1Type value = this.fields[index.getValue()];
            if (value != null && value instanceof Asn1Any) {
                Asn1Any any = (Asn1Any)value;
                any.setValueType(valueType);
            }
        }
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        dumper.indent(indents).appendType(this.getClass());
        dumper.append(this.simpleInfo()).newLine();
        for (int i = 0; i < this.fieldInfos.length; ++i) {
            String fdName = this.fieldInfos[i].getIndex().getName();
            fdName = fdName.replace("_", "-").toLowerCase();
            dumper.indent(indents + 4).append(fdName).append(" = ");
            Asn1Type fdValue = this.fields[i];
            if (fdValue == null || fdValue instanceof Asn1Simple) {
                dumper.append((Asn1Simple)fdValue);
            } else {
                dumper.newLine().dumpType(indents + 8, fdValue);
            }
            if (i >= this.fieldInfos.length - 1) continue;
            dumper.newLine();
        }
    }
}

