/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.FsGetter;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
final class NflyFSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(NflyFSystem.class);
    private static final String NFLY_TMP_PREFIX = "_nfly_tmp_";
    private static final int DEFAULT_MIN_REPLICATION = 2;
    private static URI nflyURI = URI.create("nfly:///");
    private final NflyNode[] nodes;
    private final int minReplication;
    private final EnumSet<NflyKey> nflyFlags;
    private final Node myNode;
    private final NetworkTopology topology;

    private MRNflyNode[] workSet() {
        MRNflyNode[] res = new MRNflyNode[this.nodes.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new MRNflyNode(this.nodes[i]);
        }
        return res;
    }

    private static String getRack(String rackString) {
        return rackString == null ? "/default-rack" : rackString;
    }

    private NflyFSystem(URI[] uris, Configuration conf, int minReplication, EnumSet<NflyKey> nflyFlags) throws IOException {
        this(uris, conf, minReplication, nflyFlags, null);
    }

    private NflyFSystem(URI[] uris, Configuration conf, int minReplication, EnumSet<NflyKey> nflyFlags, FsGetter fsGetter) throws IOException {
        if (uris.length < minReplication) {
            throw new IOException(minReplication + " < " + uris.length + ": Minimum replication < #destinations");
        }
        this.setConf(conf);
        String localHostName = InetAddress.getLocalHost().getHostName();
        ArrayList<String> hostStrings = new ArrayList<String>(uris.length + 1);
        for (URI uri : uris) {
            String uriHost = uri.getHost();
            hostStrings.add(uriHost == null ? localHostName : uriHost);
        }
        hostStrings.add(localHostName);
        DNSToSwitchMapping tmpDns = ReflectionUtils.newInstance(conf.getClass("org.apache.hadoop.hbase.shaded.net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), conf);
        List<String> rackStrings = tmpDns.resolve(hostStrings);
        this.nodes = new NflyNode[uris.length];
        Iterator<String> rackIter = rackStrings.iterator();
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = fsGetter != null ? new NflyNode((String)hostStrings.get(i), rackIter.next(), new ChRootedFileSystem(fsGetter.getNewInstance(uris[i], conf), uris[i])) : new NflyNode((String)hostStrings.get(i), rackIter.next(), uris[i], conf);
        }
        this.myNode = new NodeBase(localHostName, NflyFSystem.getRack(rackIter.next()));
        this.topology = NetworkTopology.getInstance(conf);
        this.topology.sortByDistance(this.myNode, this.nodes, this.nodes.length);
        this.minReplication = minReplication;
        this.nflyFlags = nflyFlags;
        this.statistics = NflyFSystem.getStatistics(nflyURI.getScheme(), this.getClass());
    }

    private Path getNflyTmpPath(Path f) {
        return new Path(f.getParent(), NFLY_TMP_PREFIX + f.getName());
    }

    @Override
    public URI getUri() {
        return nflyURI;
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FSDataInputStream fsdisAfterRepair;
        Object[] mrNodes;
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>(this.nodes.length);
        int numNotFounds = 0;
        for (MRNflyNode mRNflyNode : mrNodes = this.workSet()) {
            try {
                if (!this.nflyFlags.contains((Object)NflyKey.repairOnRead) && !this.nflyFlags.contains((Object)NflyKey.readMostRecent)) {
                    return mRNflyNode.getFs().open(f, bufferSize);
                }
                mRNflyNode.updateFileStatus(f);
            }
            catch (FileNotFoundException fnfe) {
                mRNflyNode.status = NflyFSystem.notFoundStatus(f);
                ++numNotFounds;
                NflyFSystem.processThrowable(mRNflyNode, "open", fnfe, ioExceptions, f);
            }
            catch (Throwable t) {
                NflyFSystem.processThrowable(mRNflyNode, "open", t, ioExceptions, f);
            }
        }
        if (this.nflyFlags.contains((Object)NflyKey.readMostRecent)) {
            Arrays.sort(mrNodes);
        }
        if ((fsdisAfterRepair = this.repairAndOpen((MRNflyNode[])mrNodes, f, bufferSize)) != null) {
            return fsdisAfterRepair;
        }
        this.mayThrowFileNotFound(ioExceptions, numNotFounds);
        throw MultipleIOException.createIOException(ioExceptions);
    }

    private static FileStatus notFoundStatus(Path f) {
        return new FileStatus(-1L, false, 0, 0L, 0L, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSDataInputStream repairAndOpen(MRNflyNode[] mrNodes, Path f, int bufferSize) {
        long maxMtime = 0L;
        for (MRNflyNode srcNode : mrNodes) {
            if (srcNode.status == null || srcNode.status.getLen() < 0L) continue;
            if (srcNode.status.getModificationTime() > maxMtime) {
                maxMtime = srcNode.status.getModificationTime();
            }
            for (MRNflyNode dstNode : mrNodes) {
                if (dstNode.status == null || srcNode.compareTo(dstNode) == 0) continue;
                try {
                    FileStatus srcStatus = srcNode.cloneStatus();
                    srcStatus.setPath(f);
                    Path tmpPath = this.getNflyTmpPath(f);
                    FileUtil.copy((FileSystem)srcNode.getFs(), srcStatus, (FileSystem)dstNode.getFs(), tmpPath, false, true, this.getConf());
                    dstNode.getFs().delete(f, false);
                    if (!dstNode.getFs().rename(tmpPath, f)) continue;
                    try {
                        dstNode.getFs().setTimes(f, srcNode.status.getModificationTime(), srcNode.status.getAccessTime());
                    }
                    finally {
                        srcStatus.setPath(dstNode.getFs().makeQualified(f));
                        dstNode.status = srcStatus;
                    }
                }
                catch (IOException ioe) {
                    LOG.info((Object)(f + " " + srcNode + "->" + dstNode + ": Failed to repair"), (Throwable)ioe);
                }
            }
        }
        if (maxMtime > 0L) {
            ArrayList<MRNflyNode> mrList = new ArrayList<MRNflyNode>();
            for (MRNflyNode openNode : mrNodes) {
                if (openNode.status == null || openNode.status.getLen() < 0L || openNode.status.getModificationTime() != maxMtime) continue;
                mrList.add(openNode);
            }
            Node[] readNodes = mrList.toArray(new MRNflyNode[0]);
            this.topology.sortByDistance(this.myNode, readNodes, readNodes.length);
            for (Node rNode : readNodes) {
                try {
                    return ((NflyNode)rNode).getFs().open(f, bufferSize);
                }
                catch (IOException e) {
                    LOG.info((Object)(f + ": Failed to open at " + ((NflyNode)rNode).getFs().getUri()));
                }
            }
        }
        return null;
    }

    private void mayThrowFileNotFound(List<IOException> ioExceptions, int numNotFounds) throws FileNotFoundException {
        if (numNotFounds == this.nodes.length) {
            throw (FileNotFoundException)ioExceptions.get(this.nodes.length - 1);
        }
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream(new NflyOutputStream(f, permission, overwrite, bufferSize, replication, blockSize, progress), this.statistics);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return null;
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
        int numNotFounds = 0;
        boolean succ = true;
        for (NflyNode nflyNode : this.nodes) {
            try {
                succ &= nflyNode.fs.rename(src, dst);
            }
            catch (FileNotFoundException fnfe) {
                ++numNotFounds;
                NflyFSystem.processThrowable(nflyNode, "rename", fnfe, ioExceptions, src, dst);
            }
            catch (Throwable t) {
                NflyFSystem.processThrowable(nflyNode, "rename", t, ioExceptions, src, dst);
                succ = false;
            }
        }
        this.mayThrowFileNotFound(ioExceptions, numNotFounds);
        if (ioExceptions.size() == this.nodes.length) {
            throw MultipleIOException.createIOException(ioExceptions);
        }
        return succ;
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
        int numNotFounds = 0;
        boolean succ = true;
        for (NflyNode nflyNode : this.nodes) {
            try {
                succ &= nflyNode.fs.delete(f);
            }
            catch (FileNotFoundException fnfe) {
                ++numNotFounds;
                NflyFSystem.processThrowable(nflyNode, "delete", fnfe, ioExceptions, f);
            }
            catch (Throwable t) {
                NflyFSystem.processThrowable(nflyNode, "delete", t, ioExceptions, f);
                succ = false;
            }
        }
        this.mayThrowFileNotFound(ioExceptions, numNotFounds);
        if (ioExceptions.size() == this.nodes.length) {
            throw MultipleIOException.createIOException(ioExceptions);
        }
        return succ;
    }

    @Override
    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        int numNotFounds;
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>(this.nodes.length);
        Object[] mrNodes = this.workSet();
        if (this.nflyFlags.contains((Object)NflyKey.readMostRecent)) {
            numNotFounds = 0;
            for (MRNflyNode mRNflyNode : mrNodes) {
                try {
                    mRNflyNode.updateFileStatus(f);
                }
                catch (FileNotFoundException fnfe) {
                    ++numNotFounds;
                    NflyFSystem.processThrowable(mRNflyNode, "listStatus", fnfe, ioExceptions, f);
                }
                catch (Throwable t) {
                    NflyFSystem.processThrowable(mRNflyNode, "listStatus", t, ioExceptions, f);
                }
            }
            this.mayThrowFileNotFound(ioExceptions, numNotFounds);
            Arrays.sort(mrNodes);
        }
        numNotFounds = 0;
        for (MRNflyNode mRNflyNode : mrNodes) {
            try {
                FileStatus[] realStats = mRNflyNode.getFs().listStatus(f);
                FileStatus[] nflyStats = new FileStatus[realStats.length];
                for (int i = 0; i < realStats.length; ++i) {
                    nflyStats[i] = new NflyStatus(mRNflyNode.getFs(), realStats[i]);
                }
                return nflyStats;
            }
            catch (FileNotFoundException fnfe) {
                ++numNotFounds;
                NflyFSystem.processThrowable(mRNflyNode, "listStatus", fnfe, ioExceptions, f);
            }
            catch (Throwable t) {
                NflyFSystem.processThrowable(mRNflyNode, "listStatus", t, ioExceptions, f);
            }
        }
        this.mayThrowFileNotFound(ioExceptions, numNotFounds);
        throw MultipleIOException.createIOException(ioExceptions);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return super.listLocatedStatus(f);
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        for (NflyNode nflyNode : this.nodes) {
            nflyNode.fs.setWorkingDirectory(newDir);
        }
    }

    @Override
    public Path getWorkingDirectory() {
        return this.nodes[0].fs.getWorkingDirectory();
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        boolean succ = true;
        for (NflyNode nflyNode : this.nodes) {
            succ &= nflyNode.fs.mkdirs(f, permission);
        }
        return succ;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>(this.nodes.length);
        int numNotFounds = 0;
        MRNflyNode[] mrNodes = this.workSet();
        long maxMtime = Long.MIN_VALUE;
        int maxMtimeIdx = Integer.MIN_VALUE;
        for (int i = 0; i < mrNodes.length; ++i) {
            MRNflyNode nflyNode = mrNodes[i];
            try {
                nflyNode.updateFileStatus(f);
                if (this.nflyFlags.contains((Object)NflyKey.readMostRecent)) {
                    long nflyTime = nflyNode.status.getModificationTime();
                    if (nflyTime > maxMtime) {
                        maxMtime = nflyTime;
                        maxMtimeIdx = i;
                    }
                    continue;
                }
                return nflyNode.nflyStatus();
            }
            catch (FileNotFoundException fnfe) {
                ++numNotFounds;
                NflyFSystem.processThrowable(nflyNode, "getFileStatus", fnfe, ioExceptions, f);
                continue;
            }
            catch (Throwable t) {
                NflyFSystem.processThrowable(nflyNode, "getFileStatus", t, ioExceptions, f);
            }
        }
        if (maxMtimeIdx >= 0) {
            return mrNodes[maxMtimeIdx].nflyStatus();
        }
        this.mayThrowFileNotFound(ioExceptions, numNotFounds);
        throw MultipleIOException.createIOException(ioExceptions);
    }

    private static void processThrowable(NflyNode nflyNode, String op, Throwable t, List<IOException> ioExceptions, Path ... f) {
        IOException ioex;
        String errMsg = Arrays.toString(f) + ": failed to " + op + " " + nflyNode.fs.getUri();
        if (t instanceof FileNotFoundException) {
            ioex = new FileNotFoundException(errMsg);
            ioex.initCause(t);
        } else {
            ioex = new IOException(errMsg, t);
        }
        if (ioExceptions != null) {
            ioExceptions.add(ioex);
        }
    }

    static FileSystem createFileSystem(URI[] uris, Configuration conf, String settings, FsGetter fsGetter) throws IOException {
        String[] kvPairs;
        int minRepl = 2;
        EnumSet<NflyKey> nflyFlags = EnumSet.noneOf(NflyKey.class);
        block4: for (String kv : kvPairs = StringUtils.split(settings)) {
            String[] kvPair = StringUtils.split(kv, '=');
            if (kvPair.length != 2) {
                throw new IllegalArgumentException(kv);
            }
            NflyKey nflyKey = NflyKey.valueOf(kvPair[0]);
            switch (nflyKey) {
                case minReplication: {
                    minRepl = Integer.parseInt(kvPair[1]);
                    continue block4;
                }
                case repairOnRead: 
                case readMostRecent: {
                    if (!Boolean.valueOf(kvPair[1]).booleanValue()) continue block4;
                    nflyFlags.add(nflyKey);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)nflyKey) + ": Infeasible");
                }
            }
        }
        return new NflyFSystem(uris, conf, minRepl, nflyFlags, fsGetter);
    }

    static final class NflyStatus
    extends FileStatus {
        private static final long serialVersionUID = 569538264L;
        private final FileStatus realStatus;
        private final String strippedRoot;

        private NflyStatus(ChRootedFileSystem realFs, FileStatus realStatus) throws IOException {
            this.realStatus = realStatus;
            this.strippedRoot = realFs.stripOutRoot(realStatus.getPath());
        }

        String stripRoot() throws IOException {
            return this.strippedRoot;
        }

        @Override
        public long getLen() {
            return this.realStatus.getLen();
        }

        @Override
        public boolean isFile() {
            return this.realStatus.isFile();
        }

        @Override
        public boolean isDirectory() {
            return this.realStatus.isDirectory();
        }

        @Override
        public boolean isSymlink() {
            return this.realStatus.isSymlink();
        }

        @Override
        public long getBlockSize() {
            return this.realStatus.getBlockSize();
        }

        @Override
        public short getReplication() {
            return this.realStatus.getReplication();
        }

        @Override
        public long getModificationTime() {
            return this.realStatus.getModificationTime();
        }

        @Override
        public long getAccessTime() {
            return this.realStatus.getAccessTime();
        }

        @Override
        public FsPermission getPermission() {
            return this.realStatus.getPermission();
        }

        @Override
        public String getOwner() {
            return this.realStatus.getOwner();
        }

        @Override
        public String getGroup() {
            return this.realStatus.getGroup();
        }

        @Override
        public Path getPath() {
            return this.realStatus.getPath();
        }

        @Override
        public void setPath(Path p) {
            this.realStatus.setPath(p);
        }

        @Override
        public Path getSymlink() throws IOException {
            return this.realStatus.getSymlink();
        }

        @Override
        public void setSymlink(Path p) {
            this.realStatus.setSymlink(p);
        }

        @Override
        public boolean equals(Object o) {
            return this.realStatus.equals(o);
        }

        @Override
        public int hashCode() {
            return this.realStatus.hashCode();
        }

        @Override
        public String toString() {
            return this.realStatus.toString();
        }
    }

    private final class NflyOutputStream
    extends OutputStream {
        private final Path nflyPath;
        private final Path tmpPath;
        private final FSDataOutputStream[] outputStreams;
        private final BitSet opSet;
        private final boolean useOverwrite;

        private NflyOutputStream(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            this.nflyPath = f;
            this.tmpPath = NflyFSystem.this.getNflyTmpPath(f);
            this.outputStreams = new FSDataOutputStream[NflyFSystem.this.nodes.length];
            for (int i = 0; i < this.outputStreams.length; ++i) {
                this.outputStreams[i] = NflyFSystem.this.nodes[i].fs.create(this.tmpPath, permission, true, bufferSize, replication, blockSize, progress);
            }
            this.opSet = new BitSet(this.outputStreams.length);
            this.opSet.set(0, this.outputStreams.length);
            this.useOverwrite = false;
        }

        private void mayThrow(List<IOException> ioExceptions) throws IOException {
            IOException ioe = MultipleIOException.createIOException(ioExceptions);
            if (this.opSet.cardinality() < NflyFSystem.this.minReplication) {
                throw ioe;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exceptions occurred: " + ioe));
            }
        }

        @Override
        public void write(int d) throws IOException {
            ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
            int i = this.opSet.nextSetBit(0);
            while (i >= 0) {
                try {
                    this.outputStreams[i].write(d);
                }
                catch (Throwable t) {
                    this.osException(i, "write", t, ioExceptions);
                }
                i = this.opSet.nextSetBit(i + 1);
            }
            this.mayThrow(ioExceptions);
        }

        private void osException(int i, String op, Throwable t, List<IOException> ioExceptions) {
            this.opSet.clear(i);
            NflyFSystem.processThrowable(NflyFSystem.this.nodes[i], op, t, ioExceptions, new Path[]{this.tmpPath, this.nflyPath});
        }

        @Override
        public void write(byte[] bytes, int offset, int len) throws IOException {
            ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
            int i = this.opSet.nextSetBit(0);
            while (i >= 0) {
                try {
                    this.outputStreams[i].write(bytes, offset, len);
                }
                catch (Throwable t) {
                    this.osException(i, "write", t, ioExceptions);
                }
                i = this.opSet.nextSetBit(i + 1);
            }
            this.mayThrow(ioExceptions);
        }

        @Override
        public void flush() throws IOException {
            ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
            int i = this.opSet.nextSetBit(0);
            while (i >= 0) {
                try {
                    this.outputStreams[i].flush();
                }
                catch (Throwable t) {
                    this.osException(i, "flush", t, ioExceptions);
                }
                i = this.opSet.nextSetBit(i + 1);
            }
            this.mayThrow(ioExceptions);
        }

        @Override
        public void close() throws IOException {
            ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
            int i = this.opSet.nextSetBit(0);
            while (i >= 0) {
                try {
                    this.outputStreams[i].close();
                }
                catch (Throwable t) {
                    this.osException(i, "close", t, ioExceptions);
                }
                i = this.opSet.nextSetBit(i + 1);
            }
            if (this.opSet.cardinality() < NflyFSystem.this.minReplication) {
                this.cleanupAllTmpFiles();
                throw new IOException("Failed to sufficiently replicate: min=" + NflyFSystem.this.minReplication + " actual=" + this.opSet.cardinality());
            }
            this.commit();
        }

        private void cleanupAllTmpFiles() throws IOException {
            for (int i = 0; i < this.outputStreams.length; ++i) {
                try {
                    NflyFSystem.this.nodes[i].fs.delete(this.tmpPath);
                    continue;
                }
                catch (Throwable t) {
                    NflyFSystem.processThrowable(NflyFSystem.this.nodes[i], "delete", t, null, new Path[]{this.tmpPath});
                }
            }
        }

        private void commit() throws IOException {
            ArrayList<IOException> ioExceptions = new ArrayList<IOException>();
            int i = this.opSet.nextSetBit(0);
            while (i >= 0) {
                NflyNode nflyNode = NflyFSystem.this.nodes[i];
                try {
                    if (this.useOverwrite) {
                        nflyNode.fs.delete(this.nflyPath);
                    }
                    nflyNode.fs.rename(this.tmpPath, this.nflyPath);
                }
                catch (Throwable t) {
                    this.osException(i, "commit", t, ioExceptions);
                }
                i = this.opSet.nextSetBit(i + 1);
            }
            if (this.opSet.cardinality() < NflyFSystem.this.minReplication) {
                throw MultipleIOException.createIOException(ioExceptions);
            }
            long commitTime = System.currentTimeMillis();
            int i2 = this.opSet.nextSetBit(0);
            while (i2 >= 0) {
                try {
                    NflyFSystem.this.nodes[i2].fs.setTimes(this.nflyPath, commitTime, commitTime);
                }
                catch (Throwable t) {
                    LOG.info((Object)("Failed to set timestamp: " + NflyFSystem.this.nodes[i2] + " " + this.nflyPath));
                }
                i2 = this.opSet.nextSetBit(i2 + 1);
            }
        }
    }

    private static final class MRNflyNode
    extends NflyNode
    implements Comparable<MRNflyNode> {
        private FileStatus status;

        private MRNflyNode(NflyNode n) {
            super(n.getName(), n.getNetworkLocation(), n.fs);
        }

        private void updateFileStatus(Path f) throws IOException {
            FileStatus tmpStatus = this.getFs().getFileStatus(f);
            this.status = tmpStatus == null ? NflyFSystem.notFoundStatus(f) : tmpStatus;
        }

        @Override
        public int compareTo(MRNflyNode other) {
            if (this.status == null) {
                return other.status == null ? 0 : 1;
            }
            if (other.status == null) {
                return -1;
            }
            long mtime = this.status.getModificationTime();
            long their = other.status.getModificationTime();
            return Long.compare(their, mtime);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MRNflyNode)) {
                return false;
            }
            MRNflyNode other = (MRNflyNode)o;
            return 0 == this.compareTo(other);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        private FileStatus nflyStatus() throws IOException {
            return new NflyStatus(this.getFs(), this.status);
        }

        private FileStatus cloneStatus() throws IOException {
            return new FileStatus(this.status.getLen(), this.status.isDirectory(), this.status.getReplication(), this.status.getBlockSize(), this.status.getModificationTime(), this.status.getAccessTime(), null, null, null, this.status.isSymlink() ? this.status.getSymlink() : null, this.status.getPath());
        }
    }

    private static class NflyNode
    extends NodeBase {
        private final ChRootedFileSystem fs;

        NflyNode(String hostName, String rackName, URI uri, Configuration conf) throws IOException {
            this(hostName, rackName, new ChRootedFileSystem(uri, conf));
        }

        NflyNode(String hostName, String rackName, ChRootedFileSystem fs) {
            super(hostName, rackName);
            this.fs = fs;
        }

        ChRootedFileSystem getFs() {
            return this.fs;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    static enum NflyKey {
        minReplication,
        readMostRecent,
        repairOnRead;

    }
}

