/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;

public class HardLink {
    private static HardLinkCommandGetter getHardLinkCommand;
    public final LinkStats linkStats = new LinkStats();

    public static void createHardLink(File file, File linkName) throws IOException {
        if (file == null) {
            throw new IOException("invalid arguments to createHardLink: source file is null");
        }
        if (linkName == null) {
            throw new IOException("invalid arguments to createHardLink: link name is null");
        }
        Files.createLink(linkName.toPath(), file.toPath());
    }

    public static void createHardLinkMult(File parentDir, String[] fileBaseNames, File linkDir) throws IOException {
        if (parentDir == null) {
            throw new IOException("invalid arguments to createHardLinkMult: parent directory is null");
        }
        if (linkDir == null) {
            throw new IOException("invalid arguments to createHardLinkMult: link directory is null");
        }
        if (fileBaseNames == null) {
            throw new IOException("invalid arguments to createHardLinkMult: filename list can be empty but not null");
        }
        if (!linkDir.exists()) {
            throw new FileNotFoundException(linkDir + " not found.");
        }
        for (String name : fileBaseNames) {
            Files.createLink(linkDir.toPath().resolve(name), parentDir.toPath().resolve(name));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getLinkCount(File fileName) throws IOException {
        int result222222;
        Shell.ShellCommandExecutor shexec;
        BufferedReader in;
        int exitValue;
        String errMsg;
        String inpMsg;
        block9: {
            if (fileName == null) {
                throw new IOException("invalid argument to getLinkCount: file name is null");
            }
            if (!fileName.exists()) {
                throw new FileNotFoundException(fileName + " not found.");
            }
            String[] cmd = getHardLinkCommand.linkCount(fileName);
            inpMsg = null;
            errMsg = null;
            exitValue = -1;
            in = null;
            shexec = new Shell.ShellCommandExecutor(cmd);
            shexec.execute();
            in = new BufferedReader(new StringReader(shexec.getOutput()));
            inpMsg = in.readLine();
            exitValue = shexec.getExitCode();
            if (inpMsg == null || exitValue != 0) {
                throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, null);
            }
            if (!Shell.SOLARIS) break block9;
            String[] result222222 = inpMsg.split("\\s+");
            int n = Integer.parseInt(result222222[1]);
            IOUtils.closeStream(in);
            return n;
        }
        try {
            result222222 = Integer.parseInt(inpMsg);
        }
        catch (Shell.ExitCodeException e) {
            try {
                inpMsg = shexec.getOutput();
                errMsg = e.getMessage();
                exitValue = e.getExitCode();
                throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, e);
                catch (NumberFormatException e2) {
                    throw HardLink.createIOException(fileName, inpMsg, errMsg, exitValue, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
        }
        IOUtils.closeStream(in);
        return result222222;
    }

    private static IOException createIOException(File f, String message, String error, int exitvalue, Exception cause) {
        String s2 = "Failed to get link count on file " + f + ": message=" + message + "; error=" + error + "; exit value=" + exitvalue;
        return cause == null ? new IOException(s2) : new IOException(s2, cause);
    }

    static {
        if (Shell.WINDOWS) {
            getHardLinkCommand = new HardLinkCGWin();
        } else {
            getHardLinkCommand = new HardLinkCGUnix();
            if (Shell.MAC || Shell.FREEBSD) {
                String[] linkCountCmdTemplate = new String[]{"/usr/bin/stat", "-f%l", null};
                HardLinkCGUnix.setLinkCountCmdTemplate(linkCountCmdTemplate);
            } else if (Shell.SOLARIS) {
                String[] linkCountCmdTemplate = new String[]{"ls", "-l", null};
                HardLinkCGUnix.setLinkCountCmdTemplate(linkCountCmdTemplate);
            }
        }
    }

    public static class LinkStats {
        public int countDirs = 0;
        public int countSingleLinks = 0;
        public int countMultLinks = 0;
        public int countFilesMultLinks = 0;
        public int countEmptyDirs = 0;
        public int countPhysicalFileCopies = 0;

        public void clear() {
            this.countDirs = 0;
            this.countSingleLinks = 0;
            this.countMultLinks = 0;
            this.countFilesMultLinks = 0;
            this.countEmptyDirs = 0;
            this.countPhysicalFileCopies = 0;
        }

        public String report() {
            return "HardLinkStats: " + this.countDirs + " Directories, including " + this.countEmptyDirs + " Empty Directories, " + this.countSingleLinks + " single Link operations, " + this.countMultLinks + " multi-Link operations, linking " + this.countFilesMultLinks + " files, total " + (this.countSingleLinks + this.countFilesMultLinks) + " linkable files.  Also physically copied " + this.countPhysicalFileCopies + " other files.";
        }
    }

    @VisibleForTesting
    static class HardLinkCGWin
    extends HardLinkCommandGetter {
        static String[] getLinkCountCommand = new String[]{Shell.WINUTILS, "hardlink", "stat", null};

        HardLinkCGWin() {
        }

        @Override
        String[] linkCount(File file) throws IOException {
            Shell.getWinUtilsFile();
            String[] buf = new String[getLinkCountCommand.length];
            System.arraycopy(getLinkCountCommand, 0, buf, 0, getLinkCountCommand.length);
            buf[HardLinkCGWin.getLinkCountCommand.length - 1] = file.getCanonicalPath();
            return buf;
        }
    }

    private static class HardLinkCGUnix
    extends HardLinkCommandGetter {
        private static String[] getLinkCountCommand = new String[]{"stat", "-c%h", null};

        private HardLinkCGUnix() {
        }

        private static synchronized void setLinkCountCmdTemplate(String[] template) {
            getLinkCountCommand = template;
        }

        @Override
        String[] linkCount(File file) throws IOException {
            String[] buf = new String[getLinkCountCommand.length];
            System.arraycopy(getLinkCountCommand, 0, buf, 0, getLinkCountCommand.length);
            buf[HardLinkCGUnix.getLinkCountCommand.length - 1] = FileUtil.makeShellPath(file, true);
            return buf;
        }
    }

    private static abstract class HardLinkCommandGetter {
        private HardLinkCommandGetter() {
        }

        abstract String[] linkCount(File var1) throws IOException;
    }
}

