/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.provider.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.security.provider.AttemptingUserProvidingSaslServer;
import org.apache.hadoop.hbase.security.provider.SaslServerAuthenticationProvider;
import org.apache.hadoop.hbase.security.provider.example.SaslPlainServer;
import org.apache.hadoop.hbase.security.provider.example.ShadeSaslAuthenticationProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ShadeSaslServerAuthenticationProvider
extends ShadeSaslAuthenticationProvider
implements SaslServerAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ShadeSaslServerAuthenticationProvider.class);
    public static final String PASSWORD_FILE_KEY = "hbase.security.shade.password.file";
    static final char SEPARATOR = '=';
    private AtomicReference<UserGroupInformation> attemptingUser = new AtomicReference<Object>(null);
    private Map<String, char[]> passwordDatabase;

    public void init(Configuration conf) throws IOException {
        this.passwordDatabase = this.readPasswordDB(conf);
    }

    public AttemptingUserProvidingSaslServer createServer(SecretManager<TokenIdentifier> secretManager, Map<String, String> saslProps) throws IOException {
        return new AttemptingUserProvidingSaslServer((SaslServer)new SaslPlainServer(new ShadeSaslServerCallbackHandler(this.attemptingUser, this.passwordDatabase)), () -> this.attemptingUser.get());
    }

    Map<String, char[]> readPasswordDB(Configuration conf) throws IOException {
        String passwordFileName = conf.get(PASSWORD_FILE_KEY);
        if (passwordFileName == null) {
            throw new RuntimeException("hbase.security.shade.password.file is not defined in configuration, cannot use this implementation");
        }
        Path passwordFile = new Path(passwordFileName);
        FileSystem fs = passwordFile.getFileSystem(conf);
        if (!fs.exists(passwordFile)) {
            throw new RuntimeException("Configured password file does not exist: " + passwordFile);
        }
        HashMap<String, char[]> passwordDb = new HashMap<String, char[]>();
        try (FSDataInputStream fdis = fs.open(passwordFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fdis, StandardCharsets.UTF_8));){
            String line = null;
            int offset = 0;
            while ((line = reader.readLine()) != null) {
                String[] parts = StringUtils.split((String)(line = line.trim()), (char)'=');
                if (parts.length < 2) {
                    LOG.warn("Password file contains invalid record on line {}, skipping", (Object)(offset + 1));
                    continue;
                }
                String username = parts[0];
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i < parts.length; ++i) {
                    if (builder.length() > 0) {
                        builder.append('=');
                    }
                    builder.append(parts[i]);
                }
                passwordDb.put(username, builder.toString().toCharArray());
                ++offset;
            }
        }
        return passwordDb;
    }

    public boolean supportsProtocolAuthentication() {
        return false;
    }

    public UserGroupInformation getAuthorizedUgi(String authzId, SecretManager<TokenIdentifier> secretManager) throws IOException {
        return UserGroupInformation.createRemoteUser((String)authzId);
    }

    static class ShadeSaslServerCallbackHandler
    implements CallbackHandler {
        private final AtomicReference<UserGroupInformation> attemptingUser;
        private final Map<String, char[]> passwordDatabase;

        public ShadeSaslServerCallbackHandler(AtomicReference<UserGroupInformation> attemptingUser, Map<String, char[]> passwordDatabase) {
            this.attemptingUser = attemptingUser;
            this.passwordDatabase = passwordDatabase;
        }

        @Override
        public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
            LOG.info("SaslServerCallbackHandler called", (Throwable)new Exception());
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL PLAIN Callback");
            }
            if (nc != null && pc != null) {
                String username = nc.getName();
                UserGroupInformation ugi = this.createUgiForRemoteUser(username);
                this.attemptingUser.set(ugi);
                char[] clientPassword = pc.getPassword();
                char[] actualPassword = this.passwordDatabase.get(username);
                if (!Arrays.equals(clientPassword, actualPassword)) {
                    throw new SecretManager.InvalidToken("Authentication failed for " + username);
                }
            }
            if (ac != null) {
                String userRequestedToExecuteAs;
                String authenticatedUserId = ac.getAuthenticationID();
                if (authenticatedUserId.equals(userRequestedToExecuteAs = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                    ac.setAuthorizedID(userRequestedToExecuteAs);
                } else {
                    ac.setAuthorized(false);
                }
            }
        }

        UserGroupInformation createUgiForRemoteUser(String username) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)username);
            ugi.setAuthenticationMethod(ShadeSaslAuthenticationProvider.METHOD.getAuthMethod());
            return ugi;
        }
    }
}

