/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.client.impl.BlockReaderRemote;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.tools.AdminHelper;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DebugAdmin
extends Configured
implements Tool {
    private final DebugCommand[] DEBUG_COMMANDS = new DebugCommand[]{new VerifyMetaCommand(), new ComputeMetaCommand(), new RecoverLeaseCommand(), new VerifyECCommand(), new HelpCommand()};
    private static int HEADER_LEN = 7;

    public DebugAdmin(Configuration conf) {
        super(conf);
    }

    private DebugCommand popCommand(List<String> args) {
        String commandStr;
        String string = commandStr = args.size() == 0 ? "" : args.get(0);
        if (commandStr.startsWith("-")) {
            commandStr = commandStr.substring(1);
        }
        for (DebugCommand command : this.DEBUG_COMMANDS) {
            if (!command.name.equals(commandStr)) continue;
            args.remove(0);
            return command;
        }
        return null;
    }

    public int run(String[] argv) {
        LinkedList<String> args = new LinkedList<String>();
        for (int j = 0; j < argv.length; ++j) {
            args.add(argv[j]);
        }
        DebugCommand command = this.popCommand(args);
        if (command == null) {
            this.printUsage();
            return 0;
        }
        try {
            return command.run(args);
        }
        catch (IOException e) {
            System.err.println("IOException: " + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException: " + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private void printUsage() {
        System.out.println("Usage: hdfs debug <command> [arguments]\n");
        System.out.println("These commands are for advanced users only.\n");
        System.out.println("Incorrect usages may result in data loss. Use at your own risk.\n");
        for (DebugCommand command : this.DEBUG_COMMANDS) {
            if (command.name.equals("help")) continue;
            System.out.println(command.usageText);
        }
    }

    public static void main(String[] argsArray) throws IOException {
        DebugAdmin debugAdmin = new DebugAdmin(new Configuration());
        System.exit(debugAdmin.run(argsArray));
    }

    static /* synthetic */ int access$000() {
        return HEADER_LEN;
    }

    private class HelpCommand
    extends DebugCommand {
        HelpCommand() {
            super("help", "help [command-name]", "  Get help about a command.");
        }

        @Override
        int run(List<String> args) {
            DebugCommand command = DebugAdmin.this.popCommand(args);
            if (command == null) {
                DebugAdmin.this.printUsage();
                return 0;
            }
            System.out.println(command.usageText);
            System.out.println(command.helpText + System.lineSeparator());
            return 0;
        }
    }

    private class VerifyECCommand
    extends DebugCommand {
        private DFSClient client;
        private int dataBlkNum;
        private int parityBlkNum;
        private int cellSize;
        private boolean useDNHostname;
        private CachingStrategy cachingStrategy;
        private int stripedReadBufferSize;
        private CompletionService<Integer> readService;
        private RawErasureEncoder encoder;
        private BlockReader[] blockReaders;

        VerifyECCommand() {
            super("verifyEC", "verifyEC -file <file>", "  Verify HDFS erasure coding on all block groups of the file.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int run(List<String> args) throws IOException {
            FileStatus fileStatus;
            if (args.size() < 2) {
                System.out.println(this.usageText);
                System.out.println(this.helpText + System.lineSeparator());
                return 1;
            }
            String file = StringUtils.popOptionWithArgument((String)"-file", args);
            Path path = new Path(file);
            DistributedFileSystem dfs = AdminHelper.getDFS(DebugAdmin.this.getConf());
            this.client = dfs.getClient();
            try {
                fileStatus = dfs.getFileStatus(path);
            }
            catch (FileNotFoundException e) {
                System.err.println("File " + file + " does not exist.");
                return 1;
            }
            if (!fileStatus.isFile()) {
                System.err.println("File " + file + " is not a regular file.");
                return 1;
            }
            if (!dfs.isFileClosed(path)) {
                System.err.println("File " + file + " is not closed.");
                return 1;
            }
            this.useDNHostname = DebugAdmin.this.getConf().getBoolean("dfs.datanode.use.datanode.hostname", false);
            this.cachingStrategy = CachingStrategy.newDefaultStrategy();
            this.stripedReadBufferSize = DebugAdmin.this.getConf().getInt("dfs.datanode.ec.reconstruction.stripedread.buffer.size", 65536);
            LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(file, 0L, fileStatus.getLen());
            if (locatedBlocks.getErasureCodingPolicy() == null) {
                System.err.println("File " + file + " is not erasure coded.");
                return 1;
            }
            ErasureCodingPolicy ecPolicy = locatedBlocks.getErasureCodingPolicy();
            this.dataBlkNum = ecPolicy.getNumDataUnits();
            this.parityBlkNum = ecPolicy.getNumParityUnits();
            this.cellSize = ecPolicy.getCellSize();
            this.encoder = CodecUtil.createRawEncoder((Configuration)DebugAdmin.this.getConf(), (String)ecPolicy.getCodecName(), (ErasureCoderOptions)new ErasureCoderOptions(ecPolicy.getNumDataUnits(), ecPolicy.getNumParityUnits()));
            int blockNum = this.dataBlkNum + this.parityBlkNum;
            this.readService = new ExecutorCompletionService<Integer>(DFSUtilClient.getThreadPoolExecutor((int)blockNum, (int)blockNum, (long)60L, new LinkedBlockingQueue(), (String)"read-", (boolean)false));
            this.blockReaders = new BlockReader[this.dataBlkNum + this.parityBlkNum];
            for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
                System.out.println("Checking EC block group: blk_" + locatedBlock.getBlock().getBlockId());
                LocatedStripedBlock blockGroup = (LocatedStripedBlock)locatedBlock;
                try {
                    this.verifyBlockGroup(blockGroup);
                    System.out.println("Status: OK");
                }
                catch (Exception e) {
                    System.err.println("Status: ERROR, message: " + e.getMessage());
                    int n = 1;
                    return n;
                }
                finally {
                    this.closeBlockReaders();
                }
            }
            System.out.println("\nAll EC block group status: OK");
            return 0;
        }

        private void verifyBlockGroup(LocatedStripedBlock blockGroup) throws Exception {
            int toVerifyLen;
            int i;
            LocatedBlock[] indexedBlocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)blockGroup, (int)this.cellSize, (int)this.dataBlkNum, (int)this.parityBlkNum);
            int blockNumExpected = Math.min(this.dataBlkNum, (int)((blockGroup.getBlockSize() - 1L) / (long)this.cellSize + 1L)) + this.parityBlkNum;
            if (blockGroup.getBlockIndices().length < blockNumExpected) {
                throw new Exception("Block group is under-erasure-coded.");
            }
            long maxBlockLen = 0L;
            DataChecksum checksum = null;
            for (int i2 = 0; i2 < this.dataBlkNum + this.parityBlkNum; ++i2) {
                LocatedBlock block = indexedBlocks[i2];
                if (block == null) {
                    this.blockReaders[i2] = null;
                    continue;
                }
                if (block.getBlockSize() > maxBlockLen) {
                    maxBlockLen = block.getBlockSize();
                }
                BlockReader blockReader = this.createBlockReader(block.getBlock(), block.getLocations()[0], (Token<BlockTokenIdentifier>)block.getBlockToken());
                if (checksum == null) {
                    checksum = blockReader.getDataChecksum();
                } else assert (checksum.equals((Object)blockReader.getDataChecksum()));
                this.blockReaders[i2] = blockReader;
            }
            assert (checksum != null);
            int bytesPerChecksum = checksum.getBytesPerChecksum();
            int bufferSize = this.stripedReadBufferSize < bytesPerChecksum ? bytesPerChecksum : this.stripedReadBufferSize - this.stripedReadBufferSize % bytesPerChecksum;
            ByteBuffer[] buffers = new ByteBuffer[this.dataBlkNum + this.parityBlkNum];
            ByteBuffer[] outputs = new ByteBuffer[this.parityBlkNum];
            for (i = 0; i < this.dataBlkNum + this.parityBlkNum; ++i) {
                buffers[i] = ByteBuffer.allocate(bufferSize);
            }
            for (i = 0; i < this.parityBlkNum; ++i) {
                outputs[i] = ByteBuffer.allocate(bufferSize);
            }
            for (long positionInBlock = 0L; positionInBlock < maxBlockLen; positionInBlock += (long)toVerifyLen) {
                int i3;
                toVerifyLen = (int)Math.min((long)bufferSize, maxBlockLen - positionInBlock);
                ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(this.dataBlkNum + this.parityBlkNum);
                int i4 = 0;
                while (i4 < this.dataBlkNum + this.parityBlkNum) {
                    int fi = i4++;
                    futures.add(this.readService.submit(() -> {
                        int readLen;
                        BlockReader blockReader = this.blockReaders[fi];
                        ByteBuffer buffer = buffers[fi];
                        buffer.clear();
                        buffer.limit(toVerifyLen);
                        if (blockReader != null) {
                            int nread;
                            int toRead = buffer.remaining();
                            for (readLen = 0; readLen < toRead && (nread = blockReader.read(buffer)) > 0; readLen += nread) {
                            }
                        }
                        while (buffer.hasRemaining()) {
                            buffer.put((byte)0);
                        }
                        buffer.flip();
                        return readLen;
                    }));
                }
                for (i4 = 0; i4 < this.dataBlkNum + this.parityBlkNum; ++i4) {
                    ((Future)futures.get(i4)).get(1L, TimeUnit.MINUTES);
                }
                ByteBuffer[] inputs = new ByteBuffer[this.dataBlkNum];
                System.arraycopy(buffers, 0, inputs, 0, this.dataBlkNum);
                for (i3 = 0; i3 < this.parityBlkNum; ++i3) {
                    outputs[i3].clear();
                    outputs[i3].limit(toVerifyLen);
                }
                this.encoder.encode(inputs, outputs);
                for (i3 = 0; i3 < this.parityBlkNum; ++i3) {
                    if (buffers[this.dataBlkNum + i3].equals(outputs[i3])) continue;
                    throw new Exception("EC compute result not match.");
                }
            }
        }

        private BlockReader createBlockReader(ExtendedBlock block, DatanodeInfo dnInfo, Token<BlockTokenIdentifier> token) throws IOException {
            InetSocketAddress dnAddress = NetUtils.createSocketAddr((String)dnInfo.getXferAddr(this.useDNHostname));
            Peer peer = this.client.newConnectedPeer(dnAddress, token, (DatanodeID)dnInfo);
            return BlockReaderRemote.newBlockReader((String)"dummy", (ExtendedBlock)block, token, (long)0L, (long)block.getNumBytes(), (boolean)true, (String)"", (Peer)peer, (DatanodeID)dnInfo, null, (CachingStrategy)this.cachingStrategy, (int)-1);
        }

        private void closeBlockReaders() {
            for (int i = 0; i < this.blockReaders.length; ++i) {
                if (this.blockReaders[i] == null) continue;
                IOUtils.closeStream((Closeable)this.blockReaders[i]);
                this.blockReaders[i] = null;
            }
        }
    }

    private class RecoverLeaseCommand
    extends DebugCommand {
        private static final int TIMEOUT_MS = 5000;

        RecoverLeaseCommand() {
            super("recoverLease", "recoverLease -path <path> [-retries <num-retries>]", "  Recover the lease on the specified path.  The path must reside on an" + System.lineSeparator() + "  HDFS filesystem.  The default number of retries is 1.");
        }

        @Override
        int run(List<String> args) throws IOException {
            FileSystem fs;
            if (args.size() == 0) {
                System.out.println(this.usageText);
                System.out.println(this.helpText + System.lineSeparator());
                return 1;
            }
            String pathStr = StringUtils.popOptionWithArgument((String)"-path", args);
            String retriesStr = StringUtils.popOptionWithArgument((String)"-retries", args);
            if (pathStr == null) {
                System.err.println("You must supply a -path argument to recoverLease.");
                return 1;
            }
            int maxRetries = 1;
            if (retriesStr != null) {
                try {
                    maxRetries = Integer.parseInt(retriesStr);
                }
                catch (NumberFormatException e) {
                    System.err.println("Failed to parse the argument to -retries: " + StringUtils.stringifyException((Throwable)e));
                    return 1;
                }
            }
            try {
                fs = FileSystem.newInstance((URI)new URI(pathStr), (Configuration)DebugAdmin.this.getConf(), null);
            }
            catch (URISyntaxException e) {
                System.err.println("URISyntaxException for " + pathStr + ":" + StringUtils.stringifyException((Throwable)e));
                return 1;
            }
            catch (InterruptedException e) {
                System.err.println("InterruptedException for " + pathStr + ":" + StringUtils.stringifyException((Throwable)e));
                return 1;
            }
            DistributedFileSystem dfs = null;
            try {
                dfs = (DistributedFileSystem)fs;
            }
            catch (ClassCastException e) {
                System.err.println("Invalid filesystem for path " + pathStr + ": needed scheme hdfs, but got: " + fs.getScheme());
                return 1;
            }
            int retry = 0;
            while (true) {
                boolean recovered = false;
                IOException ioe = null;
                try {
                    recovered = dfs.recoverLease(new Path(pathStr));
                }
                catch (FileNotFoundException e) {
                    System.err.println("recoverLease got exception: " + e.getMessage());
                    System.err.println("Giving up on recoverLease for " + pathStr + " after 1 try");
                    return 1;
                }
                catch (IOException e) {
                    ioe = e;
                }
                if (recovered) {
                    System.out.println("recoverLease SUCCEEDED on " + pathStr);
                    return 0;
                }
                if (ioe != null) {
                    System.err.println("recoverLease got exception: " + ioe.getMessage());
                } else {
                    System.err.println("recoverLease returned false.");
                }
                if (++retry >= maxRetries) break;
                System.err.println("Retrying in 5000 ms...");
                Uninterruptibles.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                System.err.println("Retry #" + retry);
            }
            System.err.println("Giving up on recoverLease for " + pathStr + " after " + maxRetries + (maxRetries == 1 ? " try." : " tries."));
            return 1;
        }
    }

    private static class ComputeMetaCommand
    extends DebugCommand {
        ComputeMetaCommand() {
            super("computeMeta", "computeMeta -block <block-file> -out <output-metadata-file>", "  Compute HDFS metadata from the specified block file, and save it to" + System.lineSeparator() + "  the specified output metadata file." + System.lineSeparator() + System.lineSeparator() + "**NOTE: Use at your own risk!" + System.lineSeparator() + " If the block file is corrupt and you overwrite it's meta file, " + System.lineSeparator() + " it will show up as good in HDFS, but you can't read the data." + System.lineSeparator() + " Only use as a last measure, and when you are 100% certain the block file is good.");
        }

        private DataChecksum createChecksum(Options.ChecksumOpt opt) {
            DataChecksum dataChecksum = DataChecksum.newDataChecksum((DataChecksum.Type)opt.getChecksumType(), (int)opt.getBytesPerChecksum());
            if (dataChecksum == null) {
                throw new HadoopIllegalArgumentException("Invalid checksum type: userOpt=" + opt + ", default=" + opt + ", effective=null");
            }
            return dataChecksum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int run(List<String> args) throws IOException {
            int n;
            if (args.size() == 0) {
                System.out.println(this.usageText);
                System.out.println(this.helpText + System.lineSeparator());
                return 1;
            }
            String name = StringUtils.popOptionWithArgument((String)"-block", args);
            if (name == null) {
                System.err.println("You must specify a block file with -block");
                return 2;
            }
            File blockFile = new File(name);
            if (!blockFile.exists() || !blockFile.isFile()) {
                System.err.println("Block file <" + name + "> does not exist or is not a file");
                return 3;
            }
            String outFile = StringUtils.popOptionWithArgument((String)"-out", args);
            if (outFile == null) {
                System.err.println("You must specify a output file with -out");
                return 4;
            }
            File srcMeta = new File(outFile);
            if (srcMeta.exists()) {
                System.err.println("output file already exists!");
                return 5;
            }
            DataOutputStream metaOut = null;
            try {
                Configuration conf = new Configuration();
                Options.ChecksumOpt checksumOpt = DfsClientConf.getChecksumOptFromConf((Configuration)conf);
                DataChecksum checksum = this.createChecksum(checksumOpt);
                int smallBufferSize = DFSUtilClient.getSmallBufferSize((Configuration)conf);
                metaOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(srcMeta), smallBufferSize));
                BlockMetadataHeader.writeHeader((DataOutputStream)metaOut, (DataChecksum)checksum);
                metaOut.close();
                FsDatasetUtil.computeChecksum(srcMeta, srcMeta, blockFile, smallBufferSize, conf);
                System.out.println("Checksum calculation succeeded on block file " + name + " saved metadata to meta file " + outFile);
                n = 0;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{metaOut});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{metaOut});
            return n;
        }
    }

    private static class VerifyMetaCommand
    extends DebugCommand {
        VerifyMetaCommand() {
            super("verifyMeta", "verifyMeta -meta <metadata-file> [-block <block-file>]", "  Verify HDFS metadata and block files.  If a block file is specified, we" + System.lineSeparator() + "  will verify that the checksums in the metadata file match the block" + System.lineSeparator() + "  file.");
        }

        /*
         * Exception decompiling
         */
        @Override
        int run(List<String> args) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static abstract class DebugCommand {
        final String name;
        final String usageText;
        final String helpText;

        DebugCommand(String name, String usageText, String helpText) {
            this.name = name;
            this.usageText = usageText;
            this.helpText = helpText;
        }

        abstract int run(List<String> var1) throws IOException;
    }
}

