/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlacementFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlacementFactory.class);

    private PlacementFactory() {
    }

    public static PlacementRule getPlacementRule(String ruleStr, Configuration conf) throws ClassNotFoundException {
        Class<PlacementRule> ruleClass = Class.forName(ruleStr).asSubclass(PlacementRule.class);
        LOG.info("Using PlacementRule implementation - " + ruleClass);
        return (PlacementRule)ReflectionUtils.newInstance(ruleClass, (Configuration)conf);
    }
}

