/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.BignumObjectSite;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.ConstantLookupSite;
import org.jruby.ir.targets.DRegexpObjectSite;
import org.jruby.ir.targets.FixnumObjectSite;
import org.jruby.ir.targets.FloatObjectSite;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.RegexpObjectSite;
import org.jruby.ir.targets.SymbolObjectSite;
import org.jruby.ir.targets.SymbolProcObjectSite;
import org.jruby.ir.targets.YieldSite;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.RegexpOptions;

public class IRBytecodeAdapter6
extends IRBytecodeAdapter {
    public static final String SUPER_SPLAT_UNRESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
    public static final String SUPER_NOSPLAT_UNRESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, JVM.OBJECT_ARRAY, Block.class));
    public static final String SUPER_SPLAT_RESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class, boolean[].class));
    public static final String SUPER_NOSPLAT_RESOLVED = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, JVM.OBJECT_ARRAY, Block.class));

    public IRBytecodeAdapter6(SkinnyMethodAdapter adapter, Signature signature, ClassData classData) {
        super(adapter, signature, classData);
    }

    @Override
    public void pushFixnum(long l) {
        this.loadContext();
        this.adapter.invokedynamic("fixnum", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FixnumObjectSite.BOOTSTRAP, l);
    }

    @Override
    public void pushFloat(double d) {
        this.loadContext();
        this.adapter.invokedynamic("flote", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), FloatObjectSite.BOOTSTRAP, d);
    }

    @Override
    public void pushString(ByteList bl, int cr) {
        this.loadContext();
        this.adapter.invokedynamic("string", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.string(), RubyEncoding.decodeISO(bl), bl.getEncoding().toString(), cr);
    }

    @Override
    public void pushFrozenString(ByteList bl, int cr, String file2, int line) {
        this.loadContext();
        this.adapter.invokedynamic("frozen", CodegenUtils.sig(RubyString.class, ThreadContext.class), Bootstrap.fstring(), RubyEncoding.decodeISO(bl), bl.getEncoding().toString(), cr, file2, line);
    }

    @Override
    public void pushByteList(ByteList bl) {
        this.adapter.invokedynamic("bytelist", CodegenUtils.sig(ByteList.class, new Class[0]), Bootstrap.bytelist(), RubyEncoding.decodeISO(bl), bl.getEncoding().toString());
    }

    @Override
    public void pushRegexp(ByteList source2, int options2) {
        this.loadContext();
        this.adapter.invokedynamic("regexp", CodegenUtils.sig(RubyRegexp.class, ThreadContext.class), RegexpObjectSite.BOOTSTRAP, RubyEncoding.decodeISO(source2), source2.getEncoding().toString(), options2);
    }

    @Override
    public void pushDRegexp(Runnable callback, RegexpOptions options2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("dynamic regexp has more than 250 elements");
        }
        String cacheField = null;
        Label done = null;
        if (options2.isOnce()) {
            cacheField = "dregexp" + this.getClassData().cacheFieldCount.getAndIncrement();
            done = new Label();
            this.adapter.getClassVisitor().visitField(10, cacheField, CodegenUtils.ci(RubyRegexp.class), null, null).visitEnd();
            this.adapter.getstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.dup();
            this.adapter.ifnonnull(done);
            this.adapter.pop();
        }
        callback.run();
        this.adapter.invokedynamic("dregexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(ThreadContext.class, RubyString.class, arity2)), DRegexpObjectSite.BOOTSTRAP, options2.toEmbeddedOptions());
        if (done != null) {
            this.adapter.dup();
            this.adapter.putstatic(this.getClassData().clsName, cacheField, CodegenUtils.ci(RubyRegexp.class));
            this.adapter.label(done);
        }
    }

    @Override
    public void pushSymbol(ByteList bytes2) {
        this.loadContext();
        this.adapter.invokedynamic("symbol", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolObjectSite.BOOTSTRAP, RubyEncoding.decodeISO(bytes2), bytes2.getEncoding().toString());
    }

    @Override
    public void pushSymbolProc(ByteList bytes2) {
        this.loadContext();
        this.adapter.invokedynamic("symbolProc", CodegenUtils.sig(JVM.OBJECT, ThreadContext.class), SymbolProcObjectSite.BOOTSTRAP, RubyEncoding.decodeISO(bytes2), bytes2.getEncoding().toString());
    }

    @Override
    public void loadRuntime() {
        this.loadContext();
        this.adapter.invokedynamic("runtime", CodegenUtils.sig(Ruby.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushEncoding(Encoding encoding2) {
        this.loadContext();
        this.adapter.invokedynamic("encoding", CodegenUtils.sig(RubyEncoding.class, ThreadContext.class), Bootstrap.contextValueString(), new String(encoding2.getName()));
    }

    @Override
    public void invokeOther(String file2, String scopeFieldName, CallBase call2, int arity2) {
        this.invoke(file2, this.lastLine, scopeFieldName, call2, arity2);
    }

    @Override
    public void invokeArrayDeref(String file2, String scopeFieldName, CallBase call2) {
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyString.class));
        String methodName = this.getUniqueSiteName(call2.getId());
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.aloadMany(0, 1, 2, 3);
        IRBytecodeAdapter6.cacheCallSite(adapter2, this.getClassData().clsName, methodName, scopeFieldName, call2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "callOptimizedAref", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyString.class, CallSite.class));
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeAsString(String file2, String scopeFieldName, CallBase call2) {
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String methodName = this.getUniqueSiteName(call2.getId());
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.aloadMany(0, 1, 2);
        IRBytecodeAdapter6.cacheCallSite(adapter2, this.getClassData().clsName, methodName, scopeFieldName, call2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "asString", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class));
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    public void invoke(String file2, int lineNumber, String scopeFieldName, CallBase call2, int arity2) {
        String outgoingSig;
        String incomingSig;
        String id2 = call2.getId();
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + id2 + "' has more than " + 250 + " arguments");
        }
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(call2);
        boolean blockGiven = blockPassType.given();
        if (blockGiven) {
            switch (arity2) {
                case -1: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    break;
                }
                default: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2, Block.class));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY, Block.class));
                    break;
                }
            }
        } else {
            switch (arity2) {
                case -1: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    break;
                }
                default: {
                    incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT, arity2));
                    outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, JVM.OBJECT_ARRAY));
                }
            }
        }
        String methodName = this.getUniqueSiteName(id2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(lineNumber);
        IRBytecodeAdapter6.cacheCallSite(adapter2, this.getClassData().clsName, methodName, scopeFieldName, call2);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        switch (arity2) {
            case -1: 
            case 1: {
                adapter2.aload(3);
                if (!blockGiven) break;
                adapter2.aload(4);
                break;
            }
            case 0: {
                if (!blockGiven) break;
                adapter2.aload(3);
                break;
            }
            case 2: {
                adapter2.aload(3);
                adapter2.aload(4);
                if (!blockGiven) break;
                adapter2.aload(5);
                break;
            }
            case 3: {
                adapter2.aload(3);
                adapter2.aload(4);
                adapter2.aload(5);
                if (!blockGiven) break;
                adapter2.aload(6);
                break;
            }
            default: {
                IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 3, arity2);
                if (!blockGiven) break;
                adapter2.aload(3 + arity2);
            }
        }
        adapter2.invokevirtual(CodegenUtils.p(CachingCallSite.class), blockPassType.literal() ? "callIter" : "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    public static void buildArrayFromLocals(SkinnyMethodAdapter adapter2, int base, int arity2) {
        int j;
        if (arity2 == 0) {
            adapter2.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            return;
        }
        adapter2.pushInt(arity2);
        adapter2.invokestatic(CodegenUtils.p(Helpers.class), "anewarrayIRubyObjects", CodegenUtils.sig(IRubyObject[].class, Integer.TYPE));
        for (int i2 = 0; i2 < arity2; i2 += j) {
            for (j = 0; i2 + j < arity2 && j < 10; ++j) {
                adapter2.aload(base + i2 + j);
            }
            adapter2.pushInt(i2);
            adapter2.invokestatic(CodegenUtils.p(Helpers.class), "aastoreIRubyObjects", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class, j, Integer.TYPE)));
        }
    }

    @Override
    public void invokeOtherOneFixnum(String file2, CallBase call2, long fixnum) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFixnumOps(id2)) {
            this.pushFixnum(fixnum);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, null, call2, 1);
            } else {
                this.invokeSelf(file2, null, call2, 1);
            }
            return;
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Long.TYPE));
        String methodName = "invokeOtherOneFixnum" + this.getClassData().cacheFieldCount.getAndIncrement() + ":" + JavaNameMangler.mangleMethodName(id2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(this.lastLine);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CallSite.class), null, null).visitEnd();
        adapter2.getstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.dup();
        Label doCall = new Label();
        adapter2.ifnonnull(doCall);
        adapter2.pop();
        adapter2.ldc(id2);
        adapter2.invokestatic(CodegenUtils.p(MethodIndex.class), "getFastFixnumOpsCallSite", CodegenUtils.sig(CallSite.class, String.class));
        adapter2.dup();
        adapter2.putstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.label(doCall);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        adapter2.ldc(fixnum);
        adapter2.invokevirtual(CodegenUtils.p(CallSite.class), "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeOtherOneFloat(String file2, CallBase call2, double flote) {
        String id2 = call2.getId();
        if (!MethodIndex.hasFastFloatOps(id2)) {
            this.pushFloat(flote);
            if (call2.getCallType() == CallType.NORMAL) {
                this.invokeOther(file2, null, call2, 1);
            } else {
                this.invokeSelf(file2, null, call2, 1);
            }
            return;
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT));
        String outgoingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, Double.TYPE));
        String methodName = "invokeOtherOneFloat" + this.getClassData().cacheFieldCount.getAndIncrement() + ':' + JavaNameMangler.mangleMethodName(id2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(this.lastLine);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(CallSite.class), null, null).visitEnd();
        adapter2.getstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.dup();
        Label doCall = new Label();
        adapter2.ifnonnull(doCall);
        adapter2.pop();
        adapter2.ldc(id2);
        adapter2.invokestatic(CodegenUtils.p(MethodIndex.class), "getFastFloatOpsCallSite", CodegenUtils.sig(CallSite.class, String.class));
        adapter2.dup();
        adapter2.putstatic(this.getClassData().clsName, methodName, CodegenUtils.ci(CallSite.class));
        adapter2.label(doCall);
        adapter2.aload(0);
        adapter2.aload(1);
        adapter2.aload(2);
        adapter2.ldc(flote);
        adapter2.invokevirtual(CodegenUtils.p(CallSite.class), "call", outgoingSig);
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void invokeSelf(String file2, String scopeFieldName, CallBase call2, int arity2) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to `" + call2.getId() + "' has more than " + 250 + " arguments");
        }
        this.invoke(file2, this.lastLine, scopeFieldName, call2, arity2);
    }

    @Override
    public void invokeInstanceSuper(String file2, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to instance super has more than 250 arguments");
        }
        this.performSuper(file2, this.lastLine, name2, arity2, hasClosure, splatmap, "instanceSuper", "instanceSuperSplatArgs", false);
    }

    @Override
    public void invokeClassSuper(String file2, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to class super has more than 250 arguments");
        }
        this.performSuper(file2, this.lastLine, name2, arity2, hasClosure, splatmap, "classSuper", "classSuperSplatArgs", false);
    }

    @Override
    public void invokeUnresolvedSuper(String file2, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to unresolved super has more than 250 arguments");
        }
        this.performSuper(file2, this.lastLine, name2, arity2, hasClosure, splatmap, "unresolvedSuper", "unresolvedSuperSplatArgs", true);
    }

    @Override
    public void invokeZSuper(String file2, String name2, int arity2, boolean hasClosure, boolean[] splatmap) {
        if (arity2 > 250) {
            throw new NotCompilableException("call to zsuper has more than 250 arguments");
        }
        this.performSuper(file2, this.lastLine, name2, arity2, hasClosure, splatmap, "zSuper", "zSuperSplatArgs", true);
    }

    private void performSuper(String file2, int line, String name2, int arity2, boolean hasClosure, boolean[] splatmap, String superHelper, String splatHelper, boolean unresolved) {
        boolean needsSplatting = IRRuntimeHelpers.needsSplatting(splatmap);
        String incomingSig = hasClosure ? CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2, Block.class)) : CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, JVM.OBJECT, RubyClass.class, JVM.OBJECT, arity2));
        String outgoingSig = unresolved ? (needsSplatting ? SUPER_SPLAT_UNRESOLVED : SUPER_NOSPLAT_UNRESOLVED) : (needsSplatting ? SUPER_SPLAT_RESOLVED : SUPER_NOSPLAT_RESOLVED);
        String methodName = "invokeSuper" + this.getClassData().cacheFieldCount.getAndIncrement() + ':' + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        adapter2.line(line);
        adapter2.aload(0);
        adapter2.aload(2);
        if (!unresolved) {
            adapter2.ldc(name2);
        }
        if (!unresolved) {
            adapter2.aload(3);
        }
        IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 4, arity2);
        if (hasClosure) {
            adapter2.aload(4 + arity2);
        } else {
            adapter2.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        }
        if (needsSplatting) {
            String splatmapString = IRRuntimeHelpers.encodeSplatmap(splatmap);
            adapter2.ldc(splatmapString);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "decodeSplatmap", CodegenUtils.sig(boolean[].class, String.class));
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), splatHelper, outgoingSig);
        } else {
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), superHelper, outgoingSig);
        }
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(this.getClassData().clsName, methodName, incomingSig);
    }

    @Override
    public void searchConst(String name2, boolean noPrivateConsts) {
        this.adapter.invokedynamic("searchConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, StaticScope.class)), ConstantLookupSite.BOOTSTRAP, name2, noPrivateConsts ? 1 : 0, 1);
    }

    @Override
    public void searchModuleForConst(String name2, boolean noPrivateConsts, boolean callConstMissing) {
        this.adapter.invokedynamic("searchModuleForConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class)), ConstantLookupSite.BOOTSTRAP, name2, noPrivateConsts ? 1 : 0, callConstMissing ? 1 : 0);
    }

    @Override
    public void inheritanceSearchConst(String name2, boolean noPrivateConsts) {
        this.adapter.invokedynamic("inheritanceSearchConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, IRubyObject.class)), ConstantLookupSite.BOOTSTRAP, name2, noPrivateConsts ? 1 : 0, 1);
    }

    @Override
    public void lexicalSearchConst(String name2) {
        this.adapter.invokedynamic("lexicalSearchConst", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, StaticScope.class)), ConstantLookupSite.BOOTSTRAP, name2, 0, 1);
    }

    @Override
    public void pushNil() {
        this.loadContext();
        this.adapter.invokedynamic("nil", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBoolean(boolean b2) {
        this.loadContext();
        this.adapter.invokedynamic(b2 ? "True" : "False", CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.contextValue(), new Object[0]);
    }

    @Override
    public void pushBignum(BigInteger bigint) {
        this.loadContext();
        this.adapter.invokedynamic("bignum", CodegenUtils.sig(RubyBignum.class, ThreadContext.class), BignumObjectSite.BOOTSTRAP, bigint.toString());
    }

    @Override
    public void putField(String name2) {
        this.adapter.dup2();
        this.adapter.pop();
        this.cacheVariableAccessor(name2, true);
        this.invokeIRHelper("setVariableWithAccessor", CodegenUtils.sig(Void.TYPE, IRubyObject.class, IRubyObject.class, VariableAccessor.class));
    }

    @Override
    public void getField(String name2) {
        this.adapter.dup();
        this.cacheVariableAccessor(name2, false);
        this.loadContext();
        this.adapter.ldc(name2);
        this.invokeIRHelper("getVariableWithAccessor", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, VariableAccessor.class, ThreadContext.class, String.class));
    }

    private void cacheVariableAccessor(String name2, boolean write2) {
        String incomingSig = CodegenUtils.sig(VariableAccessor.class, CodegenUtils.params(JVM.OBJECT));
        String methodName = (write2 ? "ivarSet" : "ivarGet") + this.getClassData().cacheFieldCount.getAndIncrement() + ':' + JavaNameMangler.mangleMethodName(name2);
        SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
        this.adapter.getClassVisitor().visitField(10, methodName, CodegenUtils.ci(VariableAccessor.class), null, null).visitEnd();
        String className = this.getClassData().clsName;
        adapter2.getstatic(className, methodName, CodegenUtils.ci(VariableAccessor.class));
        adapter2.dup();
        Label get2 = new Label();
        adapter2.ifnull(get2);
        adapter2.dup();
        adapter2.aload(0);
        adapter2.invokevirtual(CodegenUtils.p(VariableAccessor.class), "verify", CodegenUtils.sig(Boolean.TYPE, Object.class));
        adapter2.iffalse(get2);
        adapter2.areturn();
        adapter2.label(get2);
        adapter2.pop();
        adapter2.aload(0);
        adapter2.ldc(name2);
        adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), write2 ? "getVariableAccessorForWrite" : "getVariableAccessorForRead", CodegenUtils.sig(VariableAccessor.class, IRubyObject.class, String.class));
        adapter2.dup();
        adapter2.putstatic(className, methodName, CodegenUtils.ci(VariableAccessor.class));
        adapter2.areturn();
        adapter2.end();
        this.adapter.invokestatic(className, methodName, incomingSig);
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        if (length2 <= 2) {
            this.invokeIRHelper("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, length2)));
            return;
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2));
        String methodName = "array:" + length2;
        ClassData classData = this.getClassData();
        if (!classData.arrayMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, length2);
            adapter2.invokevirtual(CodegenUtils.p(Ruby.class), "newArrayNoCopy", CodegenUtils.sig(RubyArray.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.arrayMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2));
        String methodName = "hash:" + length2;
        ClassData classData = this.getClassData();
        if (!classData.hashMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 1, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "constructHashFromArray", CodegenUtils.sig(RubyHash.class, Ruby.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.hashMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }

    @Override
    public void kwargsHash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("kwargs hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, RubyHash.class, IRubyObject.class, length2 * 2));
        String methodName = "kwargsHash:" + length2;
        ClassData classData = this.getClassData();
        if (!classData.kwargsHashMethodsDefined.contains(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.aload(1);
            IRBytecodeAdapter6.buildArrayFromLocals(adapter2, 2, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "dupKwargsHashAndPopulateFromArray", CodegenUtils.sig(RubyHash.class, ThreadContext.class, RubyHash.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.kwargsHashMethodsDefined.add(length2);
        }
        this.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }

    @Override
    public void checkpoint() {
        this.loadContext();
        this.adapter.invokevirtual(CodegenUtils.p(ThreadContext.class), "callThreadPoll", CodegenUtils.sig(Void.TYPE, new Class[0]));
    }

    @Override
    public void getGlobalVariable(String name2, String file2) {
        this.loadContext();
        this.adapter.invokedynamic("get:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(IRubyObject.class, ThreadContext.class), Bootstrap.global(), file2, this.lastLine);
    }

    @Override
    public void setGlobalVariable(String name2, String file2) {
        this.loadContext();
        this.adapter.invokedynamic("set:" + JavaNameMangler.mangleMethodName(name2), CodegenUtils.sig(Void.TYPE, IRubyObject.class, ThreadContext.class), Bootstrap.global(), file2, this.lastLine);
    }

    @Override
    public void yield(boolean unwrap) {
        this.adapter.invokedynamic("yield", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, Block.class, JVM.OBJECT)), YieldSite.BOOTSTRAP, unwrap ? 1 : 0);
    }

    @Override
    public void yieldSpecific() {
        this.adapter.invokedynamic("yieldSpecific", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, Block.class)), YieldSite.BOOTSTRAP, 0);
    }

    @Override
    public void yieldValues(int arity2) {
        this.adapter.invokedynamic("yieldValues", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, Block.class, JVM.OBJECT, arity2)), YieldSite.BOOTSTRAP, 0);
    }

    @Override
    public void prepareBlock(Handle handle, org.jruby.runtime.Signature signature, String className) {
        Handle scopeHandle = new Handle(2, this.getClassData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class), false);
        long encodedSignature = signature.encode();
        this.adapter.invokedynamic(handle.getName(), CodegenUtils.sig(Block.class, ThreadContext.class, IRubyObject.class, DynamicScope.class), Bootstrap.prepareBlock(), handle, scopeHandle, encodedSignature);
    }

    @Override
    public void callEqq(EQQInstr call2) {
        IRBytecodeAdapter.cacheCallSite(this.adapter, this.getClassData().clsName, this.getUniqueSiteName(call2.getId()), null, call2);
        this.adapter.ldc(call2.isSplattedValue());
        this.invokeIRHelper("isEQQ", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, Boolean.TYPE));
    }
}

