/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.protobuf.generated.NamespacesMessage;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="Namespaces")
@XmlAccessorType(value=XmlAccessType.FIELD)
@InterfaceAudience.Private
public class NamespacesModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="Namespace")
    @XmlElement(name="Namespace")
    private List<String> namespaces = new ArrayList<String>();

    public NamespacesModel() {
    }

    public NamespacesModel(Admin admin) throws IOException {
        NamespaceDescriptor[] nds = admin.listNamespaceDescriptors();
        this.namespaces = new ArrayList<String>(nds.length);
        for (NamespaceDescriptor nd : nds) {
            this.namespaces.add(nd.getName());
        }
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String namespace : this.namespaces) {
            sb.append(namespace);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public byte[] createProtobufOutput() {
        NamespacesMessage.Namespaces.Builder builder = NamespacesMessage.Namespaces.newBuilder();
        builder.addAllNamespace(this.namespaces);
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        NamespacesMessage.Namespaces.Builder builder = NamespacesMessage.Namespaces.newBuilder();
        builder.mergeFrom(message);
        this.namespaces = builder.getNamespaceList();
        return this;
    }
}

