/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.util.YarnVersionInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NodeInfo {
    private static final long BYTES_IN_MB = 0x100000L;
    protected String healthReport;
    protected long totalVmemAllocatedContainersMB;
    protected long totalPmemAllocatedContainersMB;
    protected long totalVCoresAllocatedContainers;
    protected boolean vmemCheckEnabled;
    protected boolean pmemCheckEnabled;
    protected long lastNodeUpdateTime;
    protected boolean nodeHealthy;
    protected String nodeManagerVersion;
    protected String nodeManagerBuildVersion;
    protected String nodeManagerVersionBuiltOn;
    protected String hadoopVersion;
    protected String hadoopBuildVersion;
    protected String hadoopVersionBuiltOn;
    protected String id;
    protected String nodeHostName;
    protected long nmStartupTime;

    public NodeInfo() {
    }

    public NodeInfo(Context context, ResourceView resourceView) {
        this.id = context.getNodeId().toString();
        this.nodeHostName = context.getNodeId().getHost();
        this.totalVmemAllocatedContainersMB = resourceView.getVmemAllocatedForContainers() / 0x100000L;
        this.vmemCheckEnabled = resourceView.isVmemCheckEnabled();
        this.totalPmemAllocatedContainersMB = resourceView.getPmemAllocatedForContainers() / 0x100000L;
        this.pmemCheckEnabled = resourceView.isPmemCheckEnabled();
        this.totalVCoresAllocatedContainers = resourceView.getVCoresAllocatedForContainers();
        this.nodeHealthy = context.getNodeHealthStatus().getIsNodeHealthy();
        this.lastNodeUpdateTime = context.getNodeHealthStatus().getLastHealthReportTime();
        this.healthReport = context.getNodeHealthStatus().getHealthReport();
        this.nodeManagerVersion = YarnVersionInfo.getVersion();
        this.nodeManagerBuildVersion = YarnVersionInfo.getBuildVersion();
        this.nodeManagerVersionBuiltOn = YarnVersionInfo.getDate();
        this.hadoopVersion = VersionInfo.getVersion();
        this.hadoopBuildVersion = VersionInfo.getBuildVersion();
        this.hadoopVersionBuiltOn = VersionInfo.getDate();
        this.nmStartupTime = NodeManager.getNMStartupTime();
    }

    public String getNodeId() {
        return this.id;
    }

    public String getNodeHostName() {
        return this.nodeHostName;
    }

    public String getNMVersion() {
        return this.nodeManagerVersion;
    }

    public String getNMBuildVersion() {
        return this.nodeManagerBuildVersion;
    }

    public String getNMVersionBuiltOn() {
        return this.nodeManagerVersionBuiltOn;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public String getHadoopBuildVersion() {
        return this.hadoopBuildVersion;
    }

    public String getHadoopVersionBuiltOn() {
        return this.hadoopVersionBuiltOn;
    }

    public boolean getHealthStatus() {
        return this.nodeHealthy;
    }

    public long getLastNodeUpdateTime() {
        return this.lastNodeUpdateTime;
    }

    public String getHealthReport() {
        return this.healthReport;
    }

    public long getTotalVmemAllocated() {
        return this.totalVmemAllocatedContainersMB;
    }

    public long getTotalVCoresAllocated() {
        return this.totalVCoresAllocatedContainers;
    }

    public boolean isVmemCheckEnabled() {
        return this.vmemCheckEnabled;
    }

    public long getTotalPmemAllocated() {
        return this.totalPmemAllocatedContainersMB;
    }

    public boolean isPmemCheckEnabled() {
        return this.pmemCheckEnabled;
    }

    public long getNMStartupTime() {
        return this.nmStartupTime;
    }
}

