/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.mapreduce.ExportUtils;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ExportProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class Export
extends ExportProtos.ExportService
implements RegionCoprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(Export.class);
    private static final Class<? extends CompressionCodec> DEFAULT_CODEC = DefaultCodec.class;
    private static final SequenceFile.CompressionType DEFAULT_TYPE = SequenceFile.CompressionType.RECORD;
    private RegionCoprocessorEnvironment env = null;
    private UserProvider userProvider;

    public static void main(String[] args) throws Throwable {
        Map<byte[], Response> response = Export.run(HBaseConfiguration.create(), args);
        System.exit(response == null ? -1 : 0);
    }

    @InterfaceAudience.Private
    static Map<byte[], Response> run(Configuration conf, String[] args) throws Throwable {
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (!ExportUtils.isValidArguements((String[])args)) {
            ExportUtils.usage((String)("Wrong number of arguments: " + ArrayUtils.getLength((Object)otherArgs)));
            return null;
        }
        Triple arguments = ExportUtils.getArgumentsFromCommandLine((Configuration)conf, (String[])otherArgs);
        return Export.run(conf, (TableName)arguments.getFirst(), (Scan)arguments.getSecond(), (Path)arguments.getThird());
    }

    /*
     * Exception decompiling
     */
    public static Map<byte[], Response> run(Configuration conf, TableName tableName, Scan scan, Path dir) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean getCompression(ExportProtos.ExportRequest request) {
        if (request.hasCompressed()) {
            return request.getCompressed();
        }
        return false;
    }

    private static SequenceFile.CompressionType getCompressionType(ExportProtos.ExportRequest request) {
        if (request.hasCompressType()) {
            return SequenceFile.CompressionType.valueOf((String)request.getCompressType());
        }
        return DEFAULT_TYPE;
    }

    private static CompressionCodec getCompressionCodec(Configuration conf, ExportProtos.ExportRequest request) {
        try {
            Class<Object> codecClass = request.hasCompressCodec() ? conf.getClassByName(request.getCompressCodec()).asSubclass(CompressionCodec.class) : DEFAULT_CODEC;
            return (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Compression codec " + request.getCompressCodec() + " was not found.", e);
        }
    }

    private static SequenceFile.Writer.Option getOutputPath(Configuration conf, RegionInfo info, ExportProtos.ExportRequest request) throws IOException {
        Path file = new Path(request.getOutputPath(), "export-" + info.getEncodedName());
        FileSystem fs = file.getFileSystem(conf);
        if (fs.exists(file)) {
            throw new IOException(file + " exists");
        }
        return SequenceFile.Writer.file((Path)file);
    }

    private static List<SequenceFile.Writer.Option> getWriterOptions(Configuration conf, RegionInfo info, ExportProtos.ExportRequest request) throws IOException {
        LinkedList<SequenceFile.Writer.Option> rval = new LinkedList<SequenceFile.Writer.Option>();
        rval.add(SequenceFile.Writer.keyClass(ImmutableBytesWritable.class));
        rval.add(SequenceFile.Writer.valueClass(Result.class));
        rval.add(Export.getOutputPath(conf, info, request));
        if (Export.getCompression(request)) {
            rval.add(SequenceFile.Writer.compression((SequenceFile.CompressionType)Export.getCompressionType(request), (CompressionCodec)Export.getCompressionCodec(conf, request)));
        } else {
            rval.add(SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE));
        }
        return rval;
    }

    /*
     * Exception decompiling
     */
    private static ExportProtos.ExportResponse processData(Region region, Configuration conf, UserProvider userProvider, Scan scan, Token userToken, List<SequenceFile.Writer.Option> opts) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkDir(FileSystem fs, Path dir) throws IOException {
        if (fs.exists(dir)) {
            throw new RuntimeException("The " + dir + " exists");
        }
        if (!fs.mkdirs(dir)) {
            throw new IOException("Failed to create the " + dir);
        }
    }

    private static ExportProtos.ExportRequest getConfiguredRequest(Configuration conf, Path dir, Scan scan, Token<?> userToken) throws IOException {
        boolean compressed = conf.getBoolean("mapreduce.output.fileoutputformat.compress", false);
        String compressionType = conf.get("mapreduce.output.fileoutputformat.compress.type", DEFAULT_TYPE.toString());
        String compressionCodec = conf.get("mapreduce.output.fileoutputformat.compress.codec", DEFAULT_CODEC.getName());
        ClientProtos.DelegationToken protoToken = null;
        if (userToken != null) {
            protoToken = ClientProtos.DelegationToken.newBuilder().setIdentifier(ByteStringer.wrap((byte[])userToken.getIdentifier())).setPassword(ByteStringer.wrap((byte[])userToken.getPassword())).setKind(userToken.getKind().toString()).setService(userToken.getService().toString()).build();
        }
        LOG.info("compressed=" + compressed + ", compression type=" + compressionType + ", compression codec=" + compressionCodec + ", userToken=" + userToken);
        ExportProtos.ExportRequest.Builder builder = ExportProtos.ExportRequest.newBuilder().setScan(ProtobufUtil.toScan((Scan)scan)).setOutputPath(dir.toString()).setCompressed(compressed).setCompressCodec(compressionCodec).setCompressType(compressionType);
        if (protoToken != null) {
            builder.setFsToken(protoToken);
        }
        return builder.build();
    }

    public void start(CoprocessorEnvironment environment) throws IOException {
        if (!(environment instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)environment;
        this.userProvider = UserProvider.instantiate((Configuration)this.env.getConfiguration());
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    @Override
    public void export(RpcController controller, ExportProtos.ExportRequest request, RpcCallback<ExportProtos.ExportResponse> done) {
        Region region = this.env.getRegion();
        Configuration conf = HBaseConfiguration.create((Configuration)this.env.getConfiguration());
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), ResultSerialization.class.getName()});
        try {
            Scan scan = this.validateKey(region.getRegionInfo(), request);
            Token userToken = null;
            if (this.userProvider.isHadoopSecurityEnabled() && !request.hasFsToken()) {
                LOG.warn("Hadoop security is enable, but no found of user token");
            } else if (this.userProvider.isHadoopSecurityEnabled()) {
                userToken = new Token(request.getFsToken().getIdentifier().toByteArray(), request.getFsToken().getPassword().toByteArray(), new Text(request.getFsToken().getKind()), new Text(request.getFsToken().getService()));
            }
            ExportProtos.ExportResponse response = Export.processData(region, conf, this.userProvider, scan, userToken, Export.getWriterOptions(conf, region.getRegionInfo(), request));
            done.run((Object)response);
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            LOG.error(e.toString(), (Throwable)e);
        }
    }

    private Scan validateKey(RegionInfo region, ExportProtos.ExportRequest request) throws IOException {
        Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
        byte[] regionStartKey = region.getStartKey();
        byte[] originStartKey = scan.getStartRow();
        if (originStartKey == null || Bytes.compareTo((byte[])originStartKey, (byte[])regionStartKey) < 0) {
            scan.setStartRow(regionStartKey);
        }
        byte[] regionEndKey = region.getEndKey();
        byte[] originEndKey = scan.getStopRow();
        if (originEndKey == null || Bytes.compareTo((byte[])originEndKey, (byte[])regionEndKey) > 0) {
            scan.setStartRow(regionEndKey);
        }
        return scan;
    }

    private static /* synthetic */ void lambda$run$1(Map result, byte[] k, ExportProtos.ExportResponse v) {
        result.put(k, new Response(v));
    }

    private static /* synthetic */ ExportProtos.ExportResponse lambda$run$0(ExportProtos.ExportRequest request, ExportProtos.ExportService service) throws IOException {
        ServerRpcController controller = new ServerRpcController();
        TreeMap rval = new TreeMap(Bytes.BYTES_COMPARATOR);
        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
        service.export((RpcController)controller, request, (RpcCallback<ExportProtos.ExportResponse>)rpcCallback);
        if (controller.failedOnException()) {
            throw controller.getFailedOn();
        }
        return (ExportProtos.ExportResponse)rpcCallback.get();
    }

    public static final class Response {
        private final long rowCount;
        private final long cellCount;

        private Response(ExportProtos.ExportResponse r) {
            this.rowCount = r.getRowCount();
            this.cellCount = r.getCellCount();
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public long getCellCount() {
            return this.cellCount;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(35);
            return builder.append("rowCount=").append(this.rowCount).append(", cellCount=").append(this.cellCount).toString();
        }
    }

    private static class PrivilegedWriter
    implements PrivilegedExceptionAction<Boolean>,
    Closeable {
        private final User user;
        private final SequenceFile.Writer out;
        private Object key;
        private Object value;

        PrivilegedWriter(User user, SequenceFile.Writer out) {
            this.user = user;
            this.out = out;
        }

        void append(Object key, Object value) throws IOException {
            if (this.user == null) {
                this.out.append(key, value);
            } else {
                this.key = key;
                this.value = value;
                try {
                    this.user.runAs((PrivilegedExceptionAction)this);
                }
                catch (InterruptedException ex) {
                    throw new IOException(ex);
                }
            }
        }

        @Override
        public Boolean run() throws Exception {
            this.out.append(this.key, this.value);
            return true;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class SecureWriter
    implements Closeable {
        private final PrivilegedWriter privilegedWriter;

        SecureWriter(Configuration conf, UserProvider userProvider, Token userToken, List<SequenceFile.Writer.Option> opts) throws IOException {
            User user = SecureWriter.getActiveUser(userProvider, userToken);
            try {
                SequenceFile.Writer sequenceFileWriter = (SequenceFile.Writer)user.runAs(() -> SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])opts.toArray(new SequenceFile.Writer.Option[opts.size()])));
                this.privilegedWriter = new PrivilegedWriter(user, sequenceFileWriter);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        void append(Object key, Object value) throws IOException {
            this.privilegedWriter.append(key, value);
        }

        private static User getActiveUser(UserProvider userProvider, Token userToken) throws IOException {
            User user = RpcServer.getRequestUser().orElse(userProvider.getCurrent());
            if (user == null && userToken != null) {
                LOG.warn("No found of user credentials, but a token was got from user request");
            } else if (user != null && userToken != null) {
                user.addToken(userToken);
            }
            return user;
        }

        @Override
        public void close() throws IOException {
            this.privilegedWriter.close();
        }
    }

    private static class ScanCoprocessor {
        private final HRegion region;

        ScanCoprocessor(Region region) {
            this.region = (HRegion)region;
        }

        RegionScanner checkScannerOpen(Scan scan) throws IOException {
            HRegion.RegionScannerImpl scanner;
            if (this.region.getCoprocessorHost() == null) {
                scanner = this.region.getScanner(scan);
            } else {
                this.region.getCoprocessorHost().preScannerOpen(scan);
                scanner = this.region.getScanner(scan);
                scanner = this.region.getCoprocessorHost().postScannerOpen(scan, (RegionScanner)scanner);
            }
            if (scanner == null) {
                throw new IOException("Failed to open region scanner");
            }
            return scanner;
        }

        void checkScannerClose(InternalScanner s) throws IOException {
            if (s == null) {
                return;
            }
            if (this.region.getCoprocessorHost() == null) {
                s.close();
                return;
            }
            this.region.getCoprocessorHost().preScannerClose(s);
            try {
                s.close();
            }
            finally {
                this.region.getCoprocessorHost().postScannerClose(s);
            }
        }

        boolean preScannerNext(InternalScanner s, List<Result> results, int limit) throws IOException {
            if (this.region.getCoprocessorHost() == null) {
                return false;
            }
            Boolean bypass = this.region.getCoprocessorHost().preScannerNext(s, results, limit);
            return bypass == null ? false : bypass;
        }

        boolean postScannerNext(InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            if (this.region.getCoprocessorHost() == null) {
                return false;
            }
            return this.region.getCoprocessorHost().postScannerNext(s, results, limit, hasMore);
        }
    }

    private static class RegionOp
    implements Closeable {
        private final Region region;

        RegionOp(Region region) throws IOException {
            this.region = region;
            region.startRegionOperation();
        }

        @Override
        public void close() throws IOException {
            this.region.closeRegionOperation();
        }
    }
}

