/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.StatisticTrackable;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.Counter;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.Histogram;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.JmxReporter;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.MetricRegistry;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.RatioGauge;
import org.apache.hadoop.hbase.shaded.com.codahale.metrics.Timer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsConnection
implements StatisticTrackable {
    public static final String CLIENT_SIDE_METRICS_ENABLED_KEY = "hbase.client.metrics.enable";
    private static final String CNT_BASE = "rpcCount_";
    private static final String FAILURE_CNT_BASE = "rpcFailureCount_";
    private static final String TOTAL_EXCEPTION_CNT = "rpcTotalExceptions";
    private static final String LOCAL_EXCEPTION_CNT_BASE = "rpcLocalExceptions_";
    private static final String REMOTE_EXCEPTION_CNT_BASE = "rpcRemoteExceptions_";
    private static final String DRTN_BASE = "rpcCallDurationMs_";
    private static final String REQ_BASE = "rpcCallRequestSizeBytes_";
    private static final String RESP_BASE = "rpcCallResponseSizeBytes_";
    private static final String MEMLOAD_BASE = "memstoreLoad_";
    private static final String HEAP_BASE = "heapOccupancy_";
    private static final String CACHE_BASE = "cacheDroppingExceptions_";
    private static final String UNKNOWN_EXCEPTION = "UnknownException";
    private static final String CLIENT_SVC = ClientProtos.ClientService.getDescriptor().getName();
    protected ConcurrentHashMap<ServerName, ConcurrentMap<byte[], RegionStats>> serverStats = new ConcurrentHashMap();
    private static final int CAPACITY = 50;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CONCURRENCY_LEVEL = 256;
    private final MetricRegistry registry;
    private final JmxReporter reporter;
    private final String scope;
    private final NewMetric<Timer> timerFactory = new NewMetric<Timer>(){

        @Override
        public Timer newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.timer(MetricRegistry.name(clazz, name, scope));
        }
    };
    private final NewMetric<Histogram> histogramFactory = new NewMetric<Histogram>(){

        @Override
        public Histogram newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.histogram(MetricRegistry.name(clazz, name, scope));
        }
    };
    private final NewMetric<Counter> counterFactory = new NewMetric<Counter>(){

        @Override
        public Counter newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.counter(MetricRegistry.name(clazz, name, scope));
        }
    };
    protected final Counter metaCacheHits;
    protected final Counter metaCacheMisses;
    protected final CallTracker getTracker;
    protected final CallTracker scanTracker;
    protected final CallTracker appendTracker;
    protected final CallTracker deleteTracker;
    protected final CallTracker incrementTracker;
    protected final CallTracker putTracker;
    protected final CallTracker multiTracker;
    protected final RunnerStats runnerStats;
    protected final Counter metaCacheNumClearServer;
    protected final Counter metaCacheNumClearRegion;
    protected final Counter hedgedReadOps;
    protected final Counter hedgedReadWin;
    protected final Histogram concurrentCallsPerServerHist;
    protected final Histogram numActionsPerServerHist;
    protected final Counter userRegionLockTimeoutCount;
    protected final Timer userRegionLockWaitingTimer;
    protected final Timer userRegionLockHeldTimer;
    protected final Histogram userRegionLockQueueHist;
    protected final ConcurrentMap<String, Timer> rpcTimers = new ConcurrentHashMap<String, Timer>(50, 0.75f, 256);
    protected final ConcurrentMap<String, Histogram> rpcHistograms = new ConcurrentHashMap<String, Histogram>(100, 0.75f, 256);
    private final ConcurrentMap<String, Counter> cacheDroppingExceptions = new ConcurrentHashMap<String, Counter>(50, 0.75f, 256);
    protected final ConcurrentMap<String, Counter> rpcCounters = new ConcurrentHashMap<String, Counter>(50, 0.75f, 256);

    public void updateServerStats(ServerName serverName, byte[] regionName, Object r) {
        if (!(r instanceof Result)) {
            return;
        }
        Result result = (Result)r;
        RegionLoadStats stats = result.getStats();
        if (stats == null) {
            return;
        }
        this.updateRegionStats(serverName, regionName, stats);
    }

    @Override
    public void updateRegionStats(ServerName serverName, byte[] regionName, RegionLoadStats stats) {
        String name = serverName.getServerName() + "," + Bytes.toStringBinary(regionName);
        ConcurrentMap rsStats = ConcurrentMapUtils.computeIfAbsent(this.serverStats, serverName, () -> new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
        RegionStats regionStats = ConcurrentMapUtils.computeIfAbsent(rsStats, regionName, () -> new RegionStats(this.registry, name));
        regionStats.update(stats);
    }

    MetricsConnection(String scope, final Supplier<ThreadPoolExecutor> batchPool, final Supplier<ThreadPoolExecutor> metaPool) {
        this.scope = scope;
        this.registry = new MetricRegistry();
        this.registry.register(this.getExecutorPoolName(), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                ThreadPoolExecutor pool = (ThreadPoolExecutor)batchPool.get();
                if (pool == null) {
                    return RatioGauge.Ratio.of(0.0, 0.0);
                }
                return RatioGauge.Ratio.of(pool.getActiveCount(), pool.getMaximumPoolSize());
            }
        });
        this.registry.register(this.getMetaPoolName(), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                ThreadPoolExecutor pool = (ThreadPoolExecutor)metaPool.get();
                if (pool == null) {
                    return RatioGauge.Ratio.of(0.0, 0.0);
                }
                return RatioGauge.Ratio.of(pool.getActiveCount(), pool.getMaximumPoolSize());
            }
        });
        this.metaCacheHits = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheHits", scope));
        this.metaCacheMisses = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheMisses", scope));
        this.metaCacheNumClearServer = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheNumClearServer", scope));
        this.metaCacheNumClearRegion = this.registry.counter(MetricRegistry.name(this.getClass(), "metaCacheNumClearRegion", scope));
        this.hedgedReadOps = this.registry.counter(MetricRegistry.name(this.getClass(), "hedgedReadOps", scope));
        this.hedgedReadWin = this.registry.counter(MetricRegistry.name(this.getClass(), "hedgedReadWin", scope));
        this.getTracker = new CallTracker(this.registry, "Get", scope);
        this.scanTracker = new CallTracker(this.registry, "Scan", scope);
        this.appendTracker = new CallTracker(this.registry, "Mutate", "Append", scope);
        this.deleteTracker = new CallTracker(this.registry, "Mutate", "Delete", scope);
        this.incrementTracker = new CallTracker(this.registry, "Mutate", "Increment", scope);
        this.putTracker = new CallTracker(this.registry, "Mutate", "Put", scope);
        this.multiTracker = new CallTracker(this.registry, "Multi", scope);
        this.runnerStats = new RunnerStats(this.registry);
        this.concurrentCallsPerServerHist = this.registry.histogram(MetricRegistry.name(MetricsConnection.class, "concurrentCallsPerServer", scope));
        this.numActionsPerServerHist = this.registry.histogram(MetricRegistry.name(MetricsConnection.class, "numActionsPerServer", scope));
        this.userRegionLockTimeoutCount = this.registry.counter(MetricRegistry.name(this.getClass(), "userRegionLockTimeoutCount", scope));
        this.userRegionLockWaitingTimer = this.registry.timer(MetricRegistry.name(this.getClass(), "userRegionLockWaitingDuration", scope));
        this.userRegionLockHeldTimer = this.registry.timer(MetricRegistry.name(this.getClass(), "userRegionLockHeldDuration", scope));
        this.userRegionLockQueueHist = this.registry.histogram(MetricRegistry.name(MetricsConnection.class, "userRegionLockQueueLength", scope));
        this.reporter = JmxReporter.forRegistry(this.registry).build();
        this.reporter.start();
    }

    final String getExecutorPoolName() {
        return MetricRegistry.name(this.getClass(), "executorPoolActiveThreads", this.scope);
    }

    final String getMetaPoolName() {
        return MetricRegistry.name(this.getClass(), "metaPoolActiveThreads", this.scope);
    }

    MetricRegistry getMetricRegistry() {
        return this.registry;
    }

    public void shutdown() {
        this.reporter.stop();
    }

    public static CallStats newCallStats() {
        return new CallStats();
    }

    public void incrMetaCacheHit() {
        this.metaCacheHits.inc();
    }

    public void incrMetaCacheMiss() {
        this.metaCacheMisses.inc();
    }

    public long getMetaCacheMisses() {
        return this.metaCacheMisses.getCount();
    }

    public void incrMetaCacheNumClearServer() {
        this.metaCacheNumClearServer.inc();
    }

    public void incrMetaCacheNumClearRegion() {
        this.metaCacheNumClearRegion.inc();
    }

    public void incrMetaCacheNumClearRegion(int count) {
        this.metaCacheNumClearRegion.inc(count);
    }

    public void incrHedgedReadOps() {
        this.hedgedReadOps.inc();
    }

    public void incrHedgedReadWin() {
        this.hedgedReadWin.inc();
    }

    public void incrNormalRunners() {
        this.runnerStats.incrNormalRunners();
    }

    public void incrDelayRunnersAndUpdateDelayInterval(long interval) {
        this.runnerStats.incrDelayRunners();
        this.runnerStats.updateDelayInterval(interval);
    }

    public void incrUserRegionLockTimeout() {
        this.userRegionLockTimeoutCount.inc();
    }

    public void updateUserRegionLockWaiting(long duration) {
        this.userRegionLockWaitingTimer.update(duration, TimeUnit.MILLISECONDS);
    }

    public void updateUserRegionLockHeld(long duration) {
        this.userRegionLockHeldTimer.update(duration, TimeUnit.MILLISECONDS);
    }

    public void updateUserRegionLockQueue(int count) {
        this.userRegionLockQueueHist.update(count);
    }

    private <T> T getMetric(String key, ConcurrentMap<String, T> map, NewMetric<T> factory) {
        return (T)ConcurrentMapUtils.computeIfAbsent(map, key, () -> factory.newMetric(this.getClass(), key, this.scope));
    }

    private void updateRpcGeneric(String methodName, CallStats stats) {
        this.getMetric(DRTN_BASE + methodName, this.rpcTimers, this.timerFactory).update(stats.getCallTimeMs(), TimeUnit.MILLISECONDS);
        this.getMetric(REQ_BASE + methodName, this.rpcHistograms, this.histogramFactory).update(stats.getRequestSizeBytes());
        this.getMetric(RESP_BASE + methodName, this.rpcHistograms, this.histogramFactory).update(stats.getResponseSizeBytes());
    }

    public void updateRpc(Descriptors.MethodDescriptor method, Message param, CallStats stats, Throwable e) {
        int callsPerServer = stats.getConcurrentCallsPerServer();
        if (callsPerServer > 0) {
            this.concurrentCallsPerServerHist.update(callsPerServer);
        }
        String methodName = method.getService().getName() + "_" + method.getName();
        this.getMetric(CNT_BASE + methodName, this.rpcCounters, this.counterFactory).inc();
        if (e != null) {
            this.getMetric(FAILURE_CNT_BASE + methodName, this.rpcCounters, this.counterFactory).inc();
            this.getMetric(TOTAL_EXCEPTION_CNT, this.rpcCounters, this.counterFactory).inc();
            if (e instanceof RemoteException) {
                String fullClassName = ((RemoteException)e).getClassName();
                String simpleClassName = fullClassName != null ? fullClassName.substring(fullClassName.lastIndexOf(".") + 1) : "unknown";
                this.getMetric(REMOTE_EXCEPTION_CNT_BASE + simpleClassName, this.rpcCounters, this.counterFactory).inc();
            } else {
                this.getMetric(LOCAL_EXCEPTION_CNT_BASE + e.getClass().getSimpleName(), this.rpcCounters, this.counterFactory).inc();
            }
        }
        if (method.getService() == ClientProtos.ClientService.getDescriptor()) {
            switch (method.getIndex()) {
                case 0: {
                    assert ("Get".equals(method.getName()));
                    this.getTracker.updateRpc(stats);
                    return;
                }
                case 1: {
                    assert ("Mutate".equals(method.getName()));
                    ClientProtos.MutationProto.MutationType mutationType = ((ClientProtos.MutateRequest)param).getMutation().getMutateType();
                    switch (mutationType) {
                        case APPEND: {
                            this.appendTracker.updateRpc(stats);
                            return;
                        }
                        case DELETE: {
                            this.deleteTracker.updateRpc(stats);
                            return;
                        }
                        case INCREMENT: {
                            this.incrementTracker.updateRpc(stats);
                            return;
                        }
                        case PUT: {
                            this.putTracker.updateRpc(stats);
                            return;
                        }
                    }
                    throw new RuntimeException("Unrecognized mutation type " + mutationType);
                }
                case 2: {
                    assert ("Scan".equals(method.getName()));
                    this.scanTracker.updateRpc(stats);
                    return;
                }
                case 3: {
                    assert ("BulkLoadHFile".equals(method.getName()));
                    break;
                }
                case 4: {
                    assert ("PrepareBulkLoad".equals(method.getName()));
                    break;
                }
                case 5: {
                    assert ("CleanupBulkLoad".equals(method.getName()));
                    break;
                }
                case 6: {
                    assert ("ExecService".equals(method.getName()));
                    break;
                }
                case 7: {
                    assert ("ExecRegionServerService".equals(method.getName()));
                    break;
                }
                case 8: {
                    assert ("Multi".equals(method.getName()));
                    this.numActionsPerServerHist.update(stats.getNumActionsPerServer());
                    this.multiTracker.updateRpc(stats);
                    return;
                }
                default: {
                    throw new RuntimeException("Unrecognized ClientService RPC type " + method.getFullName());
                }
            }
        }
        this.updateRpcGeneric(methodName, stats);
    }

    public void incrCacheDroppingExceptions(Object exception) {
        this.getMetric(CACHE_BASE + (exception == null ? UNKNOWN_EXCEPTION : exception.getClass().getSimpleName()), this.cacheDroppingExceptions, this.counterFactory).inc();
    }

    private static interface NewMetric<T> {
        public T newMetric(Class<?> var1, String var2, String var3);
    }

    protected static class RunnerStats {
        final Counter normalRunners;
        final Counter delayRunners;
        final Histogram delayIntevalHist;

        public RunnerStats(MetricRegistry registry) {
            this.normalRunners = registry.counter(MetricRegistry.name(MetricsConnection.class, "normalRunnersCount"));
            this.delayRunners = registry.counter(MetricRegistry.name(MetricsConnection.class, "delayRunnersCount"));
            this.delayIntevalHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, "delayIntervalHist"));
        }

        public void incrNormalRunners() {
            this.normalRunners.inc();
        }

        public void incrDelayRunners() {
            this.delayRunners.inc();
        }

        public void updateDelayInterval(long interval) {
            this.delayIntevalHist.update(interval);
        }
    }

    protected static class RegionStats {
        final String name;
        final Histogram memstoreLoadHist;
        final Histogram heapOccupancyHist;

        public RegionStats(MetricRegistry registry, String name) {
            this.name = name;
            this.memstoreLoadHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.MEMLOAD_BASE + this.name));
            this.heapOccupancyHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.HEAP_BASE + this.name));
        }

        public void update(RegionLoadStats regionStatistics) {
            this.memstoreLoadHist.update(regionStatistics.getMemStoreLoad());
            this.heapOccupancyHist.update(regionStatistics.getHeapOccupancy());
        }
    }

    protected static final class CallTracker {
        private final String name;
        final Timer callTimer;
        final Histogram reqHist;
        final Histogram respHist;

        private CallTracker(MetricRegistry registry, String name, String subName, String scope) {
            StringBuilder sb = new StringBuilder(CLIENT_SVC).append("_").append(name);
            if (subName != null) {
                sb.append("(").append(subName).append(")");
            }
            this.name = sb.toString();
            this.callTimer = registry.timer(MetricRegistry.name(MetricsConnection.class, MetricsConnection.DRTN_BASE + this.name, scope));
            this.reqHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.REQ_BASE + this.name, scope));
            this.respHist = registry.histogram(MetricRegistry.name(MetricsConnection.class, MetricsConnection.RESP_BASE + this.name, scope));
        }

        private CallTracker(MetricRegistry registry, String name, String scope) {
            this(registry, name, null, scope);
        }

        public void updateRpc(CallStats stats) {
            this.callTimer.update(stats.getCallTimeMs(), TimeUnit.MILLISECONDS);
            this.reqHist.update(stats.getRequestSizeBytes());
            this.respHist.update(stats.getResponseSizeBytes());
        }

        public String toString() {
            return "CallTracker:" + this.name;
        }
    }

    public static class CallStats {
        private long requestSizeBytes = 0L;
        private long responseSizeBytes = 0L;
        private long startTime = 0L;
        private long callTimeMs = 0L;
        private int concurrentCallsPerServer = 0;
        private int numActionsPerServer = 0;

        public long getRequestSizeBytes() {
            return this.requestSizeBytes;
        }

        public void setRequestSizeBytes(long requestSizeBytes) {
            this.requestSizeBytes = requestSizeBytes;
        }

        public long getResponseSizeBytes() {
            return this.responseSizeBytes;
        }

        public void setResponseSizeBytes(long responseSizeBytes) {
            this.responseSizeBytes = responseSizeBytes;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getCallTimeMs() {
            return this.callTimeMs;
        }

        public void setCallTimeMs(long callTimeMs) {
            this.callTimeMs = callTimeMs;
        }

        public int getConcurrentCallsPerServer() {
            return this.concurrentCallsPerServer;
        }

        public void setConcurrentCallsPerServer(int callsPerServer) {
            this.concurrentCallsPerServer = callsPerServer;
        }

        public int getNumActionsPerServer() {
            return this.numActionsPerServer;
        }

        public void setNumActionsPerServer(int numActionsPerServer) {
            this.numActionsPerServer = numActionsPerServer;
        }
    }
}

