/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.ResourceNotFoundException;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
@InterfaceStability.Unstable
public class Resources {
    private static final Log LOG = LogFactory.getLog(Resources.class);
    private static final Resource UNBOUNDED = new FixedValueResource("UNBOUNDED", Long.MAX_VALUE);
    private static final Resource NONE = new FixedValueResource("NONE", 0L);

    public static Resource createResource(int memory) {
        return Resources.createResource(memory, memory > 0 ? 1 : 0);
    }

    public static Resource createResource(int memory, int cores) {
        return Resource.newInstance((int)memory, (int)cores);
    }

    public static Resource createResource(long memory) {
        return Resources.createResource(memory, memory > 0L ? 1 : 0);
    }

    public static Resource createResource(long memory, int cores) {
        return Resource.newInstance((long)memory, (int)cores);
    }

    public static Resource none() {
        return NONE;
    }

    public static boolean isNone(Resource other) {
        return NONE.equals((Object)other);
    }

    public static Resource unbounded() {
        return UNBOUNDED;
    }

    public static Resource clone(Resource res) {
        return Resource.newInstance((Resource)res);
    }

    public static Resource addTo(Resource lhs, Resource rhs) {
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                ResourceInformation rhsValue = rhs.getResourceInformation(i);
                ResourceInformation lhsValue = lhs.getResourceInformation(i);
                long convertedRhs = rhsValue.getUnits().equals(lhsValue.getUnits()) ? rhsValue.getValue() : UnitsConversionUtil.convert((String)rhsValue.getUnits(), (String)lhsValue.getUnits(), (long)rhsValue.getValue());
                lhs.setResourceValue(i, lhsValue.getValue() + convertedRhs);
                continue;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return lhs;
    }

    public static Resource add(Resource lhs, Resource rhs) {
        return Resources.addTo(Resources.clone(lhs), rhs);
    }

    public static Resource subtractFrom(Resource lhs, Resource rhs) {
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                ResourceInformation rhsValue = rhs.getResourceInformation(i);
                ResourceInformation lhsValue = lhs.getResourceInformation(i);
                long convertedRhs = rhsValue.getUnits().equals(lhsValue.getUnits()) ? rhsValue.getValue() : UnitsConversionUtil.convert((String)rhsValue.getUnits(), (String)lhsValue.getUnits(), (long)rhsValue.getValue());
                lhs.setResourceValue(i, lhsValue.getValue() - convertedRhs);
                continue;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return lhs;
    }

    public static Resource subtract(Resource lhs, Resource rhs) {
        return Resources.subtractFrom(Resources.clone(lhs), rhs);
    }

    public static Resource subtractFromNonNegative(Resource lhs, Resource rhs) {
        Resources.subtractFrom(lhs, rhs);
        if (lhs.getMemorySize() < 0L) {
            lhs.setMemorySize(0L);
        }
        if (lhs.getVirtualCores() < 0) {
            lhs.setVirtualCores(0);
        }
        return lhs;
    }

    public static Resource negate(Resource resource) {
        return Resources.subtract(NONE, resource);
    }

    public static Resource multiplyTo(Resource lhs, double by) {
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                ResourceInformation lhsValue = lhs.getResourceInformation(i);
                lhs.setResourceValue(i, (long)((double)lhsValue.getValue() * by));
                continue;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return lhs;
    }

    public static Resource multiply(Resource lhs, double by) {
        return Resources.multiplyTo(Resources.clone(lhs), by);
    }

    public static Resource multiplyAndAddTo(Resource lhs, Resource rhs, double by) {
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                ResourceInformation rhsValue = rhs.getResourceInformation(i);
                ResourceInformation lhsValue = lhs.getResourceInformation(i);
                long convertedRhs = (long)((double)(rhsValue.getUnits().equals(lhsValue.getUnits()) ? rhsValue.getValue() : UnitsConversionUtil.convert((String)rhsValue.getUnits(), (String)lhsValue.getUnits(), (long)rhsValue.getValue())) * by);
                lhs.setResourceValue(i, lhsValue.getValue() + convertedRhs);
                continue;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return lhs;
    }

    public static Resource multiplyAndNormalizeUp(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeUp(lhs, by, factor);
    }

    public static Resource multiplyAndNormalizeDown(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeDown(lhs, by, factor);
    }

    public static Resource multiplyAndRoundDown(Resource lhs, double by) {
        Resource out = Resources.clone(lhs);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                ResourceInformation lhsValue = lhs.getResourceInformation(i);
                out.setResourceValue(i, (long)((double)lhsValue.getValue() * by));
                continue;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return out;
    }

    public static Resource multiplyAndRoundUp(Resource lhs, double by) {
        Resource out = Resources.clone(lhs);
        out.setMemorySize((long)Math.ceil((double)lhs.getMemorySize() * by));
        out.setVirtualCores((int)Math.ceil((double)lhs.getVirtualCores() * by));
        return out;
    }

    public static Resource normalize(ResourceCalculator calculator, Resource lhs, Resource min, Resource max, Resource increment) {
        return calculator.normalize(lhs, min, max, increment);
    }

    public static Resource roundUp(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundUp(lhs, factor);
    }

    public static Resource roundDown(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundDown(lhs, factor);
    }

    public static boolean isInvalidDivisor(ResourceCalculator resourceCalculator, Resource divisor) {
        return resourceCalculator.isInvalidDivisor(divisor);
    }

    public static float ratio(ResourceCalculator resourceCalculator, Resource lhs, Resource rhs) {
        return resourceCalculator.ratio(lhs, rhs);
    }

    public static float divide(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.divide(clusterResource, lhs, rhs);
    }

    public static Resource divideAndCeil(ResourceCalculator resourceCalculator, Resource lhs, int rhs) {
        return resourceCalculator.divideAndCeil(lhs, rhs);
    }

    public static Resource divideAndCeil(ResourceCalculator resourceCalculator, Resource lhs, float rhs) {
        return resourceCalculator.divideAndCeil(lhs, rhs);
    }

    public static boolean equals(Resource lhs, Resource rhs) {
        return lhs.equals((Object)rhs);
    }

    public static boolean lessThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) < 0;
    }

    public static boolean lessThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0;
    }

    public static boolean greaterThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) > 0;
    }

    public static boolean greaterThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0;
    }

    public static Resource min(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0 ? lhs : rhs;
    }

    public static Resource max(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0 ? lhs : rhs;
    }

    public static boolean fitsIn(Resource smaller, Resource bigger) {
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                long convertedRhs;
                ResourceInformation rhsValue = bigger.getResourceInformation(i);
                ResourceInformation lhsValue = smaller.getResourceInformation(i);
                long l = convertedRhs = rhsValue.getUnits().equals(lhsValue.getUnits()) ? rhsValue.getValue() : UnitsConversionUtil.convert((String)rhsValue.getUnits(), (String)lhsValue.getUnits(), (long)rhsValue.getValue());
                if (lhsValue.getValue() <= convertedRhs) continue;
                return false;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return true;
    }

    public static boolean fitsIn(ResourceCalculator rc, Resource cluster, Resource smaller, Resource bigger) {
        return rc.fitsIn(cluster, smaller, bigger);
    }

    public static Resource componentwiseMin(Resource lhs, Resource rhs) {
        Resource ret = Resources.createResource(0);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                ResourceInformation rhsValue = rhs.getResourceInformation(i);
                ResourceInformation lhsValue = lhs.getResourceInformation(i);
                long convertedRhs = rhsValue.getUnits().equals(lhsValue.getUnits()) ? rhsValue.getValue() : UnitsConversionUtil.convert((String)rhsValue.getUnits(), (String)lhsValue.getUnits(), (long)rhsValue.getValue());
                ResourceInformation outInfo = lhsValue.getValue() < convertedRhs ? lhsValue : rhsValue;
                ret.setResourceInformation(i, outInfo);
                continue;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return ret;
    }

    public static Resource componentwiseMax(Resource lhs, Resource rhs) {
        Resource ret = Resources.createResource(0);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            try {
                ResourceInformation rhsValue = rhs.getResourceInformation(i);
                ResourceInformation lhsValue = lhs.getResourceInformation(i);
                long convertedRhs = rhsValue.getUnits().equals(lhsValue.getUnits()) ? rhsValue.getValue() : UnitsConversionUtil.convert((String)rhsValue.getUnits(), (String)lhsValue.getUnits(), (long)rhsValue.getValue());
                ResourceInformation outInfo = lhsValue.getValue() > convertedRhs ? lhsValue : rhsValue;
                ret.setResourceInformation(i, outInfo);
                continue;
            }
            catch (ResourceNotFoundException ye) {
                LOG.warn((Object)("Resource is missing:" + ye.getMessage()));
            }
        }
        return ret;
    }

    public static boolean isAnyMajorResourceZero(ResourceCalculator rc, Resource resource) {
        return rc.isAnyMajorResourceZero(resource);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static class FixedValueResource
    extends Resource {
        private final long resourceValue;
        private String name;

        FixedValueResource(String rName, long value) {
            this.resourceValue = value;
            this.name = rName;
            this.initResourceMap();
        }

        private int resourceValueToInt() {
            if (this.resourceValue > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return Long.valueOf(this.resourceValue).intValue();
        }

        public int getMemory() {
            return this.resourceValueToInt();
        }

        public long getMemorySize() {
            return this.resourceValue;
        }

        public void setMemory(int memory) {
            throw new RuntimeException(this.name + " cannot be modified!");
        }

        public void setMemorySize(long memory) {
            throw new RuntimeException(this.name + " cannot be modified!");
        }

        public int getVirtualCores() {
            return this.resourceValueToInt();
        }

        public void setVirtualCores(int virtualCores) {
            throw new RuntimeException(this.name + " cannot be modified!");
        }

        public void setResourceInformation(int index, ResourceInformation resourceInformation) throws ResourceNotFoundException {
            throw new RuntimeException(this.name + " cannot be modified!");
        }

        public void setResourceValue(int index, long value) throws ResourceNotFoundException {
            throw new RuntimeException(this.name + " cannot be modified!");
        }

        public void setResourceInformation(String resource, ResourceInformation resourceInformation) throws ResourceNotFoundException {
            throw new RuntimeException(this.name + " cannot be modified!");
        }

        public void setResourceValue(String resource, long value) throws ResourceNotFoundException {
            throw new RuntimeException(this.name + " cannot be modified!");
        }

        public ResourceInformation getResourceInformation(int index) throws ResourceNotFoundException {
            ResourceInformation ri = null;
            try {
                ri = super.getResourceInformation(index);
            }
            catch (ResourceNotFoundException e) {
                this.initResourceMap();
                try {
                    return super.getResourceInformation(index);
                }
                catch (ResourceNotFoundException ee) {
                    this.throwExceptionWhenArrayOutOfBound(index);
                }
            }
            return ri;
        }

        public ResourceInformation getResourceInformation(String resource) throws ResourceNotFoundException {
            ResourceInformation ri;
            try {
                ri = super.getResourceInformation(resource);
            }
            catch (ResourceNotFoundException e) {
                this.initResourceMap();
                return super.getResourceInformation(resource);
            }
            return ri;
        }

        public ResourceInformation[] getResources() {
            if (this.resources.length != ResourceUtils.getNumberOfKnownResourceTypes()) {
                this.initResourceMap();
                if (this.resources.length != ResourceUtils.getNumberOfKnownResourceTypes()) {
                    throw new ResourceNotFoundException("Failed to reinitialize FixedValueResource to get number of resource types same as configured");
                }
            }
            return this.resources;
        }

        private void initResourceMap() {
            ResourceInformation[] types = ResourceUtils.getResourceTypesArray();
            if (types != null) {
                this.resources = new ResourceInformation[types.length];
                for (int index = 0; index < types.length; ++index) {
                    this.resources[index] = ResourceInformation.newInstance((ResourceInformation)types[index]);
                    this.resources[index].setValue(this.resourceValue);
                }
            }
        }
    }
}

