/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ExampleRegionObserverWithMetrics
implements RegionCoprocessor {
    private Counter preGetCounter;
    private Counter flushCounter;
    private Counter filesCompactedCounter;
    private Timer costlyOperationTimer;
    private ExampleRegionObserver observer;

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this.observer);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (env instanceof RegionCoprocessorEnvironment) {
            MetricRegistry registry = ((RegionCoprocessorEnvironment)env).getMetricRegistryForRegionServer();
            this.observer = new ExampleRegionObserver();
            if (this.preGetCounter == null) {
                this.preGetCounter = registry.counter("preGetRequests");
            }
            if (this.costlyOperationTimer == null) {
                this.costlyOperationTimer = registry.timer("costlyOperation");
            }
            if (this.flushCounter == null) {
                this.flushCounter = registry.counter("flushesCompleted");
            }
            if (this.filesCompactedCounter == null) {
                this.filesCompactedCounter = registry.counter("filesCompacted");
            }
        }
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
    }

    class ExampleRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        ExampleRegionObserver() {
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            ExampleRegionObserverWithMetrics.this.preGetCounter.increment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            long start = System.nanoTime();
            try {
                this.performCostlyOperation();
            }
            finally {
                ExampleRegionObserverWithMetrics.this.costlyOperationTimer.updateNanos(System.nanoTime() - start);
            }
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, FlushLifeCycleTracker tracker) throws IOException {
            ExampleRegionObserverWithMetrics.this.flushCounter.increment();
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, FlushLifeCycleTracker tracker) throws IOException {
            ExampleRegionObserverWithMetrics.this.flushCounter.increment();
        }

        public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> selected, CompactionLifeCycleTracker tracker, CompactionRequest request) {
            if (selected != null) {
                ExampleRegionObserverWithMetrics.this.filesCompactedCounter.increment((long)selected.size());
            }
        }

        private void performCostlyOperation() {
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(100L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

