/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerNoMaster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerNoMaster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerNoMaster.class);
    private static final int NB_SERVERS = 1;
    private static Table table;
    private static final byte[] row;
    private static HRegionInfo hri;
    private static byte[] regionName;
    private static final HBaseTestingUtility HTU;

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniCluster(1);
        TableName tableName = TableName.valueOf((String)TestRegionServerNoMaster.class.getSimpleName());
        table = HTU.createTable(tableName, HConstants.CATALOG_FAMILY);
        Put p = new Put(row);
        p.addColumn(HConstants.CATALOG_FAMILY, row, row);
        table.put(p);
        try (RegionLocator locator = HTU.getConnection().getRegionLocator(tableName);){
            hri = locator.getRegionLocation(row, false).getRegionInfo();
        }
        regionName = hri.getRegionName();
        TestRegionServerNoMaster.stopMasterAndAssignMeta(HTU);
    }

    public static void stopMasterAndAssignMeta(HBaseTestingUtility HTU) throws IOException, InterruptedException {
        HMaster master = HTU.getHBaseCluster().getMaster();
        JVMClusterUtil.MasterThread masterThread = HTU.getHBaseCluster().getMasterThread();
        ServerName masterAddr = master.getServerName();
        master.stopMaster();
        LOG.info("Waiting until master thread exits");
        while (masterThread != null && masterThread.isAlive()) {
            Threads.sleep((long)100L);
        }
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = true;
        HRegionServer hrs = HTU.getHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
        ZKWatcher zkw = hrs.getZooKeeper();
        ServerName sn = MetaTableLocator.getMetaRegionLocation((ZKWatcher)zkw);
        if (sn != null && !masterAddr.equals((Object)sn)) {
            return;
        }
        ProtobufUtil.openRegion(null, (AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices(), (ServerName)hrs.getServerName(), (RegionInfo)HRegionInfo.FIRST_META_REGIONINFO);
        while ((sn = MetaTableLocator.getMetaRegionLocation((ZKWatcher)zkw)) == null || !sn.equals((Object)hrs.getServerName()) || !hrs.getOnlineRegions().containsKey(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName())) {
            Thread.sleep(100L);
        }
    }

    public static void flushRegion(HBaseTestingUtility HTU, RegionInfo regionInfo) throws IOException {
        for (JVMClusterUtil.RegionServerThread rst : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegion region = rst.getRegionServer().getRegionByEncodedName(regionInfo.getEncodedName());
            if (region == null) continue;
            region.flush(true);
            return;
        }
        throw new IOException("Region to flush cannot be found");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = false;
        if (table != null) {
            table.close();
        }
        HTU.shutdownMiniCluster();
    }

    private static HRegionServer getRS() {
        return HTU.getHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
    }

    public static void openRegion(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)rs.getServerName(), (RegionInfo)hri, null);
        AdminProtos.OpenRegionResponse responseOpen = rs.rpcServices.openRegion(null, orr);
        Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseOpen.getOpeningState(0).equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED));
        TestRegionServerNoMaster.checkRegionIsOpened(HTU, rs, hri);
    }

    public static void checkRegionIsOpened(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        while (!rs.getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((boolean)rs.getRegion(hri.getRegionName()).isAvailable());
    }

    public static void closeRegion(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        AdminProtos.CloseRegionRequest crr = ProtobufUtil.buildCloseRegionRequest((ServerName)rs.getServerName(), (byte[])hri.getRegionName());
        AdminProtos.CloseRegionResponse responseClose = rs.rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, rs, hri);
    }

    public static void checkRegionIsClosed(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        while (!rs.getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        try {
            Assert.assertFalse((boolean)rs.getRegion(hri.getRegionName()).isAvailable());
        }
        catch (NotServingRegionException notServingRegionException) {
            // empty catch block
        }
    }

    private void closeRegionNoZK() throws Exception {
        AdminProtos.CloseRegionRequest crr = ProtobufUtil.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test
    public void testCloseByRegionServer() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test
    public void testMultipleCloseFromMaster() throws Exception {
        for (int i = 0; i < 10; ++i) {
            AdminProtos.CloseRegionRequest crr = ProtobufUtil.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName, null);
            try {
                AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
                Assert.assertTrue((String)("request " + i + " failed"), (responseClose.getClosed() || responseClose.hasClosed() ? 1 : 0) != 0);
                continue;
            }
            catch (ServiceException se) {
                Assert.assertTrue((String)"The next queries may throw an exception.", (i > 0 ? 1 : 0) != 0);
            }
        }
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test
    public void testCancelOpeningWithoutZK() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        AdminProtos.CloseRegionRequest crr = ProtobufUtil.buildCloseRegionRequest((ServerName)TestRegionServerNoMaster.getRS().getServerName(), (byte[])regionName);
        try {
            TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
            Assert.assertTrue((boolean)false);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.FALSE, TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        TableDescriptor htd = TestRegionServerNoMaster.getRS().tableDescriptors.get(hri.getTable());
        TestRegionServerNoMaster.getRS().executorService.submit((EventHandler)new OpenRegionHandler((Server)TestRegionServerNoMaster.getRS(), (RegionServerServices)TestRegionServerNoMaster.getRS(), (RegionInfo)hri, htd, -1L));
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenCloseRegionRPCIntendedForPreviousServer() throws Exception {
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        ServerName sn = TestRegionServerNoMaster.getRS().getServerName();
        ServerName earlierServerName = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)1L);
        try {
            AdminProtos.CloseRegionRequest request = ProtobufUtil.buildCloseRegionRequest((ServerName)earlierServerName, (byte[])regionName);
            TestRegionServerNoMaster.getRS().getRSRpcServices().closeRegion(null, request);
            Assert.fail((String)"The closeRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        this.closeRegionNoZK();
        try {
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)earlierServerName, (RegionInfo)hri, null);
            TestRegionServerNoMaster.getRS().getRSRpcServices().openRegion(null, orr);
            Assert.fail((String)"The openRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        finally {
            TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
        }
    }

    static {
        row = Bytes.toBytes((String)"ee");
        HTU = new HBaseTestingUtility();
    }
}

