/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MultiActionResultTooLarge;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.LockTimeoutException;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMetaCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaCache.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test_table");
    private static final byte[] FAMILY = Bytes.toBytes((String)"fam1");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private static HRegionServer badRS;
    private static final Logger LOG;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.regionserver.impl", new String[]{RegionServerWithFakeRpcServices.class.getName()});
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        badRS = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        Assert.assertTrue((boolean)(badRS.getRSRpcServices() instanceof FakeRSRpcServices));
        HTableDescriptor table = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        fam.setMaxVersions(2);
        table.addFamily(fam);
        TEST_UTIL.createTable((TableDescriptor)table, (byte[][])null);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMergeEmptyWithMetaCache() throws Throwable {
        TableName tableName = TableName.valueOf((String)"MergeEmpty");
        byte[] family = Bytes.toBytes((String)"CF");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
        TEST_UTIL.getAdmin().createTable(td, (byte[][])new byte[][]{Bytes.toBytes((int)2), Bytes.toBytes((int)5)});
        TEST_UTIL.waitTableAvailable(tableName);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        RegionInfo regionA = null;
        RegionInfo regionB = null;
        RegionInfo regionC = null;
        for (RegionInfo region : TEST_UTIL.getAdmin().getRegions(tableName)) {
            if (region.getStartKey().length == 0) {
                regionA = region;
                continue;
            }
            if (Bytes.equals((byte[])region.getStartKey(), (byte[])Bytes.toBytes((int)2))) {
                regionB = region;
                continue;
            }
            if (!Bytes.equals((byte[])region.getStartKey(), (byte[])Bytes.toBytes((int)5))) continue;
            regionC = region;
        }
        Assert.assertNotNull(regionA);
        Assert.assertNotNull(regionB);
        Assert.assertNotNull(regionC);
        TEST_UTIL.getConfiguration().setBoolean("hbase.client.metrics.enable", true);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             AsyncConnection asyncConn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();){
            ConnectionImplementation connImpl = (ConnectionImplementation)conn;
            AsyncConnectionImpl asyncConnImpl = (AsyncConnectionImpl)asyncConn;
            MetricsConnection metrics = connImpl.getConnectionMetrics();
            MetricsConnection asyncMetrics = (MetricsConnection)asyncConnImpl.getConnectionMetrics().get();
            conn.getRegionLocator(tableName).getAllRegionLocations();
            asyncConn.getRegionLocator(tableName).getAllRegionLocations().get();
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getAdmin().getRegions(tableName).size());
            TEST_UTIL.getAdmin().mergeRegionsAsync((byte[][])new byte[][]{regionA.getRegionName(), regionB.getRegionName(), regionC.getRegionName()}, false).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getAdmin().getRegions(tableName).size());
            Table table = conn.getTable(tableName);
            AsyncTable asyncTable = asyncConn.getTable(tableName);
            Assert.assertTrue((this.executeAndGetNewMisses(() -> table.get(new Get(Bytes.toBytes((int)6))), metrics) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((this.executeAndGetNewMisses(() -> {
                Result cfr_ignored_0 = (Result)asyncTable.get(new Get(Bytes.toBytes((int)6))).get();
            }, asyncMetrics) > 0L ? 1 : 0) != 0);
            junit.framework.Assert.assertEquals((long)0L, (long)this.executeAndGetNewMisses(() -> table.get(new Get(Bytes.toBytes((int)6))), metrics));
            junit.framework.Assert.assertEquals((long)0L, (long)this.executeAndGetNewMisses(() -> {
                Result cfr_ignored_0 = (Result)asyncTable.get(new Get(Bytes.toBytes((int)6))).get();
            }, asyncMetrics));
        }
    }

    private long executeAndGetNewMisses(ThrowingRunnable runnable, MetricsConnection metrics) throws Throwable {
        long lastVal = metrics.getMetaCacheMisses();
        runnable.run();
        long curVal = metrics.getMetaCacheMisses();
        return curVal - lastVal;
    }

    @Test
    public void testAddToCacheReverse() throws IOException, InterruptedException, ExecutionException {
        try (AsyncConnectionImpl asyncConn = (AsyncConnectionImpl)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
             ConnectionImplementation conn = (ConnectionImplementation)ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            int i;
            AsyncNonMetaRegionLocator asyncLocator = asyncConn.getLocator().getNonMetaRegionLocator();
            TableName tableName = TableName.valueOf((String)"testAddToCache");
            byte[] family = Bytes.toBytes((String)"CF");
            TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).build();
            int maxSplits = 10;
            List splits = IntStream.range(1, maxSplits).mapToObj(Bytes::toBytes).collect(Collectors.toList());
            TEST_UTIL.getAdmin().createTable(td, (byte[][])splits.toArray((T[])new byte[0][]));
            TEST_UTIL.waitTableAvailable(tableName);
            TEST_UTIL.waitUntilNoRegionsInTransition();
            conn.getRegionLocator(tableName);
            junit.framework.Assert.assertEquals((int)(splits.size() + 1), (int)TEST_UTIL.getAdmin().getRegions(tableName).size());
            RegionLocator locatorForTable = conn.getRegionLocator(tableName);
            AsyncTableRegionLocator asyncLocatorForTable = asyncConn.getRegionLocator(tableName);
            for (i = maxSplits; i >= 0; --i) {
                locatorForTable.getRegionLocation(Bytes.toBytes((int)i));
                asyncLocatorForTable.getRegionLocation(Bytes.toBytes((int)i));
            }
            for (i = 0; i < maxSplits; ++i) {
                Assert.assertNotNull((Object)asyncLocator.getRegionLocationInCache(tableName, Bytes.toBytes((int)i)));
                Assert.assertNotNull((Object)conn.getCachedLocation(tableName, Bytes.toBytes((int)i)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveMetaCacheOnException() throws Exception {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new RoundRobinExceptionInjector());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.client.retries.number", "1");
        try (ConnectionImplementation conn = (ConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);){
            Table table = conn.getTable(TABLE_NAME);
            byte[] row = Bytes.toBytes((String)"row1");
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
            Get get = new Get(row);
            Append append = new Append(row);
            append.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)11));
            Increment increment = new Increment(row);
            increment.addColumn(FAMILY, QUALIFIER, 10L);
            Delete delete = new Delete(row);
            delete.addColumn(FAMILY, QUALIFIER);
            RowMutations mutations = new RowMutations(row);
            mutations.add(put);
            mutations.add(delete);
            for (int i = 0; i < 50; ++i) {
                boolean success;
                IOException exp;
                block7: {
                    exp = null;
                    success = false;
                    try {
                        table.put(put);
                        success = true;
                        table.get(get);
                        table.append(append);
                        table.increment(increment);
                        table.delete(delete);
                        table.mutateRow(mutations);
                    }
                    catch (IOException ex) {
                        if (!ClientExceptionsUtil.isMetaClearingException((Throwable)ex) && !success) break block7;
                        exp = ex;
                    }
                }
                if (exp != null && ClientExceptionsUtil.isMetaClearingException((Throwable)exp)) {
                    Assert.assertNull((Object)conn.getCachedLocation(TABLE_NAME, row));
                    continue;
                }
                if (!success) continue;
                Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, row));
            }
        }
    }

    @Test
    public void testClearsCacheOnScanException() throws Exception {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new RoundRobinExceptionInjector());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.client.retries.number", "1");
        try (ConnectionImplementation conn = (ConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);
             Table table = conn.getTable(TABLE_NAME);){
            byte[] row = Bytes.toBytes((String)"row2");
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
            Scan scan = new Scan();
            scan.withStartRow(row);
            scan.setLimit(1);
            scan.setCaching(1);
            this.populateCache(table, row);
            Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, row));
            Assert.assertTrue((boolean)this.executeUntilCacheClearingException(table, scan));
            Assert.assertNull((Object)conn.getCachedLocation(TABLE_NAME, row));
            this.populateCache(table, row);
            Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, row));
            scan.setReversed(true);
            Assert.assertTrue((boolean)this.executeUntilCacheClearingException(table, scan));
            Assert.assertNull((Object)conn.getCachedLocation(TABLE_NAME, row));
        }
    }

    private void populateCache(Table table, byte[] row) {
        for (int i = 0; i < 50; ++i) {
            try {
                table.get(new Get(row));
                return;
            }
            catch (Exception exception) {
                continue;
            }
        }
    }

    private boolean executeUntilCacheClearingException(Table table, Scan scan) {
        for (int i = 0; i < 50; ++i) {
            try (ResultScanner scanner = table.getScanner(scan);){
                scanner.next();
                continue;
            }
            catch (Exception ex) {
                if (!ClientExceptionsUtil.isMetaClearingException((Throwable)ex)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheClearingOnCallQueueTooBig() throws Exception {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new CallQueueTooBigExceptionInjector());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.client.retries.number", "2");
        conf.set("hbase.client.metrics.enable", "true");
        try (ConnectionImplementation conn = (ConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);){
            Table table = conn.getTable(TABLE_NAME);
            byte[] row = Bytes.toBytes((String)"row1");
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
            table.put(put);
            MetricsConnection metrics = conn.getConnectionMetrics();
            long preGetRegionClears = metrics.metaCacheNumClearRegion.getCount();
            long preGetServerClears = metrics.metaCacheNumClearServer.getCount();
            Get get = new Get(row);
            try {
                table.get(get);
                Assert.fail((String)"Expected CallQueueTooBigException");
            }
            catch (RetriesExhaustedException retriesExhaustedException) {
                // empty catch block
            }
            long postGetRegionClears = metrics.metaCacheNumClearRegion.getCount();
            long postGetServerClears = metrics.metaCacheNumClearServer.getCount();
            junit.framework.Assert.assertEquals((long)preGetRegionClears, (long)postGetRegionClears);
            junit.framework.Assert.assertEquals((long)preGetServerClears, (long)postGetServerClears);
        }
    }

    public static List<Throwable> metaCachePreservingExceptions() {
        return Arrays.asList(new Throwable[]{new RegionOpeningException(" "), new RegionTooBusyException("Some old message"), new RpcThrottlingException(" "), new MultiActionResultTooLarge(" "), new RetryImmediatelyException(" "), new CallQueueTooBigException()});
    }

    @Test
    public void testUserRegionLockThrowsException() throws IOException, InterruptedException {
        ((FakeRSRpcServices)badRS.getRSRpcServices()).setExceptionInjector(new LockSleepInjector());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.retries.number", 0);
        conf.setLong("hbase.client.meta.operation.timeout", 2000L);
        conf.setLong("hbase.client.scanner.timeout.period", 2000L);
        conf.setBoolean("hbase.client.metrics.enable", true);
        try (ConnectionImplementation conn = (ConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);){
            ClientThread client1 = new ClientThread(conn);
            ClientThread client2 = new ClientThread(conn);
            client1.start();
            client2.start();
            client1.join();
            client2.join();
            Assert.assertNotNull((Object)client1.getException());
            Assert.assertNotNull((Object)client2.getException());
            Assert.assertTrue((boolean)(client1.getException() instanceof LockTimeoutException ^ client2.getException() instanceof LockTimeoutException));
            MetricsConnection metrics = conn.getConnectionMetrics();
            long queueCount = metrics.userRegionLockQueueHist.getCount();
            junit.framework.Assert.assertEquals((String)("Queue of userRegionLock should be updated twice. queueCount: " + queueCount), (long)queueCount, (long)2L);
            long timeoutCount = metrics.userRegionLockTimeoutCount.getCount();
            junit.framework.Assert.assertEquals((String)("Timeout of userRegionLock should happen once. timeoutCount: " + timeoutCount), (long)timeoutCount, (long)1L);
            long waitingTimerCount = metrics.userRegionLockWaitingTimer.getCount();
            junit.framework.Assert.assertEquals((String)("userRegionLock should be grabbed successfully once. waitingTimerCount: " + waitingTimerCount), (long)waitingTimerCount, (long)1L);
            long heldTimerCount = metrics.userRegionLockHeldTimer.getCount();
            junit.framework.Assert.assertEquals((String)("userRegionLock should be held successfully once. heldTimerCount: " + heldTimerCount), (long)heldTimerCount, (long)1L);
            double heldTime = metrics.userRegionLockHeldTimer.getSnapshot().getMax();
            Assert.assertTrue((String)("Max held time should be greater than 2 seconds. heldTime: " + heldTime), (heldTime >= 2.0E9 ? 1 : 0) != 0);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TestMetaCache.class);
    }

    public static class LockSleepInjector
    extends ExceptionInjector {
        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted exception", (Throwable)e);
            }
        }

        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) {
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) {
        }
    }

    private final class ClientThread
    extends Thread {
        private Exception exception;
        private ConnectionImplementation connection;

        private ClientThread(ConnectionImplementation connection) {
            this.connection = connection;
        }

        @Override
        public void run() {
            byte[] currentKey = HConstants.EMPTY_START_ROW;
            try {
                this.connection.getRegionLocation(TABLE_NAME, currentKey, true);
            }
            catch (IOException e) {
                LOG.error("Thread id: " + this.getId() + "  exception: ", (Throwable)e);
                this.exception = e;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class CallQueueTooBigExceptionInjector
    extends ExceptionInjector {
        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) throws ServiceException {
            if (this.isTestTable(rpcServices, request.getRegion())) {
                throw new ServiceException((Throwable)new CallQueueTooBigException());
            }
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) throws ServiceException {
        }

        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) throws ServiceException {
        }
    }

    public static class RoundRobinExceptionInjector
    extends ExceptionInjector {
        private int numReqs = -1;
        private int expCount = -1;
        private List<Throwable> metaCachePreservingExceptions = TestMetaCache.metaCachePreservingExceptions();

        @Override
        public void throwOnGet(FakeRSRpcServices rpcServices, ClientProtos.GetRequest request) throws ServiceException {
            this.throwSomeExceptions(rpcServices, request.getRegion());
        }

        @Override
        public void throwOnMutate(FakeRSRpcServices rpcServices, ClientProtos.MutateRequest request) throws ServiceException {
            this.throwSomeExceptions(rpcServices, request.getRegion());
        }

        @Override
        public void throwOnScan(FakeRSRpcServices rpcServices, ClientProtos.ScanRequest request) throws ServiceException {
            if (!request.hasScannerId()) {
                this.throwSomeExceptions(rpcServices, request.getRegion());
            }
        }

        private void throwSomeExceptions(FakeRSRpcServices rpcServices, HBaseProtos.RegionSpecifier regionSpec) throws ServiceException {
            if (!this.isTestTable(rpcServices, regionSpec)) {
                return;
            }
            ++this.numReqs;
            if (this.numReqs % 5 == 0) {
                return;
            }
            if (this.numReqs % 5 == 1 || this.numReqs % 5 == 2) {
                throw new ServiceException((Throwable)new NotServingRegionException());
            }
            ++this.expCount;
            Throwable t = this.metaCachePreservingExceptions.get(this.expCount % this.metaCachePreservingExceptions.size());
            throw new ServiceException(t);
        }
    }

    public static abstract class ExceptionInjector {
        protected boolean isTestTable(FakeRSRpcServices rpcServices, HBaseProtos.RegionSpecifier regionSpec) throws ServiceException {
            try {
                return TABLE_NAME.equals((Object)rpcServices.getRegion(regionSpec).getTableDescriptor().getTableName());
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }

        public abstract void throwOnGet(FakeRSRpcServices var1, ClientProtos.GetRequest var2) throws ServiceException;

        public abstract void throwOnMutate(FakeRSRpcServices var1, ClientProtos.MutateRequest var2) throws ServiceException;

        public abstract void throwOnScan(FakeRSRpcServices var1, ClientProtos.ScanRequest var2) throws ServiceException;
    }

    public static class FakeRSRpcServices
    extends RSRpcServices {
        private ExceptionInjector exceptions = new RoundRobinExceptionInjector();

        public FakeRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public void setExceptionInjector(ExceptionInjector injector) {
            this.exceptions = injector;
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            this.exceptions.throwOnGet(this, request);
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
            this.exceptions.throwOnMutate(this, request);
            return super.mutate(controller, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            this.exceptions.throwOnScan(this, request);
            return super.scan(controller, request);
        }
    }

    public static class RegionServerWithFakeRpcServices
    extends HRegionServer {
        private FakeRSRpcServices rsRpcServices;

        public RegionServerWithFakeRpcServices(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            this.rsRpcServices = new FakeRSRpcServices(this);
            return this.rsRpcServices;
        }

        public void setExceptionInjector(ExceptionInjector injector) {
            this.rsRpcServices.setExceptionInjector(injector);
        }
    }
}

