/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CatalogReplicaMode;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
@RunWith(value=Parameterized.class)
public class TestAsyncNonMetaRegionLocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncNonMetaRegionLocator.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAsyncNonMetaRegionLocator.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final int META_STOREFILE_REFRESH_PERIOD = 100;
    private static final int NB_SERVERS = 4;
    private static int numOfMetaReplica = 3;
    private static AsyncConnectionImpl CONN;
    private static AsyncNonMetaRegionLocator LOCATOR;
    private static ConnectionRegistry registry;
    private static byte[][] SPLIT_KEYS;
    private CatalogReplicaMode metaReplicaMode;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.region.replica.replication.catalog.enabled", true);
        conf.setLong("replication.source.sleepforretries", 10L);
        TEST_UTIL.startMiniCluster(4);
        Admin admin = TEST_UTIL.getAdmin();
        admin.balancerSwitch(false, true);
        HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, numOfMetaReplica);
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getMiniHBaseCluster().getRegions(TableName.META_TABLE_NAME).size() >= numOfMetaReplica);
        registry = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        SPLIT_KEYS = new byte[8][];
        for (int i = 111; i < 999; i += 111) {
            TestAsyncNonMetaRegionLocator.SPLIT_KEYS[i / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i));
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDownAfterTest() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(TABLE_NAME)) {
            if (admin.isTableEnabled(TABLE_NAME)) {
                TEST_UTIL.getAdmin().disableTable(TABLE_NAME);
            }
            TEST_UTIL.getAdmin().deleteTable(TABLE_NAME);
        }
        LOCATOR.clearCache(TABLE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({null}, {CatalogReplicaMode.LOAD_BALANCE.toString()});
    }

    public TestAsyncNonMetaRegionLocator(String clientMetaReplicaMode) throws Exception {
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        if (clientMetaReplicaMode != null) {
            c.set("hbase.locator.meta.replicas.mode", clientMetaReplicaMode);
            this.metaReplicaMode = CatalogReplicaMode.fromString((String)clientMetaReplicaMode);
        }
        CONN = new AsyncConnectionImpl(c, registry, (String)registry.getClusterId().get(), User.getCurrent());
        LOCATOR = new AsyncNonMetaRegionLocator(CONN);
    }

    private void createSingleRegionTable() throws IOException, InterruptedException {
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    private CompletableFuture<HRegionLocation> getDefaultRegionLocation(TableName tableName, byte[] row, RegionLocateType locateType, boolean reload) {
        return LOCATOR.getRegionLocations(tableName, row, 0, locateType, reload).thenApply(RegionLocations::getDefaultRegionLocation);
    }

    @Test
    public void testNoTable() throws InterruptedException {
        for (RegionLocateType locateType : RegionLocateType.values()) {
            try {
                this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, locateType, false).get();
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(TableNotFoundException.class));
            }
        }
    }

    @Test
    public void testDisableTable() throws IOException, InterruptedException {
        this.createSingleRegionTable();
        TEST_UTIL.getAdmin().disableTable(TABLE_NAME);
        for (RegionLocateType locateType : RegionLocateType.values()) {
            try {
                this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, locateType, false).get();
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(TableNotFoundException.class));
            }
        }
    }

    private void assertLocEquals(byte[] startKey, byte[] endKey, ServerName serverName, HRegionLocation loc) {
        RegionInfo info = loc.getRegion();
        Assert.assertEquals((Object)TABLE_NAME, (Object)info.getTable());
        Assert.assertArrayEquals((byte[])startKey, (byte[])info.getStartKey());
        Assert.assertArrayEquals((byte[])endKey, (byte[])info.getEndKey());
        Assert.assertEquals((Object)serverName, (Object)loc.getServerName());
    }

    @Test
    public void testSingleRegionTable() throws IOException, InterruptedException, ExecutionException {
        this.createSingleRegionTable();
        ServerName serverName = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME).getServerName();
        for (RegionLocateType locateType : RegionLocateType.values()) {
            this.assertLocEquals(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, serverName, this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, locateType, false).get());
        }
        byte[] key = new byte[ThreadLocalRandom.current().nextInt(128)];
        Bytes.random((byte[])key);
        for (RegionLocateType locateType : RegionLocateType.values()) {
            this.assertLocEquals(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, serverName, this.getDefaultRegionLocation(TABLE_NAME, key, locateType, false).get());
        }
    }

    private void createMultiRegionTable() throws IOException, InterruptedException {
        TEST_UTIL.createTable(TABLE_NAME, FAMILY, SPLIT_KEYS);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    private static byte[][] getStartKeys() {
        byte[][] startKeys = new byte[SPLIT_KEYS.length + 1][];
        startKeys[0] = HConstants.EMPTY_START_ROW;
        System.arraycopy(SPLIT_KEYS, 0, startKeys, 1, SPLIT_KEYS.length);
        return startKeys;
    }

    private static byte[][] getEndKeys() {
        byte[][] endKeys = (byte[][])Arrays.copyOf(SPLIT_KEYS, SPLIT_KEYS.length + 1);
        endKeys[endKeys.length - 1] = HConstants.EMPTY_START_ROW;
        return endKeys;
    }

    private ServerName[] getLocations(byte[][] startKeys) {
        ServerName[] serverNames = new ServerName[startKeys.length];
        TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).forEach(rs -> rs.getRegions(TABLE_NAME).forEach(r -> {
            serverNames[Arrays.binarySearch(startKeys, r.getRegionInfo().getStartKey(), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, compareTo(byte[] byte[] ), ([B[B)I)())] = rs.getServerName();
        }));
        return serverNames;
    }

    @Test
    public void testMultiRegionTable() throws IOException, InterruptedException {
        this.createMultiRegionTable();
        byte[][] startKeys = TestAsyncNonMetaRegionLocator.getStartKeys();
        ServerName[] serverNames = this.getLocations(startKeys);
        IntStream.range(0, 2).forEach(n -> IntStream.range(0, startKeys.length).forEach(i -> {
            try {
                this.assertLocEquals(startKeys[i], i == startKeys.length - 1 ? HConstants.EMPTY_END_ROW : startKeys[i + 1], serverNames[i], this.getDefaultRegionLocation(TABLE_NAME, startKeys[i], RegionLocateType.CURRENT, false).get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }));
        LOCATOR.clearCache(TABLE_NAME);
        IntStream.range(0, 2).forEach(n -> IntStream.range(0, startKeys.length).forEach(i -> {
            try {
                this.assertLocEquals(startKeys[i], i == startKeys.length - 1 ? HConstants.EMPTY_END_ROW : startKeys[i + 1], serverNames[i], this.getDefaultRegionLocation(TABLE_NAME, startKeys[i], RegionLocateType.AFTER, false).get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }));
        LOCATOR.clearCache(TABLE_NAME);
        byte[][] endKeys = TestAsyncNonMetaRegionLocator.getEndKeys();
        IntStream.range(0, 2).forEach(n -> IntStream.range(0, endKeys.length).map(i -> endKeys.length - 1 - i).forEach(i -> {
            try {
                this.assertLocEquals(i == 0 ? HConstants.EMPTY_START_ROW : endKeys[i - 1], endKeys[i], serverNames[i], this.getDefaultRegionLocation(TABLE_NAME, endKeys[i], RegionLocateType.BEFORE, false).get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Test
    public void testRegionMove() throws IOException, InterruptedException, ExecutionException {
        this.createSingleRegionTable();
        ServerName serverName = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME).getServerName();
        HRegionLocation loc = this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, false).get();
        this.assertLocEquals(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, serverName, loc);
        ServerName newServerName = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(sn -> !sn.equals((Object)serverName)).findAny().get();
        TEST_UTIL.getAdmin().move(Bytes.toBytes((String)loc.getRegion().getEncodedName()), newServerName);
        while (!TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME).getServerName().equals((Object)newServerName)) {
            Thread.sleep(100L);
        }
        Assert.assertSame((Object)loc, (Object)this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, false).get());
        LOCATOR.updateCachedLocationOnError(loc, null);
        Assert.assertSame((Object)loc, (Object)this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, false).get());
        LOCATOR.updateCachedLocationOnError(loc, (Throwable)new NotServingRegionException());
        this.assertLocEquals(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, newServerName, this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, false).get());
    }

    @Test
    public void testLocateAfter() throws IOException, InterruptedException, ExecutionException {
        byte[] row = Bytes.toBytes((String)"1");
        byte[] splitKey = Arrays.copyOf(row, 2);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY, (byte[][])new byte[][]{splitKey});
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        HRegionLocation currentLoc = this.getDefaultRegionLocation(TABLE_NAME, row, RegionLocateType.CURRENT, false).get();
        ServerName currentServerName = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME).getServerName();
        this.assertLocEquals(HConstants.EMPTY_START_ROW, splitKey, currentServerName, currentLoc);
        HRegionLocation afterLoc = this.getDefaultRegionLocation(TABLE_NAME, row, RegionLocateType.AFTER, false).get();
        ServerName afterServerName = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(rs -> rs.getRegions(TABLE_NAME).stream().anyMatch(r -> Bytes.equals((byte[])splitKey, (byte[])r.getRegionInfo().getStartKey()))).findAny().get().getServerName();
        this.assertLocEquals(splitKey, HConstants.EMPTY_END_ROW, afterServerName, afterLoc);
        Assert.assertSame((Object)afterLoc, (Object)this.getDefaultRegionLocation(TABLE_NAME, row, RegionLocateType.AFTER, false).get());
    }

    @Test
    public void testConcurrentLocate() throws IOException, InterruptedException, ExecutionException {
        this.createMultiRegionTable();
        byte[][] startKeys = TestAsyncNonMetaRegionLocator.getStartKeys();
        byte[][] endKeys = TestAsyncNonMetaRegionLocator.getEndKeys();
        ServerName[] serverNames = this.getLocations(startKeys);
        for (int i = 0; i < 100; ++i) {
            LOCATOR.clearCache(TABLE_NAME);
            List futures = IntStream.range(0, 1000).mapToObj(n -> String.format("%03d", n)).map(s -> Bytes.toBytes((String)s)).map(r -> this.getDefaultRegionLocation(TABLE_NAME, (byte[])r, RegionLocateType.CURRENT, false)).collect(Collectors.toList());
            for (int j = 0; j < 1000; ++j) {
                int index = Math.min(8, j / 111);
                this.assertLocEquals(startKeys[index], endKeys[index], serverNames[index], (HRegionLocation)((CompletableFuture)futures.get(j)).get());
            }
        }
    }

    @Test
    public void testReload() throws Exception {
        this.createSingleRegionTable();
        final ServerName serverName = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME).getServerName();
        for (RegionLocateType locateType : RegionLocateType.values()) {
            this.assertLocEquals(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, serverName, this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, locateType, false).get());
        }
        final ServerName newServerName = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(sn -> !sn.equals((Object)serverName)).findAny().get();
        Admin admin = TEST_UTIL.getAdmin();
        final RegionInfo region = (RegionInfo)admin.getRegions(TABLE_NAME).stream().findAny().get();
        admin.move(region.getEncodedNameAsBytes(), newServerName);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                ServerName newServerName = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME).getServerName();
                return newServerName != null && !newServerName.equals((Object)serverName);
            }

            public String explainFailure() throws Exception {
                return region.getRegionNameAsString() + " is still on " + serverName;
            }
        });
        for (RegionLocateType locateType : RegionLocateType.values()) {
            this.assertLocEquals(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, serverName, this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, locateType, false).get());
        }
        TEST_UTIL.waitFor(3000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                HRegionLocation loc = (HRegionLocation)TestAsyncNonMetaRegionLocator.this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, true).get();
                return newServerName.equals((Object)loc.getServerName());
            }

            public String explainFailure() throws Exception {
                return "New location does not show up in meta (replica) region";
            }
        });
        for (RegionLocateType locateType : RegionLocateType.values()) {
            this.assertLocEquals(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, newServerName, this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, locateType, false).get());
        }
    }

    @Test
    public void testLocateBeforeLastRegion() throws IOException, InterruptedException, ExecutionException {
        this.createMultiRegionTable();
        this.getDefaultRegionLocation(TABLE_NAME, SPLIT_KEYS[0], RegionLocateType.CURRENT, false).join();
        HRegionLocation loc = this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_END_ROW, RegionLocateType.BEFORE, false).get();
        Assert.assertArrayEquals((byte[])loc.getRegion().getEndKey(), (byte[])HConstants.EMPTY_END_ROW);
    }

    @Test
    public void testRegionReplicas() throws Exception {
        TEST_UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setRegionReplication(3).build());
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_NAME);
        RegionReplicaTestHelper.testLocator(TEST_UTIL, TABLE_NAME, new RegionReplicaTestHelper.Locator(){

            @Override
            public void updateCachedLocationOnError(HRegionLocation loc, Throwable error) throws Exception {
                LOCATOR.updateCachedLocationOnError(loc, error);
            }

            @Override
            public RegionLocations getRegionLocations(TableName tableName, int replicaId, boolean reload) throws Exception {
                return (RegionLocations)LOCATOR.getRegionLocations(tableName, HConstants.EMPTY_START_ROW, replicaId, RegionLocateType.CURRENT, reload).get();
            }
        });
    }

    @Test
    public void testLocateBeforeInOnlyRegion() throws IOException, InterruptedException {
        this.createSingleRegionTable();
        HRegionLocation loc = this.getDefaultRegionLocation(TABLE_NAME, Bytes.toBytes((int)1), RegionLocateType.BEFORE, false).join();
        Assert.assertArrayEquals((byte[])loc.getRegion().getStartKey(), (byte[])HConstants.EMPTY_START_ROW);
        Assert.assertArrayEquals((byte[])loc.getRegion().getEndKey(), (byte[])HConstants.EMPTY_END_ROW);
    }

    @Test
    public void testConcurrentUpdateCachedLocationOnError() throws Exception {
        this.createSingleRegionTable();
        HRegionLocation loc = this.getDefaultRegionLocation(TABLE_NAME, HConstants.EMPTY_START_ROW, RegionLocateType.CURRENT, false).get();
        IntStream.range(0, 100).parallel().forEach(i -> LOCATOR.updateCachedLocationOnError(loc, (Throwable)new NotServingRegionException()));
    }

    @Test
    public void testCacheLocationWhenGetAllLocations() throws Exception {
        this.createMultiRegionTable();
        AsyncConnectionImpl conn = (AsyncConnectionImpl)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        conn.getRegionLocator(TABLE_NAME).getAllRegionLocations().get();
        List regions = TEST_UTIL.getAdmin().getRegions(TABLE_NAME);
        for (RegionInfo region : regions) {
            Assert.assertNotNull((Object)conn.getLocator().getNonMetaRegionLocator().getRegionLocationInCache(TABLE_NAME, region.getStartKey()));
        }
    }

    @Test
    public void testDoNotCacheLocationWithNullServerNameWhenGetAllLocations() throws Exception {
        this.createMultiRegionTable();
        AsyncConnectionImpl conn = (AsyncConnectionImpl)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        List regions = TEST_UTIL.getAdmin().getRegions(TABLE_NAME);
        RegionInfo chosen = (RegionInfo)regions.get(0);
        AsyncTableRegionLocator regionLocator = conn.getRegionLocator(TABLE_NAME);
        regionLocator.clearRegionLocationCache();
        regionLocator.getAllRegionLocations().get();
        int tries = 3;
        this.checkRegionsWithRetries(conn, regions, null, tries);
        Put put = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)chosen, (long)EnvironmentEdgeManager.currentTime());
        MetaTableAccessor.addEmptyLocation((Put)put, (int)0);
        MetaTableAccessor.putsToMetaTable((Connection)TEST_UTIL.getConnection(), (List)Lists.newArrayList((Object[])new Put[]{put}));
        regionLocator.clearRegionLocationCache();
        for (HRegionLocation loc : (List)regionLocator.getAllRegionLocations().get()) {
            if (!loc.getRegion().equals(chosen)) continue;
            Assert.assertNull((Object)loc.getServerName());
        }
        this.checkRegionsWithRetries(conn, regions, chosen, tries);
    }

    private void checkRegionsWithRetries(AsyncConnectionImpl conn, List<RegionInfo> regions, RegionInfo chosen, int retries) throws InterruptedException {
        while (true) {
            try {
                this.checkRegions(conn, regions, chosen);
            }
            catch (AssertionError e) {
                if (retries-- <= 0) {
                    throw e;
                }
                Thread.sleep(500L);
                continue;
            }
            break;
        }
    }

    private void checkRegions(AsyncConnectionImpl conn, List<RegionInfo> regions, RegionInfo chosen) {
        for (RegionInfo region : regions) {
            RegionLocations fromCache = conn.getLocator().getNonMetaRegionLocator().getRegionLocationInCache(TABLE_NAME, region.getStartKey());
            if (region.equals(chosen)) {
                Assert.assertNull((Object)fromCache);
                continue;
            }
            Assert.assertNotNull((Object)fromCache);
        }
    }
}

