/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupableBalancer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSGroupBasedLoadBalancer
implements RSGroupableBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupBasedLoadBalancer.class);
    private Configuration config;
    private ClusterMetrics clusterStatus;
    private MasterServices masterServices;
    private volatile RSGroupInfoManager rsGroupInfoManager;
    private LoadBalancer internalBalancer;
    public static final String FALLBACK_GROUP_ENABLE_KEY = "hbase.rsgroup.fallback.enable";
    private boolean fallbackEnabled = false;

    @InterfaceAudience.Private
    public RSGroupBasedLoadBalancer() {
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        if (this.internalBalancer != null) {
            this.internalBalancer.setConf(conf);
        }
    }

    public void setClusterMetrics(ClusterMetrics sm) {
        this.clusterStatus = sm;
        if (this.internalBalancer != null) {
            this.internalBalancer.setClusterMetrics(sm);
        }
    }

    public void setMasterServices(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    public List<RegionPlan> balanceCluster(Map<TableName, Map<ServerName, List<RegionInfo>>> loadOfAllTable) throws IOException {
        if (!this.isOnline()) {
            throw new ConstraintException(RSGroupInfoManager.RSGROUP_TABLE_NAME + " is not online, unable to perform balance");
        }
        Pair<Map<TableName, Map<ServerName, List<RegionInfo>>>, List<RegionPlan>> correctedStateAndRegionPlans = this.correctAssignments(loadOfAllTable);
        Map correctedLoadOfAllTable = (Map)correctedStateAndRegionPlans.getFirst();
        List regionPlans = (List)correctedStateAndRegionPlans.getSecond();
        try {
            for (RSGroupInfo rsgroup : this.rsGroupInfoManager.listRSGroups()) {
                HashMap loadOfTablesInGroup = new HashMap();
                for (Map.Entry entry : correctedLoadOfAllTable.entrySet()) {
                    TableName tableName = (TableName)entry.getKey();
                    String targetRSGroupName = this.rsGroupInfoManager.getRSGroupOfTable(tableName);
                    if (targetRSGroupName == null) {
                        targetRSGroupName = "default";
                    }
                    if (!targetRSGroupName.equals(rsgroup.getName())) continue;
                    loadOfTablesInGroup.put(tableName, entry.getValue());
                }
                List groupPlans = null;
                if (!loadOfTablesInGroup.isEmpty()) {
                    LOG.info("Start Generate Balance plan for group: " + rsgroup.getName());
                    groupPlans = this.internalBalancer.balanceCluster(loadOfTablesInGroup);
                }
                if (groupPlans == null) continue;
                regionPlans.addAll(groupPlans);
            }
        }
        catch (IOException exp) {
            LOG.warn("Exception while balancing cluster.", (Throwable)exp);
            regionPlans.clear();
        }
        return regionPlans;
    }

    @NonNull
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        HashMap assignments = Maps.newHashMap();
        List<Pair<List<RegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(regions, servers);
        for (Pair<List<RegionInfo>, List<ServerName>> pair : pairs) {
            Map result = this.internalBalancer.roundRobinAssignment((List)pair.getFirst(), (List)pair.getSecond());
            result.forEach((server, regionInfos) -> assignments.computeIfAbsent(server, s -> Lists.newArrayList()).addAll(regionInfos));
        }
        return assignments;
    }

    @NonNull
    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        try {
            TreeMap<ServerName, List<RegionInfo>> assignments = new TreeMap<ServerName, List<RegionInfo>>();
            List<Pair<List<RegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(Lists.newArrayList(regions.keySet()), servers);
            for (Pair<List<RegionInfo>, List<ServerName>> pair : pairs) {
                List regionList = (List)pair.getFirst();
                TreeMap currentAssignmentMap = Maps.newTreeMap();
                regionList.forEach(r -> {
                    ServerName cfr_ignored_0 = (ServerName)currentAssignmentMap.put(r, regions.get(r));
                });
                Map pairResult = this.internalBalancer.retainAssignment((Map)currentAssignmentMap, (List)pair.getSecond());
                pairResult.forEach((server, rs) -> assignments.computeIfAbsent((ServerName)server, s -> Lists.newArrayList()).addAll(rs));
            }
            return assignments;
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to do online retain assignment", (Throwable)e);
        }
    }

    public ServerName randomAssignment(RegionInfo region, List<ServerName> servers) throws HBaseIOException {
        List<Pair<List<RegionInfo>, List<ServerName>>> pairs = this.generateGroupAssignments(Lists.newArrayList((Object[])new RegionInfo[]{region}), servers);
        List filteredServers = (List)pairs.iterator().next().getSecond();
        return this.internalBalancer.randomAssignment(region, filteredServers);
    }

    private List<Pair<List<RegionInfo>, List<ServerName>>> generateGroupAssignments(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        try {
            ArrayListMultimap regionMap = ArrayListMultimap.create();
            ArrayListMultimap serverMap = ArrayListMultimap.create();
            RSGroupInfo defaultInfo = this.rsGroupInfoManager.getRSGroup("default");
            for (RegionInfo region : regions) {
                String groupName = Optional.ofNullable(this.rsGroupInfoManager.getRSGroupOfTable(region.getTable())).orElse(defaultInfo.getName());
                regionMap.put((Object)groupName, (Object)region);
            }
            for (String groupKey : regionMap.keySet()) {
                RSGroupInfo info = this.rsGroupInfoManager.getRSGroup(groupKey);
                serverMap.putAll((Object)groupKey, this.filterOfflineServers(info, servers));
            }
            ArrayList result = Lists.newArrayList();
            ArrayList fallbackRegions = Lists.newArrayList();
            for (String groupKey : regionMap.keySet()) {
                if (serverMap.get((Object)groupKey).isEmpty()) {
                    fallbackRegions.addAll(regionMap.get((Object)groupKey));
                    continue;
                }
                result.add(Pair.newPair((Object)regionMap.get((Object)groupKey), (Object)serverMap.get((Object)groupKey)));
            }
            if (!fallbackRegions.isEmpty()) {
                ArrayList candidates = null;
                if (this.isFallbackEnabled()) {
                    candidates = this.getFallBackCandidates(servers);
                }
                candidates = candidates == null || candidates.isEmpty() ? Lists.newArrayList((Object[])new ServerName[]{BOGUS_SERVER_NAME}) : candidates;
                result.add(Pair.newPair((Object)fallbackRegions, (Object)candidates));
            }
            return result;
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to generate group assignments", (Throwable)e);
        }
    }

    private List<ServerName> filterOfflineServers(RSGroupInfo RSGroupInfo2, List<ServerName> onlineServers) {
        if (RSGroupInfo2 != null) {
            return this.filterServers(RSGroupInfo2.getServers(), onlineServers);
        }
        LOG.warn("RSGroup Information found to be null. Some regions might be unassigned.");
        return Collections.emptyList();
    }

    private List<ServerName> filterServers(Set<Address> servers, List<ServerName> onlineServers) {
        ArrayList<ServerName> finalList = new ArrayList<ServerName>();
        for (ServerName onlineServer : onlineServers) {
            if (!servers.contains(onlineServer.getAddress())) continue;
            finalList.add(onlineServer);
        }
        return finalList;
    }

    private Pair<Map<TableName, Map<ServerName, List<RegionInfo>>>, List<RegionPlan>> correctAssignments(Map<TableName, Map<ServerName, List<RegionInfo>>> existingAssignments) throws IOException {
        HashMap correctAssignments = new HashMap();
        ArrayList regionPlansForMisplacedRegions = new ArrayList();
        for (Map.Entry<TableName, Map<ServerName, List<RegionInfo>>> assignments : existingAssignments.entrySet()) {
            TableName tableName = assignments.getKey();
            Map<ServerName, List<RegionInfo>> clusterLoad = assignments.getValue();
            TreeMap<ServerName, List<RegionInfo>> correctServerRegion = new TreeMap<ServerName, List<RegionInfo>>();
            RSGroupInfo targetRSGInfo = null;
            try {
                String groupName = this.rsGroupInfoManager.getRSGroupOfTable(tableName);
                if (groupName == null) {
                    LOG.debug("Group not found for table " + tableName + ", using default");
                    groupName = "default";
                }
                targetRSGInfo = this.rsGroupInfoManager.getRSGroup(groupName);
            }
            catch (IOException exp) {
                LOG.debug("RSGroup information null for region of table " + tableName, (Throwable)exp);
            }
            for (Map.Entry<ServerName, List<RegionInfo>> serverRegionMap : clusterLoad.entrySet()) {
                ServerName currentHostServer = serverRegionMap.getKey();
                List<RegionInfo> regionInfoList = serverRegionMap.getValue();
                if (targetRSGInfo == null || !targetRSGInfo.containsServer(currentHostServer.getAddress())) {
                    regionInfoList.forEach(regionInfo -> regionPlansForMisplacedRegions.add(new RegionPlan(regionInfo, currentHostServer, null)));
                    continue;
                }
                correctServerRegion.put(currentHostServer, regionInfoList);
            }
            correctAssignments.put(tableName, correctServerRegion);
        }
        return new Pair(correctAssignments, regionPlansForMisplacedRegions);
    }

    public void initialize() throws HBaseIOException {
        try {
            if (this.rsGroupInfoManager == null) {
                List cps = this.masterServices.getMasterCoprocessorHost().findCoprocessors(RSGroupAdminEndpoint.class);
                if (cps.size() != 1) {
                    String msg = "Expected one implementation of GroupAdminEndpoint but found " + cps.size();
                    LOG.error(msg);
                    throw new HBaseIOException(msg);
                }
                this.rsGroupInfoManager = ((RSGroupAdminEndpoint)cps.get(0)).getGroupInfoManager();
                if (this.rsGroupInfoManager == null) {
                    String msg = "RSGroupInfoManager hasn't been initialized";
                    LOG.error(msg);
                    throw new HBaseIOException(msg);
                }
                this.rsGroupInfoManager.start();
            }
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to initialize GroupInfoManagerImpl", (Throwable)e);
        }
        Class balancerClass = this.config.getClass("hbase.rsgroup.grouploadbalancer.class", StochasticLoadBalancer.class, LoadBalancer.class);
        if (this.getClass().isAssignableFrom(balancerClass)) {
            LOG.warn("The internal balancer of RSGroupBasedLoadBalancer cannot be itself, falling back to the default LoadBalancer class");
            balancerClass = LoadBalancerFactory.getDefaultLoadBalancerClass();
        }
        this.internalBalancer = (LoadBalancer)ReflectionUtils.newInstance((Class)balancerClass, (Configuration)this.config);
        this.internalBalancer.setMasterServices(this.masterServices);
        if (this.clusterStatus != null) {
            this.internalBalancer.setClusterMetrics(this.clusterStatus);
        }
        this.internalBalancer.setConf(this.config);
        this.internalBalancer.initialize();
        this.fallbackEnabled = this.config.getBoolean(FALLBACK_GROUP_ENABLE_KEY, false);
    }

    public boolean isOnline() {
        if (this.rsGroupInfoManager == null) {
            return false;
        }
        return this.rsGroupInfoManager.isOnline();
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled;
    }

    public void regionOnline(RegionInfo regionInfo, ServerName sn) {
    }

    public void regionOffline(RegionInfo regionInfo) {
    }

    public void onConfigurationChange(Configuration conf) {
        this.config = conf;
        boolean newFallbackEnabled = conf.getBoolean(FALLBACK_GROUP_ENABLE_KEY, false);
        if (this.fallbackEnabled != newFallbackEnabled) {
            LOG.info("Changing the value of {} from {} to {}", new Object[]{FALLBACK_GROUP_ENABLE_KEY, this.fallbackEnabled, newFallbackEnabled});
            this.fallbackEnabled = newFallbackEnabled;
        }
        this.internalBalancer.onConfigurationChange(conf);
    }

    public void stop(String why) {
    }

    public boolean isStopped() {
        return false;
    }

    public void setRsGroupInfoManager(RSGroupInfoManager rsGroupInfoManager) {
        this.rsGroupInfoManager = rsGroupInfoManager;
    }

    public void postMasterStartupInitialize() {
        this.internalBalancer.postMasterStartupInitialize();
    }

    public void updateBalancerStatus(boolean status) {
        this.internalBalancer.updateBalancerStatus(status);
    }

    public List<RegionPlan> balanceTable(TableName tableName, Map<ServerName, List<RegionInfo>> loadOfOneTable) {
        Pair<Map<TableName, Map<ServerName, List<RegionInfo>>>, List<RegionPlan>> correctedStateAndRegionPlans;
        if (!this.isOnline()) {
            LOG.error(RSGroupInfoManager.class.getSimpleName() + " is not online, unable to perform balanceTable");
            return null;
        }
        HashMap<TableName, Map<ServerName, List<RegionInfo>>> loadOfThisTable = new HashMap<TableName, Map<ServerName, List<RegionInfo>>>();
        loadOfThisTable.put(tableName, loadOfOneTable);
        try {
            correctedStateAndRegionPlans = this.correctAssignments(loadOfThisTable);
        }
        catch (IOException e) {
            LOG.error("get correct assignments and mis-placed regions error ", (Throwable)e);
            return null;
        }
        Map correctedLoadOfThisTable = (Map)correctedStateAndRegionPlans.getFirst();
        List regionPlans = (List)correctedStateAndRegionPlans.getSecond();
        List tablePlans = this.internalBalancer.balanceTable(tableName, (Map)correctedLoadOfThisTable.get(tableName));
        if (tablePlans != null) {
            regionPlans.addAll(tablePlans);
        }
        return regionPlans;
    }

    private List<ServerName> getFallBackCandidates(List<ServerName> servers) {
        List<ServerName> serverNames = null;
        try {
            RSGroupInfo info = this.rsGroupInfoManager.getRSGroup("default");
            serverNames = this.filterOfflineServers(info, servers);
        }
        catch (IOException e) {
            LOG.error("Failed to get default rsgroup info to fallback", (Throwable)e);
        }
        return serverNames == null || serverNames.isEmpty() ? servers : serverNames;
    }
}

