/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="To be fixed but warning suppressed for now")
public class HFileLink
extends FileLink {
    private static final Logger LOG = LoggerFactory.getLogger(HFileLink.class);
    public static final String LINK_NAME_REGEX = String.format("(?:(?:%s=)?)%s=%s-%s", "(?:[_\\p{Digit}\\p{IsAlphabetic}]+)", "(?:[_\\p{Digit}\\p{IsAlphabetic}][-_.\\p{Digit}\\p{IsAlphabetic}]*)", "(?:[a-f0-9]+)", "[0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?");
    public static final Pattern LINK_NAME_PATTERN = Pattern.compile(String.format("^(?:(%s)(?:\\=))?(%s)=(%s)-(%s)$", "(?:[_\\p{Digit}\\p{IsAlphabetic}]+)", "(?:[_\\p{Digit}\\p{IsAlphabetic}][-_.\\p{Digit}\\p{IsAlphabetic}]*)", "(?:[a-f0-9]+)", "[0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?"));
    private static final Pattern REF_OR_HFILE_LINK_PATTERN = Pattern.compile(String.format("^(?:(%s)(?:=))?(%s)=(%s)-(.+)$", "(?:[_\\p{Digit}\\p{IsAlphabetic}]+)", "(?:[_\\p{Digit}\\p{IsAlphabetic}][-_.\\p{Digit}\\p{IsAlphabetic}]*)", "(?:[a-f0-9]+)"));
    private final Path archivePath;
    private final Path originPath;
    private final Path mobPath;
    private final Path tempPath;

    public HFileLink(Path originPath, Path tempPath, Path mobPath, Path archivePath) {
        this.tempPath = tempPath;
        this.originPath = originPath;
        this.mobPath = mobPath;
        this.archivePath = archivePath;
        this.setLocations(originPath, archivePath, tempPath, mobPath);
    }

    public static final HFileLink buildFromHFileLinkPattern(Configuration conf, Path hFileLinkPattern) throws IOException {
        return HFileLink.buildFromHFileLinkPattern(CommonFSUtils.getRootDir(conf), HFileArchiveUtil.getArchivePath(conf), hFileLinkPattern);
    }

    public static final HFileLink buildFromHFileLinkPattern(Path rootDir, Path archiveDir, Path hFileLinkPattern) {
        Path hfilePath = HFileLink.getHFileLinkPatternRelativePath(hFileLinkPattern);
        Path tempPath = new Path(new Path(rootDir, ".tmp"), hfilePath);
        Path originPath = new Path(rootDir, hfilePath);
        Path mobPath = new Path(new Path(rootDir, "mobdir"), hfilePath);
        Path archivePath = new Path(archiveDir, hfilePath);
        return new HFileLink(originPath, tempPath, mobPath, archivePath);
    }

    public static Path createPath(TableName table, String region, String family, String hfile) {
        if (HFileLink.isHFileLink(hfile)) {
            return new Path(family, hfile);
        }
        return new Path(family, HFileLink.createHFileLinkName(table, region, hfile));
    }

    public static HFileLink build(Configuration conf, TableName table, String region, String family, String hfile) throws IOException {
        return HFileLink.buildFromHFileLinkPattern(conf, HFileLink.createPath(table, region, family, hfile));
    }

    public Path getOriginPath() {
        return this.originPath;
    }

    public Path getArchivePath() {
        return this.archivePath;
    }

    public Path getMobPath() {
        return this.mobPath;
    }

    public static boolean isHFileLink(Path path) {
        return HFileLink.isHFileLink(path.getName());
    }

    public static boolean isHFileLink(String fileName) {
        Matcher m3 = LINK_NAME_PATTERN.matcher(fileName);
        if (!m3.matches()) {
            return false;
        }
        return m3.groupCount() > 2 && m3.group(4) != null && m3.group(3) != null && m3.group(2) != null;
    }

    private static Path getHFileLinkPatternRelativePath(Path path) {
        Matcher m3 = REF_OR_HFILE_LINK_PATTERN.matcher(path.getName());
        if (!m3.matches()) {
            throw new IllegalArgumentException(path.getName() + " is not a valid HFileLink pattern!");
        }
        TableName tableName = TableName.valueOf(m3.group(1), m3.group(2));
        String regionName = m3.group(3);
        String hfileName = m3.group(4);
        String familyName = path.getParent().getName();
        Path tableDir = CommonFSUtils.getTableDir(new Path("./"), tableName);
        return new Path(tableDir, new Path(regionName, new Path(familyName, hfileName)));
    }

    public static String getReferencedHFileName(String fileName) {
        Matcher m3 = REF_OR_HFILE_LINK_PATTERN.matcher(fileName);
        if (!m3.matches()) {
            throw new IllegalArgumentException(fileName + " is not a valid HFileLink name!");
        }
        return m3.group(4);
    }

    public static String getReferencedRegionName(String fileName) {
        Matcher m3 = REF_OR_HFILE_LINK_PATTERN.matcher(fileName);
        if (!m3.matches()) {
            throw new IllegalArgumentException(fileName + " is not a valid HFileLink name!");
        }
        return m3.group(3);
    }

    public static TableName getReferencedTableName(String fileName) {
        Matcher m3 = REF_OR_HFILE_LINK_PATTERN.matcher(fileName);
        if (!m3.matches()) {
            throw new IllegalArgumentException(fileName + " is not a valid HFileLink name!");
        }
        return TableName.valueOf(m3.group(1), m3.group(2));
    }

    public static String createHFileLinkName(RegionInfo hfileRegionInfo, String hfileName) {
        return HFileLink.createHFileLinkName(hfileRegionInfo.getTable(), hfileRegionInfo.getEncodedName(), hfileName);
    }

    public static String createHFileLinkName(TableName tableName, String regionName, String hfileName) {
        String s2 = String.format("%s=%s-%s", tableName.getNameAsString().replace(':', '='), regionName, hfileName);
        return s2;
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, RegionInfo hfileRegionInfo, String hfileName) throws IOException {
        return HFileLink.create(conf, fs, dstFamilyPath, hfileRegionInfo, hfileName, true);
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, RegionInfo hfileRegionInfo, String hfileName, boolean createBackRef) throws IOException {
        TableName linkedTable = hfileRegionInfo.getTable();
        String linkedRegion = hfileRegionInfo.getEncodedName();
        return HFileLink.create(conf, fs, dstFamilyPath, linkedTable, linkedRegion, hfileName, createBackRef);
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, TableName linkedTable, String linkedRegion, String hfileName) throws IOException {
        return HFileLink.create(conf, fs, dstFamilyPath, linkedTable, linkedRegion, hfileName, true);
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, TableName linkedTable, String linkedRegion, String hfileName, boolean createBackRef) throws IOException {
        String familyName = dstFamilyPath.getName();
        String regionName = dstFamilyPath.getParent().getName();
        String tableName = CommonFSUtils.getTableName(dstFamilyPath.getParent().getParent()).getNameAsString();
        return HFileLink.create(conf, fs, dstFamilyPath, familyName, tableName, regionName, linkedTable, linkedRegion, hfileName, createBackRef);
    }

    public static boolean create(Configuration conf, FileSystem fs, Path dstFamilyPath, String familyName, String dstTableName, String dstRegionName, TableName linkedTable, String linkedRegion, String hfileName, boolean createBackRef) throws IOException {
        String name = HFileLink.createHFileLinkName(linkedTable, linkedRegion, hfileName);
        String refName = HFileLink.createBackReferenceName(dstTableName, dstRegionName);
        fs.mkdirs(dstFamilyPath);
        Path archiveStoreDir = HFileArchiveUtil.getStoreArchivePath(conf, linkedTable, linkedRegion, familyName);
        Path backRefPath = null;
        if (createBackRef) {
            Path backRefssDir = HFileLink.getBackReferencesDir(archiveStoreDir, hfileName);
            fs.mkdirs(backRefssDir);
            backRefPath = new Path(backRefssDir, refName);
            fs.createNewFile(backRefPath);
        }
        try {
            return fs.createNewFile(new Path(dstFamilyPath, name));
        }
        catch (IOException e) {
            LOG.error("couldn't create the link=" + name + " for " + dstFamilyPath, (Throwable)e);
            if (createBackRef) {
                fs.delete(backRefPath, false);
            }
            throw e;
        }
    }

    public static boolean createFromHFileLink(Configuration conf, FileSystem fs, Path dstFamilyPath, String hfileLinkName) throws IOException {
        return HFileLink.createFromHFileLink(conf, fs, dstFamilyPath, hfileLinkName, true);
    }

    public static boolean createFromHFileLink(Configuration conf, FileSystem fs, Path dstFamilyPath, String hfileLinkName, boolean createBackRef) throws IOException {
        Matcher m3 = LINK_NAME_PATTERN.matcher(hfileLinkName);
        if (!m3.matches()) {
            throw new IllegalArgumentException(hfileLinkName + " is not a valid HFileLink name!");
        }
        return HFileLink.create(conf, fs, dstFamilyPath, TableName.valueOf(m3.group(1), m3.group(2)), m3.group(3), m3.group(4), createBackRef);
    }

    static String createBackReferenceName(String tableNameStr, String regionName) {
        return regionName + "." + tableNameStr.replace(':', '=');
    }

    public static Path getHFileFromBackReference(Path rootDir, Path linkRefPath) {
        Pair<TableName, String> p = HFileLink.parseBackReferenceName(linkRefPath.getName());
        TableName linkTableName = p.getFirst();
        String linkRegionName = p.getSecond();
        String hfileName = HFileLink.getBackReferenceFileName(linkRefPath.getParent());
        Path familyPath = linkRefPath.getParent().getParent();
        Path regionPath = familyPath.getParent();
        Path tablePath = regionPath.getParent();
        String linkName = HFileLink.createHFileLinkName(CommonFSUtils.getTableName(tablePath), regionPath.getName(), hfileName);
        Path linkTableDir = CommonFSUtils.getTableDir(rootDir, linkTableName);
        Path regionDir = HRegion.getRegionDir(linkTableDir, linkRegionName);
        return new Path(new Path(regionDir, familyPath.getName()), linkName);
    }

    public static Pair<TableName, String> parseBackReferenceName(String name) {
        int separatorIndex = name.indexOf(46);
        String linkRegionName = name.substring(0, separatorIndex);
        String tableSubstr = name.substring(separatorIndex + 1).replace('=', ':');
        TableName linkTableName = TableName.valueOf(tableSubstr);
        return new Pair<TableName, String>(linkTableName, linkRegionName);
    }

    public static Path getHFileFromBackReference(Configuration conf, Path linkRefPath) throws IOException {
        return HFileLink.getHFileFromBackReference(CommonFSUtils.getRootDir(conf), linkRefPath);
    }
}

