/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.procedure2.BadProcedureException;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.LockedResourceType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.Any;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.Parser;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ProcedureUtil {
    public static final String PROCEDURE_RETRY_SLEEP_INTERVAL_MS = "hbase.procedure.retry.sleep.interval.ms";
    public static final long DEFAULT_PROCEDURE_RETRY_SLEEP_INTERVAL_MS = 1000L;
    public static final String PROCEDURE_RETRY_MAX_SLEEP_TIME_MS = "hbase.procedure.retry.max.sleep.time.ms";
    public static final long DEFAULT_PROCEDURE_RETRY_MAX_SLEEP_TIME_MS = TimeUnit.MINUTES.toMillis(10L);

    private ProcedureUtil() {
    }

    private static Procedure<?> newProcedure(String className) throws BadProcedureException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new Exception("the " + clazz + " class is not public");
            }
            Constructor<Procedure> ctor = clazz.asSubclass(Procedure.class).getConstructor(new Class[0]);
            assert (ctor != null) : "no constructor found";
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new Exception("the " + clazz + " constructor is not public");
            }
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BadProcedureException("The procedure class " + className + " must be accessible and have an empty constructor", e);
        }
    }

    static void validateClass(Procedure<?> proc) throws BadProcedureException {
        try {
            Class<?> clazz = proc.getClass();
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new Exception("the " + clazz + " class is not public");
            }
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            assert (ctor != null);
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new Exception("the " + clazz + " constructor is not public");
            }
        }
        catch (Exception e) {
            throw new BadProcedureException("The procedure class " + proc.getClass().getName() + " must be accessible and have an empty constructor", e);
        }
    }

    public static ProcedureProtos.Procedure convertToProtoProcedure(Procedure<?> proc) throws IOException {
        byte[] result;
        int[] stackIds;
        Preconditions.checkArgument(proc != null);
        ProcedureUtil.validateClass(proc);
        ProcedureProtos.Procedure.Builder builder = ProcedureProtos.Procedure.newBuilder().setClassName(proc.getClass().getName()).setProcId(proc.getProcId()).setState(proc.getState()).setSubmittedTime(proc.getSubmittedTime()).setLastUpdate(proc.getLastUpdate());
        if (proc.hasParent()) {
            builder.setParentId(proc.getParentProcId());
        }
        if (proc.hasTimeout()) {
            builder.setTimeout(proc.getTimeout());
        }
        if (proc.hasOwner()) {
            builder.setOwner(proc.getOwner());
        }
        if ((stackIds = proc.getStackIndexes()) != null) {
            for (int i = 0; i < stackIds.length; ++i) {
                builder.addStackId(stackIds[i]);
            }
        }
        if (proc.hasException()) {
            RemoteProcedureException exception = proc.getException();
            builder.setException(RemoteProcedureException.toProto(exception.getSource(), exception.getCause()));
        }
        if ((result = proc.getResult()) != null) {
            builder.setResult(UnsafeByteOperations.unsafeWrap(result));
        }
        StateSerializer serializer = new StateSerializer(builder);
        proc.serializeStateData(serializer);
        if (proc.getNonceKey() != null) {
            builder.setNonceGroup(proc.getNonceKey().getNonceGroup());
            builder.setNonce(proc.getNonceKey().getNonce());
        }
        if (proc.hasLock()) {
            builder.setLocked(true);
        }
        if (proc.isBypass()) {
            builder.setBypass(true);
        }
        return builder.build();
    }

    public static Procedure<?> convertToProcedure(ProcedureProtos.Procedure proto) throws IOException {
        Procedure<?> proc = ProcedureUtil.newProcedure(proto.getClassName());
        proc.setProcId(proto.getProcId());
        proc.setState(proto.getState());
        proc.setSubmittedTime(proto.getSubmittedTime());
        proc.setLastUpdate(proto.getLastUpdate());
        if (proto.hasParentId()) {
            proc.setParentProcId(proto.getParentId());
        }
        if (proto.hasOwner()) {
            proc.setOwner(proto.getOwner());
        }
        if (proto.hasTimeout()) {
            proc.setTimeout(proto.getTimeout());
        }
        if (proto.getStackIdCount() > 0) {
            proc.setStackIndexes(proto.getStackIdList());
        }
        if (proto.hasException()) {
            assert (proc.getState() == ProcedureProtos.ProcedureState.FAILED || proc.getState() == ProcedureProtos.ProcedureState.ROLLEDBACK) : "The procedure must be failed (waiting to rollback) or rolledback";
            proc.setFailure(RemoteProcedureException.fromProto(proto.getException()));
        }
        if (proto.hasResult()) {
            proc.setResult(proto.getResult().toByteArray());
        }
        if (proto.getNonce() != 0L) {
            proc.setNonceKey(new NonceKey(proto.getNonceGroup(), proto.getNonce()));
        }
        if (proto.getLocked()) {
            proc.lockedWhenLoading();
        }
        if (proto.getBypass()) {
            proc.bypass(null);
        }
        ProcedureStateSerializer serializer = null;
        if (proto.getStateMessageCount() > 0) {
            serializer = new StateSerializer(proto.toBuilder());
        } else if (proto.hasStateData()) {
            InputStream inputStream = proto.getStateData().newInput();
            serializer = new CompatStateSerializer(inputStream);
        }
        if (serializer != null) {
            proc.deserializeStateData(serializer);
        }
        return proc;
    }

    public static LockServiceProtos.LockedResourceType convertToProtoResourceType(LockedResourceType resourceType) {
        return LockServiceProtos.LockedResourceType.valueOf(resourceType.name());
    }

    public static LockServiceProtos.LockType convertToProtoLockType(LockType lockType) {
        return LockServiceProtos.LockType.valueOf(lockType.name());
    }

    public static LockServiceProtos.LockedResource convertToProtoLockedResource(LockedResource lockedResource) throws IOException {
        LockServiceProtos.LockedResource.Builder builder = LockServiceProtos.LockedResource.newBuilder();
        builder.setResourceType(ProcedureUtil.convertToProtoResourceType(lockedResource.getResourceType())).setResourceName(lockedResource.getResourceName()).setLockType(ProcedureUtil.convertToProtoLockType(lockedResource.getLockType()));
        Procedure<?> exclusiveLockOwnerProcedure = lockedResource.getExclusiveLockOwnerProcedure();
        if (exclusiveLockOwnerProcedure != null) {
            ProcedureProtos.Procedure exclusiveLockOwnerProcedureProto = ProcedureUtil.convertToProtoProcedure(exclusiveLockOwnerProcedure);
            builder.setExclusiveLockOwnerProcedure(exclusiveLockOwnerProcedureProto);
        }
        builder.setSharedLockCount(lockedResource.getSharedLockCount());
        for (Procedure<?> waitingProcedure : lockedResource.getWaitingProcedures()) {
            ProcedureProtos.Procedure waitingProcedureProto = ProcedureUtil.convertToProtoProcedure(waitingProcedure);
            builder.addWaitingProcedures(waitingProcedureProto);
        }
        return builder.build();
    }

    public static RetryCounter createRetryCounter(Configuration conf) {
        long sleepIntervalMs = conf.getLong(PROCEDURE_RETRY_SLEEP_INTERVAL_MS, 1000L);
        long maxSleepTimeMs = conf.getLong(PROCEDURE_RETRY_MAX_SLEEP_TIME_MS, DEFAULT_PROCEDURE_RETRY_MAX_SLEEP_TIME_MS);
        RetryCounter.RetryConfig retryConfig = new RetryCounter.RetryConfig().setSleepInterval(sleepIntervalMs).setMaxSleepTime(maxSleepTimeMs).setBackoffPolicy(new RetryCounter.ExponentialBackoffPolicyWithLimit());
        return new RetryCounter(retryConfig);
    }

    public static boolean isFinished(ProcedureProtos.Procedure proc) {
        if (!proc.hasParentId()) {
            switch (proc.getState()) {
                case ROLLEDBACK: 
                case SUCCESS: {
                    return true;
                }
            }
        }
        return false;
    }

    private static class CompatStateSerializer
    implements ProcedureStateSerializer {
        private InputStream inputStream;

        public CompatStateSerializer(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void serialize(Message message) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <M extends Message> M deserialize(Class<M> clazz) throws IOException {
            Parser<? extends Message> parser = ((Message)Internal.getDefaultInstance(clazz)).getParserForType();
            try {
                return (M)parser.parseDelimitedFrom(this.inputStream);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
        }
    }

    private static class StateSerializer
    implements ProcedureStateSerializer {
        private final ProcedureProtos.Procedure.Builder builder;
        private int deserializeIndex;

        public StateSerializer(ProcedureProtos.Procedure.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void serialize(Message message) throws IOException {
            Any packedMessage = Any.pack(message);
            this.builder.addStateMessage(packedMessage);
        }

        @Override
        public <M extends Message> M deserialize(Class<M> clazz) throws IOException {
            if (this.deserializeIndex >= this.builder.getStateMessageCount()) {
                throw new IOException("Invalid state message index: " + this.deserializeIndex);
            }
            try {
                Any packedMessage = this.builder.getStateMessage(this.deserializeIndex++);
                return packedMessage.unpack(clazz);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
        }
    }
}

