/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldValue;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RecordFilter {
    private final boolean ignoreCase;
    private final boolean not;
    private final Field field;
    private final Operator operator;
    private final FieldValue value;

    public static RecordFilter parse(String filterString, boolean ignoreCase) {
        return RecordFilter.parse(filterString, Arrays.asList(Field.values()), ignoreCase);
    }

    public static RecordFilter parse(String filterString, List<Field> fields, boolean ignoreCase) {
        int index = 0;
        boolean not = RecordFilter.isNot(filterString);
        if (not) {
            ++index;
        }
        StringBuilder fieldString = new StringBuilder();
        while (filterString.length() > index && filterString.charAt(index) != '<' && filterString.charAt(index) != '>' && filterString.charAt(index) != '=') {
            fieldString.append(filterString.charAt(index++));
        }
        if (fieldString.length() == 0 || filterString.length() == index) {
            return null;
        }
        Field field = RecordFilter.getField(fields, fieldString.toString());
        if (field == null) {
            return null;
        }
        StringBuilder operatorString = new StringBuilder();
        while (filterString.length() > index && (filterString.charAt(index) == '<' || filterString.charAt(index) == '>' || filterString.charAt(index) == '=')) {
            operatorString.append(filterString.charAt(index++));
        }
        Operator operator = RecordFilter.getOperator(operatorString.toString());
        if (operator == null) {
            return null;
        }
        String value = filterString.substring(index);
        FieldValue fieldValue = RecordFilter.getFieldValue(field, value);
        if (fieldValue == null) {
            return null;
        }
        return new RecordFilter(ignoreCase, not, field, operator, fieldValue);
    }

    private static FieldValue getFieldValue(Field field, String value) {
        try {
            return field.newValue(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isNot(String filterString) {
        return filterString.startsWith("!");
    }

    private static Field getField(List<Field> fields, String fieldString) {
        for (Field f : fields) {
            if (!f.getHeader().equals(fieldString)) continue;
            return f;
        }
        return null;
    }

    private static Operator getOperator(String operatorString) {
        for (Operator o : Operator.values()) {
            if (!operatorString.equals(o.toString())) continue;
            return o;
        }
        return null;
    }

    private RecordFilter(boolean ignoreCase, boolean not, Field field, Operator operator, FieldValue value) {
        this.ignoreCase = ignoreCase;
        this.not = not;
        this.field = Objects.requireNonNull(field);
        this.operator = Objects.requireNonNull(operator);
        this.value = Objects.requireNonNull(value);
    }

    public Field getField() {
        return this.field;
    }

    public boolean execute(Record record) {
        boolean ret;
        FieldValue fieldValue = record.get((Object)this.field);
        if (fieldValue == null) {
            return false;
        }
        if (this.operator == Operator.EQUAL) {
            boolean ret2 = this.ignoreCase ? fieldValue.asString().toLowerCase().contains(this.value.asString().toLowerCase()) : fieldValue.asString().contains(this.value.asString());
            return this.not != ret2;
        }
        int compare = this.ignoreCase ? fieldValue.compareToIgnoreCase(this.value) : fieldValue.compareTo(this.value);
        switch (this.operator) {
            case DOUBLE_EQUALS: {
                ret = compare == 0;
                break;
            }
            case GREATER: {
                ret = compare > 0;
                break;
            }
            case GREATER_OR_EQUAL: {
                ret = compare >= 0;
                break;
            }
            case LESS: {
                ret = compare < 0;
                break;
            }
            case LESS_OR_EQUAL: {
                ret = compare <= 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.not != ret;
    }

    public String toString() {
        return (this.not ? "!" : "") + this.field.getHeader() + (Object)((Object)this.operator) + this.value.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordFilter)) {
            return false;
        }
        RecordFilter filter = (RecordFilter)o;
        return this.ignoreCase == filter.ignoreCase && this.not == filter.not && this.field == filter.field && this.operator == filter.operator && this.value.equals(filter.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ignoreCase, this.not, this.field, this.operator, this.value});
    }

    public static FilterBuilder newBuilder(Field field) {
        return new FilterBuilder(field, false);
    }

    public static FilterBuilder newBuilder(Field field, boolean ignoreCase) {
        return new FilterBuilder(field, ignoreCase);
    }

    public static final class FilterBuilder {
        private final Field field;
        private final boolean ignoreCase;

        private FilterBuilder(Field field, boolean ignoreCase) {
            this.field = Objects.requireNonNull(field);
            this.ignoreCase = ignoreCase;
        }

        public RecordFilter equal(FieldValue value) {
            return this.newFilter(false, Operator.EQUAL, value);
        }

        public RecordFilter equal(Object value) {
            return this.equal(this.field.newValue(value));
        }

        public RecordFilter notEqual(FieldValue value) {
            return this.newFilter(true, Operator.EQUAL, value);
        }

        public RecordFilter notEqual(Object value) {
            return this.notEqual(this.field.newValue(value));
        }

        public RecordFilter doubleEquals(FieldValue value) {
            return this.newFilter(false, Operator.DOUBLE_EQUALS, value);
        }

        public RecordFilter doubleEquals(Object value) {
            return this.doubleEquals(this.field.newValue(value));
        }

        public RecordFilter notDoubleEquals(FieldValue value) {
            return this.newFilter(true, Operator.DOUBLE_EQUALS, value);
        }

        public RecordFilter notDoubleEquals(Object value) {
            return this.notDoubleEquals(this.field.newValue(value));
        }

        public RecordFilter greater(FieldValue value) {
            return this.newFilter(false, Operator.GREATER, value);
        }

        public RecordFilter greater(Object value) {
            return this.greater(this.field.newValue(value));
        }

        public RecordFilter notGreater(FieldValue value) {
            return this.newFilter(true, Operator.GREATER, value);
        }

        public RecordFilter notGreater(Object value) {
            return this.notGreater(this.field.newValue(value));
        }

        public RecordFilter greaterOrEqual(FieldValue value) {
            return this.newFilter(false, Operator.GREATER_OR_EQUAL, value);
        }

        public RecordFilter greaterOrEqual(Object value) {
            return this.greaterOrEqual(this.field.newValue(value));
        }

        public RecordFilter notGreaterOrEqual(FieldValue value) {
            return this.newFilter(true, Operator.GREATER_OR_EQUAL, value);
        }

        public RecordFilter notGreaterOrEqual(Object value) {
            return this.notGreaterOrEqual(this.field.newValue(value));
        }

        public RecordFilter less(FieldValue value) {
            return this.newFilter(false, Operator.LESS, value);
        }

        public RecordFilter less(Object value) {
            return this.less(this.field.newValue(value));
        }

        public RecordFilter notLess(FieldValue value) {
            return this.newFilter(true, Operator.LESS, value);
        }

        public RecordFilter notLess(Object value) {
            return this.notLess(this.field.newValue(value));
        }

        public RecordFilter lessOrEqual(FieldValue value) {
            return this.newFilter(false, Operator.LESS_OR_EQUAL, value);
        }

        public RecordFilter lessOrEqual(Object value) {
            return this.lessOrEqual(this.field.newValue(value));
        }

        public RecordFilter notLessOrEqual(FieldValue value) {
            return this.newFilter(true, Operator.LESS_OR_EQUAL, value);
        }

        public RecordFilter notLessOrEqual(Object value) {
            return this.notLessOrEqual(this.field.newValue(value));
        }

        private RecordFilter newFilter(boolean not, Operator operator, FieldValue value) {
            return new RecordFilter(this.ignoreCase, not, this.field, operator, value);
        }
    }

    private static enum Operator {
        EQUAL("="),
        DOUBLE_EQUALS("=="),
        GREATER(">"),
        GREATER_OR_EQUAL(">="),
        LESS("<"),
        LESS_OR_EQUAL("<=");

        private final String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

