/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDataFilesAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteDataFilesAction.class);
    private final float chance;

    public DeleteDataFilesAction(float chance) {
        this.chance = chance * 100.0f;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info("Start deleting data files");
        FileSystem fs = CommonFSUtils.getRootDirFileSystem((Configuration)this.getConf());
        Path rootDir = CommonFSUtils.getRootDir((Configuration)this.getConf());
        Path defaultDir = rootDir.suffix("/data/default");
        RemoteIterator iterator = fs.listFiles(defaultDir, true);
        while (iterator.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)iterator.next();
            if (!HFile.isHFileFormat((FileSystem)fs, (Path)status.getPath()) || RandomUtils.nextFloat((float)0.0f, (float)100.0f) > this.chance) continue;
            fs.delete(status.getPath(), true);
            this.getLogger().info("Deleting {}", (Object)status.getPath());
        }
        this.getLogger().info("Done deleting data files");
    }
}

