/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactRandomRegionOfTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(CompactRandomRegionOfTableAction.class);
    private final int majorRatio;
    private final long sleepTime;
    private final TableName tableName;

    public CompactRandomRegionOfTableAction(TableName tableName, float majorRatio) {
        this(-1, tableName, majorRatio);
    }

    public CompactRandomRegionOfTableAction(int sleepTime, TableName tableName, float majorRatio) {
        this.majorRatio = (int)(100.0f * majorRatio);
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        boolean major = RandomUtils.nextInt((int)0, (int)100) < this.majorRatio;
        this.getLogger().info("Performing action: Compact random region of table " + this.tableName + ", major=" + major);
        List regions = admin.getRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            this.getLogger().info("Table " + this.tableName + " doesn't have regions to compact");
            return;
        }
        RegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new RegionInfo[0]));
        try {
            if (major) {
                this.getLogger().debug("Major compacting region " + region.getRegionNameAsString());
                admin.majorCompactRegion(region.getRegionName());
            } else {
                this.getLogger().debug("Compacting region " + region.getRegionNameAsString());
                admin.compactRegion(region.getRegionName());
            }
        }
        catch (Exception ex) {
            this.getLogger().warn("Compaction failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

