/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Random;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSplitPolicyAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeSplitPolicyAction.class);
    private final TableName tableName;
    private final String[] possiblePolicies;
    private final Random random;

    public ChangeSplitPolicyAction(TableName tableName) {
        this.tableName = tableName;
        this.possiblePolicies = new String[]{IncreasingToUpperBoundRegionSplitPolicy.class.getName(), ConstantSizeRegionSplitPolicy.class.getName(), DisabledRegionSplitPolicy.class.getName()};
        this.random = new Random();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        this.getLogger().info("Performing action: Change split policy of table " + this.tableName);
        TableDescriptor tableDescriptor = admin.getDescriptor(this.tableName);
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor);
        String chosenPolicy = this.possiblePolicies[this.random.nextInt(this.possiblePolicies.length)];
        builder.setRegionSplitPolicyClassName(chosenPolicy);
        this.getLogger().info("Changing " + this.tableName + " split policy to " + chosenPolicy);
        admin.modifyTable(builder.build());
    }
}

