/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Connector;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Handler;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Request;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.RequestLog;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Server;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.ServerConnector;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.Slf4jRequestLog;
import org.apache.hbase.thirdparty.org.eclipse.jetty.server.handler.AbstractHandler;
import org.apache.hbase.thirdparty.org.eclipse.jetty.util.RegexSet;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHttpApiRule
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(MockHttpApiRule.class);
    private MockHandler handler;
    private Server server;

    public MockHttpApiRule addRegistration(String pathRegex, BiConsumer<String, HttpServletResponse> responder) {
        this.handler.register(pathRegex, responder);
        return this;
    }

    public MockHttpApiRule registerOk(String pathRegex, String responseBody) {
        return this.addRegistration(pathRegex, (target, resp) -> {
            try {
                resp.setStatus(200);
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType(MediaType.APPLICATION_JSON_TYPE.toString());
                PrintWriter writer = resp.getWriter();
                writer.write(responseBody);
                writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void clearRegistrations() {
        this.handler.clearRegistrations();
    }

    public URI getURI() {
        if (this.server == null || !this.server.isRunning()) {
            throw new IllegalStateException("server is not running");
        }
        return this.server.getURI();
    }

    protected void before() throws Exception {
        this.handler = new MockHandler();
        this.server = new Server();
        ServerConnector http = new ServerConnector(this.server);
        http.setHost("localhost");
        this.server.addConnector((Connector)http);
        this.server.setStopAtShutdown(true);
        this.server.setHandler((Handler)this.handler);
        this.server.setRequestLog(MockHttpApiRule.buildRequestLog());
        this.server.start();
    }

    protected void after() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static RequestLog buildRequestLog() {
        Slf4jRequestLog requestLog = new Slf4jRequestLog();
        requestLog.setLoggerName(LOG.getName() + ".RequestLog");
        requestLog.setExtended(true);
        return requestLog;
    }

    private static class MockHandler
    extends AbstractHandler {
        private final ReadWriteLock responseMappingLock = new ReentrantReadWriteLock();
        private final Map<String, BiConsumer<String, HttpServletResponse>> responseMapping = new HashMap<String, BiConsumer<String, HttpServletResponse>>();
        private final RegexSet regexSet = new RegexSet();

        private MockHandler() {
        }

        void register(String pathRegex, BiConsumer<String, HttpServletResponse> responder) {
            LOG.debug("Registering responder to '{}'", (Object)pathRegex);
            this.responseMappingLock.writeLock().lock();
            try {
                this.responseMapping.put(pathRegex, responder);
                this.regexSet.add(pathRegex);
            }
            finally {
                this.responseMappingLock.writeLock().unlock();
            }
        }

        void clearRegistrations() {
            LOG.debug("Clearing registrations");
            this.responseMappingLock.writeLock().lock();
            try {
                this.responseMapping.clear();
                this.regexSet.clear();
            }
            finally {
                this.responseMappingLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            this.responseMappingLock.readLock().lock();
            try {
                if (!this.regexSet.matches(target)) {
                    response.setStatus(404);
                    return;
                }
                this.responseMapping.entrySet().stream().filter(e -> Pattern.matches((String)e.getKey(), target)).findAny().map(Map.Entry::getValue).orElseThrow(() -> MockHandler.noMatchFound(target)).accept(target, response);
            }
            finally {
                this.responseMappingLock.readLock().unlock();
            }
        }

        private static RuntimeException noMatchFound(String target) {
            return new RuntimeException(String.format("Target path '%s' matches no registered regex.", target));
        }
    }
}

