/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.net.URI;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.BalancerParameters;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestBalancerWithHANameNodes {
    private MiniDFSCluster cluster;
    ClientProtocol client;
    private static final String[] TEST_RACKS = new String[]{"/rack0", "/rack1"};
    private static final long[] TEST_CAPACITIES = new long[]{5000L, 5000L};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerWithHANameNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        Assert.assertEquals((long)TEST_CAPACITIES.length, (long)TEST_RACKS.length);
        MiniDFSNNTopology.NNConf nn1Conf = new MiniDFSNNTopology.NNConf("nn1");
        nn1Conf.setIpcPort(8020);
        Configuration copiedConf = new Configuration((Configuration)conf);
        this.cluster = new MiniDFSCluster.Builder(copiedConf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(TEST_CAPACITIES.length).racks(TEST_RACKS).simulatedCapacities(TEST_CAPACITIES).build();
        HATestUtil.setFailoverConfigurations(this.cluster, (Configuration)conf);
        try {
            this.cluster.waitActive();
            this.cluster.transitionToActive(0);
            Thread.sleep(500L);
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)FileSystem.getDefaultUri((Configuration)conf), ClientProtocol.class).getProxy();
            this.doTest((Configuration)conf);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    void doTest(Configuration conf) throws Exception {
        int numOfDatanodes = TEST_CAPACITIES.length;
        long totalCapacity = TestBalancer.sum(TEST_CAPACITIES);
        long totalUsedSpace = totalCapacity * 3L / 10L;
        TestBalancer.createFile(this.cluster, TestBalancer.filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 0);
        long newNodeCapacity = 5000L;
        String newNodeRack = "/rack2";
        this.cluster.startDataNodes(conf, 1, true, null, new String[]{newNodeRack}, new long[]{newNodeCapacity});
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity += newNodeCapacity, this.client, this.cluster);
        Collection namenodes = DFSUtil.getInternalNsRpcUris((Configuration)conf);
        Assert.assertEquals((long)1L, (long)namenodes.size());
        int r = Balancer.run((Collection)namenodes, (BalancerParameters)BalancerParameters.DEFAULT, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)r);
        TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, this.client, this.cluster, BalancerParameters.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBalancerWithObserver() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        MiniQJMHACluster qjmhaCluster = null;
        try {
            qjmhaCluster = HATestUtil.setUpObserverCluster((Configuration)conf, 2, TEST_CAPACITIES.length, true, TEST_CAPACITIES, TEST_RACKS);
            this.cluster = qjmhaCluster.getDfsCluster();
            this.cluster.waitClusterUp();
            this.cluster.waitActive();
            DistributedFileSystem dfs = HATestUtil.configureObserverReadFs(this.cluster, (Configuration)conf, ObserverReadProxyProvider.class, true);
            this.client = dfs.getClient().getNamenode();
            this.doTest((Configuration)conf);
        }
        finally {
            if (qjmhaCluster != null) {
                qjmhaCluster.shutdown();
            }
        }
    }

    static {
        TestBalancer.initTestSetup();
    }
}

