/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.VerifyingRSGroupAdminClient;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestRSGroupsBase {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsBase.class);
    protected static final String groupPrefix = "Group";
    protected static final String tablePrefix = "Group";
    protected static final Random rand = new Random();
    protected static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static Admin admin;
    protected static HBaseCluster cluster;
    protected static RSGroupAdmin rsGroupAdmin;
    protected static HMaster master;
    protected boolean INIT = false;
    protected static RSGroupAdminEndpoint rsGroupAdminEndpoint;
    protected static CPMasterObserver observer;
    public static final long WAIT_TIMEOUT = 60000L;
    public static final int NUM_SLAVES_BASE = 4;
    public static int NUM_DEAD_SERVERS;
    @Rule
    public TestName name = new TestName();
    protected TableName tableName;

    public static void setUpTestBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setFloat("hbase.master.balancer.stochastic.tableSkewCost", 6000.0f);
        TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName() + "," + CPMasterObserver.class.getName());
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TestRSGroupsBase.initialize();
    }

    protected static void initialize() throws Exception {
        admin = TEST_UTIL.getAdmin();
        cluster = TEST_UTIL.getHBaseCluster();
        master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return master.isInitialized() && ((RSGroupBasedLoadBalancer)master.getLoadBalancer()).isOnline();
            }
        });
        admin.balancerSwitch(false, true);
        rsGroupAdmin = new VerifyingRSGroupAdminClient((RSGroupAdmin)new RSGroupAdminClient(TEST_UTIL.getConnection()), TEST_UTIL.getConfiguration());
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        observer = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        rsGroupAdminEndpoint = (RSGroupAdminEndpoint)host.findCoprocessor(RSGroupAdminEndpoint.class.getName());
    }

    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setUpBeforeMethod() throws Exception {
        LOG.info(this.name.getMethodName());
        this.tableName = TableName.valueOf((String)("Group_" + this.name.getMethodName()));
        if (!this.INIT) {
            this.INIT = true;
            this.tearDownAfterMethod();
        }
        observer.resetFlags();
    }

    public void tearDownAfterMethod() throws Exception {
        this.deleteTableIfNecessary();
        this.deleteNamespaceIfNecessary();
        this.deleteGroups();
        for (ServerName sn : admin.listDecommissionedRegionServers()) {
            admin.recommissionRegionServer(sn, null);
        }
        Assert.assertTrue((boolean)admin.listDecommissionedRegionServers().isEmpty());
        int missing = 4 - this.getNumServers();
        LOG.info("Restoring servers: " + missing);
        for (int i = 0; i < missing; ++i) {
            ((MiniHBaseCluster)cluster).startRegionServer();
        }
        rsGroupAdmin.addRSGroup("master");
        ServerName masterServerName = ((MiniHBaseCluster)cluster).getMaster().getServerName();
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{masterServerName.getAddress()}), "master");
        }
        catch (Exception ex) {
            LOG.warn("Got this on setup, FYI", (Throwable)ex);
        }
        Assert.assertTrue((boolean)TestRSGroupsBase.observer.preMoveServersCalled);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.info("Waiting for cleanup to finish " + rsGroupAdmin.listRSGroups());
                return rsGroupAdmin.getRSGroupInfo("default").getServers().size() == 4;
            }
        });
    }

    protected RSGroupInfo addGroup(String groupName, int serverCount) throws IOException, InterruptedException {
        RSGroupInfo defaultInfo = rsGroupAdmin.getRSGroupInfo("default");
        rsGroupAdmin.addRSGroup(groupName);
        HashSet<Address> set = new HashSet<Address>();
        for (Address server : defaultInfo.getServers()) {
            if (set.size() == serverCount) break;
            set.add(server);
        }
        rsGroupAdmin.moveServers(set, groupName);
        RSGroupInfo result = rsGroupAdmin.getRSGroupInfo(groupName);
        return result;
    }

    protected void removeGroup(String groupName) throws IOException {
        RSGroupInfo groupInfo = rsGroupAdmin.getRSGroupInfo(groupName);
        rsGroupAdmin.moveTables((Set)groupInfo.getTables(), "default");
        rsGroupAdmin.moveServers(groupInfo.getServers(), "default");
        rsGroupAdmin.removeRSGroup(groupName);
    }

    protected void deleteTableIfNecessary() throws IOException {
        for (TableDescriptor desc : TEST_UTIL.getAdmin().listTableDescriptors(Pattern.compile("Group.*"))) {
            TEST_UTIL.deleteTable(desc.getTableName());
        }
    }

    protected void deleteNamespaceIfNecessary() throws IOException {
        for (NamespaceDescriptor desc : TEST_UTIL.getAdmin().listNamespaceDescriptors()) {
            if (!desc.getName().startsWith("Group")) continue;
            admin.deleteNamespace(desc.getName());
        }
    }

    protected void deleteGroups() throws IOException {
        RSGroupAdminClient groupAdmin = new RSGroupAdminClient(TEST_UTIL.getConnection());
        for (RSGroupInfo group : groupAdmin.listRSGroups()) {
            if (group.getName().equals("default")) continue;
            groupAdmin.moveTables((Set)group.getTables(), "default");
            groupAdmin.moveServers(group.getServers(), "default");
            groupAdmin.removeRSGroup(group.getName());
        }
    }

    protected Map<TableName, List<String>> getTableRegionMap() throws IOException {
        TreeMap map = Maps.newTreeMap();
        Map<TableName, Map<ServerName, List<String>>> tableServerRegionMap = this.getTableServerRegionMap();
        for (TableName tableName : tableServerRegionMap.keySet()) {
            if (!map.containsKey(tableName)) {
                map.put(tableName, new LinkedList());
            }
            for (List<String> subset : tableServerRegionMap.get(tableName).values()) {
                ((List)map.get(tableName)).addAll(subset);
            }
        }
        return map;
    }

    protected Map<TableName, Map<ServerName, List<String>>> getTableServerRegionMap() throws IOException {
        TreeMap map = Maps.newTreeMap();
        Admin admin = TEST_UTIL.getAdmin();
        ClusterMetrics metrics = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.SERVERS_NAME));
        for (ServerName serverName : metrics.getServersName()) {
            for (RegionInfo region : admin.getRegions(serverName)) {
                TableName tableName = region.getTable();
                map.computeIfAbsent(tableName, k -> new TreeMap()).computeIfAbsent(serverName, k -> new ArrayList()).add(region.getRegionNameAsString());
            }
        }
        return map;
    }

    protected int getNumServers() throws IOException {
        ClusterMetrics status = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER, ClusterMetrics.Option.LIVE_SERVERS));
        ServerName masterName = status.getMasterName();
        int count = 0;
        for (ServerName sn : status.getLiveServerMetrics().keySet()) {
            if (sn.equals((Object)masterName)) continue;
            ++count;
        }
        return count;
    }

    protected String getGroupName(String baseName) {
        return "Group_" + baseName + "_" + rand.nextInt(Integer.MAX_VALUE);
    }

    protected ServerName getServerName(Address addr) {
        return TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(sn -> sn.getAddress().equals((Object)addr)).findFirst().get();
    }

    static {
        NUM_DEAD_SERVERS = 0;
    }

    public static class CPMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        boolean preBalanceRSGroupCalled = false;
        boolean postBalanceRSGroupCalled = false;
        boolean preMoveServersCalled = false;
        boolean postMoveServersCalled = false;
        boolean preMoveTablesCalled = false;
        boolean postMoveTablesCalled = false;
        boolean preAddRSGroupCalled = false;
        boolean postAddRSGroupCalled = false;
        boolean preRemoveRSGroupCalled = false;
        boolean postRemoveRSGroupCalled = false;
        boolean preRemoveServersCalled = false;
        boolean postRemoveServersCalled = false;
        boolean preMoveServersAndTables = false;
        boolean postMoveServersAndTables = false;
        boolean preRenameRSGroupCalled = false;
        boolean postRenameRSGroupCalled = false;

        public void resetFlags() {
            this.preBalanceRSGroupCalled = false;
            this.postBalanceRSGroupCalled = false;
            this.preMoveServersCalled = false;
            this.postMoveServersCalled = false;
            this.preMoveTablesCalled = false;
            this.postMoveTablesCalled = false;
            this.preAddRSGroupCalled = false;
            this.postAddRSGroupCalled = false;
            this.preRemoveRSGroupCalled = false;
            this.postRemoveRSGroupCalled = false;
            this.preRemoveServersCalled = false;
            this.postRemoveServersCalled = false;
            this.preMoveServersAndTables = false;
            this.postMoveServersAndTables = false;
            this.preRenameRSGroupCalled = false;
            this.postRenameRSGroupCalled = false;
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
            this.preMoveServersAndTables = true;
        }

        public void postMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
            this.postMoveServersAndTables = true;
        }

        public void preRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
            this.preRemoveServersCalled = true;
        }

        public void postRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
            this.postRemoveServersCalled = true;
        }

        public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.preRemoveRSGroupCalled = true;
        }

        public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.postRemoveRSGroupCalled = true;
        }

        public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.preAddRSGroupCalled = true;
        }

        public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.postAddRSGroupCalled = true;
        }

        public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
            this.preMoveTablesCalled = true;
        }

        public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
            this.postMoveTablesCalled = true;
        }

        public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
            this.preMoveServersCalled = true;
        }

        public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
            this.postMoveServersCalled = true;
        }

        public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
            this.preBalanceRSGroupCalled = true;
        }

        public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
            this.postBalanceRSGroupCalled = true;
        }

        public void preRenameRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String oldName, String newName) throws IOException {
            this.preRenameRSGroupCalled = true;
        }

        public void postRenameRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String oldName, String newName) throws IOException {
            this.postRenameRSGroupCalled = true;
        }
    }
}

