/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterAllFilter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.RandomDistribution;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.apache.hadoop.hbase.trace.SpanReceiverHost;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.ByteArrayHashKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.YammerHistogramUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.ProbabilitySampler;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.TraceScope;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class PerformanceEvaluation
extends Configured
implements Tool {
    static final String RANDOM_SEEK_SCAN = "randomSeekScan";
    static final String RANDOM_READ = "randomRead";
    static final String PE_COMMAND_SHORTNAME = "pe";
    private static final Logger LOG = LoggerFactory.getLogger((String)PerformanceEvaluation.class.getName());
    private static final Gson GSON = GsonUtil.createGson().create();
    public static final String TABLE_NAME = "TestTable";
    public static final String FAMILY_NAME_BASE = "info";
    public static final byte[] FAMILY_ZERO = Bytes.toBytes((String)"info0");
    public static final byte[] COLUMN_ZERO = Bytes.toBytes((String)"0");
    public static final int DEFAULT_VALUE_LENGTH = 1000;
    public static final int ROW_LENGTH = 26;
    private static final int ONE_GB = 1048576000;
    private static final int DEFAULT_ROWS_PER_GB = 0x100000;
    private static final int TAG_LENGTH = 256;
    private static final DecimalFormat FMT = new DecimalFormat("0.##");
    private static final MathContext CXT = MathContext.DECIMAL64;
    private static final BigDecimal MS_PER_SEC = BigDecimal.valueOf(1000L);
    private static final BigDecimal BYTES_PER_MB = BigDecimal.valueOf(0x100000L);
    private static final TestOptions DEFAULT_OPTS = new TestOptions();
    private static Map<String, CmdDescriptor> COMMANDS = new TreeMap<String, CmdDescriptor>();
    private static final Path PERF_EVAL_DIR = new Path("performance_evaluation");
    static String JOB_INPUT_FILENAME;

    public PerformanceEvaluation(Configuration conf) {
        super(conf);
    }

    protected static void addCommandDescriptor(Class<? extends TestBase> cmdClass, String name, String description) {
        CmdDescriptor cmdDescriptor = new CmdDescriptor(cmdClass, name, description);
        COMMANDS.put(name, cmdDescriptor);
    }

    static boolean checkTable(Admin admin, TestOptions opts) throws IOException {
        boolean isReadCmd;
        TableName tableName = TableName.valueOf((String)opts.tableName);
        boolean needsDelete = false;
        boolean exists = admin.tableExists(tableName);
        boolean bl = isReadCmd = opts.cmdName.toLowerCase(Locale.ROOT).contains("read") || opts.cmdName.toLowerCase(Locale.ROOT).contains("scan");
        if (!exists && isReadCmd) {
            throw new IllegalStateException("Must specify an existing table for read commands. Run a write command first.");
        }
        HTableDescriptor desc = exists ? admin.getTableDescriptor(TableName.valueOf((String)opts.tableName)) : null;
        byte[][] splits = PerformanceEvaluation.getSplits(opts);
        if (exists && opts.presplitRegions != PerformanceEvaluation.DEFAULT_OPTS.presplitRegions || !isReadCmd && desc != null && !StringUtils.equals((CharSequence)desc.getRegionSplitPolicyClassName(), (CharSequence)opts.splitPolicy) || !isReadCmd && desc != null && desc.getRegionReplication() != opts.replicas || desc != null && desc.getColumnFamilyCount() != opts.families) {
            needsDelete = true;
            LOG.debug(MoreObjects.toStringHelper((String)"needsDelete").add("needsDelete", needsDelete).add("isReadCmd", isReadCmd).add("exists", exists).add("desc", (Object)desc).add("presplit", opts.presplitRegions).add("splitPolicy", (Object)opts.splitPolicy).add("replicas", opts.replicas).add("families", opts.families).toString());
        }
        if (needsDelete) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
        if (!exists || needsDelete) {
            desc = PerformanceEvaluation.getTableDescriptor(opts);
            if (splits != null && LOG.isDebugEnabled()) {
                for (int i = 0; i < splits.length; ++i) {
                    LOG.debug(" split " + i + ": " + Bytes.toStringBinary((byte[])splits[i]));
                }
            }
            admin.createTable((TableDescriptor)desc, splits);
            LOG.info("Table " + desc + " created");
        }
        return admin.tableExists(tableName);
    }

    protected static HTableDescriptor getTableDescriptor(TestOptions opts) {
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)opts.tableName));
        for (int family = 0; family < opts.families; ++family) {
            byte[] familyName = Bytes.toBytes((String)(FAMILY_NAME_BASE + family));
            HColumnDescriptor familyDesc = new HColumnDescriptor(familyName);
            familyDesc.setDataBlockEncoding(opts.blockEncoding);
            familyDesc.setCompressionType(opts.compression);
            familyDesc.setBloomFilterType(opts.bloomType);
            familyDesc.setBlocksize(opts.blockSize);
            if (opts.inMemoryCF) {
                familyDesc.setInMemory(true);
            }
            familyDesc.setInMemoryCompaction(opts.inMemoryCompaction);
            tableDesc.addFamily(familyDesc);
        }
        if (opts.replicas != PerformanceEvaluation.DEFAULT_OPTS.replicas) {
            tableDesc.setRegionReplication(opts.replicas);
        }
        if (opts.splitPolicy != null && !opts.splitPolicy.equals(PerformanceEvaluation.DEFAULT_OPTS.splitPolicy)) {
            tableDesc.setRegionSplitPolicyClassName(opts.splitPolicy);
        }
        return tableDesc;
    }

    protected static byte[][] getSplits(TestOptions opts) {
        if (opts.presplitRegions == PerformanceEvaluation.DEFAULT_OPTS.presplitRegions) {
            return null;
        }
        int numSplitPoints = opts.presplitRegions - 1;
        byte[][] splits = new byte[numSplitPoints][];
        int jump = opts.totalRows / opts.presplitRegions;
        for (int i = 0; i < numSplitPoints; ++i) {
            int rowkey = jump * (1 + i);
            splits[i] = PerformanceEvaluation.format(rowkey);
        }
        return splits;
    }

    static void setupConnectionCount(TestOptions opts) {
        if (opts.oneCon) {
            opts.connCount = 1;
        } else if (opts.connCount == -1) {
            opts.connCount = opts.numClientThreads;
        }
    }

    static RunResult[] doLocalClients(final TestOptions opts, final Configuration conf) throws IOException, InterruptedException, ExecutionException {
        int i;
        final Class<? extends TestBase> cmd = PerformanceEvaluation.determineCommandClass(opts.cmdName);
        assert (cmd != null);
        Future[] threads = new Future[opts.numClientThreads];
        Object[] results = new RunResult[opts.numClientThreads];
        ExecutorService pool = Executors.newFixedThreadPool(opts.numClientThreads, new ThreadFactoryBuilder().setNameFormat("TestClient-%s").build());
        PerformanceEvaluation.setupConnectionCount(opts);
        final Connection[] cons = new Connection[opts.connCount];
        final AsyncConnection[] asyncCons = new AsyncConnection[opts.connCount];
        for (i = 0; i < opts.connCount; ++i) {
            cons[i] = ConnectionFactory.createConnection((Configuration)conf);
            asyncCons[i] = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();
        }
        LOG.info("Created " + opts.connCount + " connections for " + opts.numClientThreads + " threads");
        for (i = 0; i < threads.length; ++i) {
            final int index = i;
            threads[i] = pool.submit(new Callable<RunResult>(){

                @Override
                public RunResult call() throws Exception {
                    TestOptions threadOpts = new TestOptions(opts);
                    Connection con = cons[index % cons.length];
                    AsyncConnection asyncCon = asyncCons[index % asyncCons.length];
                    if (threadOpts.startRow == 0) {
                        threadOpts.startRow = index * threadOpts.perClientRunRows;
                    }
                    RunResult run = PerformanceEvaluation.runOneClient(cmd, conf, con, asyncCon, threadOpts, new Status(){

                        @Override
                        public void setStatus(String msg) throws IOException {
                            LOG.info(msg);
                        }
                    });
                    LOG.info("Finished " + Thread.currentThread().getName() + " in " + run.duration + "ms over " + threadOpts.perClientRunRows + " rows");
                    if (opts.latencyThreshold > 0) {
                        LOG.info("Number of replies over latency threshold " + opts.latencyThreshold + "(ms) is " + run.numbOfReplyOverThreshold);
                    }
                    return run;
                }
            });
        }
        pool.shutdown();
        for (i = 0; i < threads.length; ++i) {
            try {
                results[i] = (RunResult)threads[i].get();
                continue;
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
        }
        String test = cmd.getSimpleName();
        LOG.info("[" + test + "] Summary of timings (ms): " + Arrays.toString(results));
        Arrays.sort(results);
        long total = 0L;
        float avgLatency = 0.0f;
        float avgTPS = 0.0f;
        long replicaWins = 0L;
        for (Object result : results) {
            total += ((RunResult)result).duration;
            avgLatency = (float)((double)avgLatency + ((RunResult)result).hist.getSnapshot().getMean());
            avgTPS += (float)opts.perClientRunRows * 1.0f / (float)((RunResult)result).duration;
            replicaWins += ((RunResult)result).numOfReplyFromReplica;
        }
        LOG.info("[" + test + " duration ]\tMin: " + results[0] + "ms\tMax: " + results[results.length - 1] + "ms\tAvg: " + total / (long)results.length + "ms");
        LOG.info("[ Avg latency (us)]\t" + Math.round(avgLatency /= (float)results.length));
        LOG.info("[ Avg TPS/QPS]\t" + Math.round(avgTPS *= 1000.0f) + "\t row per second");
        if (opts.replicas > 1) {
            LOG.info("[results from replica regions] " + replicaWins);
        }
        for (int i2 = 0; i2 < opts.connCount; ++i2) {
            cons[i2].close();
            asyncCons[i2].close();
        }
        return results;
    }

    static Job doMapReduce(TestOptions opts, Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        Class<? extends TestBase> cmd = PerformanceEvaluation.determineCommandClass(opts.cmdName);
        assert (cmd != null);
        Path inputDir = PerformanceEvaluation.writeInputFile(conf, opts);
        conf.set("EvaluationMapTask.command", cmd.getName());
        conf.set("EvaluationMapTask.performanceEvalImpl", PerformanceEvaluation.class.getName());
        Job job = Job.getInstance((Configuration)conf);
        job.setJarByClass(PerformanceEvaluation.class);
        job.setJobName("HBase Performance Evaluation - " + opts.cmdName);
        job.setInputFormatClass(NLineInputFormat.class);
        NLineInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        NLineInputFormat.setNumLinesPerSplit((Job)job, (int)1);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(EvaluationMapTask.class);
        job.setReducerClass(LongSumReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(inputDir.getParent(), "outputs"));
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.addDependencyJarsForClasses((Configuration)job.getConfiguration(), (Class[])new Class[]{Histogram.class, Gson.class, FilterAllFilter.class});
        TableMapReduceUtil.initCredentials((Job)job);
        job.waitForCompletion(true);
        return job;
    }

    static Path writeInputFile(Configuration c, TestOptions opts) throws IOException {
        return PerformanceEvaluation.writeInputFile(c, opts, new Path("."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path writeInputFile(Configuration c, TestOptions opts, Path basedir) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Path jobdir = new Path(new Path(basedir, PERF_EVAL_DIR), formatter.format(new Date()));
        Path inputDir = new Path(jobdir, "inputs");
        FileSystem fs = FileSystem.get((Configuration)c);
        fs.mkdirs(inputDir);
        Path inputFile = new Path(inputDir, JOB_INPUT_FILENAME);
        PrintStream out = new PrintStream((OutputStream)fs.create(inputFile));
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        Hash h = MurmurHash.getInstance();
        int perClientRows = opts.totalRows / opts.numClientThreads;
        try {
            for (int j = 0; j < opts.numClientThreads; ++j) {
                TestOptions next = new TestOptions(opts);
                next.startRow = j * perClientRows;
                next.perClientRunRows = perClientRows;
                String s = GSON.toJson((Object)next);
                LOG.info("Client=" + j + ", input=" + s);
                byte[] b = Bytes.toBytes((String)s);
                int hash = h.hash((HashKey)new ByteArrayHashKey(b, 0, b.length), -1);
                m.put(hash, s);
            }
            for (Map.Entry e : m.entrySet()) {
                out.println((String)e.getValue());
            }
        }
        finally {
            out.close();
        }
        return inputDir;
    }

    private static String calculateMbps(int rows, long timeMs, int valueSize, int families, int columns) {
        BigDecimal rowSize = BigDecimal.valueOf(26 + (valueSize + (FAMILY_NAME_BASE.length() + 1) + COLUMN_ZERO.length) * columns * families);
        BigDecimal mbps = BigDecimal.valueOf(rows).multiply(rowSize, CXT).divide(BigDecimal.valueOf(timeMs), CXT).multiply(MS_PER_SEC, CXT).divide(BYTES_PER_MB, CXT);
        return FMT.format(mbps) + " MB/s";
    }

    public static byte[] format(int number) {
        byte[] b = new byte[26];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return b;
    }

    public static byte[] generateData(Random r, int length) {
        int i;
        byte[] b = new byte[length];
        for (i = 0; i < length - 8; i += 8) {
            b[i] = (byte)(65 + r.nextInt(26));
            b[i + 1] = b[i];
            b[i + 2] = b[i];
            b[i + 3] = b[i];
            b[i + 4] = b[i];
            b[i + 5] = b[i];
            b[i + 6] = b[i];
            b[i + 7] = b[i];
        }
        byte a = (byte)(65 + r.nextInt(26));
        while (i < length) {
            b[i] = a;
            ++i;
        }
        return b;
    }

    static byte[] getRandomRow(Random random, int totalRows) {
        return PerformanceEvaluation.format(PerformanceEvaluation.generateRandomRow(random, totalRows));
    }

    static int generateRandomRow(Random random, int totalRows) {
        return random.nextInt(Integer.MAX_VALUE) % totalRows;
    }

    static RunResult runOneClient(Class<? extends TestBase> cmd, Configuration conf, Connection con, AsyncConnection asyncCon, TestOptions opts, Status status) throws IOException, InterruptedException {
        TestBase t;
        status.setStatus("Start " + cmd + " at offset " + opts.startRow + " for " + opts.perClientRunRows + " rows");
        try {
            if (AsyncTest.class.isAssignableFrom(cmd)) {
                Class<? extends TestBase> newCmd = cmd;
                Constructor<? extends TestBase> constructor = newCmd.getDeclaredConstructor(AsyncConnection.class, TestOptions.class, Status.class);
                t = constructor.newInstance(asyncCon, opts, status);
            } else {
                Class<? extends TestBase> newCmd = cmd;
                Constructor<? extends TestBase> constructor = newCmd.getDeclaredConstructor(Connection.class, TestOptions.class, Status.class);
                t = constructor.newInstance(con, opts, status);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid command class: " + cmd.getName() + ".  It does not provide a constructor as described by the javadoc comment.  Available constructors are: " + Arrays.toString(cmd.getConstructors()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to construct command class", e);
        }
        long totalElapsedTime = t.test();
        status.setStatus("Finished " + cmd + " in " + totalElapsedTime + "ms at offset " + opts.startRow + " for " + opts.perClientRunRows + " rows (" + PerformanceEvaluation.calculateMbps((int)((float)opts.perClientRunRows * opts.sampleRate), totalElapsedTime, PerformanceEvaluation.getAverageValueLength(opts), opts.families, opts.columns) + ")");
        return new RunResult(totalElapsedTime, t.numOfReplyOverLatencyThreshold, t.numOfReplyFromReplica, t.getLatencyHistogram());
    }

    private static int getAverageValueLength(TestOptions opts) {
        return opts.valueRandom ? opts.valueSize / 2 : opts.valueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(Class<? extends TestBase> cmd, TestOptions opts) throws IOException, InterruptedException, ClassNotFoundException, ExecutionException {
        LOG.info(cmd.getSimpleName() + " test run options=" + GSON.toJson((Object)opts));
        Admin admin = null;
        Connection connection = null;
        try {
            connection = ConnectionFactory.createConnection((Configuration)this.getConf());
            admin = connection.getAdmin();
            PerformanceEvaluation.checkTable(admin, opts);
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        if (opts.nomapred) {
            PerformanceEvaluation.doLocalClients(opts, this.getConf());
        } else {
            PerformanceEvaluation.doMapReduce(opts, this.getConf());
        }
    }

    protected void printUsage() {
        PerformanceEvaluation.printUsage(PE_COMMAND_SHORTNAME, null);
    }

    protected static void printUsage(String message) {
        PerformanceEvaluation.printUsage(PE_COMMAND_SHORTNAME, message);
    }

    protected static void printUsageAndExit(String message, int exitCode) {
        PerformanceEvaluation.printUsage(message);
        System.exit(exitCode);
    }

    protected static void printUsage(String shortName, String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.print("Usage: hbase " + shortName);
        System.err.println("  <OPTIONS> [-D<property=value>]* <command> <nclients>");
        System.err.println();
        System.err.println("General Options:");
        System.err.println(" nomapred        Run multiple clients using threads (rather than use mapreduce)");
        System.err.println(" oneCon          all the threads share the same connection. Default: False");
        System.err.println(" connCount          connections all threads share. For example, if set to 2, then all thread share 2 connection. Default: depend on oneCon parameter. if oneCon set to true, then connCount=1, if not, connCount=thread number");
        System.err.println(" sampleRate      Execute test on a sample of total rows. Only supported by randomRead. Default: 1.0");
        System.err.println(" period          Report every 'period' rows: Default: opts.perClientRunRows / 10 = " + DEFAULT_OPTS.getPerClientRunRows() / 10);
        System.err.println(" cycles          How many times to cycle the test. Defaults: 1.");
        System.err.println(" traceRate       Enable HTrace spans. Initiate tracing every N rows. Default: 0");
        System.err.println(" latency         Set to report operation latencies. Default: False");
        System.err.println(" latencyThreshold  Set to report number of operations with latency over lantencyThreshold, unit in millisecond, default 0");
        System.err.println(" measureAfter    Start to measure the latency once 'measureAfter' rows have been treated. Default: 0");
        System.err.println(" valueSize       Pass value size to use: Default: " + DEFAULT_OPTS.getValueSize());
        System.err.println(" valueRandom     Set if we should vary value size between 0 and 'valueSize'; set on read for stats on size: Default: Not set.");
        System.err.println(" blockEncoding   Block encoding to use. Value should be one of " + Arrays.toString(DataBlockEncoding.values()) + ". Default: NONE");
        System.err.println();
        System.err.println("Table Creation / Write Tests:");
        System.err.println(" table           Alternate table name. Default: 'TestTable'");
        System.err.println(" rows            Rows each client runs. Default: " + DEFAULT_OPTS.getPerClientRunRows() + ".  In case of randomReads and randomSeekScans this could be specified along with --size to specify the number of rows to be scanned within the total range specified by the size.");
        System.err.println(" size            Total size in GiB. Mutually exclusive with --rows for writes and scans. But for randomReads and randomSeekScans when you use size with --rows you could use size to specify the end range and --rows specifies the number of rows within that range. Default: 1.0.");
        System.err.println(" compress        Compression type to use (GZ, LZO, ...). Default: 'NONE'");
        System.err.println(" flushCommits    Used to determine if the test should flush the table. Default: false");
        System.err.println(" valueZipf       Set if we should vary value size between 0 and 'valueSize' in zipf form: Default: Not set.");
        System.err.println(" writeToWAL      Set writeToWAL on puts. Default: True");
        System.err.println(" autoFlush       Set autoFlush on htable. Default: False");
        System.err.println(" multiPut        Batch puts together into groups of N. Only supported by write. If multiPut is bigger than 0, autoFlush need to set to true. Default: 0");
        System.err.println(" presplit        Create presplit table. If a table with same name exists, it'll be deleted and recreated (instead of verifying count of its existing regions). Recommended for accurate perf analysis (see guide). Default: disabled");
        System.err.println(" usetags         Writes tags along with KVs. Use with HFile V3. Default: false");
        System.err.println(" numoftags       Specify the no of tags that would be needed. This works only if usetags is true. Default: " + PerformanceEvaluation.DEFAULT_OPTS.noOfTags);
        System.err.println(" splitPolicy     Specify a custom RegionSplitPolicy for the table.");
        System.err.println(" columns         Columns to write per row. Default: 1");
        System.err.println(" families        Specify number of column families for the table. Default: 1");
        System.err.println();
        System.err.println("Read Tests:");
        System.err.println(" filterAll       Helps to filter out all the rows on the server side there by not returning any thing back to the client.  Helps to check the server side performance.  Uses FilterAllFilter internally. ");
        System.err.println(" multiGet        Batch gets together into groups of N. Only supported by randomRead. Default: disabled");
        System.err.println(" inmemory        Tries to keep the HFiles of the CF inmemory as far as possible. Not guaranteed that reads are always served from memory.  Default: false");
        System.err.println(" bloomFilter     Bloom filter type, one of " + Arrays.toString(BloomType.values()));
        System.err.println(" blockSize       Blocksize to use when writing out hfiles. ");
        System.err.println(" inmemoryCompaction  Makes the column family to do inmemory flushes/compactions. Uses the CompactingMemstore");
        System.err.println(" addColumns      Adds columns to scans/gets explicitly. Default: true");
        System.err.println(" replicas        Enable region replica testing. Defaults: 1.");
        System.err.println(" randomSleep     Do a random sleep before each get between 0 and entered value. Defaults: 0");
        System.err.println(" caching         Scan caching to use. Default: 30");
        System.err.println(" asyncPrefetch   Enable asyncPrefetch for scan");
        System.err.println(" cacheBlocks     Set the cacheBlocks option for scan. Default: true");
        System.err.println(" scanReadType    Set the readType option for scan, stream/pread/default. Default: default");
        System.err.println(" bufferSize      Set the value of client side buffering. Default: 2MB");
        System.err.println();
        System.err.println(" Note: -D properties will be applied to the conf used. ");
        System.err.println("  For example: ");
        System.err.println("   -Dmapreduce.output.fileoutputformat.compress=true");
        System.err.println("   -Dmapreduce.task.timeout=60000");
        System.err.println();
        System.err.println("Command:");
        for (CmdDescriptor command : COMMANDS.values()) {
            System.err.println(String.format(" %-20s %s", command.getName(), command.getDescription()));
        }
        System.err.println();
        System.err.println("Args:");
        System.err.println(" nclients        Integer. Required. Total number of clients (and HRegionServers) running. 1 <= value <= 500");
        System.err.println("Examples:");
        System.err.println(" To run a single client doing the default 1M sequentialWrites:");
        System.err.println(" $ hbase " + shortName + " sequentialWrite 1");
        System.err.println(" To run 10 clients doing increments over ten rows:");
        System.err.println(" $ hbase " + shortName + " --rows=10 --nomapred increment 10");
    }

    static TestOptions parseOpts(Queue<String> args) {
        TestOptions opts = new TestOptions();
        String cmd = null;
        while ((cmd = args.poll()) != null) {
            if (cmd.equals("-h") || cmd.startsWith("--h")) {
                args.add(cmd);
                break;
            }
            String nmr = "--nomapred";
            if (cmd.startsWith("--nomapred")) {
                opts.nomapred = true;
                continue;
            }
            String rows = "--rows=";
            if (cmd.startsWith("--rows=")) {
                opts.perClientRunRows = Integer.parseInt(cmd.substring("--rows=".length()));
                continue;
            }
            String cycles = "--cycles=";
            if (cmd.startsWith("--cycles=")) {
                opts.cycles = Integer.parseInt(cmd.substring("--cycles=".length()));
                continue;
            }
            String sampleRate = "--sampleRate=";
            if (cmd.startsWith("--sampleRate=")) {
                opts.sampleRate = Float.parseFloat(cmd.substring("--sampleRate=".length()));
                continue;
            }
            String table = "--table=";
            if (cmd.startsWith("--table=")) {
                opts.tableName = cmd.substring("--table=".length());
                continue;
            }
            String startRow = "--startRow=";
            if (cmd.startsWith("--startRow=")) {
                opts.startRow = Integer.parseInt(cmd.substring("--startRow=".length()));
                continue;
            }
            String compress = "--compress=";
            if (cmd.startsWith("--compress=")) {
                opts.compression = Compression.Algorithm.valueOf((String)cmd.substring("--compress=".length()));
                continue;
            }
            String traceRate = "--traceRate=";
            if (cmd.startsWith("--traceRate=")) {
                opts.traceRate = Double.parseDouble(cmd.substring("--traceRate=".length()));
                continue;
            }
            String blockEncoding = "--blockEncoding=";
            if (cmd.startsWith("--blockEncoding=")) {
                opts.blockEncoding = DataBlockEncoding.valueOf((String)cmd.substring("--blockEncoding=".length()));
                continue;
            }
            String flushCommits = "--flushCommits=";
            if (cmd.startsWith("--flushCommits=")) {
                opts.flushCommits = Boolean.parseBoolean(cmd.substring("--flushCommits=".length()));
                continue;
            }
            String writeToWAL = "--writeToWAL=";
            if (cmd.startsWith("--writeToWAL=")) {
                opts.writeToWAL = Boolean.parseBoolean(cmd.substring("--writeToWAL=".length()));
                continue;
            }
            String presplit = "--presplit=";
            if (cmd.startsWith("--presplit=")) {
                opts.presplitRegions = Integer.parseInt(cmd.substring("--presplit=".length()));
                continue;
            }
            String inMemory = "--inmemory=";
            if (cmd.startsWith("--inmemory=")) {
                opts.inMemoryCF = Boolean.parseBoolean(cmd.substring("--inmemory=".length()));
                continue;
            }
            String autoFlush = "--autoFlush=";
            if (cmd.startsWith("--autoFlush=")) {
                opts.autoFlush = Boolean.parseBoolean(cmd.substring("--autoFlush=".length()));
                continue;
            }
            String onceCon = "--oneCon=";
            if (cmd.startsWith("--oneCon=")) {
                opts.oneCon = Boolean.parseBoolean(cmd.substring("--oneCon=".length()));
                continue;
            }
            String connCount = "--connCount=";
            if (cmd.startsWith("--connCount=")) {
                opts.connCount = Integer.parseInt(cmd.substring("--connCount=".length()));
                continue;
            }
            String latencyThreshold = "--latencyThreshold=";
            if (cmd.startsWith("--latencyThreshold=")) {
                opts.latencyThreshold = Integer.parseInt(cmd.substring("--latencyThreshold=".length()));
                continue;
            }
            String latency = "--latency";
            if (cmd.startsWith("--latency")) {
                opts.reportLatency = true;
                continue;
            }
            String multiGet = "--multiGet=";
            if (cmd.startsWith("--multiGet=")) {
                opts.multiGet = Integer.parseInt(cmd.substring("--multiGet=".length()));
                continue;
            }
            String multiPut = "--multiPut=";
            if (cmd.startsWith("--multiPut=")) {
                opts.multiPut = Integer.parseInt(cmd.substring("--multiPut=".length()));
                continue;
            }
            String useTags = "--usetags=";
            if (cmd.startsWith("--usetags=")) {
                opts.useTags = Boolean.parseBoolean(cmd.substring("--usetags=".length()));
                continue;
            }
            String noOfTags = "--numoftags=";
            if (cmd.startsWith("--numoftags=")) {
                opts.noOfTags = Integer.parseInt(cmd.substring("--numoftags=".length()));
                continue;
            }
            String replicas = "--replicas=";
            if (cmd.startsWith("--replicas=")) {
                opts.replicas = Integer.parseInt(cmd.substring("--replicas=".length()));
                continue;
            }
            String filterOutAll = "--filterAll";
            if (cmd.startsWith("--filterAll")) {
                opts.filterAll = true;
                continue;
            }
            String size = "--size=";
            if (cmd.startsWith("--size=")) {
                opts.size = Float.parseFloat(cmd.substring("--size=".length()));
                if (!(opts.size <= 1.0f)) continue;
                throw new IllegalStateException("Size must be > 1; i.e. 1GB");
            }
            String splitPolicy = "--splitPolicy=";
            if (cmd.startsWith("--splitPolicy=")) {
                opts.splitPolicy = cmd.substring("--splitPolicy=".length());
                continue;
            }
            String randomSleep = "--randomSleep=";
            if (cmd.startsWith("--randomSleep=")) {
                opts.randomSleep = Integer.parseInt(cmd.substring("--randomSleep=".length()));
                continue;
            }
            String measureAfter = "--measureAfter=";
            if (cmd.startsWith("--measureAfter=")) {
                opts.measureAfter = Integer.parseInt(cmd.substring("--measureAfter=".length()));
                continue;
            }
            String bloomFilter = "--bloomFilter=";
            if (cmd.startsWith("--bloomFilter=")) {
                opts.bloomType = BloomType.valueOf((String)cmd.substring("--bloomFilter=".length()));
                continue;
            }
            String blockSize = "--blockSize=";
            if (cmd.startsWith("--blockSize=")) {
                opts.blockSize = Integer.parseInt(cmd.substring("--blockSize=".length()));
                continue;
            }
            String valueSize = "--valueSize=";
            if (cmd.startsWith("--valueSize=")) {
                opts.valueSize = Integer.parseInt(cmd.substring("--valueSize=".length()));
                continue;
            }
            String valueRandom = "--valueRandom";
            if (cmd.startsWith("--valueRandom")) {
                opts.valueRandom = true;
                continue;
            }
            String valueZipf = "--valueZipf";
            if (cmd.startsWith("--valueZipf")) {
                opts.valueZipf = true;
                continue;
            }
            String period = "--period=";
            if (cmd.startsWith("--period=")) {
                opts.period = Integer.parseInt(cmd.substring("--period=".length()));
                continue;
            }
            String addColumns = "--addColumns=";
            if (cmd.startsWith("--addColumns=")) {
                opts.addColumns = Boolean.parseBoolean(cmd.substring("--addColumns=".length()));
                continue;
            }
            String inMemoryCompaction = "--inmemoryCompaction=";
            if (cmd.startsWith("--inmemoryCompaction=")) {
                opts.inMemoryCompaction = MemoryCompactionPolicy.valueOf((String)cmd.substring("--inmemoryCompaction=".length()));
                continue;
            }
            String columns = "--columns=";
            if (cmd.startsWith("--columns=")) {
                opts.columns = Integer.parseInt(cmd.substring("--columns=".length()));
                continue;
            }
            String families = "--families=";
            if (cmd.startsWith("--families=")) {
                opts.families = Integer.parseInt(cmd.substring("--families=".length()));
                continue;
            }
            String caching = "--caching=";
            if (cmd.startsWith("--caching=")) {
                opts.caching = Integer.parseInt(cmd.substring("--caching=".length()));
                continue;
            }
            String asyncPrefetch = "--asyncPrefetch";
            if (cmd.startsWith("--asyncPrefetch")) {
                opts.asyncPrefetch = true;
                continue;
            }
            String cacheBlocks = "--cacheBlocks=";
            if (cmd.startsWith("--cacheBlocks=")) {
                opts.cacheBlocks = Boolean.parseBoolean(cmd.substring("--cacheBlocks=".length()));
                continue;
            }
            String scanReadType = "--scanReadType=";
            if (cmd.startsWith("--scanReadType=")) {
                opts.scanReadType = Scan.ReadType.valueOf((String)cmd.substring("--scanReadType=".length()).toUpperCase());
                continue;
            }
            String bufferSize = "--bufferSize=";
            if (cmd.startsWith("--bufferSize=")) {
                opts.bufferSize = Long.parseLong(cmd.substring("--bufferSize=".length()));
                continue;
            }
            PerformanceEvaluation.validateParsedOpts(opts);
            if (PerformanceEvaluation.isCommandClass(cmd)) {
                opts.cmdName = cmd;
                try {
                    opts.numClientThreads = Integer.parseInt(args.remove());
                }
                catch (NumberFormatException | NoSuchElementException e) {
                    throw new IllegalArgumentException("Command " + cmd + " does not have threads number", e);
                }
                opts = PerformanceEvaluation.calculateRowsAndSize(opts);
                break;
            }
            PerformanceEvaluation.printUsageAndExit("ERROR: Unrecognized option/command: " + cmd, -1);
            System.err.println("Error: Wrong option or command: " + cmd);
            args.add(cmd);
            break;
        }
        return opts;
    }

    private static void validateParsedOpts(TestOptions opts) {
        if (!opts.autoFlush && opts.multiPut > 0) {
            throw new IllegalArgumentException("autoFlush must be true when multiPut is more than 0");
        }
        if (opts.oneCon && opts.connCount > 1) {
            throw new IllegalArgumentException("oneCon is set to true, connCount should not bigger than 1");
        }
        if (opts.valueZipf && opts.valueRandom) {
            throw new IllegalStateException("Either valueZipf or valueRandom but not both");
        }
    }

    static TestOptions calculateRowsAndSize(TestOptions opts) {
        int rowsPerGB = PerformanceEvaluation.getRowsPerGB(opts);
        if (opts.getCmdName() != null && (opts.getCmdName().equals(RANDOM_READ) || opts.getCmdName().equals(RANDOM_SEEK_SCAN)) && opts.size != PerformanceEvaluation.DEFAULT_OPTS.size && opts.perClientRunRows != PerformanceEvaluation.DEFAULT_OPTS.perClientRunRows) {
            opts.totalRows = (int)opts.size * rowsPerGB;
        } else if (opts.size != PerformanceEvaluation.DEFAULT_OPTS.size) {
            opts.totalRows = (int)opts.size * rowsPerGB;
            opts.perClientRunRows = opts.totalRows / opts.numClientThreads;
        } else {
            opts.totalRows = opts.perClientRunRows * opts.numClientThreads;
            opts.size = opts.totalRows / rowsPerGB;
        }
        return opts;
    }

    static int getRowsPerGB(TestOptions opts) {
        return 1048576000 / ((opts.valueRandom ? opts.valueSize / 2 : opts.valueSize) * opts.getFamilies() * opts.getColumns());
    }

    public int run(String[] args) throws Exception {
        int errCode = -1;
        if (args.length < 1) {
            this.printUsage();
            return errCode;
        }
        try {
            LinkedList<String> argv = new LinkedList<String>();
            argv.addAll(Arrays.asList(args));
            TestOptions opts = PerformanceEvaluation.parseOpts(argv);
            if (!argv.isEmpty()) {
                errCode = 0;
                this.printUsage();
                return errCode;
            }
            if (opts.numClientThreads <= 0) {
                throw new IllegalArgumentException("Number of clients must be > 0");
            }
            if (opts.cmdName == null) {
                this.printUsage();
                return errCode;
            }
            Class<? extends TestBase> cmdClass = PerformanceEvaluation.determineCommandClass(opts.cmdName);
            if (cmdClass != null) {
                this.runTest(cmdClass, opts);
                errCode = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCode;
    }

    private static boolean isCommandClass(String cmd) {
        return COMMANDS.containsKey(cmd);
    }

    private static Class<? extends TestBase> determineCommandClass(String cmd) {
        CmdDescriptor descriptor = COMMANDS.get(cmd);
        return descriptor != null ? descriptor.getCmdClass() : null;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new PerformanceEvaluation(HBaseConfiguration.create()), (String[])args);
        System.exit(res);
    }

    static {
        PerformanceEvaluation.addCommandDescriptor(AsyncRandomReadTest.class, "asyncRandomRead", "Run async random read test");
        PerformanceEvaluation.addCommandDescriptor(AsyncRandomWriteTest.class, "asyncRandomWrite", "Run async random write test");
        PerformanceEvaluation.addCommandDescriptor(AsyncSequentialReadTest.class, "asyncSequentialRead", "Run async sequential read test");
        PerformanceEvaluation.addCommandDescriptor(AsyncSequentialWriteTest.class, "asyncSequentialWrite", "Run async sequential write test");
        PerformanceEvaluation.addCommandDescriptor(AsyncScanTest.class, "asyncScan", "Run async scan test (read every row)");
        PerformanceEvaluation.addCommandDescriptor(RandomReadTest.class, RANDOM_READ, "Run random read test");
        PerformanceEvaluation.addCommandDescriptor(MetaRandomReadTest.class, "metaRandomRead", "Run getRegionLocation test");
        PerformanceEvaluation.addCommandDescriptor(RandomSeekScanTest.class, RANDOM_SEEK_SCAN, "Run random seek and scan 100 test");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange10Test.class, "scanRange10", "Run random seek scan with both start and stop row (max 10 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange100Test.class, "scanRange100", "Run random seek scan with both start and stop row (max 100 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange1000Test.class, "scanRange1000", "Run random seek scan with both start and stop row (max 1000 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange10000Test.class, "scanRange10000", "Run random seek scan with both start and stop row (max 10000 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomWriteTest.class, "randomWrite", "Run random write test");
        PerformanceEvaluation.addCommandDescriptor(SequentialReadTest.class, "sequentialRead", "Run sequential read test");
        PerformanceEvaluation.addCommandDescriptor(SequentialWriteTest.class, "sequentialWrite", "Run sequential write test");
        PerformanceEvaluation.addCommandDescriptor(MetaWriteTest.class, "metaWrite", "Populate meta table;used with 1 thread; to be cleaned up by cleanMeta");
        PerformanceEvaluation.addCommandDescriptor(ScanTest.class, "scan", "Run scan test (read every row)");
        PerformanceEvaluation.addCommandDescriptor(FilteredScanTest.class, "filterScan", "Run scan test using a filter to find a specific row based on it's value (make sure to use --rows=20)");
        PerformanceEvaluation.addCommandDescriptor(IncrementTest.class, "increment", "Increment on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(AppendTest.class, "append", "Append on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(CheckAndMutateTest.class, "checkAndMutate", "CheckAndMutate on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(CheckAndPutTest.class, "checkAndPut", "CheckAndPut on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(CheckAndDeleteTest.class, "checkAndDelete", "CheckAndDelete on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(CleanMetaTest.class, "cleanMeta", "Remove fake region entries on meta table inserted by metaWrite; used with 1 thread");
        JOB_INPUT_FILENAME = "input.txt";
    }

    static class FilteredScanTest
    extends TableTest {
        protected static final Logger LOG = LoggerFactory.getLogger((String)FilteredScanTest.class.getName());

        FilteredScanTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
            if (this.opts.perClientRunRows == 0x100000) {
                LOG.warn("Option \"rows\" unspecified. Using default value 1048576. This could take a very long time.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean testRow(int i, long startTime) throws IOException {
            byte[] value = PerformanceEvaluation.generateData(this.rand, this.getValueLength(this.rand));
            Scan scan = this.constructScan(value);
            ResultScanner scanner = null;
            try {
                scanner = this.table.getScanner(scan);
                Result r = null;
                while ((r = scanner.next()) != null) {
                    this.updateValueSize(r);
                }
            }
            finally {
                if (scanner != null) {
                    this.updateScanMetrics(scanner.getScanMetrics());
                    scanner.close();
                }
            }
            return true;
        }

        protected Scan constructScan(byte[] valuePrefix) throws IOException {
            FilterList list = new FilterList(new Filter[0]);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY_ZERO, COLUMN_ZERO, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(valuePrefix));
            list.addFilter((Filter)filter);
            if (this.opts.filterAll) {
                list.addFilter((Filter)new FilterAllFilter());
            }
            Scan scan = new Scan().setCaching(this.opts.caching).setCacheBlocks(this.opts.cacheBlocks).setAsyncPrefetch(this.opts.asyncPrefetch).setReadType(this.opts.scanReadType).setScanMetricsEnabled(true);
            if (this.opts.addColumns) {
                for (int column = 0; column < this.opts.columns; ++column) {
                    byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                    scan.addColumn(FAMILY_ZERO, qualifier);
                }
            } else {
                scan.addFamily(FAMILY_ZERO);
            }
            scan.setFilter((Filter)list);
            return scan;
        }
    }

    static class MetaWriteTest
    extends MetaTest {
        MetaWriteTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>();
            RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)PerformanceEvaluation.TABLE_NAME)).setStartKey(this.getSplitKey(i)).setEndKey(this.getSplitKey(i + 1)).build();
            regionInfos.add(regionInfo);
            MetaTableAccessor.addRegionsToMeta((Connection)this.connection, regionInfos, (int)1);
            MetaTableAccessor.updateRegionLocation((Connection)this.connection, (RegionInfo)regionInfo, (ServerName)ServerName.valueOf((String)"localhost", (int)60010, (long)this.rand.nextLong()), (long)i, (long)System.currentTimeMillis());
            return true;
        }
    }

    static class SequentialWriteTest
    extends BufferedMutatorTest {
        private ArrayList<Put> puts;

        SequentialWriteTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
            if (this.opts.multiPut > 0) {
                LOG.info("MultiPut enabled. Sending PUTs in batches of " + this.opts.multiPut + ".");
                this.puts = new ArrayList(this.opts.multiPut);
            }
        }

        protected byte[] generateRow(int i) {
            return PerformanceEvaluation.format(i);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean testRow(int i, long startTime) throws IOException {
            byte[] row = this.generateRow(i);
            Put put = new Put(row);
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                for (int column = 0; column < this.opts.columns; ++column) {
                    byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                    byte[] value = PerformanceEvaluation.generateData(this.rand, this.getValueLength(this.rand));
                    if (this.opts.useTags) {
                        byte[] tag = PerformanceEvaluation.generateData(this.rand, 256);
                        Tag[] tags = new Tag[this.opts.noOfTags];
                        for (int n = 0; n < this.opts.noOfTags; ++n) {
                            ArrayBackedTag t = new ArrayBackedTag((byte)n, tag);
                            tags[n] = t;
                        }
                        KeyValue kv = new KeyValue(row, familyName, qualifier, Long.MAX_VALUE, value, tags);
                        put.add((Cell)kv);
                        this.updateValueSize(kv.getValueLength());
                        continue;
                    }
                    put.addColumn(familyName, qualifier, value);
                    this.updateValueSize(value.length);
                }
            }
            put.setDurability(this.opts.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            if (this.opts.autoFlush) {
                if (this.opts.multiPut > 0) {
                    this.puts.add(put);
                    if (this.puts.size() != this.opts.multiPut) return false;
                    this.table.put(this.puts);
                    this.puts.clear();
                    return true;
                } else {
                    this.table.put(put);
                }
                return true;
            } else {
                this.mutator.mutate((Mutation)put);
            }
            return true;
        }
    }

    static class SequentialReadTest
    extends TableTest {
        SequentialReadTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            Get get = new Get(PerformanceEvaluation.format(i));
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                if (this.opts.addColumns) {
                    for (int column = 0; column < this.opts.columns; ++column) {
                        byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                        get.addColumn(familyName, qualifier);
                    }
                    continue;
                }
                get.addFamily(familyName);
            }
            if (this.opts.filterAll) {
                get.setFilter((Filter)new FilterAllFilter());
            }
            this.updateValueSize(this.table.get(get));
            return true;
        }
    }

    static class CleanMetaTest
    extends MetaTest {
        CleanMetaTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            try {
                RegionInfo regionInfo = this.connection.getRegionLocator(this.table.getName()).getRegionLocation(this.getSplitKey(i), false).getRegion();
                LOG.debug("deleting region from meta: " + regionInfo);
                Delete delete = MetaTableAccessor.makeDeleteFromRegionInfo((RegionInfo)regionInfo, (long)Long.MAX_VALUE);
                try (Table t = MetaTableAccessor.getMetaHTable((Connection)this.connection);){
                    t.delete(delete);
                }
            }
            catch (IOException ie) {
                LOG.error("cannot find region with start key: " + i);
            }
            return true;
        }
    }

    static class CheckAndDeleteTest
    extends CASTableTest {
        CheckAndDeleteTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Put put = new Put(bytes);
            put.addColumn(FAMILY_ZERO, this.getQualifier(), bytes);
            this.table.put(put);
            Delete delete = new Delete(put.getRow());
            delete.addColumn(FAMILY_ZERO, this.getQualifier());
            this.table.checkAndMutate(bytes, FAMILY_ZERO).qualifier(this.getQualifier()).ifEquals(bytes).thenDelete(delete);
            return true;
        }
    }

    static class CheckAndPutTest
    extends CASTableTest {
        CheckAndPutTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Put put = new Put(bytes);
            put.addColumn(FAMILY_ZERO, this.getQualifier(), bytes);
            this.table.put(put);
            this.table.checkAndMutate(bytes, FAMILY_ZERO).qualifier(this.getQualifier()).ifEquals(bytes).thenPut(put);
            return true;
        }
    }

    static class CheckAndMutateTest
    extends CASTableTest {
        CheckAndMutateTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Put put = new Put(bytes);
            put.addColumn(FAMILY_ZERO, this.getQualifier(), bytes);
            this.table.put(put);
            RowMutations mutations = new RowMutations(bytes);
            mutations.add(put);
            this.table.checkAndMutate(bytes, FAMILY_ZERO).qualifier(this.getQualifier()).ifEquals(bytes).thenMutate(mutations);
            return true;
        }
    }

    static class AppendTest
    extends CASTableTest {
        AppendTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Append append = new Append(bytes);
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                append.addColumn(familyName, this.getQualifier(), bytes);
            }
            this.updateValueSize(this.table.append(append));
            return true;
        }
    }

    static class IncrementTest
    extends CASTableTest {
        IncrementTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            Increment increment = new Increment(PerformanceEvaluation.format(i));
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                increment.addColumn(familyName, this.getQualifier(), 1L);
            }
            this.updateValueSize(this.table.increment(increment));
            return true;
        }
    }

    static abstract class CASTableTest
    extends TableTest {
        private final byte[] qualifier = Bytes.toBytes((String)this.getClass().getSimpleName());

        CASTableTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        byte[] getQualifier() {
            return this.qualifier;
        }

        @Override
        int getStartRow() {
            return 0;
        }

        @Override
        int getLastRow() {
            return this.opts.perClientRunRows;
        }
    }

    static class ScanTest
    extends TableTest {
        private ResultScanner testScanner;

        ScanTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testTakedown() throws IOException {
            if (this.testScanner != null) {
                this.testScanner.close();
            }
            super.testTakedown();
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            if (this.testScanner == null) {
                Scan scan = new Scan().withStartRow(PerformanceEvaluation.format(this.opts.startRow)).setCaching(this.opts.caching).setCacheBlocks(this.opts.cacheBlocks).setAsyncPrefetch(this.opts.asyncPrefetch).setReadType(this.opts.scanReadType).setScanMetricsEnabled(true);
                for (int family = 0; family < this.opts.families; ++family) {
                    byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                    if (this.opts.addColumns) {
                        for (int column = 0; column < this.opts.columns; ++column) {
                            byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                            scan.addColumn(familyName, qualifier);
                        }
                        continue;
                    }
                    scan.addFamily(familyName);
                }
                if (this.opts.filterAll) {
                    scan.setFilter((Filter)new FilterAllFilter());
                }
                this.testScanner = this.table.getScanner(scan);
            }
            Result r = this.testScanner.next();
            this.updateValueSize(r);
            return true;
        }
    }

    static class RandomWriteTest
    extends SequentialWriteTest {
        RandomWriteTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected byte[] generateRow(int i) {
            return PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows);
        }
    }

    static class MetaRandomReadTest
    extends MetaTest {
        private Random rd = new Random();
        private RegionLocator regionLocator;

        MetaRandomReadTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
            LOG.info("call getRegionLocation");
        }

        @Override
        void onStartup() throws IOException {
            super.onStartup();
            this.regionLocator = this.connection.getRegionLocator(this.table.getName());
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException, InterruptedException {
            if (this.opts.randomSleep > 0) {
                Thread.sleep(this.rd.nextInt(this.opts.randomSleep));
            }
            HRegionLocation hRegionLocation = this.regionLocator.getRegionLocation(this.getSplitKey(this.rd.nextInt(this.opts.perClientRunRows)), true);
            LOG.debug("get location for region: " + hRegionLocation);
            return true;
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 10;
            return period == 0 ? this.opts.perClientRunRows : period;
        }

        @Override
        protected void testTakedown() throws IOException {
            super.testTakedown();
        }
    }

    static class RandomReadTest
    extends TableTest {
        private final Consistency consistency;
        private ArrayList<Get> gets;
        private Random rd = new Random();
        private long numOfReplyFromReplica = 0L;

        RandomReadTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
            Consistency consistency = this.consistency = options.replicas == DEFAULT_OPTS.replicas ? null : Consistency.TIMELINE;
            if (this.opts.multiGet > 0) {
                LOG.info("MultiGet enabled. Sending GETs in batches of " + this.opts.multiGet + ".");
                this.gets = new ArrayList(this.opts.multiGet);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean testRow(int i, long startTime) throws IOException, InterruptedException {
            if (this.opts.randomSleep > 0) {
                Thread.sleep(this.rd.nextInt(this.opts.randomSleep));
            }
            Get get = new Get(PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows));
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                if (this.opts.addColumns) {
                    for (int column = 0; column < this.opts.columns; ++column) {
                        byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                        get.addColumn(familyName, qualifier);
                    }
                    continue;
                }
                get.addFamily(familyName);
            }
            if (this.opts.filterAll) {
                get.setFilter((Filter)new FilterAllFilter());
            }
            get.setConsistency(this.consistency);
            if (LOG.isTraceEnabled()) {
                LOG.trace(get.toString());
            }
            if (this.opts.multiGet > 0) {
                this.gets.add(get);
                if (this.gets.size() != this.opts.multiGet) return false;
                Result[] rs = this.table.get(this.gets);
                if (this.opts.replicas > 1) {
                    long latency = System.nanoTime() - startTime;
                    this.updateValueSize(rs, latency);
                } else {
                    this.updateValueSize(rs);
                }
                this.gets.clear();
                return true;
            } else if (this.opts.replicas > 1) {
                Result r = this.table.get(get);
                long latency = System.nanoTime() - startTime;
                this.updateValueSize(r, latency);
                return true;
            } else {
                this.updateValueSize(this.table.get(get));
            }
            return true;
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 10;
            return period == 0 ? this.opts.perClientRunRows : period;
        }

        @Override
        protected void testTakedown() throws IOException {
            if (this.gets != null && this.gets.size() > 0) {
                this.table.get(this.gets);
                this.gets.clear();
            }
            super.testTakedown();
        }
    }

    static class RandomScanWithRange10000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10000Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10000);
        }
    }

    static class RandomScanWithRange1000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange1000Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(1000);
        }
    }

    static class RandomScanWithRange100Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange100Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(100);
        }
    }

    static class RandomScanWithRange10Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10);
        }
    }

    static abstract class RandomScanWithRangeTest
    extends TableTest {
        RandomScanWithRangeTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean testRow(int i, long startTime) throws IOException {
            Pair<byte[], byte[]> startAndStopRow = this.getStartAndStopRow();
            Scan scan = new Scan().withStartRow((byte[])startAndStopRow.getFirst()).withStopRow((byte[])startAndStopRow.getSecond()).setCaching(this.opts.caching).setCacheBlocks(this.opts.cacheBlocks).setAsyncPrefetch(this.opts.asyncPrefetch).setReadType(this.opts.scanReadType).setScanMetricsEnabled(true);
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                if (this.opts.addColumns) {
                    for (int column = 0; column < this.opts.columns; ++column) {
                        byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                        scan.addColumn(familyName, qualifier);
                    }
                    continue;
                }
                scan.addFamily(familyName);
            }
            if (this.opts.filterAll) {
                scan.setFilter((Filter)new FilterAllFilter());
            }
            Result r = null;
            int count = 0;
            ResultScanner s = this.table.getScanner(scan);
            try {
                while ((r = s.next()) != null) {
                    this.updateValueSize(r);
                    ++count;
                }
                if (i % 100 == 0) {
                    LOG.info(String.format("Scan for key range %s - %s returned %s rows", Bytes.toString((byte[])((byte[])startAndStopRow.getFirst())), Bytes.toString((byte[])((byte[])startAndStopRow.getSecond())), count));
                }
            }
            finally {
                this.updateScanMetrics(s.getScanMetrics());
                s.close();
            }
            return true;
        }

        protected abstract Pair<byte[], byte[]> getStartAndStopRow();

        protected Pair<byte[], byte[]> generateStartAndStopRows(int maxRange) {
            int start = this.rand.nextInt(Integer.MAX_VALUE) % this.opts.totalRows;
            int stop = start + maxRange;
            return new Pair((Object)PerformanceEvaluation.format(start), (Object)PerformanceEvaluation.format(stop));
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 100;
            return period == 0 ? this.opts.perClientRunRows : period;
        }
    }

    static class RandomSeekScanTest
    extends TableTest {
        RandomSeekScanTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean testRow(int i, long startTime) throws IOException {
            Scan scan = new Scan().withStartRow(PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows)).setCaching(this.opts.caching).setCacheBlocks(this.opts.cacheBlocks).setAsyncPrefetch(this.opts.asyncPrefetch).setReadType(this.opts.scanReadType).setScanMetricsEnabled(true);
            FilterList list = new FilterList(new Filter[0]);
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                if (this.opts.addColumns) {
                    for (int column = 0; column < this.opts.columns; ++column) {
                        byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                        scan.addColumn(familyName, qualifier);
                    }
                    continue;
                }
                scan.addFamily(familyName);
            }
            if (this.opts.filterAll) {
                list.addFilter((Filter)new FilterAllFilter());
            }
            list.addFilter((Filter)new WhileMatchFilter((Filter)new PageFilter(120L)));
            scan.setFilter((Filter)list);
            ResultScanner s = this.table.getScanner(scan);
            try {
                Result rr;
                while ((rr = s.next()) != null) {
                    this.updateValueSize(rr);
                }
            }
            finally {
                this.updateScanMetrics(s.getScanMetrics());
                s.close();
            }
            return true;
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 100;
            return period == 0 ? this.opts.perClientRunRows : period;
        }
    }

    static abstract class BufferedMutatorTest
    extends Test {
        protected BufferedMutator mutator;
        protected Table table;

        BufferedMutatorTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void onStartup() throws IOException {
            BufferedMutatorParams p = new BufferedMutatorParams(TableName.valueOf((String)this.opts.tableName));
            p.writeBufferSize(this.opts.bufferSize);
            this.mutator = this.connection.getBufferedMutator(p);
            this.table = this.connection.getTable(TableName.valueOf((String)this.opts.tableName));
        }

        @Override
        void onTakedown() throws IOException {
            this.mutator.close();
            this.table.close();
        }
    }

    static class AsyncSequentialWriteTest
    extends AsyncTableTest {
        private ArrayList<Put> puts;

        AsyncSequentialWriteTest(AsyncConnection con, TestOptions options, Status status) {
            super(con, options, status);
            if (this.opts.multiPut > 0) {
                LOG.info("MultiPut enabled. Sending PUTs in batches of " + this.opts.multiPut + ".");
                this.puts = new ArrayList(this.opts.multiPut);
            }
        }

        protected byte[] generateRow(int i) {
            return PerformanceEvaluation.format(i);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean testRow(int i, long startTime) throws IOException, InterruptedException {
            byte[] row = this.generateRow(i);
            Put put = new Put(row);
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                for (int column = 0; column < this.opts.columns; ++column) {
                    byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                    byte[] value = PerformanceEvaluation.generateData(this.rand, this.getValueLength(this.rand));
                    if (this.opts.useTags) {
                        byte[] tag = PerformanceEvaluation.generateData(this.rand, 256);
                        Tag[] tags = new Tag[this.opts.noOfTags];
                        for (int n = 0; n < this.opts.noOfTags; ++n) {
                            ArrayBackedTag t = new ArrayBackedTag((byte)n, tag);
                            tags[n] = t;
                        }
                        KeyValue kv = new KeyValue(row, familyName, qualifier, Long.MAX_VALUE, value, tags);
                        put.add((Cell)kv);
                        this.updateValueSize(kv.getValueLength());
                        continue;
                    }
                    put.addColumn(familyName, qualifier, value);
                    this.updateValueSize(value.length);
                }
            }
            put.setDurability(this.opts.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            try {
                this.table.put(put).get();
                if (this.opts.multiPut > 0) {
                    this.puts.add(put);
                    if (this.puts.size() != this.opts.multiPut) return false;
                    this.table.put(this.puts).stream().map(f -> AsyncRandomReadTest.propagate(f::get));
                    this.puts.clear();
                    return true;
                } else {
                    this.table.put(put).get();
                }
                return true;
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    static class AsyncSequentialReadTest
    extends AsyncTableTest {
        AsyncSequentialReadTest(AsyncConnection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException, InterruptedException {
            Get get = new Get(PerformanceEvaluation.format(i));
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                if (this.opts.addColumns) {
                    for (int column = 0; column < this.opts.columns; ++column) {
                        byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                        get.addColumn(familyName, qualifier);
                    }
                    continue;
                }
                get.addFamily(familyName);
            }
            if (this.opts.filterAll) {
                get.setFilter((Filter)new FilterAllFilter());
            }
            try {
                this.updateValueSize((Result)this.table.get(get).get());
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
            return true;
        }
    }

    static class AsyncScanTest
    extends AsyncTableTest {
        private ResultScanner testScanner;
        private AsyncTable<?> asyncTable;

        AsyncScanTest(AsyncConnection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void onStartup() throws IOException {
            this.asyncTable = this.connection.getTable(TableName.valueOf((String)this.opts.tableName), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        }

        @Override
        void testTakedown() throws IOException {
            if (this.testScanner != null) {
                this.updateScanMetrics(this.testScanner.getScanMetrics());
                this.testScanner.close();
            }
            super.testTakedown();
        }

        @Override
        boolean testRow(int i, long startTime) throws IOException {
            if (this.testScanner == null) {
                Scan scan = new Scan().withStartRow(PerformanceEvaluation.format(this.opts.startRow)).setCaching(this.opts.caching).setCacheBlocks(this.opts.cacheBlocks).setAsyncPrefetch(this.opts.asyncPrefetch).setReadType(this.opts.scanReadType).setScanMetricsEnabled(true);
                for (int family = 0; family < this.opts.families; ++family) {
                    byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                    if (this.opts.addColumns) {
                        for (int column = 0; column < this.opts.columns; ++column) {
                            byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                            scan.addColumn(familyName, qualifier);
                        }
                        continue;
                    }
                    scan.addFamily(familyName);
                }
                if (this.opts.filterAll) {
                    scan.setFilter((Filter)new FilterAllFilter());
                }
                this.testScanner = this.asyncTable.getScanner(scan);
            }
            Result r = this.testScanner.next();
            this.updateValueSize(r);
            return true;
        }
    }

    static class AsyncRandomWriteTest
    extends AsyncSequentialWriteTest {
        AsyncRandomWriteTest(AsyncConnection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected byte[] generateRow(int i) {
            return PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows);
        }
    }

    static class AsyncRandomReadTest
    extends AsyncTableTest {
        private final Consistency consistency;
        private ArrayList<Get> gets;
        private Random rd = new Random();

        AsyncRandomReadTest(AsyncConnection con, TestOptions options, Status status) {
            super(con, options, status);
            Consistency consistency = this.consistency = options.replicas == DEFAULT_OPTS.replicas ? null : Consistency.TIMELINE;
            if (this.opts.multiGet > 0) {
                LOG.info("MultiGet enabled. Sending GETs in batches of " + this.opts.multiGet + ".");
                this.gets = new ArrayList(this.opts.multiGet);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean testRow(int i, long startTime) throws IOException, InterruptedException {
            if (this.opts.randomSleep > 0) {
                Thread.sleep(this.rd.nextInt(this.opts.randomSleep));
            }
            Get get = new Get(PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows));
            for (int family = 0; family < this.opts.families; ++family) {
                byte[] familyName = Bytes.toBytes((String)(PerformanceEvaluation.FAMILY_NAME_BASE + family));
                if (this.opts.addColumns) {
                    for (int column = 0; column < this.opts.columns; ++column) {
                        byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                        get.addColumn(familyName, qualifier);
                    }
                    continue;
                }
                get.addFamily(familyName);
            }
            if (this.opts.filterAll) {
                get.setFilter((Filter)new FilterAllFilter());
            }
            get.setConsistency(this.consistency);
            if (LOG.isTraceEnabled()) {
                LOG.trace(get.toString());
            }
            try {
                if (this.opts.multiGet > 0) {
                    this.gets.add(get);
                    if (this.gets.size() != this.opts.multiGet) return false;
                    Result[] rs = (Result[])this.table.get(this.gets).stream().map(f -> AsyncRandomReadTest.propagate(f::get)).toArray(Result[]::new);
                    this.updateValueSize(rs);
                    this.gets.clear();
                    return true;
                } else {
                    this.updateValueSize((Result)this.table.get(get).get());
                }
                return true;
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }

        public static RuntimeException runtime(Throwable e) {
            if (e instanceof RuntimeException) {
                return (RuntimeException)e;
            }
            return new RuntimeException(e);
        }

        public static <V> V propagate(Callable<V> callable) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw AsyncRandomReadTest.runtime(e);
            }
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 10;
            return period == 0 ? this.opts.perClientRunRows : period;
        }

        @Override
        protected void testTakedown() throws IOException {
            if (this.gets != null && this.gets.size() > 0) {
                this.table.get(this.gets);
                this.gets.clear();
            }
            super.testTakedown();
        }
    }

    static abstract class AsyncTableTest
    extends AsyncTest {
        protected AsyncTable<?> table;

        AsyncTableTest(AsyncConnection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void onStartup() throws IOException {
            this.table = this.connection.getTable(TableName.valueOf((String)this.opts.tableName));
        }

        @Override
        void onTakedown() throws IOException {
        }
    }

    static abstract class MetaTest
    extends TableTest {
        protected int keyLength;

        MetaTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
            this.keyLength = Integer.toString(this.opts.perClientRunRows).length();
        }

        @Override
        void onTakedown() throws IOException {
        }

        protected byte[] getSplitKey(int i) {
            return Bytes.toBytes((String)String.format("%0" + this.keyLength + "d", i));
        }
    }

    static abstract class TableTest
    extends Test {
        protected Table table;

        TableTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void onStartup() throws IOException {
            this.table = this.connection.getTable(TableName.valueOf((String)this.opts.tableName));
        }

        @Override
        void onTakedown() throws IOException {
            this.table.close();
        }
    }

    static abstract class AsyncTest
    extends TestBase {
        protected AsyncConnection connection;

        AsyncTest(AsyncConnection con, TestOptions options, Status status) {
            super(con == null ? HBaseConfiguration.create() : con.getConfiguration(), options, status);
            this.connection = con;
        }
    }

    static abstract class Test
    extends TestBase {
        protected Connection connection;

        Test(Connection con, TestOptions options, Status status) {
            super(con == null ? HBaseConfiguration.create() : con.getConfiguration(), options, status);
            this.connection = con;
        }
    }

    static abstract class TestBase {
        private static final Random randomSeed = new Random(System.currentTimeMillis());
        private final int everyN;
        protected final Random rand = new Random(TestBase.nextRandomSeed());
        protected final Configuration conf;
        protected final TestOptions opts;
        private final Status status;
        private final Sampler traceSampler;
        private final SpanReceiverHost receiverHost;
        private String testName;
        private Histogram latencyHistogram;
        private Histogram replicaLatencyHistogram;
        private Histogram valueSizeHistogram;
        private Histogram rpcCallsHistogram;
        private Histogram remoteRpcCallsHistogram;
        private Histogram millisBetweenNextHistogram;
        private Histogram regionsScannedHistogram;
        private Histogram bytesInResultsHistogram;
        private Histogram bytesInRemoteResultsHistogram;
        private RandomDistribution.Zipf zipf;
        private long numOfReplyOverLatencyThreshold = 0L;
        private long numOfReplyFromReplica = 0L;

        private static long nextRandomSeed() {
            return randomSeed.nextLong();
        }

        TestBase(Configuration conf, TestOptions options, Status status) {
            this.conf = conf;
            this.receiverHost = this.conf == null ? null : SpanReceiverHost.getInstance((Configuration)conf);
            this.opts = options;
            this.status = status;
            this.testName = this.getClass().getSimpleName();
            if (options.traceRate >= 1.0) {
                this.traceSampler = Sampler.ALWAYS;
            } else if (options.traceRate > 0.0) {
                conf.setDouble("hbase.sampler.fraction", options.traceRate);
                this.traceSampler = new ProbabilitySampler((HTraceConfiguration)new HBaseHTraceConfiguration(conf));
            } else {
                this.traceSampler = Sampler.NEVER;
            }
            this.everyN = (int)((float)this.opts.totalRows / ((float)this.opts.totalRows * this.opts.sampleRate));
            if (options.isValueZipf()) {
                this.zipf = new RandomDistribution.Zipf(this.rand, 1, options.getValueSize(), 1.2);
            }
            LOG.info("Sampling 1 every " + this.everyN + " out of " + this.opts.perClientRunRows + " total rows.");
        }

        int getValueLength(Random r) {
            if (this.opts.isValueRandom()) {
                return r.nextInt(this.opts.valueSize);
            }
            if (this.opts.isValueZipf()) {
                return Math.abs(this.zipf.nextInt());
            }
            return this.opts.valueSize;
        }

        void updateValueSize(Result[] rs) throws IOException {
            this.updateValueSize(rs, 0L);
        }

        void updateValueSize(Result[] rs, long latency) throws IOException {
            if (rs == null || latency == 0L) {
                return;
            }
            for (Result r : rs) {
                this.updateValueSize(r, latency);
            }
        }

        void updateValueSize(Result r) throws IOException {
            this.updateValueSize(r, 0L);
        }

        void updateValueSize(Result r, long latency) throws IOException {
            if (r == null || latency == 0L) {
                return;
            }
            int size = 0;
            if (r.isStale()) {
                this.replicaLatencyHistogram.update(latency / 1000L);
                ++this.numOfReplyFromReplica;
            }
            if (!this.isRandomValueSize()) {
                return;
            }
            CellScanner scanner = r.cellScanner();
            while (scanner.advance()) {
                size += scanner.current().getValueLength();
            }
            this.updateValueSize(size);
        }

        void updateValueSize(int valueSize) {
            if (!this.isRandomValueSize()) {
                return;
            }
            this.valueSizeHistogram.update(valueSize);
        }

        void updateScanMetrics(ScanMetrics metrics) {
            Long bytesInRemoteResults;
            Long bytesInResults;
            Long regionsScanned;
            Long millisBetweenNext;
            Long remoteRpcCalls;
            if (metrics == null) {
                return;
            }
            Map metricsMap = metrics.getMetricsMap();
            Long rpcCalls = (Long)metricsMap.get("RPC_CALLS");
            if (rpcCalls != null) {
                this.rpcCallsHistogram.update(rpcCalls.longValue());
            }
            if ((remoteRpcCalls = (Long)metricsMap.get("REMOTE_RPC_CALLS")) != null) {
                this.remoteRpcCallsHistogram.update(remoteRpcCalls.longValue());
            }
            if ((millisBetweenNext = (Long)metricsMap.get("MILLIS_BETWEEN_NEXTS")) != null) {
                this.millisBetweenNextHistogram.update(millisBetweenNext.longValue());
            }
            if ((regionsScanned = (Long)metricsMap.get("REGIONS_SCANNED")) != null) {
                this.regionsScannedHistogram.update(regionsScanned.longValue());
            }
            if ((bytesInResults = (Long)metricsMap.get("BYTES_IN_RESULTS")) != null && bytesInResults > 0L) {
                this.bytesInResultsHistogram.update(bytesInResults.longValue());
            }
            if ((bytesInRemoteResults = (Long)metricsMap.get("BYTES_IN_REMOTE_RESULTS")) != null && bytesInRemoteResults > 0L) {
                this.bytesInRemoteResultsHistogram.update(bytesInRemoteResults.longValue());
            }
        }

        String generateStatus(int sr, int i, int lr) {
            return sr + "/" + i + "/" + lr + ", latency " + this.getShortLatencyReport() + (!this.isRandomValueSize() ? "" : ", value size " + this.getShortValueSizeReport());
        }

        boolean isRandomValueSize() {
            return this.opts.valueRandom;
        }

        protected int getReportingPeriod() {
            return this.opts.period;
        }

        public Histogram getLatencyHistogram() {
            return this.latencyHistogram;
        }

        void testSetup() throws IOException {
            this.latencyHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            if (this.opts.replicas > 1) {
                this.replicaLatencyHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            }
            this.valueSizeHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            this.rpcCallsHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            this.remoteRpcCallsHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            this.millisBetweenNextHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            this.regionsScannedHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            this.bytesInResultsHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            this.bytesInRemoteResultsHistogram = YammerHistogramUtils.newHistogram((Reservoir)new UniformReservoir(512000));
            this.onStartup();
        }

        abstract void onStartup() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void testTakedown() throws IOException {
            this.onTakedown();
            Class<Test> clazz = Test.class;
            synchronized (Test.class) {
                this.status.setStatus("Test : " + this.testName + ", Thread : " + Thread.currentThread().getName());
                this.status.setStatus("Latency (us) : " + YammerHistogramUtils.getHistogramReport((Histogram)this.latencyHistogram));
                if (this.opts.replicas > 1) {
                    this.status.setStatus("Latency (us) from Replica Regions: " + YammerHistogramUtils.getHistogramReport((Histogram)this.replicaLatencyHistogram));
                }
                this.status.setStatus("Num measures (latency) : " + this.latencyHistogram.getCount());
                this.status.setStatus(YammerHistogramUtils.getPrettyHistogramReport((Histogram)this.latencyHistogram));
                if (this.valueSizeHistogram.getCount() > 0L) {
                    this.status.setStatus("ValueSize (bytes) : " + YammerHistogramUtils.getHistogramReport((Histogram)this.valueSizeHistogram));
                    this.status.setStatus("Num measures (ValueSize): " + this.valueSizeHistogram.getCount());
                    this.status.setStatus(YammerHistogramUtils.getPrettyHistogramReport((Histogram)this.valueSizeHistogram));
                } else {
                    this.status.setStatus("No valueSize statistics available");
                }
                if (this.rpcCallsHistogram.getCount() > 0L) {
                    this.status.setStatus("rpcCalls (count): " + YammerHistogramUtils.getHistogramReport((Histogram)this.rpcCallsHistogram));
                }
                if (this.remoteRpcCallsHistogram.getCount() > 0L) {
                    this.status.setStatus("remoteRpcCalls (count): " + YammerHistogramUtils.getHistogramReport((Histogram)this.remoteRpcCallsHistogram));
                }
                if (this.millisBetweenNextHistogram.getCount() > 0L) {
                    this.status.setStatus("millisBetweenNext (latency): " + YammerHistogramUtils.getHistogramReport((Histogram)this.millisBetweenNextHistogram));
                }
                if (this.regionsScannedHistogram.getCount() > 0L) {
                    this.status.setStatus("regionsScanned (count): " + YammerHistogramUtils.getHistogramReport((Histogram)this.regionsScannedHistogram));
                }
                if (this.bytesInResultsHistogram.getCount() > 0L) {
                    this.status.setStatus("bytesInResults (size): " + YammerHistogramUtils.getHistogramReport((Histogram)this.bytesInResultsHistogram));
                }
                if (this.bytesInRemoteResultsHistogram.getCount() > 0L) {
                    this.status.setStatus("bytesInRemoteResults (size): " + YammerHistogramUtils.getHistogramReport((Histogram)this.bytesInRemoteResultsHistogram));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.receiverHost.closeReceivers();
                return;
            }
        }

        abstract void onTakedown() throws IOException;

        long test() throws IOException, InterruptedException {
            this.testSetup();
            LOG.info("Timed test starting in thread " + Thread.currentThread().getName());
            long startTime = System.nanoTime();
            try {
                this.testTimed();
            }
            finally {
                this.testTakedown();
            }
            return (System.nanoTime() - startTime) / 1000000L;
        }

        int getStartRow() {
            return this.opts.startRow;
        }

        int getLastRow() {
            return this.getStartRow() + this.opts.perClientRunRows;
        }

        void testTimed() throws IOException, InterruptedException {
            int startRow = this.getStartRow();
            int lastRow = this.getLastRow();
            TraceUtil.addSampler((Sampler)this.traceSampler);
            for (int ii = 0; ii < this.opts.cycles; ++ii) {
                if (this.opts.cycles > 1) {
                    LOG.info("Cycle=" + ii + " of " + this.opts.cycles);
                }
                for (int i = startRow; i < lastRow; ++i) {
                    if (i % this.everyN != 0) continue;
                    long startTime = System.nanoTime();
                    boolean requestSent = false;
                    try (TraceScope scope = TraceUtil.createTrace((String)"test row");){
                        requestSent = this.testRow(i, startTime);
                    }
                    if (i - startRow <= this.opts.measureAfter) continue;
                    if (requestSent) {
                        long latency = (System.nanoTime() - startTime) / 1000L;
                        this.latencyHistogram.update(latency);
                        if (this.opts.latencyThreshold > 0 && latency / 1000L >= (long)this.opts.latencyThreshold) {
                            ++this.numOfReplyOverLatencyThreshold;
                        }
                    }
                    if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                    this.status.setStatus(this.generateStatus(startRow, i, lastRow));
                }
            }
        }

        public String getShortLatencyReport() {
            return YammerHistogramUtils.getShortHistogramReport((Histogram)this.latencyHistogram);
        }

        public String getShortValueSizeReport() {
            return YammerHistogramUtils.getShortHistogramReport((Histogram)this.valueSizeHistogram);
        }

        abstract boolean testRow(int var1, long var2) throws IOException, InterruptedException;
    }

    static class TestOptions {
        String cmdName = null;
        boolean nomapred = false;
        boolean filterAll = false;
        int startRow = 0;
        float size = 1.0f;
        int perClientRunRows = 0x100000;
        int numClientThreads = 1;
        int totalRows = 0x100000;
        int measureAfter = 0;
        float sampleRate = 1.0f;
        double traceRate = 0.0;
        String tableName = "TestTable";
        boolean flushCommits = true;
        boolean writeToWAL = true;
        boolean autoFlush = false;
        boolean oneCon = false;
        int connCount = -1;
        boolean useTags = false;
        int noOfTags = 1;
        boolean reportLatency = false;
        int multiGet = 0;
        int multiPut = 0;
        int randomSleep = 0;
        boolean inMemoryCF = false;
        int presplitRegions = 0;
        int replicas = 1;
        String splitPolicy = null;
        Compression.Algorithm compression = Compression.Algorithm.NONE;
        BloomType bloomType = BloomType.ROW;
        int blockSize = 65536;
        DataBlockEncoding blockEncoding = DataBlockEncoding.NONE;
        boolean valueRandom = false;
        boolean valueZipf = false;
        int valueSize = 1000;
        int period = this.perClientRunRows / 10 == 0 ? this.perClientRunRows : this.perClientRunRows / 10;
        int cycles = 1;
        int columns = 1;
        int families = 1;
        int caching = 30;
        int latencyThreshold = 0;
        boolean addColumns = true;
        MemoryCompactionPolicy inMemoryCompaction = MemoryCompactionPolicy.valueOf((String)CompactingMemStore.COMPACTING_MEMSTORE_TYPE_DEFAULT);
        boolean asyncPrefetch = false;
        boolean cacheBlocks = true;
        Scan.ReadType scanReadType = Scan.ReadType.DEFAULT;
        long bufferSize = 0x200000L;

        public TestOptions() {
        }

        public TestOptions(TestOptions that) {
            this.cmdName = that.cmdName;
            this.cycles = that.cycles;
            this.nomapred = that.nomapred;
            this.startRow = that.startRow;
            this.size = that.size;
            this.perClientRunRows = that.perClientRunRows;
            this.numClientThreads = that.numClientThreads;
            this.totalRows = that.totalRows;
            this.sampleRate = that.sampleRate;
            this.traceRate = that.traceRate;
            this.tableName = that.tableName;
            this.flushCommits = that.flushCommits;
            this.writeToWAL = that.writeToWAL;
            this.autoFlush = that.autoFlush;
            this.oneCon = that.oneCon;
            this.connCount = that.connCount;
            this.useTags = that.useTags;
            this.noOfTags = that.noOfTags;
            this.reportLatency = that.reportLatency;
            this.latencyThreshold = that.latencyThreshold;
            this.multiGet = that.multiGet;
            this.multiPut = that.multiPut;
            this.inMemoryCF = that.inMemoryCF;
            this.presplitRegions = that.presplitRegions;
            this.replicas = that.replicas;
            this.splitPolicy = that.splitPolicy;
            this.compression = that.compression;
            this.blockEncoding = that.blockEncoding;
            this.filterAll = that.filterAll;
            this.bloomType = that.bloomType;
            this.blockSize = that.blockSize;
            this.valueRandom = that.valueRandom;
            this.valueZipf = that.valueZipf;
            this.valueSize = that.valueSize;
            this.period = that.period;
            this.randomSleep = that.randomSleep;
            this.measureAfter = that.measureAfter;
            this.addColumns = that.addColumns;
            this.columns = that.columns;
            this.families = that.families;
            this.caching = that.caching;
            this.inMemoryCompaction = that.inMemoryCompaction;
            this.asyncPrefetch = that.asyncPrefetch;
            this.cacheBlocks = that.cacheBlocks;
            this.scanReadType = that.scanReadType;
            this.bufferSize = that.bufferSize;
        }

        public int getCaching() {
            return this.caching;
        }

        public void setCaching(int caching) {
            this.caching = caching;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public int getFamilies() {
            return this.families;
        }

        public void setFamilies(int families) {
            this.families = families;
        }

        public int getCycles() {
            return this.cycles;
        }

        public void setCycles(int cycles) {
            this.cycles = cycles;
        }

        public boolean isValueZipf() {
            return this.valueZipf;
        }

        public void setValueZipf(boolean valueZipf) {
            this.valueZipf = valueZipf;
        }

        public String getCmdName() {
            return this.cmdName;
        }

        public void setCmdName(String cmdName) {
            this.cmdName = cmdName;
        }

        public int getRandomSleep() {
            return this.randomSleep;
        }

        public void setRandomSleep(int randomSleep) {
            this.randomSleep = randomSleep;
        }

        public int getReplicas() {
            return this.replicas;
        }

        public void setReplicas(int replicas) {
            this.replicas = replicas;
        }

        public String getSplitPolicy() {
            return this.splitPolicy;
        }

        public void setSplitPolicy(String splitPolicy) {
            this.splitPolicy = splitPolicy;
        }

        public void setNomapred(boolean nomapred) {
            this.nomapred = nomapred;
        }

        public void setFilterAll(boolean filterAll) {
            this.filterAll = filterAll;
        }

        public void setStartRow(int startRow) {
            this.startRow = startRow;
        }

        public void setSize(float size) {
            this.size = size;
        }

        public void setPerClientRunRows(int perClientRunRows) {
            this.perClientRunRows = perClientRunRows;
        }

        public void setNumClientThreads(int numClientThreads) {
            this.numClientThreads = numClientThreads;
        }

        public void setTotalRows(int totalRows) {
            this.totalRows = totalRows;
        }

        public void setSampleRate(float sampleRate) {
            this.sampleRate = sampleRate;
        }

        public void setTraceRate(double traceRate) {
            this.traceRate = traceRate;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setFlushCommits(boolean flushCommits) {
            this.flushCommits = flushCommits;
        }

        public void setWriteToWAL(boolean writeToWAL) {
            this.writeToWAL = writeToWAL;
        }

        public void setAutoFlush(boolean autoFlush) {
            this.autoFlush = autoFlush;
        }

        public void setOneCon(boolean oneCon) {
            this.oneCon = oneCon;
        }

        public int getConnCount() {
            return this.connCount;
        }

        public void setConnCount(int connCount) {
            this.connCount = connCount;
        }

        public void setUseTags(boolean useTags) {
            this.useTags = useTags;
        }

        public void setNoOfTags(int noOfTags) {
            this.noOfTags = noOfTags;
        }

        public void setReportLatency(boolean reportLatency) {
            this.reportLatency = reportLatency;
        }

        public void setMultiGet(int multiGet) {
            this.multiGet = multiGet;
        }

        public void setMultiPut(int multiPut) {
            this.multiPut = multiPut;
        }

        public void setInMemoryCF(boolean inMemoryCF) {
            this.inMemoryCF = inMemoryCF;
        }

        public void setPresplitRegions(int presplitRegions) {
            this.presplitRegions = presplitRegions;
        }

        public void setCompression(Compression.Algorithm compression) {
            this.compression = compression;
        }

        public void setBloomType(BloomType bloomType) {
            this.bloomType = bloomType;
        }

        public void setBlockSize(int blockSize) {
            this.blockSize = blockSize;
        }

        public void setBlockEncoding(DataBlockEncoding blockEncoding) {
            this.blockEncoding = blockEncoding;
        }

        public void setValueRandom(boolean valueRandom) {
            this.valueRandom = valueRandom;
        }

        public void setValueSize(int valueSize) {
            this.valueSize = valueSize;
        }

        public void setBufferSize(long bufferSize) {
            this.bufferSize = bufferSize;
        }

        public void setPeriod(int period) {
            this.period = period;
        }

        public boolean isNomapred() {
            return this.nomapred;
        }

        public boolean isFilterAll() {
            return this.filterAll;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public float getSize() {
            return this.size;
        }

        public int getPerClientRunRows() {
            return this.perClientRunRows;
        }

        public int getNumClientThreads() {
            return this.numClientThreads;
        }

        public int getTotalRows() {
            return this.totalRows;
        }

        public float getSampleRate() {
            return this.sampleRate;
        }

        public double getTraceRate() {
            return this.traceRate;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean isFlushCommits() {
            return this.flushCommits;
        }

        public boolean isWriteToWAL() {
            return this.writeToWAL;
        }

        public boolean isAutoFlush() {
            return this.autoFlush;
        }

        public boolean isUseTags() {
            return this.useTags;
        }

        public int getNoOfTags() {
            return this.noOfTags;
        }

        public boolean isReportLatency() {
            return this.reportLatency;
        }

        public int getMultiGet() {
            return this.multiGet;
        }

        public int getMultiPut() {
            return this.multiPut;
        }

        public boolean isInMemoryCF() {
            return this.inMemoryCF;
        }

        public int getPresplitRegions() {
            return this.presplitRegions;
        }

        public Compression.Algorithm getCompression() {
            return this.compression;
        }

        public DataBlockEncoding getBlockEncoding() {
            return this.blockEncoding;
        }

        public boolean isValueRandom() {
            return this.valueRandom;
        }

        public int getValueSize() {
            return this.valueSize;
        }

        public int getPeriod() {
            return this.period;
        }

        public BloomType getBloomType() {
            return this.bloomType;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public boolean isOneCon() {
            return this.oneCon;
        }

        public int getMeasureAfter() {
            return this.measureAfter;
        }

        public void setMeasureAfter(int measureAfter) {
            this.measureAfter = measureAfter;
        }

        public boolean getAddColumns() {
            return this.addColumns;
        }

        public void setAddColumns(boolean addColumns) {
            this.addColumns = addColumns;
        }

        public void setInMemoryCompaction(MemoryCompactionPolicy inMemoryCompaction) {
            this.inMemoryCompaction = inMemoryCompaction;
        }

        public MemoryCompactionPolicy getInMemoryCompaction() {
            return this.inMemoryCompaction;
        }

        public long getBufferSize() {
            return this.bufferSize;
        }
    }

    static class CmdDescriptor {
        private Class<? extends TestBase> cmdClass;
        private String name;
        private String description;

        CmdDescriptor(Class<? extends TestBase> cmdClass, String name, String description) {
            this.cmdClass = cmdClass;
            this.name = name;
            this.description = description;
        }

        public Class<? extends TestBase> getCmdClass() {
            return this.cmdClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EvaluationMapTask
    extends Mapper<LongWritable, Text, LongWritable, LongWritable> {
        public static final String CMD_KEY = "EvaluationMapTask.command";
        public static final String PE_KEY = "EvaluationMapTask.performanceEvalImpl";
        private Class<? extends Test> cmd;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.cmd = this.forName(context.getConfiguration().get(CMD_KEY), Test.class);
            Class<PerformanceEvaluation> peClass = this.forName(context.getConfiguration().get(PE_KEY), PerformanceEvaluation.class);
            try {
                peClass.getConstructor(Configuration.class).newInstance(context.getConfiguration());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate PE instance", e);
            }
        }

        private <Type> Class<? extends Type> forName(String className, Class<Type> type) {
            try {
                return Class.forName(className).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find class for name: " + className, e);
            }
        }

        protected void map(LongWritable key, Text value, final Mapper.Context context) throws IOException, InterruptedException {
            Status status = new Status(){

                @Override
                public void setStatus(String msg) {
                    context.setStatus(msg);
                }
            };
            TestOptions opts = (TestOptions)GSON.fromJson(value.toString(), TestOptions.class);
            Configuration conf = HBaseConfiguration.create((Configuration)context.getConfiguration());
            Connection con = ConnectionFactory.createConnection((Configuration)conf);
            AsyncConnection asyncCon = null;
            try {
                asyncCon = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
            RunResult result = PerformanceEvaluation.runOneClient(this.cmd, conf, con, asyncCon, opts, status);
            context.getCounter((Enum)Counter.ELAPSED_TIME).increment(result.duration);
            context.getCounter((Enum)Counter.ROWS).increment((long)opts.perClientRunRows);
            context.write((Object)new LongWritable((long)opts.startRow), (Object)new LongWritable(result.duration));
            context.progress();
        }
    }

    static interface Status {
        public void setStatus(String var1) throws IOException;
    }

    protected static class RunResult
    implements Comparable<RunResult> {
        public final long duration;
        public final Histogram hist;
        public final long numbOfReplyOverThreshold;
        public final long numOfReplyFromReplica;

        public RunResult(long duration, Histogram hist) {
            this.duration = duration;
            this.hist = hist;
            this.numbOfReplyOverThreshold = 0L;
            this.numOfReplyFromReplica = 0L;
        }

        public RunResult(long duration, long numbOfReplyOverThreshold, long numOfReplyFromReplica, Histogram hist) {
            this.duration = duration;
            this.hist = hist;
            this.numbOfReplyOverThreshold = numbOfReplyOverThreshold;
            this.numOfReplyFromReplica = numOfReplyFromReplica;
        }

        public String toString() {
            return Long.toString(this.duration);
        }

        @Override
        public int compareTo(RunResult o) {
            return Long.compare(this.duration, o.duration);
        }
    }

    protected static enum Counter {
        ELAPSED_TIME,
        ROWS;

    }
}

