/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.region.MasterRegionFlusherAndCompactor;
import org.apache.hadoop.hbase.master.region.MasterRegionParams;
import org.apache.hadoop.hbase.master.region.MasterRegionWALRoller;
import org.apache.hadoop.hbase.master.region.UpdateMasterRegion;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hbase.thirdparty.com.google.common.math.IntMath;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MasterRegion {
    private static final Logger LOG = LoggerFactory.getLogger(MasterRegion.class);
    private static final String REPLAY_EDITS_DIR = "recovered.wals";
    private static final String DEAD_WAL_DIR_SUFFIX = "-dead";
    private static final int REGION_ID = 1;
    private final WALFactory walFactory;
    final HRegion region;
    final MasterRegionFlusherAndCompactor flusherAndCompactor;
    private MasterRegionWALRoller walRoller;

    private MasterRegion(HRegion region, WALFactory walFactory, MasterRegionFlusherAndCompactor flusherAndCompactor, MasterRegionWALRoller walRoller) {
        this.region = region;
        this.walFactory = walFactory;
        this.flusherAndCompactor = flusherAndCompactor;
        this.walRoller = walRoller;
    }

    private void closeRegion(boolean abort) {
        try {
            this.region.close(abort);
        }
        catch (IOException e) {
            LOG.warn("Failed to close region", (Throwable)e);
        }
    }

    private void shutdownWAL() {
        try {
            this.walFactory.shutdown();
        }
        catch (IOException e) {
            LOG.warn("Failed to shutdown WAL", (Throwable)e);
        }
    }

    public void update(UpdateMasterRegion action) throws IOException {
        action.update(this.region);
        this.flusherAndCompactor.onUpdate();
    }

    public Result get(Get get) throws IOException {
        return this.region.get(get);
    }

    public RegionScanner getScanner(Scan scan) throws IOException {
        return this.region.getScanner(scan);
    }

    public HRegion.FlushResult flush(boolean force) throws IOException {
        return this.region.flush(force);
    }

    public void requestRollAll() {
        this.walRoller.requestRollAll();
    }

    public void waitUntilWalRollFinished() throws InterruptedException {
        this.walRoller.waitUntilWalRollFinished();
    }

    public void close(boolean abort) {
        LOG.info("Closing local region {}, isAbort={}", (Object)this.region.getRegionInfo(), (Object)abort);
        if (this.flusherAndCompactor != null) {
            this.flusherAndCompactor.close();
        }
        if (abort) {
            this.shutdownWAL();
            this.closeRegion(true);
        } else {
            this.closeRegion(false);
            this.shutdownWAL();
        }
        if (this.walRoller != null) {
            this.walRoller.close();
        }
    }

    private static WAL createWAL(WALFactory walFactory, MasterRegionWALRoller walRoller, String serverName, FileSystem walFs, Path walRootDir, RegionInfo regionInfo) throws IOException {
        String logName = AbstractFSWALProvider.getWALDirectoryName(serverName);
        Path walDir = new Path(walRootDir, logName);
        LOG.debug("WALDir={}", (Object)walDir);
        if (walFs.exists(walDir)) {
            throw new HBaseIOException("Already created wal directory at " + walDir + " for local region " + regionInfo);
        }
        if (!walFs.mkdirs(walDir)) {
            throw new IOException("Can not create wal directory " + walDir + " for local region " + regionInfo);
        }
        WAL wal = walFactory.getWAL(regionInfo);
        walRoller.addWAL(wal);
        return wal;
    }

    private static HRegion bootstrap(Configuration conf, TableDescriptor td, FileSystem fs, Path rootDir, FileSystem walFs, Path walRootDir, WALFactory walFactory, MasterRegionWALRoller walRoller, String serverName) throws IOException {
        TableName tn = td.getTableName();
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder(tn).setRegionId(1L).build();
        Path tmpTableDir = CommonFSUtils.getTableDir(rootDir, TableName.valueOf(tn.getNamespaceAsString(), tn.getQualifierAsString() + "-tmp"));
        if (fs.exists(tmpTableDir) && !fs.delete(tmpTableDir, true)) {
            throw new IOException("Can not delete partial created proc region " + tmpTableDir);
        }
        HRegion.createHRegion(conf, regionInfo, fs, tmpTableDir, td).close();
        Path tableDir = CommonFSUtils.getTableDir(rootDir, tn);
        if (!fs.rename(tmpTableDir, tableDir)) {
            throw new IOException("Can not rename " + tmpTableDir + " to " + tableDir);
        }
        WAL wal = MasterRegion.createWAL(walFactory, walRoller, serverName, walFs, walRootDir, regionInfo);
        return HRegion.openHRegionFromTableDir(conf, fs, tableDir, regionInfo, td, wal, null, null);
    }

    private static HRegion open(Configuration conf, TableDescriptor td, FileSystem fs, Path rootDir, FileSystem walFs, Path walRootDir, WALFactory walFactory, MasterRegionWALRoller walRoller, String serverName) throws IOException {
        Path tableDir = CommonFSUtils.getTableDir(rootDir, td.getTableName());
        Path regionDir = fs.listStatus(tableDir, p -> RegionInfo.isEncodedRegionName(Bytes.toBytes(p.getName())))[0].getPath();
        RegionInfo regionInfo = HRegionFileSystem.loadRegionInfoFileContent(fs, regionDir);
        Path walRegionDir = FSUtils.getRegionDirFromRootDir(walRootDir, regionInfo);
        Path replayEditsDir = new Path(walRegionDir, REPLAY_EDITS_DIR);
        if (!walFs.exists(replayEditsDir) && !walFs.mkdirs(replayEditsDir)) {
            throw new IOException("Failed to create replay directory: " + replayEditsDir);
        }
        Path walsDir = new Path(walRootDir, "WALs");
        if (walFs.exists(walsDir)) {
            MasterRegion.replayWALs(conf, walFs, walRootDir, walsDir, regionInfo, serverName, replayEditsDir);
        } else {
            LOG.error("UNEXPECTED: WAL directory for MasterRegion is missing. {} is unexpectedly missing.", (Object)walsDir);
        }
        WAL wal = MasterRegion.createWAL(walFactory, walRoller, serverName, walFs, walRootDir, regionInfo);
        conf.set("hbase.hregion.special.recovered.edits.dir", replayEditsDir.makeQualified(walFs.getUri(), walFs.getWorkingDirectory()).toString());
        return HRegion.openHRegionFromTableDir(conf, fs, tableDir, regionInfo, td, wal, null, null);
    }

    private static void replayWALs(Configuration conf, FileSystem walFs, Path walRootDir, Path walsDir, RegionInfo regionInfo, String serverName, Path replayEditsDir) throws IOException {
        for (FileStatus walDir : walFs.listStatus(walsDir)) {
            Path deadWALDir;
            if (!walDir.isDirectory()) continue;
            if (walDir.getPath().getName().startsWith(serverName)) {
                LOG.warn("This should not happen in real production as we have not created our WAL directory yet, ignore if you are running a local region related UT");
            }
            if (!walDir.getPath().getName().endsWith(DEAD_WAL_DIR_SUFFIX)) {
                deadWALDir = new Path(walDir.getPath().getParent(), walDir.getPath().getName() + DEAD_WAL_DIR_SUFFIX);
                if (!walFs.rename(walDir.getPath(), deadWALDir)) {
                    throw new IOException("Can not rename " + walDir + " to " + deadWALDir + " when recovering lease of proc store");
                }
                LOG.info("Renamed {} to {} as it is dead", (Object)walDir.getPath(), (Object)deadWALDir);
            } else {
                deadWALDir = walDir.getPath();
                LOG.info("{} is already marked as dead", (Object)deadWALDir);
            }
            for (FileStatus walFile : walFs.listStatus(deadWALDir)) {
                Path replayEditsFile = new Path(replayEditsDir, walFile.getPath().getName());
                RecoverLeaseFSUtils.recoverFileLease(walFs, walFile.getPath(), conf);
                if (!walFs.rename(walFile.getPath(), replayEditsFile)) {
                    throw new IOException("Can not rename " + walFile.getPath() + " to " + replayEditsFile + " when recovering lease for local region");
                }
                LOG.info("Renamed {} to {}", (Object)walFile.getPath(), (Object)replayEditsFile);
            }
            LOG.info("Delete empty local region wal dir {}", (Object)deadWALDir);
            walFs.delete(deadWALDir, true);
        }
    }

    public static MasterRegion create(MasterRegionParams params) throws IOException {
        TableDescriptor td = params.tableDescriptor();
        LOG.info("Create or load local region for table " + td);
        Server server = params.server();
        Configuration baseConf = server.getConfiguration();
        FileSystem fs = CommonFSUtils.getRootDirFileSystem(baseConf);
        FileSystem walFs = CommonFSUtils.getWALFileSystem(baseConf);
        Path globalRootDir = CommonFSUtils.getRootDir(baseConf);
        Path globalWALRootDir = CommonFSUtils.getWALRootDir(baseConf);
        Path rootDir = new Path(globalRootDir, params.regionDirName());
        Path walRootDir = new Path(globalWALRootDir, params.regionDirName());
        Configuration conf = new Configuration(baseConf);
        CommonFSUtils.setRootDir(conf, rootDir);
        CommonFSUtils.setWALRootDir(conf, walRootDir);
        MasterRegionFlusherAndCompactor.setupConf(conf, params.flushSize(), params.flushPerChanges(), params.flushIntervalMs());
        conf.setInt("hbase.regionserver.maxlogs", params.maxWals());
        if (params.useHsync() != null) {
            conf.setBoolean("hbase.wal.hsync", params.useHsync().booleanValue());
        }
        if (params.useMetaCellComparator() != null) {
            conf.setBoolean("hbase.region.use.meta.cell.comparator", params.useMetaCellComparator().booleanValue());
        }
        conf.setInt("hbase.regionserver.wal.disruptor.event.count", IntMath.ceilingPowerOfTwo(params.ringBufferSlotCount()));
        MasterRegionWALRoller walRoller = MasterRegionWALRoller.create(td.getTableName() + "-WAL-Roller", conf, server, walFs, walRootDir, globalWALRootDir, params.archivedWalSuffix(), params.rollPeriodMs(), params.flushSize());
        walRoller.start();
        WALFactory walFactory = new WALFactory(conf, server.getServerName().toString());
        Path tableDir = CommonFSUtils.getTableDir(rootDir, td.getTableName());
        HRegion region = fs.exists(tableDir) ? MasterRegion.open(conf, td, fs, rootDir, walFs, walRootDir, walFactory, walRoller, server.getServerName().toString()) : MasterRegion.bootstrap(conf, td, fs, rootDir, walFs, walRootDir, walFactory, walRoller, server.getServerName().toString());
        Path globalArchiveDir = HFileArchiveUtil.getArchivePath(baseConf);
        MasterRegionFlusherAndCompactor flusherAndCompactor = new MasterRegionFlusherAndCompactor(conf, server, region, params.flushSize(), params.flushPerChanges(), params.flushIntervalMs(), params.compactMin(), globalArchiveDir, params.archivedHFileSuffix());
        walRoller.setFlusherAndCompactor(flusherAndCompactor);
        Path archiveDir = HFileArchiveUtil.getArchivePath(conf);
        if (!fs.mkdirs(archiveDir)) {
            LOG.warn("Failed to create archive directory {}. Usually this should not happen but it will be created again when we actually archive the hfiles later, so continue", (Object)archiveDir);
        }
        return new MasterRegion(region, walFactory, flusherAndCompactor, walRoller);
    }
}

