/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ScannerResultGenerator
extends ResultGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerResultGenerator.class);
    private String id;
    private Iterator<Cell> rowI;
    private Cell cache;
    private ResultScanner scanner;
    private Result cached;

    public static Filter buildFilterFromModel(ScannerModel model) throws Exception {
        String filter = model.getFilter();
        if (filter == null || filter.length() == 0) {
            return null;
        }
        return ScannerResultGenerator.buildFilter(filter);
    }

    public ScannerResultGenerator(String tableName, RowSpec rowspec, Filter filter, boolean cacheBlocks) throws IllegalArgumentException, IOException {
        this(tableName, rowspec, filter, -1, cacheBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScannerResultGenerator(String tableName, RowSpec rowspec, Filter filter, int caching, boolean cacheBlocks) throws IllegalArgumentException, IOException {
        try (Table table = RESTServlet.getInstance().getTable(tableName);){
            Scan scan = rowspec.hasEndRow() ? new Scan(rowspec.getStartRow(), rowspec.getEndRow()) : new Scan(rowspec.getStartRow());
            if (rowspec.hasColumns()) {
                byte[][] columns;
                for (byte[] column : columns = rowspec.getColumns()) {
                    byte[][] split = CellUtil.parseColumn((byte[])column);
                    if (split.length == 1) {
                        scan.addFamily(split[0]);
                        continue;
                    }
                    if (split.length == 2) {
                        scan.addColumn(split[0], split[1]);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
                }
            }
            scan.setTimeRange(rowspec.getStartTime(), rowspec.getEndTime());
            scan.setMaxVersions(rowspec.getMaxVersions());
            if (filter != null) {
                scan.setFilter(filter);
            }
            if (caching > 0) {
                scan.setCaching(caching);
            }
            scan.setCacheBlocks(cacheBlocks);
            if (rowspec.hasLabels()) {
                scan.setAuthorizations(new Authorizations(rowspec.getLabels()));
            }
            this.scanner = table.getScanner(scan);
            this.cached = null;
            this.id = Long.toString(System.currentTimeMillis()) + Integer.toHexString(this.scanner.hashCode());
        }
    }

    public String getID() {
        return this.id;
    }

    @Override
    public void close() {
        if (this.scanner != null) {
            this.scanner.close();
            this.scanner = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.cache != null) {
            return true;
        }
        if (this.rowI != null && this.rowI.hasNext()) {
            return true;
        }
        if (this.cached != null) {
            return true;
        }
        try {
            Result result = this.scanner.next();
            if (result != null && !result.isEmpty()) {
                this.cached = result;
            }
        }
        catch (UnknownScannerException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
        }
        return this.cached != null;
    }

    @Override
    public Cell next() {
        boolean loop;
        if (this.cache != null) {
            Cell kv = this.cache;
            this.cache = null;
            return kv;
        }
        do {
            loop = false;
            if (this.rowI != null) {
                if (this.rowI.hasNext()) {
                    return this.rowI.next();
                }
                this.rowI = null;
            }
            if (this.cached != null) {
                this.rowI = this.cached.listCells().iterator();
                loop = true;
                this.cached = null;
                continue;
            }
            Result result = null;
            try {
                result = this.scanner.next();
            }
            catch (UnknownScannerException e) {
                throw new IllegalArgumentException(e);
            }
            catch (TableNotEnabledException tnee) {
                throw new IllegalStateException(tnee);
            }
            catch (TableNotFoundException tnfe) {
                throw new IllegalArgumentException(tnfe);
            }
            catch (IOException e) {
                LOG.error(StringUtils.stringifyException((Throwable)e));
            }
            if (result == null || result.isEmpty()) continue;
            this.rowI = result.listCells().iterator();
            loop = true;
        } while (loop);
        return null;
    }

    @Override
    public void putBack(Cell kv) {
        this.cache = kv;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

