/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestEncryption {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEncryption.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestEncryption.class);

    @Test
    public void testSmallBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random((byte[])key);
        byte[] iv = new byte[16];
        Bytes.random((byte[])iv);
        for (int size : new int[]{4, 8, 16, 32, 64, 128, 256, 512}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size));
        }
    }

    @Test
    public void testLargeBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random((byte[])key);
        byte[] iv = new byte[16];
        Bytes.random((byte[])iv);
        for (int size : new int[]{262144, 524288, 0x100000}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size));
        }
    }

    @Test
    public void testOddSizedBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random((byte[])key);
        byte[] iv = new byte[16];
        Bytes.random((byte[])iv);
        for (int size : new int[]{3, 7, 11, 23, 47, 79, 119, 175}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size));
        }
    }

    @Test
    public void testTypicalHFileBlocks() throws Exception {
        byte[] key = new byte[16];
        Bytes.random((byte[])key);
        byte[] iv = new byte[16];
        Bytes.random((byte[])iv);
        for (int size : new int[]{4096, 8192, 65536, 131072}) {
            this.checkTransformSymmetry(key, iv, this.getRandomBlock(size));
        }
    }

    @Test
    public void testIncrementIV() {
        byte[] iv = new byte[]{1, 2, 3};
        byte[] iv_neg = new byte[]{-3, -13, 25};
        Encryption.incrementIv((byte[])iv);
        Assert.assertTrue((boolean)Bytes.equals((byte[])iv, (byte[])new byte[]{2, 2, 3}));
        Encryption.incrementIv((byte[])iv, (int)255);
        Assert.assertTrue((boolean)Bytes.equals((byte[])iv, (byte[])new byte[]{1, 3, 3}));
        Encryption.incrementIv((byte[])iv, (int)1024);
        Assert.assertTrue((boolean)Bytes.equals((byte[])iv, (byte[])new byte[]{1, 7, 3}));
        Encryption.incrementIv((byte[])iv_neg);
        Assert.assertTrue((boolean)Bytes.equals((byte[])iv_neg, (byte[])new byte[]{-2, -13, 25}));
        Encryption.incrementIv((byte[])iv_neg, (int)5);
        Assert.assertTrue((boolean)Bytes.equals((byte[])iv_neg, (byte[])new byte[]{3, -12, 25}));
    }

    private void checkTransformSymmetry(byte[] keyBytes, byte[] iv, byte[] plaintext) throws Exception {
        LOG.info("checkTransformSymmetry: AES, plaintext length = " + plaintext.length);
        Configuration conf = HBaseConfiguration.create();
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher aes = Encryption.getCipher((Configuration)conf, (String)algorithm);
        SecretKeySpec key = new SecretKeySpec(keyBytes, algorithm);
        Encryptor e = aes.getEncryptor();
        e.setKey((Key)key);
        e.setIv(iv);
        e.reset();
        ByteArrayOutputStream encOut = new ByteArrayOutputStream();
        Encryption.encrypt((OutputStream)encOut, (byte[])plaintext, (int)0, (int)plaintext.length, (Encryptor)e);
        byte[] encrypted = encOut.toByteArray();
        Decryptor d = aes.getDecryptor();
        d.setKey((Key)key);
        d.setIv(iv);
        d.reset();
        ByteArrayInputStream encIn = new ByteArrayInputStream(encrypted);
        ByteArrayOutputStream decOut = new ByteArrayOutputStream();
        Encryption.decrypt((OutputStream)decOut, (InputStream)encIn, (int)plaintext.length, (Decryptor)d);
        byte[] result = decOut.toByteArray();
        Assert.assertEquals((String)"Decrypted result has different length than plaintext", (long)result.length, (long)plaintext.length);
        Assert.assertTrue((String)"Transformation was not symmetric", (boolean)Bytes.equals((byte[])result, (byte[])plaintext));
    }

    private byte[] getRandomBlock(int size) {
        byte[] b = new byte[size];
        Bytes.random((byte[])b);
        return b;
    }
}

