/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.StripeStoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.TestCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcatenatedLists;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.UnmodifiableListIterator;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestStripeCompactionPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStripeCompactionPolicy.class);
    private static final byte[] KEY_A = Bytes.toBytes((String)"aaa");
    private static final byte[] KEY_B = Bytes.toBytes((String)"bbb");
    private static final byte[] KEY_C = Bytes.toBytes((String)"ccc");
    private static final byte[] KEY_D = Bytes.toBytes((String)"ddd");
    private static final byte[] KEY_E = Bytes.toBytes((String)"eee");
    private static final KeyValue KV_A = new KeyValue(KEY_A, 0L);
    private static final KeyValue KV_B = new KeyValue(KEY_B, 0L);
    private static final KeyValue KV_C = new KeyValue(KEY_C, 0L);
    private static final KeyValue KV_D = new KeyValue(KEY_D, 0L);
    private static final KeyValue KV_E = new KeyValue(KEY_E, 0L);
    private static long defaultSplitSize = 18L;
    private static float defaultSplitCount = 1.8f;
    private static final int defaultInitialCount = 1;
    private static long defaultTtl = 1000000L;
    @Parameterized.Parameter
    public boolean usePrivateReaders;

    @Parameterized.Parameters(name="{index}: usePrivateReaders={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testNoStripesFromFlush() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.store.stripe.compaction.flushToL0", true);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(0, 0L);
        KeyValue[] input = new KeyValue[]{KV_A, KV_B, KV_C, KV_D, KV_E};
        KeyValue[][] expected = new KeyValue[][]{input};
        this.verifyFlush(policy, si, input, expected, null);
    }

    @Test
    public void testOldStripesFromFlush() throws Exception {
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create());
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripes(0, KEY_C, KEY_D);
        KeyValue[] input = new KeyValue[]{KV_B, KV_C, KV_C, KV_D, KV_E};
        KeyValue[][] expected = new KeyValue[][]{{KV_B}, {KV_C, KV_C}, {KV_D, KV_E}};
        this.verifyFlush(policy, si, input, expected, new byte[][]{StripeStoreFileManager.OPEN_KEY, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY});
    }

    @Test
    public void testNewStripesFromFlush() throws Exception {
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create());
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(0, 0L);
        KeyValue[] input = new KeyValue[]{KV_B, KV_C, KV_C, KV_D, KV_E};
        KeyValue[][] expected = new KeyValue[][]{input};
        this.verifyFlush(policy, si, input, expected, new byte[][]{StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY});
    }

    @Test
    public void testSingleStripeCompaction() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.unset("hbase.hstore.compaction.min.size");
        conf.setFloat("hbase.hstore.compaction.ratio", 1.0f);
        conf.setInt("hbase.store.stripe.compaction.minFiles", 3);
        conf.setInt("hbase.store.stripe.compaction.maxFiles", 4);
        conf.setLong("hbase.store.stripe.sizeToSplit", 1000L);
        StoreConfigInformation sci = (StoreConfigInformation)Mockito.mock(StoreConfigInformation.class);
        Mockito.when((Object)sci.getRegionInfo()).thenReturn((Object)HRegionInfo.FIRST_META_REGIONINFO);
        StripeStoreConfig ssc = new StripeStoreConfig(conf, sci);
        StripeCompactionPolicy policy = new StripeCompactionPolicy(conf, sci, ssc){

            public StripeCompactionPolicy.StripeCompactionRequest selectCompaction(StripeCompactionPolicy.StripeInformationProvider si, List<HStoreFile> filesCompacting, boolean isOffpeak) throws IOException {
                if (!filesCompacting.isEmpty()) {
                    return null;
                }
                return this.selectSingleStripeCompaction(si, false, false, isOffpeak);
            }

            public boolean needsCompactions(StripeCompactionPolicy.StripeInformationProvider si, List<HStoreFile> filesCompacting) {
                if (!filesCompacting.isEmpty()) {
                    return false;
                }
                return this.needsSingleStripeCompaction(si);
            }
        };
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {2L}, {3L, 3L}, {5L, 1L});
        this.verifyNoCompaction(policy, si);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {2L}, {3L, 3L}, {5L, 1L, 1L});
        Assert.assertNull((Object)policy.selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false));
        Assert.assertTrue((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new HStoreFile[0])));
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {2L}, {3L, 3L}, {5L, 4L, 3L});
        this.verifySingleStripeCompaction(policy, si, 2, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {3L, 2L, 2L}, {2L, 2L, 1L}, {3L, 2L, 2L, 1L});
        this.verifySingleStripeCompaction(policy, si, 2, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {5L}, {3L, 2L, 2L, 1L}, {3L, 2L, 2L});
        this.verifySingleStripeCompaction(policy, si, 1, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {3L, 3L, 3L}, {3L, 1L, 2L}, {3L, 2L, 2L});
        this.verifySingleStripeCompaction(policy, si, 1, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {5L}, {5L, 4L, 4L, 4L, 4L});
        ImmutableList sfs = ((ImmutableList)si.getStripes().get(1)).subList(1, 5);
        this.verifyCompaction(policy, si, (Collection<HStoreFile>)sfs, null, 1, null, si.getStartRow(1), si.getEndRow(1), true);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {5L}, {50L, 4L, 4L, 4L, 4L});
        sfs = ((ImmutableList)si.getStripes().get(1)).subList(1, 5);
        this.verifyCompaction(policy, si, (Collection<HStoreFile>)sfs, null, 1, null, si.getStartRow(1), si.getEndRow(1), true);
    }

    @Test
    public void testWithParallelCompaction() throws Exception {
        Assert.assertNull((Object)TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create()).selectCompaction((StripeCompactionPolicy.StripeInformationProvider)Mockito.mock(StripeCompactionPolicy.StripeInformationProvider.class), TestStripeCompactionPolicy.al(TestStripeCompactionPolicy.createFile()), false));
    }

    @Test
    public void testWithReferences() throws Exception {
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create());
        StripeCompactor sc = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        HStoreFile ref = TestStripeCompactionPolicy.createFile();
        Mockito.when((Object)ref.isReference()).thenReturn((Object)true);
        StripeCompactionPolicy.StripeInformationProvider si = (StripeCompactionPolicy.StripeInformationProvider)Mockito.mock(StripeCompactionPolicy.StripeInformationProvider.class);
        ArrayList<HStoreFile> sfs = TestStripeCompactionPolicy.al(ref, TestStripeCompactionPolicy.createFile());
        Mockito.when((Object)si.getStorefiles()).thenReturn(sfs);
        Assert.assertTrue((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new HStoreFile[0])));
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false);
        Assert.assertEquals((Object)si.getStorefiles(), new ArrayList(scr.getRequest().getFiles()));
        scr.execute(sc, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        ((StripeCompactor)Mockito.verify((Object)sc, (VerificationMode)Mockito.only())).compact((CompactionRequestImpl)Matchers.eq((Object)scr.getRequest()), Matchers.anyInt(), Matchers.anyLong(), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), (ThroughputController)Matchers.any(), (User)Matchers.any());
    }

    @Test
    public void testInitialCountFromL0() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 2);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize, defaultSplitCount, 2, false);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(3, 8L);
        this.verifyCompaction(policy, si, si.getStorefiles(), true, 2, 12L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, true);
        si = TestStripeCompactionPolicy.createStripesL0Only(3, 10L);
        this.verifyCompaction(policy, si, si.getStorefiles(), true, 3, 10L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, true);
        policy = TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize, defaultSplitCount, 6, false);
        this.verifyCompaction(policy, si, si.getStorefiles(), true, 6, 5L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, true);
    }

    @Test
    public void testExistingStripesFromL0() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 3);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripes(3, new byte[][]{KEY_A});
        this.verifyCompaction(TestStripeCompactionPolicy.createPolicy(conf), si, si.getLevel0Files(), null, null, si.getStripeBoundaries());
    }

    @Test
    public void testNothingToCompactFromL0() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 4);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(3, 10L);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        this.verifyNoCompaction(policy, si);
        si = TestStripeCompactionPolicy.createStripes(3, new byte[][]{KEY_A});
        this.verifyNoCompaction(policy, si);
    }

    @Test
    public void testCheckExpiredStripeCompaction() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 5);
        conf.setInt("hbase.store.stripe.compaction.minFiles", 4);
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        long now = defaultTtl + 2L;
        edge.setValue(now);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        HStoreFile expiredFile = TestStripeCompactionPolicy.createFile(10L);
        HStoreFile notExpiredFile = TestStripeCompactionPolicy.createFile(10L);
        Mockito.when((Object)expiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl - 1L));
        Mockito.when((Object)notExpiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl + 1L));
        ArrayList expired = Lists.newArrayList((Object[])new HStoreFile[]{expiredFile, expiredFile});
        ArrayList mixed = Lists.newArrayList((Object[])new HStoreFile[]{expiredFile, notExpiredFile});
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize, defaultSplitCount, 1, true);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{mixed, mixed, mixed});
        Assert.assertFalse((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new HStoreFile[0])));
        si = TestStripeCompactionPolicy.createStripesWithFiles(mixed, mixed, mixed, expired);
        Assert.assertFalse((boolean)policy.needsSingleStripeCompaction(si));
        Assert.assertTrue((boolean)policy.hasExpiredStripes(si));
        Assert.assertTrue((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new HStoreFile[0])));
    }

    @Test
    public void testSplitOffStripe() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.unset("hbase.hstore.compaction.min.size");
        conf.setInt("hbase.store.stripe.compaction.minFiles", 2);
        Long[] toSplit = new Long[]{defaultSplitSize - 2L, 1L, 1L};
        Long[] noSplit = new Long[]{defaultSplitSize - 2L, 1L};
        long splitTargetSize = (long)((float)defaultSplitSize / defaultSplitCount);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, new Long[][]{{defaultSplitSize - 2L, 2L}});
        Assert.assertNull((Object)TestStripeCompactionPolicy.createPolicy(conf).selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false));
        conf.setFloat("hbase.hstore.compaction.ratio", 500.0f);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        this.verifyWholeStripesCompaction(policy, si, 0, 0, null, 2, splitTargetSize);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, noSplit, noSplit, toSplit);
        this.verifyWholeStripesCompaction(policy, si, 2, 2, null, 2, splitTargetSize);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, noSplit, toSplit, noSplit);
        this.verifyWholeStripesCompaction(policy, si, 1, 1, null, 2, splitTargetSize);
        StripeCompactionPolicy specPolicy = TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize + 1L, defaultSplitCount, 1, false);
        this.verifySingleStripeCompaction(specPolicy, si, 1, null);
    }

    @Test
    public void testSplitOffStripeOffPeak() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.unset("hbase.hstore.compaction.min.size");
        conf.setInt("hbase.store.stripe.compaction.minFiles", 2);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, new Long[][]{{defaultSplitSize - 2L, 1L, 1L}});
        Assert.assertEquals((long)2L, (long)TestStripeCompactionPolicy.createPolicy(conf).selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false).getRequest().getFiles().size());
        conf.setFloat("hbase.hstore.compaction.ratio.offpeak", 500.0f);
        Assert.assertEquals((long)3L, (long)TestStripeCompactionPolicy.createPolicy(conf).selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), true).getRequest().getFiles().size());
    }

    @Test
    public void testSplitOffStripeDropDeletes() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFiles", 2);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        Long[] toSplit = new Long[]{defaultSplitSize / 2L, defaultSplitSize / 2L};
        Long[] noSplit = new Long[]{1L};
        long splitTargetSize = (long)((float)defaultSplitSize / defaultSplitCount);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, noSplit, toSplit);
        this.verifyWholeStripesCompaction(policy, si, 1, 1, true, null, splitTargetSize);
        si = TestStripeCompactionPolicy.createStripesWithSizes(2, 2L, noSplit, toSplit);
        this.verifyWholeStripesCompaction(policy, si, 1, 1, false, null, splitTargetSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeExpiredFiles() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        long now = defaultTtl + 2L;
        edge.setValue(now);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        try {
            HStoreFile expiredFile = TestStripeCompactionPolicy.createFile();
            HStoreFile notExpiredFile = TestStripeCompactionPolicy.createFile();
            Mockito.when((Object)expiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl - 1L));
            Mockito.when((Object)notExpiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl + 1L));
            ArrayList expired = Lists.newArrayList((Object[])new HStoreFile[]{expiredFile, expiredFile});
            ArrayList notExpired = Lists.newArrayList((Object[])new HStoreFile[]{notExpiredFile, notExpiredFile});
            ArrayList mixed = Lists.newArrayList((Object[])new HStoreFile[]{expiredFile, notExpiredFile});
            StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create(), defaultSplitSize, defaultSplitCount, 1, true);
            StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{expired, expired, expired});
            this.verifyWholeStripesCompaction(policy, si, 0, 2, null, 1, Long.MAX_VALUE, false);
            si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{notExpired, notExpired, notExpired});
            Assert.assertNull((Object)policy.selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false));
            si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{notExpired, expired, notExpired});
            this.verifyWholeStripesCompaction(policy, si, 1, 2, null, 1, Long.MAX_VALUE, false);
            si = TestStripeCompactionPolicy.createStripesWithFiles(notExpired, expired, notExpired, expired, expired, notExpired);
            this.verifyWholeStripesCompaction(policy, si, 3, 4, null, 1, Long.MAX_VALUE, false);
            si = TestStripeCompactionPolicy.createStripesWithFiles(expired, expired, notExpired, expired, mixed);
            this.verifyWholeStripesCompaction(policy, si, 0, 1, null, 1, Long.MAX_VALUE, false);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeExpiredStripes() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        long now = defaultTtl + 2L;
        edge.setValue(now);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        try {
            HStoreFile expiredFile = TestStripeCompactionPolicy.createFile();
            HStoreFile notExpiredFile = TestStripeCompactionPolicy.createFile();
            Mockito.when((Object)expiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl - 1L));
            Mockito.when((Object)notExpiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl + 1L));
            ArrayList expired = Lists.newArrayList((Object[])new HStoreFile[]{expiredFile, expiredFile});
            ArrayList notExpired = Lists.newArrayList((Object[])new HStoreFile[]{notExpiredFile, notExpiredFile});
            StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create(), defaultSplitSize, defaultSplitCount, 1, true);
            StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{expired, expired, expired});
            this.verifyMergeCompatcion(policy, si, 0, 2);
            si = TestStripeCompactionPolicy.createStripesWithFiles(notExpired, expired, notExpired, expired, expired, notExpired);
            this.verifyMergeCompatcion(policy, si, 3, 4);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithFiles(List<HStoreFile> ... stripeFiles) throws Exception {
        return TestStripeCompactionPolicy.createStripesWithFiles(TestStripeCompactionPolicy.createBoundaries(stripeFiles.length), Lists.newArrayList((Object[])stripeFiles), new ArrayList<HStoreFile>());
    }

    @Test
    public void testSingleStripeDropDeletes() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.unset("hbase.hstore.compaction.min.size");
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        Long[][] stripes = new Long[][]{{3L, 2L, 2L, 2L}, {6L}};
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, stripes);
        this.verifySingleStripeCompaction(policy, si, 0, true);
        si = TestStripeCompactionPolicy.createStripesWithSizes(2, 2L, stripes);
        this.verifySingleStripeCompaction(policy, si, 0, false);
        si = TestStripeCompactionPolicy.createStripesWithSizes(6, 2L, stripes);
        ConcatenatedLists sfs = new ConcatenatedLists();
        sfs.addSublist(si.getLevel0Files());
        sfs.addSublist((List)si.getStripes().get(0));
        this.verifyCompaction(policy, si, (Collection<HStoreFile>)sfs, si.getStartRow(0), si.getEndRow(0), si.getStripeBoundaries());
        si = TestStripeCompactionPolicy.createStripesWithSizes(6, 2L, {10L, 1L, 1L, 1L, 1L}, {12L});
        this.verifyCompaction(policy, si, si.getLevel0Files(), null, null, si.getStripeBoundaries());
        stripes = new Long[][]{{100L, 3L, 2L, 2L, 2L}, {6L}};
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, stripes);
        ArrayList<HStoreFile> compactFile = new ArrayList<HStoreFile>();
        UnmodifiableListIterator iter = ((ImmutableList)si.getStripes().get(0)).listIterator(1);
        while (iter.hasNext()) {
            compactFile.add((HStoreFile)iter.next());
        }
        this.verifyCompaction(policy, si, compactFile, false, 1, null, si.getStartRow(0), si.getEndRow(0), true);
    }

    private static StripeCompactionPolicy createPolicy(Configuration conf) throws Exception {
        return TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize, defaultSplitCount, 1, false);
    }

    private static StripeCompactionPolicy createPolicy(Configuration conf, long splitSize, float splitCount, int initialCount, boolean hasTtl) throws Exception {
        conf.setLong("hbase.store.stripe.sizeToSplit", splitSize);
        conf.setFloat("hbase.store.stripe.splitPartCount", splitCount);
        conf.setInt("hbase.store.stripe.initialStripeCount", initialCount);
        StoreConfigInformation sci = (StoreConfigInformation)Mockito.mock(StoreConfigInformation.class);
        Mockito.when((Object)sci.getStoreFileTtl()).thenReturn((Object)(hasTtl ? defaultTtl : Long.MAX_VALUE));
        Mockito.when((Object)sci.getRegionInfo()).thenReturn((Object)HRegionInfo.FIRST_META_REGIONINFO);
        StripeStoreConfig ssc = new StripeStoreConfig(conf, sci);
        return new StripeCompactionPolicy(conf, sci, ssc);
    }

    private static ArrayList<HStoreFile> al(HStoreFile ... sfs) {
        return new ArrayList<HStoreFile>(Arrays.asList(sfs));
    }

    private void verifyMergeCompatcion(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int from, int to) throws Exception {
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false);
        List<HStoreFile> sfs = TestStripeCompactionPolicy.getAllFiles(si, from, to);
        this.verifyCollectionsEqual(sfs, scr.getRequest().getFiles());
        StripeCompactor sc = this.createCompactor();
        List paths = scr.execute(sc, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        Assert.assertEquals((long)1L, (long)paths.size());
    }

    private void verifyWholeStripesCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int from, int to, Boolean dropDeletes, Integer count, Long size, boolean needsCompaction) throws IOException {
        this.verifyCompaction(policy, si, TestStripeCompactionPolicy.getAllFiles(si, from, to), dropDeletes, count, size, si.getStartRow(from), si.getEndRow(to), needsCompaction);
    }

    private void verifyWholeStripesCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int from, int to, Boolean dropDeletes, Integer count, Long size) throws IOException {
        this.verifyWholeStripesCompaction(policy, si, from, to, dropDeletes, count, size, true);
    }

    private void verifySingleStripeCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int index, Boolean dropDeletes) throws IOException {
        this.verifyWholeStripesCompaction(policy, si, index, index, dropDeletes, 1, null, true);
    }

    private void verifyNoCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si) throws IOException {
        Assert.assertNull((Object)policy.selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false));
        Assert.assertFalse((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new HStoreFile[0])));
    }

    private void verifyCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, Collection<HStoreFile> sfs, byte[] dropDeletesFrom, byte[] dropDeletesTo, final List<byte[]> boundaries) throws Exception {
        StripeCompactor sc = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        Assert.assertTrue((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new HStoreFile[0])));
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false);
        this.verifyCollectionsEqual(sfs, scr.getRequest().getFiles());
        scr.execute(sc, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        ((StripeCompactor)Mockito.verify((Object)sc, (VerificationMode)Mockito.times((int)1))).compact((CompactionRequestImpl)Matchers.eq((Object)scr.getRequest()), (List)Matchers.argThat((ArgumentMatcher)new ArgumentMatcher<List<byte[]>>(){

            public boolean matches(List<byte[]> argument) {
                List<byte[]> other = argument;
                if (other.size() != boundaries.size()) {
                    return false;
                }
                for (int i = 0; i < other.size(); ++i) {
                    if (Bytes.equals((byte[])other.get(i), (byte[])((byte[])boundaries.get(i)))) continue;
                    return false;
                }
                return true;
            }
        }), dropDeletesFrom == null ? (byte[])Matchers.isNull(byte[].class) : AdditionalMatchers.aryEq((byte[])dropDeletesFrom), dropDeletesTo == null ? (byte[])Matchers.isNull(byte[].class) : AdditionalMatchers.aryEq((byte[])dropDeletesTo), (ThroughputController)Matchers.any(), (User)Matchers.any());
    }

    private void verifyCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, Collection<HStoreFile> sfs, Boolean dropDeletes, Integer count, Long size, byte[] start, byte[] end, boolean needsCompaction) throws IOException {
        StripeCompactor sc = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        Assert.assertTrue((!needsCompaction || policy.needsCompactions(si, TestStripeCompactionPolicy.al(new HStoreFile[0])) ? 1 : 0) != 0);
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new HStoreFile[0]), false);
        this.verifyCollectionsEqual(sfs, scr.getRequest().getFiles());
        scr.execute(sc, (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        ((StripeCompactor)Mockito.verify((Object)sc, (VerificationMode)Mockito.times((int)1))).compact((CompactionRequestImpl)Matchers.eq((Object)scr.getRequest()), count == null ? Matchers.anyInt() : Matchers.eq((int)count), size == null ? Matchers.anyLong() : Matchers.eq((long)size), AdditionalMatchers.aryEq((byte[])start), AdditionalMatchers.aryEq((byte[])end), this.dropDeletesMatcher(dropDeletes, start), this.dropDeletesMatcher(dropDeletes, end), (ThroughputController)Matchers.any(), (User)Matchers.any());
    }

    protected void verifyFlush(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, KeyValue[] input, KeyValue[][] expected, byte[][] boundaries) throws IOException {
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        StripeStoreFlusher.StripeFlushRequest req = policy.selectFlush((CellComparator)CellComparatorImpl.COMPARATOR, si, input.length);
        StripeMultiFileWriter mw = req.createWriter();
        mw.init(null, (AbstractMultiFileWriter.WriterFactory)writers);
        for (KeyValue kv : input) {
            mw.append((Cell)kv);
        }
        boolean hasMetadata = boundaries != null;
        mw.commitWriters(0L, false);
        writers.verifyKvs(expected, true, hasMetadata);
        if (hasMetadata) {
            writers.verifyBoundaries(boundaries);
        }
    }

    private byte[] dropDeletesMatcher(Boolean dropDeletes, byte[] value) {
        return dropDeletes == null ? (byte[])Matchers.any() : (dropDeletes != false ? AdditionalMatchers.aryEq((byte[])value) : (byte[])Matchers.isNull(byte[].class));
    }

    private void verifyCollectionsEqual(Collection<HStoreFile> sfs, Collection<HStoreFile> scr) {
        Assert.assertEquals((long)sfs.size(), (long)scr.size());
        Assert.assertTrue((boolean)scr.containsAll(sfs));
    }

    private static List<HStoreFile> getAllFiles(StripeCompactionPolicy.StripeInformationProvider si, int fromStripe, int toStripe) {
        ArrayList<HStoreFile> expected = new ArrayList<HStoreFile>();
        for (int i = fromStripe; i <= toStripe; ++i) {
            expected.addAll((Collection)si.getStripes().get(i));
        }
        return expected;
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripes(int l0Count, byte[] ... boundaries) throws Exception {
        ArrayList<Long> l0Sizes = new ArrayList<Long>();
        for (int i = 0; i < l0Count; ++i) {
            l0Sizes.add(5L);
        }
        ArrayList<List<Long>> sizes = new ArrayList<List<Long>>();
        for (int i = 0; i <= boundaries.length; ++i) {
            sizes.add(Arrays.asList(5L));
        }
        return TestStripeCompactionPolicy.createStripes(Arrays.asList(boundaries), sizes, l0Sizes);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesL0Only(int l0Count, long l0Size) throws Exception {
        ArrayList<Long> l0Sizes = new ArrayList<Long>();
        for (int i = 0; i < l0Count; ++i) {
            l0Sizes.add(l0Size);
        }
        return TestStripeCompactionPolicy.createStripes(null, new ArrayList<List<Long>>(), l0Sizes);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithSizes(int l0Count, long l0Size, Long[] ... sizes) throws Exception {
        ArrayList<List<Long>> sizeList = new ArrayList<List<Long>>(sizes.length);
        for (Long[] size : sizes) {
            sizeList.add(Arrays.asList(size));
        }
        return TestStripeCompactionPolicy.createStripesWithSizes(l0Count, l0Size, sizeList);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithSizes(int l0Count, long l0Size, List<List<Long>> sizes) throws Exception {
        List<byte[]> boundaries = TestStripeCompactionPolicy.createBoundaries(sizes.size());
        ArrayList<Long> l0Sizes = new ArrayList<Long>();
        for (int i = 0; i < l0Count; ++i) {
            l0Sizes.add(l0Size);
        }
        return TestStripeCompactionPolicy.createStripes(boundaries, sizes, l0Sizes);
    }

    private static List<byte[]> createBoundaries(int stripeCount) {
        byte[][] keys = new byte[][]{KEY_A, KEY_B, KEY_C, KEY_D, KEY_E};
        assert (stripeCount <= keys.length + 1);
        ArrayList<byte[]> boundaries = new ArrayList<byte[]>();
        boundaries.addAll(Arrays.asList(keys).subList(0, stripeCount - 1));
        return boundaries;
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripes(List<byte[]> boundaries, List<List<Long>> stripeSizes, List<Long> l0Sizes) throws Exception {
        ArrayList<List<HStoreFile>> stripeFiles = new ArrayList<List<HStoreFile>>(stripeSizes.size());
        for (List<Long> sizes : stripeSizes) {
            ArrayList<HStoreFile> sfs = new ArrayList<HStoreFile>(sizes.size());
            for (Long size : sizes) {
                sfs.add(TestStripeCompactionPolicy.createFile(size));
            }
            stripeFiles.add(sfs);
        }
        ArrayList<HStoreFile> l0Files = new ArrayList<HStoreFile>();
        for (Long size : l0Sizes) {
            l0Files.add(TestStripeCompactionPolicy.createFile(size));
        }
        return TestStripeCompactionPolicy.createStripesWithFiles(boundaries, stripeFiles, l0Files);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithFiles(List<byte[]> boundaries, List<List<HStoreFile>> stripeFiles, List<HStoreFile> l0Files) throws Exception {
        ArrayList<ImmutableList> stripes = new ArrayList<ImmutableList>();
        ArrayList<byte[]> boundariesList = new ArrayList<byte[]>();
        StripeCompactionPolicy.StripeInformationProvider si = (StripeCompactionPolicy.StripeInformationProvider)Mockito.mock(StripeCompactionPolicy.StripeInformationProvider.class);
        if (!stripeFiles.isEmpty()) {
            assert (stripeFiles.size() == boundaries.size() + 1);
            boundariesList.add(StripeStoreFileManager.OPEN_KEY);
            for (int i = 0; i <= boundaries.size(); ++i) {
                byte[] startKey = i == 0 ? StripeStoreFileManager.OPEN_KEY : boundaries.get(i - 1);
                byte[] endKey = i == boundaries.size() ? StripeStoreFileManager.OPEN_KEY : boundaries.get(i);
                boundariesList.add(endKey);
                for (HStoreFile sf : stripeFiles.get(i)) {
                    TestStripeCompactionPolicy.setFileStripe(sf, startKey, endKey);
                }
                stripes.add(ImmutableList.copyOf((Collection)stripeFiles.get(i)));
                Mockito.when((Object)si.getStartRow(Matchers.eq((int)i))).thenReturn((Object)startKey);
                Mockito.when((Object)si.getEndRow(Matchers.eq((int)i))).thenReturn((Object)endKey);
            }
        }
        ConcatenatedLists sfs = new ConcatenatedLists();
        sfs.addAllSublists(stripes);
        sfs.addSublist(l0Files);
        Mockito.when((Object)si.getStorefiles()).thenReturn((Object)sfs);
        Mockito.when((Object)si.getStripes()).thenReturn(stripes);
        Mockito.when((Object)si.getStripeBoundaries()).thenReturn(boundariesList);
        Mockito.when((Object)si.getStripeCount()).thenReturn((Object)stripes.size());
        Mockito.when((Object)si.getLevel0Files()).thenReturn(l0Files);
        return si;
    }

    private static HStoreFile createFile(long size) throws Exception {
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        Mockito.when((Object)sf.getPath()).thenReturn((Object)new Path("moo"));
        StoreFileReader r = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        Mockito.when((Object)r.getEntries()).thenReturn((Object)size);
        Mockito.when((Object)r.length()).thenReturn((Object)size);
        Mockito.when((Object)r.getBloomFilterType()).thenReturn((Object)BloomType.NONE);
        Mockito.when((Object)r.getHFileReader()).thenReturn(Mockito.mock(HFile.Reader.class));
        Mockito.when((Object)r.getStoreFileScanner(Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean())).thenReturn(Mockito.mock(StoreFileScanner.class));
        Mockito.when((Object)sf.getReader()).thenReturn((Object)r);
        Mockito.when((Object)sf.getBulkLoadTimestamp()).thenReturn((Object)OptionalLong.empty());
        Mockito.when((Object)r.getMaxTimestamp()).thenReturn((Object)Long.MAX_VALUE);
        return sf;
    }

    private static HStoreFile createFile() throws Exception {
        return TestStripeCompactionPolicy.createFile(0L);
    }

    private static void setFileStripe(HStoreFile sf, byte[] startKey, byte[] endKey) {
        Mockito.when((Object)sf.getMetadataValue(StripeStoreFileManager.STRIPE_START_KEY)).thenReturn((Object)startKey);
        Mockito.when((Object)sf.getMetadataValue(StripeStoreFileManager.STRIPE_END_KEY)).thenReturn((Object)endKey);
    }

    private StripeCompactor createCompactor() throws Exception {
        HColumnDescriptor col = new HColumnDescriptor(Bytes.toBytes((String)"foo"));
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        HStore store = (HStore)Mockito.mock(HStore.class);
        HRegionInfo info = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)info.getRegionNameAsString()).thenReturn((Object)"testRegion");
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)col);
        Mockito.when((Object)store.getRegionInfo()).thenReturn((Object)info);
        Mockito.when((Object)store.createWriterInTmp(Matchers.anyLong(), (Compression.Algorithm)Matchers.any(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenAnswer((Answer)writers);
        Mockito.when((Object)store.createWriterInTmp(Matchers.anyLong(), (Compression.Algorithm)Matchers.any(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyLong())).thenAnswer((Answer)writers);
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.regionserver.compaction.private.readers", this.usePrivateReaders);
        final Scanner scanner = new Scanner(new KeyValue[0]);
        return new StripeCompactor(conf, store){

            protected InternalScanner createScanner(HStore store, ScanInfo scanInfo, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
                return scanner;
            }

            protected InternalScanner createScanner(HStore store, ScanInfo scanInfo, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
                return scanner;
            }
        };
    }

    private static class Scanner
    implements InternalScanner {
        private final ArrayList<KeyValue> kvs;

        public Scanner(KeyValue ... kvs) {
            this.kvs = new ArrayList<KeyValue>(Arrays.asList(kvs));
        }

        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            if (this.kvs.isEmpty()) {
                return false;
            }
            result.add((Cell)this.kvs.remove(0));
            return !this.kvs.isEmpty();
        }

        public void close() throws IOException {
        }
    }
}

