/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.balancer.DoubleArrayCost;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestDoubleArrayCost {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDoubleArrayCost.class);

    @Test
    public void testComputeCost() {
        DoubleArrayCost cost = new DoubleArrayCost();
        cost.prepare(100);
        cost.applyCostsChange(costs -> {
            for (int i = 0; i < 100; ++i) {
                costs[i] = 10.0;
            }
        });
        Assert.assertEquals((double)0.0, (double)cost.cost(), (double)0.01);
        cost.prepare(101);
        cost.applyCostsChange(costs -> {
            for (int i = 0; i < 100; ++i) {
                costs[i] = 0.0;
            }
            costs[100] = 100.0;
        });
        Assert.assertEquals((double)1.0, (double)cost.cost(), (double)0.01);
        cost.prepare(200);
        cost.applyCostsChange(costs -> {
            for (int i = 0; i < 100; ++i) {
                costs[i] = 0.0;
                costs[i + 100] = 100.0;
            }
            costs[100] = 100.0;
        });
        Assert.assertEquals((double)0.5, (double)cost.cost(), (double)0.01);
    }
}

