/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegionLocationCache;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, MasterTests.class})
public class TestMetaRegionLocationCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaRegionLocationCache.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ConnectionRegistry REGISTRY;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        TEST_UTIL.startMiniCluster(3);
        REGISTRY = ConnectionRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(TEST_UTIL, REGISTRY);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        Closeables.close((Closeable)REGISTRY, (boolean)true);
        TEST_UTIL.shutdownMiniCluster();
    }

    private List<HRegionLocation> getCurrentMetaLocations(ZKWatcher zk) throws Exception {
        ArrayList<HRegionLocation> result = new ArrayList<HRegionLocation>();
        for (String znode : zk.getMetaReplicaNodes()) {
            String path = ZNodePaths.joinZNode((String)zk.getZNodePaths().baseZNode, (String)znode);
            int replicaId = zk.getZNodePaths().getMetaReplicaIdFromPath(path);
            RegionState state = MetaTableLocator.getMetaRegionState((ZKWatcher)zk, (int)replicaId);
            result.add(new HRegionLocation(state.getRegion(), state.getServerName()));
        }
        return result;
    }

    private void verifyCachedMetaLocations(HMaster master) throws Exception {
        int retries = 0;
        while (!master.getMetaRegionLocationCache().getMetaRegionLocations().isPresent()) {
            Thread.sleep(1000L);
            if (++retries != 10) continue;
        }
        List metaHRLs = (List)master.getMetaRegionLocationCache().getMetaRegionLocations().get();
        Assert.assertFalse((boolean)metaHRLs.isEmpty());
        ZKWatcher zk = master.getZooKeeper();
        List metaZnodes = zk.getMetaReplicaNodes();
        retries = 0;
        while (((List)master.getMetaRegionLocationCache().getMetaRegionLocations().get()).size() != metaZnodes.size()) {
            Thread.sleep(1000L);
            if (++retries != 10) continue;
        }
        Assert.assertEquals((long)metaZnodes.size(), (long)metaHRLs.size());
        List<HRegionLocation> actualHRLs = this.getCurrentMetaLocations(zk);
        Collections.sort(metaHRLs);
        Collections.sort(actualHRLs);
        Assert.assertEquals(actualHRLs, (Object)metaHRLs);
    }

    @Test
    public void testInitialMetaLocations() throws Exception {
        this.verifyCachedMetaLocations(TEST_UTIL.getMiniHBaseCluster().getMaster());
    }

    @Test
    public void testStandByMetaLocations() throws Exception {
        HMaster standBy = TEST_UTIL.getMiniHBaseCluster().startMaster().getMaster();
        standBy.isInitialized();
        this.verifyCachedMetaLocations(standBy);
    }

    @Test
    public void testMetaLocationsChange() throws Exception {
        List<HRegionLocation> currentMetaLocs = this.getCurrentMetaLocations(TEST_UTIL.getMiniHBaseCluster().getMaster().getZooKeeper());
        for (HRegionLocation location : currentMetaLocs) {
            RegionReplicaTestHelper.moveRegion(TEST_UTIL, location);
        }
        RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(TEST_UTIL, REGISTRY);
        for (JVMClusterUtil.MasterThread masterThread : TEST_UTIL.getMiniHBaseCluster().getMasterThreads()) {
            this.verifyCachedMetaLocations(masterThread.getMaster());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaRegionLocationCache() throws Exception {
        String parentZnodeName = "/randomznodename";
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("zookeeper.znode.parent", "/randomznodename");
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)5678L);
        try (final ZKWatcher zkWatcher = new ZKWatcher(conf, null, null, true);){
            MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
            ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){

                @Override
                public void doAnAction() throws Exception {
                    String testZnode = "/randomznodename/child";
                    ZKUtil.createNodeIfNotExistsAndWatch((ZKWatcher)zkWatcher, (String)"/randomznodename/child", (byte[])"/randomznodename/child".getBytes());
                    ZKUtil.deleteNode((ZKWatcher)zkWatcher, (String)"/randomznodename/child");
                }
            });
            ctx.startThreads();
            try {
                MetaRegionLocationCache metaCache = new MetaRegionLocationCache(zkWatcher);
                Assert.assertFalse((boolean)metaCache.getMetaRegionLocations().isPresent());
                for (int i = 0; i < 3; ++i) {
                    MetaTableLocator.setMetaLocation((ZKWatcher)zkWatcher, (ServerName)sn, (int)i, (RegionState.State)RegionState.State.OPEN);
                }
                int iters = 0;
                while (!(iters++ >= 10 || metaCache.getMetaRegionLocations().isPresent() && ((List)metaCache.getMetaRegionLocations().get()).size() == 3)) {
                    Thread.sleep(1000L);
                }
                List metaLocations = (List)metaCache.getMetaRegionLocations().get();
                Assert.assertEquals((long)3L, (long)metaLocations.size());
                for (HRegionLocation location : metaLocations) {
                    Assert.assertEquals((Object)sn, (Object)location.getServerName());
                }
            }
            finally {
                ctx.stop();
                ZKUtil.deleteChildrenRecursively((ZKWatcher)zkWatcher, (String)"/randomznodename");
            }
        }
    }
}

