/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableRSCrashPublish {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableRSCrashPublish.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"Publish");
    private static byte[] FAMILY = Bytes.toBytes((String)"family");

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        UTIL.startMiniCluster(2);
        UTIL.createTable(TABLE_NAME, FAMILY);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException, ExecutionException, InterruptedException {
        Configuration conf = UTIL.getHBaseCluster().getMaster().getConfiguration();
        try (AsyncConnection connection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();){
            AsyncNonMetaRegionLocator locator = ((AsyncConnectionImpl)connection).getLocator().getNonMetaRegionLocator();
            connection.getTable(TABLE_NAME).get(new Get(Bytes.toBytes((int)0))).join();
            ServerName serverName = locator.getRegionLocationInCache(TABLE_NAME, HConstants.EMPTY_START_ROW).getDefaultRegionLocation().getServerName();
            UTIL.getMiniHBaseCluster().stopRegionServer(serverName);
            UTIL.waitFor(60000L, () -> locator.getRegionLocationInCache(TABLE_NAME, HConstants.EMPTY_START_ROW) == null);
            connection.getTable(TABLE_NAME).get(new Get(Bytes.toBytes((int)0))).join();
            Assert.assertNotEquals((Object)serverName, (Object)locator.getRegionLocationInCache(TABLE_NAME, HConstants.EMPTY_START_ROW).getDefaultRegionLocation().getServerName());
        }
    }
}

