/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SplitNormalizationPlan
implements NormalizationPlan {
    private final RegionInfo regionInfo;

    public SplitNormalizationPlan(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    @Override
    public long submit(MasterServices masterServices) throws IOException {
        return masterServices.splitRegion(this.regionInfo, null, 0L, 0L);
    }

    @Override
    public NormalizationPlan.PlanType getType() {
        return NormalizationPlan.PlanType.SPLIT;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("regionInfo", (Object)this.regionInfo).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitNormalizationPlan that = (SplitNormalizationPlan)o;
        return new EqualsBuilder().append((Object)this.regionInfo, (Object)that.regionInfo).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.regionInfo).toHashCode();
    }
}

