/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.AsyncCallback;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Op;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Watcher;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooDefs;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Id;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.proto.CreateRequest;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.proto.DeleteRequest;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.proto.SetDataRequest;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ZKUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZKUtil.class);
    private static int zkDumpConnectionTimeOut;
    private static boolean useMultiWarn;

    private ZKUtil() {
    }

    public static RecoverableZooKeeper connect(Configuration conf, Watcher watcher) throws IOException {
        String ensemble = ZKConfig.getZKQuorumServersString(conf);
        return ZKUtil.connect(conf, ensemble, watcher);
    }

    public static RecoverableZooKeeper connect(Configuration conf, String ensemble, Watcher watcher) throws IOException {
        return ZKUtil.connect(conf, ensemble, watcher, null);
    }

    public static RecoverableZooKeeper connect(Configuration conf, String ensemble, Watcher watcher, String identifier) throws IOException {
        if (ensemble == null) {
            throw new IOException("Unable to determine ZooKeeper ensemble");
        }
        int timeout = conf.getInt("zookeeper.session.timeout", 90000);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} opening connection to ZooKeeper ensemble={}", (Object)identifier, (Object)ensemble);
        }
        int retry = conf.getInt("zookeeper.recovery.retry", 3);
        int retryIntervalMillis = conf.getInt("zookeeper.recovery.retry.intervalmill", 1000);
        int maxSleepTime = conf.getInt("zookeeper.recovery.retry.maxsleeptime", 60000);
        zkDumpConnectionTimeOut = conf.getInt("zookeeper.dump.connection.timeout", 1000);
        int multiMaxSize = conf.getInt("zookeeper.multi.max.size", 0x100000);
        return new RecoverableZooKeeper(ensemble, timeout, watcher, retry, retryIntervalMillis, maxSleepTime, identifier, multiMaxSize);
    }

    public static void loginServer(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.serverconfig", "zookeeper-server-keytab-kerberos");
    }

    public static void loginClient(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.clientconfig", "zookeeper-client-keytab-kerberos");
    }

    private static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname, String loginContextProperty, String loginContextName) throws IOException {
        if (!ZKUtil.isSecureZooKeeper(conf)) {
            return;
        }
        if (System.getProperty("java.security.auth.login.config") != null) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            LOG.warn("no keytab specified for: {}", (Object)keytabFileKey);
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal((String)principalConfig, (String)hostname);
        JaasConfiguration jaasConf = new JaasConfiguration(loginContextName, principalName, keytabFilename);
        javax.security.auth.login.Configuration.setConfiguration(jaasConf);
        System.setProperty(loginContextProperty, loginContextName);
    }

    public static String getParent(String node) {
        int idx = node.lastIndexOf(47);
        return idx <= 0 ? null : node.substring(0, idx);
    }

    public static String getNodeName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static boolean watchAndCheckExists(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            boolean exists;
            Stat s2 = zkw.getRecoverableZooKeeper().exists(znode, zkw);
            boolean bl = exists = s2 != null;
            if (exists) {
                LOG.debug(zkw.prefix("Set watcher on existing znode=" + znode));
            } else {
                LOG.debug(zkw.prefix("Set watcher on znode that does not yet exist, " + znode));
            }
            return exists;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static boolean setWatchIfNodeExists(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().getData(znode, true, null);
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int checkExists(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            Stat s2 = zkw.getRecoverableZooKeeper().exists(znode, null);
            return s2 != null ? s2.getVersion() : -1;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.keeperException(e);
            return -1;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static List<String> listChildrenAndWatchForNewChildren(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            return zkw.getRecoverableZooKeeper().getChildren(znode, zkw);
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug(zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.interruptedException(e);
        }
        return null;
    }

    public static List<String> listChildrenAndWatchThem(ZKWatcher zkw, String znode) throws KeeperException {
        List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(zkw, znode);
        if (children == null) {
            return null;
        }
        for (String child : children) {
            ZKUtil.watchAndCheckExists(zkw, ZNodePaths.joinZNode(znode, child));
        }
        return children;
    }

    public static List<String> listChildrenNoWatch(ZKWatcher zkw, String znode) throws KeeperException {
        List<String> children = null;
        try {
            children = zkw.getRecoverableZooKeeper().getChildren(znode, null);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
        return children;
    }

    public static boolean nodeHasChildren(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            return !zkw.getRecoverableZooKeeper().getChildren(znode, null).isEmpty();
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug(zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
            return false;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int getNumberOfChildren(ZKWatcher zkw, String znode) throws KeeperException {
        try {
            Stat stat = zkw.getRecoverableZooKeeper().exists(znode, null);
            return stat == null ? 0 : stat.getNumChildren();
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get children of node " + znode));
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
        }
        return 0;
    }

    public static byte[] getData(ZKWatcher zkw, String znode) throws KeeperException, InterruptedException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, null);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug(zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
    }

    public static byte[] getDataAndWatch(ZKWatcher zkw, String znode) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, null, true, true);
    }

    public static byte[] getDataAndWatch(ZKWatcher zkw, String znode, boolean throwOnInterrupt) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, null, true, throwOnInterrupt);
    }

    public static byte[] getDataAndWatch(ZKWatcher zkw, String znode, Stat stat) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, stat, true, true);
    }

    private static byte[] getDataInternal(ZKWatcher zkw, String znode, Stat stat, boolean watcherSet, boolean throwOnInterrupt) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, zkw, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, watcherSet);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.trace(zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            if (throwOnInterrupt) {
                zkw.interruptedException(e);
            } else {
                zkw.interruptedExceptionNoThrow(e, true);
            }
            return null;
        }
    }

    public static byte[] getDataNoWatch(ZKWatcher zkw, String znode, Stat stat) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug(zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not necessarily an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn(zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    @Deprecated
    public static List<NodeAndData> getChildDataAndWatchForNewChildren(ZKWatcher zkw, String baseNode) throws KeeperException {
        return ZKUtil.getChildDataAndWatchForNewChildren(zkw, baseNode, true);
    }

    @Deprecated
    public static List<NodeAndData> getChildDataAndWatchForNewChildren(ZKWatcher zkw, String baseNode, boolean throwOnInterrupt) throws KeeperException {
        List<String> nodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, baseNode);
        if (nodes != null) {
            ArrayList<NodeAndData> newNodes = new ArrayList<NodeAndData>();
            for (String node : nodes) {
                if (Thread.interrupted()) {
                    return Collections.emptyList();
                }
                String nodePath = ZNodePaths.joinZNode(baseNode, node);
                byte[] data = ZKUtil.getDataAndWatch(zkw, nodePath, throwOnInterrupt);
                newNodes.add(new NodeAndData(nodePath, data));
            }
            return newNodes;
        }
        return null;
    }

    @Deprecated
    public static void updateExistingNodeData(ZKWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static boolean setData(ZKWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        try {
            return zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion) != null;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
    }

    public static void createSetData(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        if (ZKUtil.checkExists(zkw, znode) == -1) {
            ZKUtil.createWithParents(zkw, znode, data);
        } else {
            ZKUtil.setData(zkw, znode, data);
        }
    }

    public static void setData(ZKWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZKUtil.setData(zkw, (ZKUtilOp.SetData)ZKUtilOp.setData(znode, data));
    }

    private static void setData(ZKWatcher zkw, ZKUtilOp.SetData setData) throws KeeperException, KeeperException.NoNodeException {
        SetDataRequest sd = (SetDataRequest)ZKUtil.toZooKeeperOp(zkw, setData).toRequestRecord();
        ZKUtil.setData(zkw, sd.getPath(), sd.getData(), sd.getVersion());
    }

    public static boolean isSecureZooKeeper(Configuration conf) {
        try {
            javax.security.auth.login.Configuration testConfig = javax.security.auth.login.Configuration.getConfiguration();
            if (testConfig.getAppConfigurationEntry("Client") == null && testConfig.getAppConfigurationEntry("zookeeper-client-keytab-kerberos") == null && testConfig.getAppConfigurationEntry("zookeeper-server-keytab-kerberos") == null && conf.get("hbase.zookeeper.client.kerberos.principal") == null && conf.get("hbase.zookeeper.server.kerberos.principal") == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return "kerberos".equalsIgnoreCase(conf.get("hbase.security.authentication"));
    }

    private static ArrayList<ACL> createACL(ZKWatcher zkw, String node) {
        return ZKUtil.createACL(zkw, node, ZKUtil.isSecureZooKeeper(zkw.getConfiguration()));
    }

    public static ArrayList<ACL> createACL(ZKWatcher zkw, String node, boolean isSecureZooKeeper) {
        if (!node.startsWith(zkw.getZNodePaths().baseZNode)) {
            return ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        if (isSecureZooKeeper) {
            ArrayList<ACL> acls = new ArrayList<ACL>();
            String[] superUsers = zkw.getConfiguration().getStrings("hbase.superuser");
            String hbaseUser = null;
            try {
                hbaseUser = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                LOG.debug("Could not acquire current User.", (Throwable)e);
            }
            if (superUsers != null) {
                ArrayList<String> groups = new ArrayList<String>();
                for (String user : superUsers) {
                    if (AuthUtil.isGroupPrincipal(user)) {
                        groups.add(user);
                        continue;
                    }
                    if (user.equals(hbaseUser)) continue;
                    acls.add(new ACL(31, new Id("sasl", user)));
                }
                if (!groups.isEmpty()) {
                    LOG.warn("Znode ACL setting for group {} is skipped, ZooKeeper doesn't support this feature presently.", groups);
                }
            }
            if (zkw.getZNodePaths().isClientReadable(node)) {
                acls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
                acls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
            } else {
                acls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            }
            return acls;
        }
        return ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    public static boolean createEphemeralNodeAndWatch(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!ZKUtil.watchAndCheckExists(zkw, znode)) {
            return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, data);
        }
        return ret;
    }

    public static boolean createNodeIfNotExistsAndWatch(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        try {
            zkw.getRecoverableZooKeeper().exists(znode, zkw);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        return ret;
    }

    public static String createNodeIfNotExistsNoWatch(ZKWatcher zkw, String znode, byte[] data, CreateMode createMode) throws KeeperException {
        String createdZNode = null;
        try {
            createdZNode = zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), createMode);
        }
        catch (KeeperException.NodeExistsException nee) {
            return znode;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return null;
        }
        return createdZNode;
    }

    public static int createAndWatch(ZKWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NodeExistsException {
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
            Stat stat = zkw.getRecoverableZooKeeper().exists(znode, zkw);
            if (stat == null) {
                throw KeeperException.create(KeeperException.Code.SYSTEMERROR, "ZK.exists returned null (i.e.: znode does not exist) for znode=" + znode);
            }
            return stat.getVersion();
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static void asyncCreate(ZKWatcher zkw, String znode, byte[] data, AsyncCallback.StringCallback cb, Object ctx) {
        zkw.getRecoverableZooKeeper().getZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT, cb, ctx);
    }

    public static void createAndFailSilent(ZKWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, znode, new byte[0]);
    }

    public static void createAndFailSilent(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)ZKUtilOp.createAndFailSilent(znode, data));
    }

    private static void createAndFailSilent(ZKWatcher zkw, ZKUtilOp.CreateAndFailSilent cafs) throws KeeperException {
        CreateRequest create = (CreateRequest)ZKUtil.toZooKeeperOp(zkw, cafs).toRequestRecord();
        String znode = create.getPath();
        try {
            RecoverableZooKeeper zk = zkw.getRecoverableZooKeeper();
            if (zk.exists(znode, false) == null) {
                zk.create(znode, create.getData(), create.getAcl(), CreateMode.fromFlag(create.getFlags()));
            }
        }
        catch (KeeperException.NodeExistsException zk) {
        }
        catch (KeeperException.NoAuthException nee) {
            try {
                if (null == zkw.getRecoverableZooKeeper().exists(znode, false)) {
                    throw nee;
                }
            }
            catch (InterruptedException ie) {
                zkw.interruptedException(ie);
            }
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void createWithParents(ZKWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createWithParents(zkw, znode, new byte[0]);
    }

    public static void createWithParents(ZKWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            if (znode == null) {
                return;
            }
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            return;
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createWithParents(zkw, ZKUtil.getParent(znode));
            ZKUtil.createWithParents(zkw, znode, data);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNode(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNode(zkw, node, -1);
    }

    public static boolean deleteNode(ZKWatcher zkw, String node, int version) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().delete(node, version);
            return true;
        }
        catch (KeeperException.BadVersionException bve) {
            return false;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
            return false;
        }
    }

    public static void deleteNodeFailSilent(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)ZKUtilOp.deleteNodeFailSilent(node));
    }

    private static void deleteNodeFailSilent(ZKWatcher zkw, ZKUtilOp.DeleteNodeFailSilent dnfs) throws KeeperException {
        DeleteRequest delete = (DeleteRequest)ZKUtil.toZooKeeperOp(zkw, dnfs).toRequestRecord();
        try {
            zkw.getRecoverableZooKeeper().delete(delete.getPath(), delete.getVersion());
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNodeRecursively(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNodeRecursivelyMultiOrSequential(zkw, true, node);
    }

    public static void deleteChildrenRecursively(ZKWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential(zkw, true, node);
    }

    public static void deleteChildrenRecursivelyMultiOrSequential(ZKWatcher zkw, boolean runSequentialOnMultiFailure, String ... pathRoots) throws KeeperException {
        if (pathRoots == null || pathRoots.length <= 0) {
            LOG.warn("Given path is not valid!");
            return;
        }
        ArrayList<ZKUtilOp> ops = new ArrayList<ZKUtilOp>();
        for (String eachRoot : pathRoots) {
            List<String> children = ZKUtil.listChildrenBFSNoWatch(zkw, eachRoot);
            for (int i = children.size() - 1; i >= 0; --i) {
                ops.add(ZKUtilOp.deleteNodeFailSilent(children.get(i)));
            }
        }
        ZKUtil.submitBatchedMultiOrSequential(zkw, runSequentialOnMultiFailure, ops);
    }

    public static void deleteNodeRecursivelyMultiOrSequential(ZKWatcher zkw, boolean runSequentialOnMultiFailure, String ... pathRoots) throws KeeperException {
        if (pathRoots == null || pathRoots.length <= 0) {
            LOG.warn("Given path is not valid!");
            return;
        }
        ArrayList<ZKUtilOp> ops = new ArrayList<ZKUtilOp>();
        for (String eachRoot : pathRoots) {
            List<String> children = ZKUtil.listChildrenBFSAndWatchThem(zkw, eachRoot);
            for (int i = children.size() - 1; i >= 0; --i) {
                ops.add(ZKUtilOp.deleteNodeFailSilent(children.get(i)));
            }
            try {
                if (zkw.getRecoverableZooKeeper().exists(eachRoot, zkw) == null) continue;
                ops.add(ZKUtilOp.deleteNodeFailSilent(eachRoot));
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
            }
        }
        ZKUtil.submitBatchedMultiOrSequential(zkw, runSequentialOnMultiFailure, ops);
    }

    private static void submitBatchedMultiOrSequential(ZKWatcher zkw, boolean runSequentialOnMultiFailure, List<ZKUtilOp> ops) throws KeeperException {
        if (ops.isEmpty()) {
            return;
        }
        int maxMultiSize = zkw.getRecoverableZooKeeper().getMaxMultiSizeLimit();
        List<List<ZKUtilOp>> batchedOps = ZKUtil.partitionOps(ops, maxMultiSize);
        for (List<ZKUtilOp> batch : batchedOps) {
            ZKUtil.multiOrSequential(zkw, batch, runSequentialOnMultiFailure);
        }
    }

    static List<List<ZKUtilOp>> partitionOps(List<ZKUtilOp> ops, int maxPartitionSize) {
        ArrayList<List<ZKUtilOp>> partitionedOps = new ArrayList<List<ZKUtilOp>>();
        ArrayList<ZKUtilOp> currentPartition = new ArrayList<ZKUtilOp>();
        int currentPartitionSize = 0;
        partitionedOps.add(currentPartition);
        for (ZKUtilOp currentOp : ops) {
            int currentOpSize = ZKUtil.estimateSize(currentOp);
            if (!currentPartition.isEmpty() && currentOpSize + currentPartitionSize > maxPartitionSize) {
                currentPartition = new ArrayList();
                partitionedOps.add(currentPartition);
                currentPartitionSize = 0;
            }
            currentPartition.add(currentOp);
            currentPartitionSize += currentOpSize;
        }
        return partitionedOps;
    }

    static int estimateSize(ZKUtilOp op) {
        return Bytes.toBytes(op.getPath()).length;
    }

    private static List<String> listChildrenBFSNoWatch(ZKWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil.listChildrenNoWatch(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static List<String> listChildrenBFSAndWatchThem(ZKWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil.listChildrenAndWatchThem(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static Op toZooKeeperOp(ZKWatcher zkw, ZKUtilOp op) throws UnsupportedOperationException {
        if (op == null) {
            return null;
        }
        if (op instanceof ZKUtilOp.CreateAndFailSilent) {
            ZKUtilOp.CreateAndFailSilent cafs = (ZKUtilOp.CreateAndFailSilent)op;
            return Op.create(cafs.getPath(), cafs.getData(), ZKUtil.createACL(zkw, cafs.getPath()), CreateMode.PERSISTENT);
        }
        if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
            ZKUtilOp.DeleteNodeFailSilent dnfs = (ZKUtilOp.DeleteNodeFailSilent)op;
            return Op.delete(dnfs.getPath(), -1);
        }
        if (op instanceof ZKUtilOp.SetData) {
            ZKUtilOp.SetData sd = (ZKUtilOp.SetData)op;
            return Op.setData(sd.getPath(), sd.getData(), sd.getVersion());
        }
        throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
    }

    public static void multiOrSequential(ZKWatcher zkw, List<ZKUtilOp> ops, boolean runSequentialOnMultiFailure) throws KeeperException {
        if (ops == null) {
            return;
        }
        if (useMultiWarn) {
            if (zkw.getConfiguration().get("hbase.zookeeper.useMulti") != null) {
                LOG.warn("hbase.zookeeper.useMulti is deprecated. Default to true always.");
            }
            useMultiWarn = false;
        }
        LinkedList<Op> zkOps = new LinkedList<Op>();
        for (ZKUtilOp op : ops) {
            zkOps.add(ZKUtil.toZooKeeperOp(zkw, op));
        }
        try {
            zkw.getRecoverableZooKeeper().multi(zkOps);
        }
        catch (KeeperException ke) {
            switch (ke.code()) {
                case NODEEXISTS: 
                case NONODE: 
                case BADVERSION: 
                case NOAUTH: 
                case NOTEMPTY: {
                    if (runSequentialOnMultiFailure) {
                        LOG.info("multi exception: {}; running operations sequentially (runSequentialOnMultiFailure=true); {}", (Object)ke.toString(), (Object)ops.stream().map(o -> o.toString()).collect(Collectors.joining(",")));
                        ZKUtil.processSequentially(zkw, ops);
                        break;
                    }
                }
                default: {
                    throw ke;
                }
            }
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    private static void processSequentially(ZKWatcher zkw, List<ZKUtilOp> ops) throws KeeperException, KeeperException.NoNodeException {
        for (ZKUtilOp op : ops) {
            if (op instanceof ZKUtilOp.CreateAndFailSilent) {
                ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
                ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.SetData) {
                ZKUtil.setData(zkw, (ZKUtilOp.SetData)op);
                continue;
            }
            throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
        }
    }

    public static String dump(ZKWatcher zkw) {
        StringBuilder sb = new StringBuilder();
        try {
            String[] servers;
            sb.append("HBase is rooted at ").append(zkw.getZNodePaths().baseZNode);
            sb.append("\nActive master address: ");
            try {
                sb.append("\n ").append(MasterAddressTracker.getMasterAddress(zkw));
            }
            catch (IOException e) {
                sb.append("<<FAILED LOOKUP: " + e.getMessage() + ">>");
            }
            sb.append("\nBackup master addresses:");
            List<String> backupMasterChildrenNoWatchList = ZKUtil.listChildrenNoWatch(zkw, zkw.getZNodePaths().backupMasterAddressesZNode);
            if (backupMasterChildrenNoWatchList != null) {
                for (String child : backupMasterChildrenNoWatchList) {
                    sb.append("\n ").append(child);
                }
            }
            sb.append("\nRegion server holding hbase:meta:");
            sb.append("\n ").append(MetaTableLocator.getMetaRegionLocation(zkw));
            Configuration conf = HBaseConfiguration.create();
            int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
            for (int i = 1; i < numMetaReplicas; ++i) {
                sb.append("\n replica" + i + ": " + MetaTableLocator.getMetaRegionLocation(zkw, i));
            }
            sb.append("\nRegion servers:");
            List<String> rsChildrenNoWatchList = ZKUtil.listChildrenNoWatch(zkw, zkw.getZNodePaths().rsZNode);
            if (rsChildrenNoWatchList != null) {
                for (String child : rsChildrenNoWatchList) {
                    sb.append("\n ").append(child);
                }
            }
            try {
                ZKUtil.getReplicationZnodesDump(zkw, sb);
            }
            catch (KeeperException ke) {
                LOG.warn("Couldn't get the replication znode dump", (Throwable)ke);
            }
            sb.append("\nQuorum Server Statistics:");
            for (String server : servers = zkw.getQuorum().split(",")) {
                sb.append("\n ").append(server);
                try {
                    String[] stat = ZKUtil.getServerStats(server, zkDumpConnectionTimeOut);
                    if (stat == null) {
                        sb.append("[Error] invalid quorum server: " + server);
                        break;
                    }
                    for (String s2 : stat) {
                        sb.append("\n  ").append(s2);
                    }
                }
                catch (Exception e) {
                    sb.append("\n  ERROR: ").append(e.getMessage());
                }
            }
        }
        catch (KeeperException ke) {
            sb.append("\nFATAL ZooKeeper Exception!\n");
            sb.append("\n" + ke.getMessage());
        }
        return sb.toString();
    }

    private static void getReplicationZnodesDump(ZKWatcher zkw, StringBuilder sb) throws KeeperException {
        String replicationZnode = zkw.getZNodePaths().replicationZNode;
        if (ZKUtil.checkExists(zkw, replicationZnode) == -1) {
            return;
        }
        sb.append("\n").append(replicationZnode).append(": ");
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, replicationZnode);
        if (children != null) {
            Collections.sort(children);
            for (String child : children) {
                String zNode = ZNodePaths.joinZNode(replicationZnode, child);
                if (zNode.equals(zkw.getZNodePaths().peersZNode)) {
                    ZKUtil.appendPeersZnodes(zkw, zNode, sb);
                    continue;
                }
                if (zNode.equals(zkw.getZNodePaths().queuesZNode)) {
                    ZKUtil.appendRSZnodes(zkw, zNode, sb);
                    continue;
                }
                if (!zNode.equals(zkw.getZNodePaths().hfileRefsZNode)) continue;
                ZKUtil.appendHFileRefsZNodes(zkw, zNode, sb);
            }
        }
    }

    private static void appendHFileRefsZNodes(ZKWatcher zkw, String hFileRefsZNode, StringBuilder sb) throws KeeperException {
        sb.append("\n").append(hFileRefsZNode).append(": ");
        List<String> hFileRefChildrenNoWatchList = ZKUtil.listChildrenNoWatch(zkw, hFileRefsZNode);
        if (hFileRefChildrenNoWatchList != null) {
            for (String peerIdZNode : hFileRefChildrenNoWatchList) {
                String zNodeToProcess = ZNodePaths.joinZNode(hFileRefsZNode, peerIdZNode);
                sb.append("\n").append(zNodeToProcess).append(": ");
                List<String> peerHFileRefsZNodes = ZKUtil.listChildrenNoWatch(zkw, zNodeToProcess);
                if (peerHFileRefsZNodes == null) continue;
                sb.append(String.join((CharSequence)", ", peerHFileRefsZNodes));
            }
        }
    }

    public static String getReplicationZnodesDump(ZKWatcher zkw) throws KeeperException {
        StringBuilder sb = new StringBuilder();
        ZKUtil.getReplicationZnodesDump(zkw, sb);
        return sb.toString();
    }

    private static void appendRSZnodes(ZKWatcher zkw, String znode, StringBuilder sb) throws KeeperException {
        LinkedList<String> stack = new LinkedList<String>();
        stack.add(znode);
        do {
            byte[] data;
            String znodeToProcess = (String)stack.remove(stack.size() - 1);
            sb.append("\n").append(znodeToProcess).append(": ");
            try {
                data = ZKUtil.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            if (data != null && data.length > 0) {
                long position = 0L;
                try {
                    position = ZKUtil.parseWALPositionFrom(ZKUtil.getData(zkw, znodeToProcess));
                    sb.append(position);
                }
                catch (DeserializationException deserializationException) {
                }
                catch (InterruptedException e) {
                    zkw.interruptedException(e);
                    return;
                }
            }
            for (String zNodeChild : ZKUtil.listChildrenNoWatch(zkw, znodeToProcess)) {
                stack.add(ZNodePaths.joinZNode(znodeToProcess, zNodeChild));
            }
        } while (stack.size() > 0);
    }

    private static void appendPeersZnodes(ZKWatcher zkw, String peersZnode, StringBuilder sb) throws KeeperException {
        int pblen = ProtobufUtil.lengthOfPBMagic();
        sb.append("\n").append(peersZnode).append(": ");
        for (String peerIdZnode : ZKUtil.listChildrenNoWatch(zkw, peersZnode)) {
            byte[] data;
            String znodeToProcess = ZNodePaths.joinZNode(peersZnode, peerIdZnode);
            try {
                data = ZKUtil.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            try {
                ReplicationProtos.ReplicationPeer.Builder builder = ReplicationProtos.ReplicationPeer.newBuilder();
                ProtobufUtil.mergeFrom(builder, data, pblen, data.length - pblen);
                String clusterKey = builder.getClusterkey();
                sb.append("\n").append(znodeToProcess).append(": ").append(clusterKey);
                ZKUtil.appendPeerState(zkw, znodeToProcess, sb);
            }
            catch (IOException ipbe) {
                LOG.warn("Got Exception while parsing peer: " + znodeToProcess, (Throwable)ipbe);
            }
        }
    }

    private static void appendPeerState(ZKWatcher zkw, String znodeToProcess, StringBuilder sb) throws KeeperException, InvalidProtocolBufferException {
        String peerState = zkw.getConfiguration().get("zookeeper.znode.replication.peers.state", "peer-state");
        int pblen = ProtobufUtil.lengthOfPBMagic();
        for (String child : ZKUtil.listChildrenNoWatch(zkw, znodeToProcess)) {
            if (!child.equals(peerState)) continue;
            String peerStateZnode = ZNodePaths.joinZNode(znodeToProcess, child);
            sb.append("\n").append(peerStateZnode).append(": ");
            try {
                byte[] peerStateData = ZKUtil.getData(zkw, peerStateZnode);
                ReplicationProtos.ReplicationState.Builder builder = ReplicationProtos.ReplicationState.newBuilder();
                ProtobufUtil.mergeFrom(builder, peerStateData, pblen, peerStateData.length - pblen);
                sb.append(builder.getState().name());
            }
            catch (IOException ipbe) {
                LOG.warn("Got Exception while parsing peer: " + znodeToProcess, (Throwable)ipbe);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String[] getServerStats(String server, int timeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void logRetrievedMsg(ZKWatcher zkw, String znode, byte[] data, boolean watcherSet) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        LOG.trace(zkw.prefix("Retrieved " + (data == null ? 0 : data.length) + " byte(s) of data from znode " + znode + (watcherSet ? " and set watcher; " : "; data=") + (data == null ? "null" : (data.length == 0 ? "empty" : (zkw.getZNodePaths().isMetaZNodePrefix(znode) ? ZKUtil.getServerNameOrEmptyString(data) : (znode.startsWith(zkw.getZNodePaths().backupMasterAddressesZNode) ? ZKUtil.getServerNameOrEmptyString(data) : StringUtils.abbreviate(Bytes.toStringBinary(data), 32)))))));
    }

    private static String getServerNameOrEmptyString(byte[] data) {
        try {
            return ProtobufUtil.parseServerNameFrom(data).toString();
        }
        catch (DeserializationException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBaseZNode(Configuration conf) throws IOException {
        LOG.info("Waiting until the base znode is available");
        String parentZNode = conf.get("zookeeper.znode.parent", "/hbase");
        ZooKeeper zk = new ZooKeeper(ZKConfig.getZKQuorumServersString(conf), conf.getInt("zookeeper.session.timeout", 90000), EmptyWatcher.instance);
        int maxTimeMs = 10000;
        int maxNumAttempts = 50;
        KeeperException keeperEx = null;
        try {
            try {
                for (int attempt = 0; attempt < 50; ++attempt) {
                    block9: {
                        try {
                            if (zk.exists(parentZNode, false) == null) break block9;
                            LOG.info("Parent znode exists: {}", (Object)parentZNode);
                            keeperEx = null;
                            break;
                        }
                        catch (KeeperException e) {
                            keeperEx = e;
                        }
                    }
                    Threads.sleepWithoutInterrupt(200L);
                }
            }
            finally {
                zk.close();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (keeperEx != null) {
            throw new IOException(keeperEx);
        }
    }

    public static KeeperException convert(DeserializationException e) {
        KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
        ke.initCause(e);
        return ke;
    }

    public static void logZKTree(ZKWatcher zkw, String root) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Current zk system:");
        String prefix = "|-";
        LOG.debug(prefix + root);
        try {
            ZKUtil.logZKTree(zkw, root, prefix);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    private static void logZKTree(ZKWatcher zkw, String root, String prefix) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, root);
        if (children == null) {
            return;
        }
        for (String child : children) {
            LOG.debug(prefix + child);
            String node = ZNodePaths.joinZNode(root.equals("/") ? "" : root, child);
            ZKUtil.logZKTree(zkw, node, prefix + "---");
        }
    }

    public static byte[] positionToByteArray(long position) {
        byte[] bytes = ReplicationProtos.ReplicationHLogPosition.newBuilder().setPosition(position).build().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static long parseWALPositionFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            throw new DeserializationException("Unable to parse null WAL position.");
        }
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            ReplicationProtos.ReplicationHLogPosition position;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ReplicationProtos.ReplicationHLogPosition.Builder builder = ReplicationProtos.ReplicationHLogPosition.newBuilder();
            try {
                ProtobufUtil.mergeFrom(builder, bytes, pblen, bytes.length - pblen);
                position = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
            return position.getPosition();
        }
        if (bytes.length > 0) {
            return Bytes.toLong(bytes);
        }
        return 0L;
    }

    static {
        useMultiWarn = true;
    }

    public static abstract class ZKUtilOp {
        private String path;

        public String toString() {
            return this.getClass().getSimpleName() + ", path=" + this.path;
        }

        private ZKUtilOp(String path) {
            this.path = path;
        }

        public static ZKUtilOp createAndFailSilent(String path, byte[] data) {
            return new CreateAndFailSilent(path, data);
        }

        public static ZKUtilOp deleteNodeFailSilent(String path) {
            return new DeleteNodeFailSilent(path);
        }

        public static ZKUtilOp setData(String path, byte[] data) {
            return new SetData(path, data);
        }

        public static ZKUtilOp setData(String path, byte[] data, int version) {
            return new SetData(path, data, version);
        }

        public String getPath() {
            return this.path;
        }

        public static final class SetData
        extends ZKUtilOp {
            private byte[] data;
            private int version = -1;

            private SetData(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            private SetData(String path, byte[] data, int version) {
                super(path);
                this.data = data;
                this.version = version;
            }

            public byte[] getData() {
                return this.data;
            }

            public int getVersion() {
                return this.version;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SetData)) {
                    return false;
                }
                SetData op = (SetData)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data) && this.getVersion() == op.getVersion();
            }

            public int hashCode() {
                int ret = this.getPath().hashCode();
                ret = ret * 31 + Bytes.hashCode(this.data);
                return ret * 31 + Integer.hashCode(this.version);
            }
        }

        public static final class DeleteNodeFailSilent
        extends ZKUtilOp {
            private DeleteNodeFailSilent(String path) {
                super(path);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DeleteNodeFailSilent)) {
                    return false;
                }
                return super.equals(o);
            }

            public int hashCode() {
                return this.getPath().hashCode();
            }
        }

        public static final class CreateAndFailSilent
        extends ZKUtilOp {
            private byte[] data;

            private CreateAndFailSilent(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CreateAndFailSilent)) {
                    return false;
                }
                CreateAndFailSilent op = (CreateAndFailSilent)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }

            public int hashCode() {
                int ret = 17 + this.getPath().hashCode() * 31;
                return ret * 31 + Bytes.hashCode(this.data);
            }
        }
    }

    @Deprecated
    public static class NodeAndData {
        private String node;
        private byte[] data;

        public NodeAndData(String node, byte[] data) {
            this.node = node;
            this.data = data;
        }

        public String getNode() {
            return this.node;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.node;
        }

        public boolean isEmpty() {
            return this.data == null || this.data.length == 0;
        }
    }

    private static class JaasConfiguration
    extends javax.security.auth.login.Configuration {
        private static final String SERVER_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-server-keytab-kerberos";
        private static final String CLIENT_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-client-keytab-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;
        private javax.security.auth.login.Configuration baseConfig;
        private final String loginContextName;
        private final boolean useTicketCache;
        private final String keytabFile;
        private final String principal;

        public JaasConfiguration(String loginContextName, String principal, String keytabFile) {
            this(loginContextName, principal, keytabFile, keytabFile == null || keytabFile.length() == 0);
        }

        private JaasConfiguration(String loginContextName, String principal, String keytabFile, boolean useTicketCache) {
            try {
                this.baseConfig = javax.security.auth.login.Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
            this.loginContextName = loginContextName;
            this.useTicketCache = useTicketCache;
            this.keytabFile = keytabFile;
            this.principal = principal;
            LOG.info("JaasConfiguration loginContextName={} principal={} useTicketCache={} keytabFile={}", new Object[]{loginContextName, principal, useTicketCache, keytabFile});
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                if (!this.useTicketCache) {
                    KEYTAB_KERBEROS_OPTIONS.put("keyTab", this.keytabFile);
                    KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
                }
                KEYTAB_KERBEROS_OPTIONS.put("principal", this.principal);
                KEYTAB_KERBEROS_OPTIONS.put("useTicketCache", this.useTicketCache ? "true" : "false");
                return KEYTAB_KERBEROS_CONF;
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }

        static {
            String jaasEnvVar = System.getenv("HBASE_JAAS_DEBUG");
            if ("true".equalsIgnoreCase(jaasEnvVar)) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN};
        }
    }
}

