/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MajorCompactionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(MajorCompactionRequest.class);
    protected final Configuration configuration;
    protected final RegionInfo region;
    private Set<String> stores;

    MajorCompactionRequest(Configuration configuration, RegionInfo region) {
        this.configuration = configuration;
        this.region = region;
    }

    @VisibleForTesting
    MajorCompactionRequest(Configuration configuration, RegionInfo region, Set<String> stores) {
        this(configuration, region);
        this.stores = stores;
    }

    static Optional<MajorCompactionRequest> newRequest(Configuration configuration, RegionInfo info, Set<String> stores, long timestamp) throws IOException {
        MajorCompactionRequest request = new MajorCompactionRequest(configuration, info, stores);
        return request.createRequest(configuration, stores, timestamp);
    }

    RegionInfo getRegion() {
        return this.region;
    }

    Set<String> getStores() {
        return this.stores;
    }

    void setStores(Set<String> stores) {
        this.stores = stores;
    }

    @VisibleForTesting
    Optional<MajorCompactionRequest> createRequest(Configuration configuration, Set<String> stores, long timestamp) throws IOException {
        Set<String> familiesToCompact = this.getStoresRequiringCompaction(stores, timestamp);
        MajorCompactionRequest request = null;
        if (!familiesToCompact.isEmpty()) {
            request = new MajorCompactionRequest(configuration, this.region, familiesToCompact);
        }
        return Optional.ofNullable(request);
    }

    Set<String> getStoresRequiringCompaction(Set<String> requestedStores, long timestamp) throws IOException {
        try (Connection connection = this.getConnection(this.configuration);){
            HRegionFileSystem fileSystem = this.getFileSystem(connection);
            HashSet<String> familiesToCompact = Sets.newHashSet();
            for (String family : requestedStores) {
                if (!this.shouldCFBeCompacted(fileSystem, family, timestamp)) continue;
                familiesToCompact.add(family);
            }
            HashSet<String> hashSet = familiesToCompact;
            return hashSet;
        }
    }

    boolean shouldCFBeCompacted(HRegionFileSystem fileSystem, String family, long ts) throws IOException {
        Collection<StoreFileInfo> storeFiles = fileSystem.getStoreFiles(family);
        if (storeFiles == null) {
            LOG.info("Excluding store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName(), (Object)" has no store files");
            return false;
        }
        if (fileSystem.hasReferences(family) && this.familyHasReferenceFile(fileSystem, family, ts)) {
            LOG.info("Including store: " + family + " with: " + storeFiles.size() + " files for compaction for region: " + fileSystem.getRegionInfo().getEncodedName());
            return true;
        }
        boolean includeStore = this.shouldIncludeStore(fileSystem, family, storeFiles, ts);
        if (!includeStore) {
            LOG.info("Excluding store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName() + " already compacted");
        }
        return includeStore;
    }

    protected boolean shouldIncludeStore(HRegionFileSystem fileSystem, String family, Collection<StoreFileInfo> storeFiles, long ts) throws IOException {
        for (StoreFileInfo storeFile : storeFiles) {
            if (storeFile.getModificationTime() >= ts) continue;
            LOG.info("Including store: " + family + " with: " + storeFiles.size() + " files for compaction for region: " + fileSystem.getRegionInfo().getEncodedName());
            return true;
        }
        return false;
    }

    @VisibleForTesting
    Connection getConnection(Configuration configuration) throws IOException {
        return ConnectionFactory.createConnection(configuration);
    }

    protected boolean familyHasReferenceFile(HRegionFileSystem fileSystem, String family, long ts) throws IOException {
        List<Path> referenceFiles = this.getReferenceFilePaths(fileSystem.getFileSystem(), fileSystem.getStoreDir(family));
        for (Path referenceFile : referenceFiles) {
            FileStatus status = fileSystem.getFileSystem().getFileLinkStatus(referenceFile);
            if (status.getModificationTime() >= ts) continue;
            LOG.info("Including store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName() + " (reference store files)");
            return true;
        }
        return false;
    }

    @VisibleForTesting
    List<Path> getReferenceFilePaths(FileSystem fileSystem, Path familyDir) throws IOException {
        return FSUtils.getReferenceFilePaths(fileSystem, familyDir);
    }

    @VisibleForTesting
    HRegionFileSystem getFileSystem(Connection connection) throws IOException {
        Admin admin = connection.getAdmin();
        return HRegionFileSystem.openRegionFromFileSystem(admin.getConfiguration(), CommonFSUtils.getCurrentFileSystem(admin.getConfiguration()), CommonFSUtils.getTableDir(CommonFSUtils.getRootDir(admin.getConfiguration()), this.region.getTable()), this.region, true);
    }

    public String toString() {
        return "region: " + this.region.getEncodedName() + " store(s): " + this.stores;
    }
}

