/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class PermissionStorage {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "acl");
    public static final byte[] ACL_GLOBAL_NAME = ACL_TABLE_NAME.getName();
    public static final String ACL_LIST_FAMILY_STR = "l";
    public static final byte[] ACL_LIST_FAMILY = Bytes.toBytes("l");
    public static final byte ACL_TAG_TYPE = 1;
    public static final char NAMESPACE_PREFIX = '@';
    public static final char ACL_KEY_DELIMITER = ',';
    private static final Logger LOG = LoggerFactory.getLogger(PermissionStorage.class);
    private static final int LIST_CODE = 61;
    private static final int WRITABLE_CODE = 14;
    private static final int WRITABLE_NOT_ENCODED = 0;

    private PermissionStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUserPermission(Configuration conf, UserPermission userPerm, Table t, boolean mergeExistingPermissions) throws IOException {
        Permission permission = userPerm.getPermission();
        Permission.Action[] actions = permission.getActions();
        byte[] rowKey = PermissionStorage.userPermissionRowKey(permission);
        Put p = new Put(rowKey);
        byte[] key = PermissionStorage.userPermissionKey(userPerm);
        if (actions == null || actions.length == 0) {
            String msg = "No actions associated with user '" + userPerm.getUser() + "'";
            LOG.warn(msg);
            throw new IOException(msg);
        }
        TreeSet<Permission.Action> actionSet = new TreeSet<Permission.Action>();
        if (mergeExistingPermissions) {
            List<UserPermission> perms = PermissionStorage.getUserPermissions(conf, rowKey, null, null, null, false);
            UserPermission currentPerm = null;
            for (UserPermission perm : perms) {
                if (!userPerm.equalsExceptActions(perm)) continue;
                currentPerm = perm;
                break;
            }
            if (currentPerm != null && currentPerm.getPermission().getActions() != null) {
                actionSet.addAll(Arrays.asList(currentPerm.getPermission().getActions()));
            }
        }
        actionSet.addAll(Arrays.asList(actions));
        byte[] value = new byte[actionSet.size()];
        int index = 0;
        for (Permission.Action action : actionSet) {
            value[index++] = action.code();
        }
        p.add(CellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(p.getRow()).setFamily(ACL_LIST_FAMILY).setQualifier(key).setTimestamp(p.getTimestamp()).setType(Cell.Type.Put).setValue(value).build());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing permission with rowKey " + Bytes.toString(rowKey) + " " + Bytes.toString(key) + ": " + Bytes.toStringBinary(value));
        }
        try {
            t.put(p);
        }
        finally {
            t.close();
        }
    }

    static void addUserPermission(Configuration conf, UserPermission userPerm, Table t) throws IOException {
        PermissionStorage.addUserPermission(conf, userPerm, t, false);
    }

    public static void removeUserPermission(Configuration conf, UserPermission userPerm, Table t) throws IOException {
        if (null == userPerm.getPermission().getActions() || userPerm.getPermission().getActions().length == 0) {
            PermissionStorage.removePermissionRecord(conf, userPerm, t);
        } else {
            List<UserPermission> permsList = PermissionStorage.getUserPermissions(conf, PermissionStorage.userPermissionRowKey(userPerm.getPermission()), null, null, null, false);
            ArrayList<Permission.Action> remainingActions = new ArrayList<Permission.Action>();
            List<Permission.Action> dropActions = Arrays.asList(userPerm.getPermission().getActions());
            for (UserPermission perm : permsList) {
                if (!perm.getUser().equals(userPerm.getUser())) continue;
                for (Permission.Action oldAction : perm.getPermission().getActions()) {
                    if (dropActions.contains((Object)oldAction)) continue;
                    remainingActions.add(oldAction);
                }
                if (!remainingActions.isEmpty()) {
                    perm.getPermission().setActions(remainingActions.toArray(new Permission.Action[remainingActions.size()]));
                    PermissionStorage.addUserPermission(conf, perm, t);
                    break;
                }
                PermissionStorage.removePermissionRecord(conf, userPerm, t);
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed permission " + userPerm.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removePermissionRecord(Configuration conf, UserPermission userPerm, Table t) throws IOException {
        Delete d = new Delete(PermissionStorage.userPermissionRowKey(userPerm.getPermission()));
        d.addColumns(ACL_LIST_FAMILY, PermissionStorage.userPermissionKey(userPerm));
        try {
            t.delete(d);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTablePermissions(Configuration conf, TableName tableName, Table t) throws IOException {
        Delete d = new Delete(tableName.getName());
        d.addFamily(ACL_LIST_FAMILY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing permissions of removed table " + tableName);
        }
        try {
            t.delete(d);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeNamespacePermissions(Configuration conf, String namespace, Table t) throws IOException {
        Delete d = new Delete(Bytes.toBytes(PermissionStorage.toNamespaceEntry(namespace)));
        d.addFamily(ACL_LIST_FAMILY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing permissions of removed namespace " + namespace);
        }
        try {
            t.delete(d);
        }
        finally {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeTablePermissions(TableName tableName, byte[] column, Table table, boolean closeTable) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        String columnName = Bytes.toString(column);
        scan.setFilter(new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(String.format("(%s%s%s)|(%s%s)$", Character.valueOf(','), columnName, Character.valueOf(','), Character.valueOf(','), columnName))));
        TreeSet<byte[]> qualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        ResultScanner scanner = null;
        try {
            scanner = table.getScanner(scan);
            for (Result res : scanner) {
                for (byte[] q : res.getFamilyMap(ACL_LIST_FAMILY).navigableKeySet()) {
                    qualifierSet.add(q);
                }
            }
            if (qualifierSet.size() > 0) {
                Delete d = new Delete(tableName.getName());
                for (byte[] qualifier : qualifierSet) {
                    d.addColumns(ACL_LIST_FAMILY, qualifier);
                }
                table.delete(d);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (closeTable) {
                table.close();
            }
        }
    }

    static void removeTablePermissions(Configuration conf, TableName tableName, byte[] column, Table t) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing permissions of removed column " + Bytes.toString(column) + " from table " + tableName);
        }
        PermissionStorage.removeTablePermissions(tableName, column, t, true);
    }

    static byte[] userPermissionRowKey(Permission permission) {
        byte[] row;
        if (permission instanceof TablePermission) {
            TablePermission tablePerm = (TablePermission)permission;
            row = tablePerm.getTableName().getName();
        } else if (permission instanceof NamespacePermission) {
            NamespacePermission nsPerm = (NamespacePermission)permission;
            row = Bytes.toBytes(PermissionStorage.toNamespaceEntry(nsPerm.getNamespace()));
        } else {
            row = ACL_GLOBAL_NAME;
        }
        return row;
    }

    static byte[] userPermissionKey(UserPermission permission) {
        byte[] key = Bytes.toBytes(permission.getUser());
        byte[] qualifier = null;
        byte[] family = null;
        if (permission.getPermission().getAccessScope() == Permission.Scope.TABLE) {
            TablePermission tablePermission = (TablePermission)permission.getPermission();
            family = tablePermission.getFamily();
            qualifier = tablePermission.getQualifier();
        }
        if (family != null && family.length > 0) {
            key = Bytes.add(key, Bytes.add(new byte[]{44}, family));
            if (qualifier != null && qualifier.length > 0) {
                key = Bytes.add(key, Bytes.add(new byte[]{44}, qualifier));
            }
        }
        return key;
    }

    static boolean isAclRegion(Region region) {
        return ACL_TABLE_NAME.equals(region.getTableDescriptor().getTableName());
    }

    static boolean isAclTable(TableDescriptor desc) {
        return ACL_TABLE_NAME.equals(desc.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, UserPermission>> loadAll(Region aclRegion) throws IOException {
        if (!PermissionStorage.isAclRegion(aclRegion)) {
            throw new IOException("Can only load permissions from " + ACL_TABLE_NAME);
        }
        TreeMap<byte[], ListMultimap<String, UserPermission>> allPerms = new TreeMap<byte[], ListMultimap<String, UserPermission>>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        try (RegionScanner iScanner = null;){
            boolean hasNext;
            iScanner = aclRegion.getScanner(scan);
            do {
                ArrayList<Cell> row = new ArrayList<Cell>();
                hasNext = iScanner.next(row);
                ArrayListMultimap<String, UserPermission> perms = ArrayListMultimap.create();
                byte[] entry = null;
                for (Cell kv : row) {
                    Pair<String, Permission> permissionsOfUserOnTable;
                    if (entry == null) {
                        entry = CellUtil.cloneRow(kv);
                    }
                    if ((permissionsOfUserOnTable = PermissionStorage.parsePermissionRecord(entry, kv, null, null, false, null)) == null) continue;
                    String username = permissionsOfUserOnTable.getFirst();
                    Permission permission = permissionsOfUserOnTable.getSecond();
                    perms.put(username, new UserPermission(username, permission));
                }
                if (entry == null) continue;
                allPerms.put(entry, perms);
            } while (hasNext);
        }
        return allPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, UserPermission>> loadAll(Configuration conf) throws IOException {
        TreeMap<byte[], ListMultimap<String, UserPermission>> allPerms = new TreeMap<byte[], ListMultimap<String, UserPermission>>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        ResultScanner scanner = null;
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(ACL_TABLE_NAME);){
            scanner = table.getScanner(scan);
            try {
                for (Result row : scanner) {
                    ListMultimap<String, UserPermission> resultPerms = PermissionStorage.parsePermissions(row.getRow(), row, null, null, null, false);
                    allPerms.put(row.getRow(), resultPerms);
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        return allPerms;
    }

    public static ListMultimap<String, UserPermission> getTablePermissions(Configuration conf, TableName tableName) throws IOException {
        return PermissionStorage.getPermissions(conf, tableName != null ? tableName.getName() : null, null, null, null, null, false);
    }

    @VisibleForTesting
    public static ListMultimap<String, UserPermission> getNamespacePermissions(Configuration conf, String namespace) throws IOException {
        return PermissionStorage.getPermissions(conf, Bytes.toBytes(PermissionStorage.toNamespaceEntry(namespace)), null, null, null, null, false);
    }

    public static ListMultimap<String, UserPermission> getGlobalPermissions(Configuration conf) throws IOException {
        return PermissionStorage.getPermissions(conf, null, null, null, null, null, false);
    }

    static ListMultimap<String, UserPermission> getPermissions(Configuration conf, byte[] entryName, Table t, byte[] cf, byte[] cq, String user, boolean hasFilterUser) throws IOException {
        Result row;
        ArrayListMultimap<String, UserPermission> perms;
        block28: {
            if (entryName == null) {
                entryName = ACL_GLOBAL_NAME;
            }
            perms = ArrayListMultimap.create();
            Get get = new Get(entryName);
            get.addFamily(ACL_LIST_FAMILY);
            row = null;
            if (t == null) {
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table table = connection.getTable(ACL_TABLE_NAME);){
                    row = table.get(get);
                    break block28;
                }
            }
            row = t.get(get);
        }
        if (!row.isEmpty()) {
            perms = PermissionStorage.parsePermissions(entryName, row, cf, cq, user, hasFilterUser);
        } else {
            LOG.info("No permissions found in " + ACL_TABLE_NAME + " for acl entry " + Bytes.toString(entryName));
        }
        return perms;
    }

    public static List<UserPermission> getUserTablePermissions(Configuration conf, TableName tableName, byte[] cf, byte[] cq, String userName, boolean hasFilterUser) throws IOException {
        return PermissionStorage.getUserPermissions(conf, tableName == null ? null : tableName.getName(), cf, cq, userName, hasFilterUser);
    }

    public static List<UserPermission> getUserNamespacePermissions(Configuration conf, String namespace, String user, boolean hasFilterUser) throws IOException {
        return PermissionStorage.getUserPermissions(conf, Bytes.toBytes(PermissionStorage.toNamespaceEntry(namespace)), null, null, user, hasFilterUser);
    }

    public static List<UserPermission> getUserPermissions(Configuration conf, byte[] entryName, byte[] cf, byte[] cq, String user, boolean hasFilterUser) throws IOException {
        ListMultimap<String, UserPermission> allPerms = PermissionStorage.getPermissions(conf, entryName, null, cf, cq, user, hasFilterUser);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>();
        for (Map.Entry entry : allPerms.entries()) {
            perms.add((UserPermission)entry.getValue());
        }
        return perms;
    }

    private static ListMultimap<String, UserPermission> parsePermissions(byte[] entryName, Result result, byte[] cf, byte[] cq, String user, boolean hasFilterUser) {
        ArrayListMultimap<String, UserPermission> perms = ArrayListMultimap.create();
        if (result != null && result.size() > 0) {
            for (Cell kv : result.rawCells()) {
                Pair<String, Permission> permissionsOfUserOnTable = PermissionStorage.parsePermissionRecord(entryName, kv, cf, cq, hasFilterUser, user);
                if (permissionsOfUserOnTable == null) continue;
                String username = permissionsOfUserOnTable.getFirst();
                Permission permission = permissionsOfUserOnTable.getSecond();
                perms.put(username, new UserPermission(username, permission));
            }
        }
        return perms;
    }

    private static Pair<String, Permission> parsePermissionRecord(byte[] entryName, Cell kv, byte[] cf, byte[] cq, boolean filterPerms, String filterUser) {
        byte[] family = CellUtil.cloneFamily(kv);
        if (!Bytes.equals(family, ACL_LIST_FAMILY)) {
            return null;
        }
        byte[] key = CellUtil.cloneQualifier(kv);
        byte[] value = CellUtil.cloneValue(kv);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read acl: entry[" + Bytes.toStringBinary(entryName) + "], kv [" + Bytes.toStringBinary(key) + ": " + Bytes.toStringBinary(value) + "]");
        }
        String username = Bytes.toString(key);
        List<String> filterUserGroups = null;
        if (filterPerms && username.charAt(0) == '@' && !StringUtils.isEmpty(filterUser) && filterUser.charAt(0) != '@') {
            filterUserGroups = AccessChecker.getUserGroups(filterUser);
        }
        if (PermissionStorage.isNamespaceEntry(entryName)) {
            if (filterPerms && !PermissionStorage.validateFilterUser(username, filterUser, filterUserGroups)) {
                return null;
            }
            return new Pair<String, Permission>(username, Permission.newBuilder(Bytes.toString(PermissionStorage.fromNamespaceEntry(entryName))).withActionCodes(value).build());
        }
        if (PermissionStorage.isGlobalEntry(entryName)) {
            if (filterPerms && !PermissionStorage.validateFilterUser(username, filterUser, filterUserGroups)) {
                return null;
            }
            return new Pair<String, Permission>(username, Permission.newBuilder().withActionCodes(value).build());
        }
        int idx = username.indexOf(44);
        byte[] permFamily = null;
        byte[] permQualifier = null;
        if (idx > 0 && idx < username.length() - 1) {
            String remainder = username.substring(idx + 1);
            username = username.substring(0, idx);
            idx = remainder.indexOf(44);
            if (idx > 0 && idx < remainder.length() - 1) {
                permFamily = Bytes.toBytes(remainder.substring(0, idx));
                permQualifier = Bytes.toBytes(remainder.substring(idx + 1));
            } else {
                permFamily = Bytes.toBytes(remainder);
            }
        }
        if (filterPerms) {
            if (filterUser != null && !PermissionStorage.validateFilterUser(username, filterUser, filterUserGroups)) {
                return null;
            }
            if (!PermissionStorage.validateCFAndCQ(permFamily, cf, permQualifier, cq)) {
                return null;
            }
        }
        return new Pair<String, Permission>(username, Permission.newBuilder(TableName.valueOf(entryName)).withFamily(permFamily).withQualifier(permQualifier).withActionCodes(value).build());
    }

    private static boolean validateFilterUser(String username, String filterUser, List<String> filterUserGroups) {
        if (filterUserGroups == null) {
            return filterUser.equals(username);
        }
        return filterUserGroups.contains(username.substring(1));
    }

    private static boolean validateCFAndCQ(byte[] permFamily, byte[] cf, byte[] permQualifier, byte[] cq) {
        boolean include = true;
        if (cf != null) {
            if (Bytes.equals(cf, permFamily)) {
                if (cq != null && !Bytes.equals(cq, permQualifier)) {
                    include = false;
                }
            } else {
                include = false;
            }
        }
        return include;
    }

    public static byte[] writePermissionsAsBytes(ListMultimap<String, UserPermission> perms, Configuration conf) {
        return ProtobufUtil.prependPBMagic(AccessControlUtil.toUserTablePermissions(perms).toByteArray());
    }

    private static List<Permission> readWritableUserPermission(DataInput in, Configuration conf) throws IOException, ClassNotFoundException {
        assert (WritableUtils.readVInt((DataInput)in) == 61);
        int length = in.readInt();
        ArrayList<Permission> list = new ArrayList<Permission>(length);
        for (int i = 0; i < length; ++i) {
            assert (WritableUtils.readVInt((DataInput)in) == 14);
            assert (WritableUtils.readVInt((DataInput)in) == 0);
            String className = Text.readString((DataInput)in);
            Class<Writable> clazz = conf.getClassByName(className).asSubclass(Writable.class);
            Writable instance = WritableFactories.newInstance(clazz, (Configuration)conf);
            instance.readFields(in);
            list.add((Permission)instance);
        }
        return list;
    }

    @VisibleForTesting
    public static ListMultimap<String, UserPermission> readUserPermission(byte[] data, Configuration conf) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
                ProtobufUtil.mergeFrom(builder, data, pblen, data.length - pblen);
                return AccessControlUtil.toUserPermission(builder.build());
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
        }
        ArrayListMultimap<String, UserPermission> userPermission = ArrayListMultimap.create();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            int length = in.readInt();
            for (int i = 0; i < length; ++i) {
                String user = Text.readString((DataInput)in);
                List<Permission> perms = PermissionStorage.readWritableUserPermission(in, conf);
                for (Permission p : perms) {
                    userPermission.put(user, new UserPermission(user, p));
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new DeserializationException(e);
        }
        return userPermission;
    }

    public static ListMultimap<String, Permission> readPermissions(byte[] data, Configuration conf) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
                ProtobufUtil.mergeFrom(builder, data, pblen, data.length - pblen);
                return AccessControlUtil.toPermission(builder.build());
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
        }
        ArrayListMultimap<String, Permission> perms = ArrayListMultimap.create();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            int length = in.readInt();
            for (int i = 0; i < length; ++i) {
                String user = Text.readString((DataInput)in);
                perms.putAll(user, PermissionStorage.readWritableUserPermission(in, conf));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new DeserializationException(e);
        }
        return perms;
    }

    public static boolean isGlobalEntry(byte[] entryName) {
        return Bytes.equals(entryName, ACL_GLOBAL_NAME);
    }

    public static boolean isNamespaceEntry(String entryName) {
        return PermissionStorage.isNamespaceEntry(Bytes.toBytes(entryName));
    }

    public static boolean isNamespaceEntry(byte[] entryName) {
        return entryName != null && entryName.length != 0 && entryName[0] == 64;
    }

    public static boolean isTableEntry(byte[] entryName) {
        return !PermissionStorage.isNamespaceEntry(entryName) && !PermissionStorage.isGlobalEntry(entryName) && entryName != null;
    }

    public static String toNamespaceEntry(String namespace) {
        return '@' + namespace;
    }

    public static String fromNamespaceEntry(String namespace) {
        if (namespace.charAt(0) != '@') {
            throw new IllegalArgumentException("Argument is not a valid namespace entry");
        }
        return namespace.substring(1);
    }

    public static byte[] toNamespaceEntry(byte[] namespace) {
        byte[] ret = new byte[namespace.length + 1];
        ret[0] = 64;
        System.arraycopy(namespace, 0, ret, 1, namespace.length);
        return ret;
    }

    public static byte[] fromNamespaceEntry(byte[] namespace) {
        if (namespace[0] != 64) {
            throw new IllegalArgumentException("Argument is not a valid namespace entry: " + Bytes.toString(namespace));
        }
        return Arrays.copyOfRange(namespace, 1, namespace.length);
    }

    public static List<Permission> getCellPermissionsForUser(User user, Cell cell) throws IOException {
        if (cell.getTagsLength() == 0) {
            return null;
        }
        ArrayList<Permission> results = Lists.newArrayList();
        Iterator<Tag> tagsIterator = PrivateCellUtil.tagsIterator(cell);
        while (tagsIterator.hasNext()) {
            String[] groupNames;
            Tag tag = tagsIterator.next();
            if (tag.getType() != 1) continue;
            AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
            if (tag.hasArray()) {
                ProtobufUtil.mergeFrom(builder, tag.getValueArray(), tag.getValueOffset(), tag.getValueLength());
            } else {
                ProtobufUtil.mergeFrom(builder, Tag.cloneValue(tag));
            }
            ListMultimap<String, Permission> kvPerms = AccessControlUtil.toUsersAndPermissions(builder.build());
            Collection userPerms = kvPerms.get((Object)user.getShortName());
            if (userPerms != null) {
                results.addAll(userPerms);
            }
            if ((groupNames = user.getGroupNames()) == null) continue;
            for (String group : groupNames) {
                Collection groupPerms = kvPerms.get((Object)AuthUtil.toGroupEntry(group));
                if (results == null) continue;
                results.addAll(groupPerms);
            }
        }
        return results;
    }
}

